/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.utilities.CssEditorKit;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.Modell;
import webetk.communication.LoginInfo;

public class ZusatzproduktInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel mNameLabel = null;
    private JTextPane mDescription = null;
    private JLabel mBaureihenLabel = null;
    private JLabel mPriceRange = null;
    private JLabel mAvailability = null;
    private MarkenLayout mMarkenLayout;
    private ArrayList<Baureihe> mBaureihenList;

    public ZusatzproduktInfoPanel(Dimension dim, MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setVisible(true);
    }

    public void setInfoPanel(String name, String descr, String price, ArrayList<Baureihe> baureihenList, Integer availability, String link) {
        this.mDescription = new JTextPane();
        this.mDescription.setContentType("text/html; charset=UTF-8");
        this.mDescription.setEditorKit(new CssEditorKit());
        this.mDescription.setPreferredSize(new Dimension(400, 20));
        this.mDescription.setMinimumSize(new Dimension(400, 20));
        this.mDescription.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mDescription.setBackground(Color.WHITE);
        if (descr != null) {
            if (this.mMarkenLayout.isBMWMotorrad()) {
                this.mDescription.setText(descr);
                if (descr.length() > 60) {
                    this.mDescription.setToolTipText("<html>" + descr.replaceAll("&#149;", "") + "</html>");
                    this.mDescription.setCursor(this.mMarkenLayout.getDetailCursor());
                } else {
                    this.mDescription.setToolTipText(null);
                    this.mDescription.setCursor(Constants.CursorTypen.STANDARD_CURSOR);
                }
            } else {
                this.mDescription.setText(this.mMarkenLayout.cleanText(descr, "#", " - "));
                if (descr.length() > 60) {
                    this.mDescription.setToolTipText("<html>" + this.mMarkenLayout.cleanTextWithNewLine(descr, "#", "- ", 90) + "</html>");
                    this.mDescription.setCursor(this.mMarkenLayout.getDetailCursor());
                } else {
                    this.mDescription.setToolTipText(null);
                    this.mDescription.setCursor(Constants.CursorTypen.STANDARD_CURSOR);
                }
            }
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.mBaureihenList = baureihenList;
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mNameLabel = this.mMarkenLayout.getBoldLabel(name);
        this.mNameLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.add((Component)this.mNameLabel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
        this.add((Component)this.mDescription, gbc);
        this.mBaureihenLabel = this.mBaureihenList != null && this.mBaureihenList.size() > 0 ? new JLabel(baureihenList.get(0).getBezeichnung() + "...", 0) : new JLabel("");
        this.mBaureihenLabel.setCursor(this.mMarkenLayout.getDetailCursor());
        this.mBaureihenLabel.setName("BAUREIHE");
        this.mBaureihenLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.05, 1.0, 0, 18, new Insets(0, 5, 0, 0));
        this.add((Component)this.mBaureihenLabel, gbc);
        this.mPriceRange = new JLabel(price + " + ", 0);
        this.mPriceRange.setForeground(this.mMarkenLayout.getPrimaryForeground());
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 0, 1, 1, 0.05, 1.0, 0, 18, new Insets(0, 5, 0, 0));
        this.add((Component)this.mPriceRange, gbc);
        LoginInfo sessionInfo = GlobalObjects.getInstance().getSessionInfo();
        if (sessionInfo.getDMSAngeschlossen() && sessionInfo.getDMSVerwenden() && ControllerProduktListPanel.getInstance().isIsPruefeVerfuegbarkeit()) {
            this.mAvailability = new JLabel(new ImageIcon("img/circle_big.gif"), 0);
            gbc = this.mMarkenLayout.setGridBagConstraints(5, 0, 1, 1, 0.05, 1.0, 0, 18, new Insets(0, 5, 0, 0));
            this.add((Component)this.mAvailability, gbc);
        }
        this.validate();
        this.updateUI();
    }

    public void createBaureihenTooltip(ArrayList<Baureihe> baureiheList) {
        this.mBaureihenList = baureiheList;
        Baureihe aktuelleBaureihe = null;
        KarosserieForm aktuelleKarosserieform = null;
        Modell aktuellesModell = null;
        String test = "<html>";
        for (int ii = 0; ii < this.mBaureihenList.size(); ++ii) {
            aktuelleBaureihe = this.mBaureihenList.get(ii);
            for (int jj = 0; jj < aktuelleBaureihe.getKarosserieForm().size(); ++jj) {
                aktuelleKarosserieform = aktuelleBaureihe.getKarosserieForm().get(jj);
                for (int kk = 0; kk < aktuelleKarosserieform.getModelle().size(); ++kk) {
                    aktuellesModell = aktuelleKarosserieform.getModelle().get(kk);
                    for (int ll = 0; ll < aktuellesModell.getKatalogausfuehrungen().size(); ++ll) {
                        test = test + " " + aktuelleBaureihe.getBezeichnung() + " " + aktuelleKarosserieform.getBezeichnung() + " " + aktuellesModell.getModell() + " " + aktuellesModell.getKatalogausfuehrungen().get(ll).getKatalogAusfuehrung() + "     <br>";
                    }
                }
            }
        }
        test = test + "</html>";
        this.mBaureihenLabel.setToolTipText(test);
    }

    public ArrayList<Baureihe> getBaureihenList() {
        return this.mBaureihenList;
    }

    public JLabel getBaureihenLabel() {
        return this.mBaureihenLabel;
    }

    public JLabel getNameLabel() {
        return this.mNameLabel;
    }
}

