/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.MainPanel;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.suche.ProduktListPanel;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.KategorieNodeData;
import de.esg.zub.configurator.navigation.suche.UnterkategorieNodeData;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.StatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.resources.Resource;

public class ControllerProduktListPanel
implements MouseListener,
Observer {
    private static ControllerProduktListPanel mInstance = null;
    private static Logger log = Logger.getLogger(ControllerProduktListPanel.class);
    private ProduktListPanel mProduktListPanel = new ProduktListPanel(WorkflowController.getInstance().getMarkenLayout());
    private KategorieNodeData trefferlisteKategorie = null;
    private UnterkategorieNodeData trefferlisteUnterkategorie = null;
    private Color headerBorderColor;
    private boolean mIsPruefeVerfuegbarkeit = false;

    private ControllerProduktListPanel() {
        this.checkVerfurgbarkeit();
        this.mProduktListPanel.addObserver(this);
    }

    public static ControllerProduktListPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerProduktListPanel();
        }
        return mInstance;
    }

    private void addListener() {
        this.addListenerProduktList();
        this.addListenerPanelLabels();
    }

    private void addListenerProduktList() {
        int anzahlUnterkategorienPanels = this.mProduktListPanel.getProduktListPanel().getComponentCount();
        JPanel currentPanel = null;
        for (int i = 0; i < anzahlUnterkategorienPanels; ++i) {
            currentPanel = (JPanel)this.mProduktListPanel.getProduktListPanel().getComponent(i);
            if (currentPanel == null) continue;
            for (int j = 0; j < currentPanel.getComponentCount(); ++j) {
                if (currentPanel.getComponent(j).getMouseListeners().length > 0 || currentPanel.getComponent(j).getName() != null && currentPanel.getComponent(j).getName().equals("keineDetailanzeige")) continue;
                currentPanel.getComponent(j).addMouseListener(this);
                currentPanel.getComponent(j).addMouseListener(new HilfeMouseListener("i50019"));
            }
        }
    }

    private void addListenerPanelLabels() {
        HilfeMouseListener hilfeListener = new HilfeMouseListener("i50019");
        if (this.mProduktListPanel.getBlaetternAnfangLabel().getMouseListeners().length <= 0) {
            this.mProduktListPanel.getBlaetternAnfangLabel().addMouseListener(this);
            this.mProduktListPanel.getBlaetternAnfangLabel().addMouseListener(hilfeListener);
        }
        if (this.mProduktListPanel.getBlaetternZurueckLabel().getMouseListeners().length <= 0) {
            this.mProduktListPanel.getBlaetternZurueckLabel().addMouseListener(this);
            this.mProduktListPanel.getBlaetternZurueckLabel().addMouseListener(hilfeListener);
        }
        if (this.mProduktListPanel.getBlaetternVorLabel().getMouseListeners().length <= 0) {
            this.mProduktListPanel.getBlaetternVorLabel().addMouseListener(this);
            this.mProduktListPanel.getBlaetternVorLabel().addMouseListener(hilfeListener);
        }
        if (this.mProduktListPanel.getBlaetternEndeLabel().getMouseListeners().length <= 0) {
            this.mProduktListPanel.getBlaetternEndeLabel().addMouseListener(this);
            this.mProduktListPanel.getBlaetternEndeLabel().addMouseListener(hilfeListener);
        }
        if (this.mProduktListPanel.getBlaetternLabelList() == null || this.mProduktListPanel.getBlaetternLabelList().size() <= 0) {
            return;
        }
        JLabel currentLabel = null;
        for (int i = 0; i < this.mProduktListPanel.getBlaetternLabelList().size(); ++i) {
            currentLabel = this.mProduktListPanel.getBlaetternLabelList().get(i);
            if (currentLabel == null || currentLabel.getMouseListeners().length > 0) continue;
            currentLabel.addMouseListener(this);
            currentLabel.addMouseListener(hilfeListener);
        }
    }

    public void checkVerfurgbarkeit() {
        try {
            ArrayList filialen = (ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getSessionInfo().getFirmaId());
            for (FilialeZub zub : filialen) {
                if (!zub.getId().equals(GlobalObjects.getInstance().getSessionInfo().getFilialeId())) continue;
                this.mIsPruefeVerfuegbarkeit = zub.isPruefVerfuegbarkeit();
            }
            if (this.mProduktListPanel != null) {
                this.mProduktListPanel.setPruefeVerfuegbarkeit(this.mIsPruefeVerfuegbarkeit);
            }
        }
        catch (Exception e) {
            log.error((Object)"Fehler", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void showProduktListe() {
        MainPanel containerPanel = ControllerMainPanel.getInstance().getMainPanel();
        HauptKategorie kategorie = null;
        if (this.trefferlisteKategorie != null) {
            kategorie = this.trefferlisteKategorie.getKategorie();
            ControllerNavigationPanel.getInstance().getNavigationPanel().getCategoryComboBox().setSelectedItem(kategorie.getName());
            this.trefferlisteKategorie = null;
            this.headerBorderColor = ControllerProduktListPanel.getBorderColor(kategorie.getName());
        } else {
            kategorie = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKategorie();
            this.headerBorderColor = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKategorieBorderColor();
        }
        HitListenUnterkategorie unterkategorie = null;
        if (this.trefferlisteUnterkategorie != null) {
            unterkategorie = this.trefferlisteUnterkategorie.getUnterkategorie();
            this.trefferlisteUnterkategorie = null;
        } else {
            unterkategorie = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedUnterkategorie();
        }
        ArrayList<ProduktListenElement> produkte = null;
        produkte = ControllerMainPanel.getInstance().getMainPanel().getSubcategory() != null ? ControllerMainPanel.getInstance().getMainPanel().getSubcategory().getZubehoerList() : ControllerProduktListPanel.getInstance().getProduktListPanel().getProduktList();
        if (unterkategorie == null && produkte.size() > 0) {
            unterkategorie = produkte.get(0).getUnterkategorie();
        }
        if (kategorie == null && produkte.size() > 0) {
            kategorie = produkte.get(0).getHauptkategorie();
        }
        StatusBar statusBar = MainController.getInstance().getMainFrame().getStatusBar();
        statusBar.removeAllStatusFromIndex(2);
        String kategorieStatus = ControllerStatusBar.createStatusHauptkat(kategorie.getName());
        if (!ControllerInfoPanel.getInstance().getInfoPanel().isHitlistShown()) {
            statusBar.addNewStatus(" > " + kategorieStatus, "SUBCAT");
        } else {
            statusBar.addNewStatus(" > " + kategorieStatus, "PRODUCTLIST");
        }
        containerPanel.showProduktListe(kategorie, unterkategorie, produkte);
        if (ControllerMainPanel.getInstance().getMainPanel().getProduktListPanel() != null) {
            String ukat = ControllerMainPanel.getInstance().getMainPanel().getProduktListPanel().getAktuelleUnterkategorie();
            MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().setSelectedUnterkategorieText(ukat);
            MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSubCategoryComboBox().setSelectedItem(ukat);
            statusBar.addNewStatus(" > " + ukat, "PRODUCTLIST");
        }
    }

    public static String createStatusKategorie(String kategorie) {
        String kategorieStatus = kategorie;
        Fahrzeug fahrzeug = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (fahrzeug != null) {
            StringBuilder bui = new StringBuilder(" ");
            bui.append(Resource.getInstance().getFuer());
            bui.append(" ");
            bui.append(fahrzeug.getBaureiheBezeichnung()).append(" ").append(fahrzeug.getKarosserieBezeichnung());
            bui.append(" ").append(fahrzeug.getModellBezeichnung());
            bui.append(" ").append(fahrzeug.getKatalogausf());
            kategorieStatus = kategorieStatus + bui.toString();
        }
        return kategorieStatus;
    }

    private static Color getBorderColor(String kategorie) {
        int itemcount = ControllerNavigationPanel.getInstance().getNavigationPanel().getCategoryComboBox().getItemCount();
        int indexTreffer = 0;
        for (int ii = 0; ii < itemcount; ++ii) {
            if (!kategorie.equals(ControllerNavigationPanel.getInstance().getNavigationPanel().getCategoryComboBox().getItemAt(ii))) continue;
            indexTreffer = ii;
        }
        switch (indexTreffer) {
            case 1: {
                return Color.LIGHT_GRAY;
            }
            case 2: {
                return Constants.Layout.AUSSENZUBEHOER_BLAU_RAHMEN_COLOR;
            }
            case 3: {
                return Constants.Layout.INNENZUBEHOER_GRUEN_RAHMEN_COLOR;
            }
            case 4: {
                return Constants.Layout.MOBILE_KOMMUNIKATION_BLAU_RAHMEN_COLOR;
            }
            case 5: {
                return Constants.Layout.TRANSPORT_BLAU_RAHMEN_COLOR;
            }
            case 6: {
                return Constants.Layout.SICHERHEIT_BRAUN_RAHMEN_COLOR;
            }
            case 7: {
                return Constants.Layout.CAR_CARE_BLAU_RAHMEN_COLOR;
            }
            case 8: {
                return Constants.Layout.COMFORT_BLAU_RAHMEN_COLOR;
            }
        }
        return Color.LIGHT_GRAY;
    }

    public boolean isLifestyle() {
        if (this.trefferlisteUnterkategorie != null) {
            return this.trefferlisteUnterkategorie.getUnterkategorie().isLifestyle();
        }
        if (this.trefferlisteKategorie != null) {
            for (HitListenUnterkategorie unterkategorie : this.trefferlisteKategorie.getKategorie().getUnterkategorie()) {
                if (unterkategorie.isLifestyle()) continue;
                return false;
            }
            return true;
        }
        if (this.mProduktListPanel != null && this.mProduktListPanel.getProduktList() != null && this.mProduktListPanel.getProduktList().size() > 0) {
            for (ProduktListenElement produkt : this.mProduktListPanel.getProduktList()) {
                if (produkt.getUnterkategorie().isLifestyle()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        JLabel selectedLabel;
        if (event.getSource() instanceof JLabel && (selectedLabel = (JLabel)event.getSource()).getParent().getParent() != this.mProduktListPanel.getProduktListPanel()) {
            this.mProduktListPanel.handleBlaetternPanelMouseEnteredEvent(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.mProduktListPanel.handleProduktListeMouseExitedEvent(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.getButton() == 3) {
            return;
        }
        if (!(event.getSource() instanceof JLabel)) return;
        JLabel selectedLabel = (JLabel)event.getSource();
        if (selectedLabel.getParent().getParent() == this.mProduktListPanel.getProduktListPanel()) {
            Cursor oldCursor = selectedLabel.getCursor();
            try {
                selectedLabel.setCursor(Cursor.getPredefinedCursor(3));
                MainController.getInstance().getMainFrame().setBusiCursor();
                if (!this.mProduktListPanel.handleProduktListeMouseEvent(event)) return;
                WorkflowController.getInstance().setNewKonfiguration(true);
                WorkflowController.getInstance().setAddKonfiguration(false);
                WorkflowController.getInstance().setAddKonfigurationDataSet(true);
                WorkflowController.getInstance().changeState("MARKETING");
                return;
            }
            finally {
                selectedLabel.setCursor(oldCursor);
                MainController.getInstance().getMainFrame().setDefaultCursor();
            }
        }
        if (selectedLabel.getParent() != this.mProduktListPanel.getBlaetternPanel()) return;
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mProduktListPanel.handleBlaetternMouseEvent(event);
            return;
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.addListener();
    }

    public ProduktListPanel getProduktListPanel() {
        return this.mProduktListPanel;
    }

    public KategorieNodeData getTrefferlisteKategorie() {
        return this.trefferlisteKategorie;
    }

    public void setTrefferlisteKategorie(KategorieNodeData trefferlisteKategorie) {
        this.trefferlisteKategorie = trefferlisteKategorie;
    }

    public Color getHeaderBorderColor() {
        return this.headerBorderColor;
    }

    public UnterkategorieNodeData getTrefferlisteUnterkategorie() {
        return this.trefferlisteUnterkategorie;
    }

    public void setTrefferlisteUnterkategorie(UnterkategorieNodeData trefferlisteUnterkategorie) {
        this.trefferlisteUnterkategorie = trefferlisteUnterkategorie;
    }

    public void setHeaderBorderColor(String kategorie) {
        this.headerBorderColor = ControllerProduktListPanel.getBorderColor(kategorie);
    }

    public Color getHeaderBorderColor(String kategorie) {
        this.headerBorderColor = ControllerProduktListPanel.getBorderColor(kategorie);
        return this.headerBorderColor;
    }

    public boolean isIsPruefeVerfuegbarkeit() {
        return this.mIsPruefeVerfuegbarkeit;
    }
}

