/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.suche.KategorieJLabel;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.StatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.CurrencyFormatter;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.ImageUtils;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktIdComparator;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.communication.LoginInfo;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class ProduktListPanel
extends Observable {
    private JPanel containerPanel = null;
    private JPanel ueberschriftPanel = null;
    private JPanel listPanel = null;
    private JPanel blaetternPanel = null;
    private JPanel[] listPanelList = null;
    private ArrayList<String> panelIndexList = null;
    private ArrayList<JLabel> blaetternLabelList = null;
    private Hashtable<String, String> panelUeberschriftHashtable = null;
    private Hashtable<String, String> panelHeadHashtable = null;
    private String aktuellesPanel = "";
    private int anzahlSeiten = 0;
    private int aktuellSelectedBlaetternIndex = -1;
    private String mAktuelleUnterkategorie;
    private String mKategorie = "";
    private String mUnterkategorie = "";
    private ArrayList<ProduktListenElement> mProduktList = null;
    private ArrayList<KategorieJLabel> mProduktGraphikList = null;
    private ArrayList<KategorieJLabel> mProduktNameList = null;
    private ArrayList<KategorieJLabel> mProduktBeschreibungList = null;
    private ArrayList<KategorieJLabel> mProduktBaureiheList = null;
    private ArrayList<KategorieJLabel> mProduktPreisList = null;
    private ArrayList<KategorieJLabel> mProduktVerfuegbarkeitList = null;
    private ArrayList<KategorieJLabel> mBteBedingungsIconList = null;
    private ArrayList<KategorieJLabel> mMarktBenList = null;
    private ArrayList<String> mProduktUnterkategorieList = null;
    private ArrayList<String> mHauptKategorieList = null;
    final int ANZAHL_ELEMENTE = 4;
    final int ANZAHL_BLAETTERN_ANZEIGE = 4;
    final int GRAPHIK_BREITE = 100;
    final int GRAPHIK_HOEHE = 70;
    final String BLAETTERN_SEPARATOR = " |";
    final String BLAETTERN_ANFANG = "<<";
    final String BLAETTERN_ZURUECK = "<";
    final String BLAETTERN_VOR = ">";
    final String BLAETTERN_ENDE = ">>";
    JLabel blaetternAnfangLabel = new JLabel("<<");
    JLabel blaetternZurueckLabel = new JLabel("<");
    JLabel blaetternVorLabel = new JLabel(">");
    JLabel blaetternEndeLabel = new JLabel(">>");
    public static final String KEINE_DETAILANZEIGE = "keineDetailanzeige";
    public static final String BTE_BEDINGUNG = "bteBedingung";
    private String mSelectedBteNr = "";
    private String mSelectedBildPosNr;
    private boolean mIsPruefeVerfuegbarkeit = false;
    private MarkenLayout mMarkenLayout;
    private boolean isFBAVisible = false;
    private static Logger log = Logger.getLogger(ProduktListPanel.class);

    public ProduktListPanel(MarkenLayout markenLayout) {
        this.containerPanel = new JPanel();
        this.containerPanel.setLayout(new BorderLayout());
        this.mMarkenLayout = markenLayout;
    }

    private JLabel getSeparatorLabel() {
        String SEPARATOR_TEXT = "___________________________________________________________________________________________________________________________________";
        JLabel separatorLabel = new JLabel("___________________________________________________________________________________________________________________________________");
        if (this.mMarkenLayout.isBMWMotorrad()) {
            separatorLabel.setForeground(Constants.Layout.BLACK_COLOR);
        } else {
            separatorLabel.setForeground(Constants.Layout.RAHMEN_COLOR);
        }
        return separatorLabel;
    }

    private void buildProduktList(String unterkategorie, String hauptKategorie) {
        int count;
        ProduktListenElement prodElement;
        Iterator<ProduktListenElement> iterator;
        this.mProduktGraphikList = null;
        this.mProduktBeschreibungList = null;
        this.mProduktNameList = null;
        this.mProduktBaureiheList = null;
        this.mProduktPreisList = null;
        this.mProduktVerfuegbarkeitList = null;
        this.mProduktUnterkategorieList = null;
        this.mHauptKategorieList = null;
        if (this.mProduktList == null) {
            return;
        }
        if (this.mMarkenLayout.isBMWMotorrad()) {
            iterator = this.mProduktList.iterator();
            while (iterator.hasNext()) {
                prodElement = iterator.next();
                if (((ArrayList)prodElement.getBauarten()).size() != 0 || prodElement.getArt().equals("ASS")) continue;
                iterator.remove();
            }
        } else {
            iterator = this.mProduktList.iterator();
            while (iterator.hasNext()) {
                prodElement = iterator.next();
                if (((ArrayList)prodElement.getBaureihen()).size() != 0 || prodElement.getArt().equals("ASS")) continue;
                iterator.remove();
            }
        }
        if ((count = this.mProduktList.size()) <= 0) {
            return;
        }
        Collections.sort(this.mProduktList, new ProduktIdComparator());
        this.mProduktGraphikList = new ArrayList(count);
        this.mProduktNameList = new ArrayList(count);
        this.mProduktBeschreibungList = new ArrayList(count);
        this.mProduktBaureiheList = new ArrayList(count);
        this.mProduktPreisList = new ArrayList(count);
        this.mProduktVerfuegbarkeitList = new ArrayList(count);
        this.mBteBedingungsIconList = new ArrayList(count);
        this.mMarktBenList = new ArrayList(count);
        this.mProduktUnterkategorieList = new ArrayList(count);
        this.mHauptKategorieList = new ArrayList(count);
        KategorieJLabel produktGraphikLabel = null;
        KategorieJLabel produktNameLabel = null;
        KategorieJLabel produktBeschreibungLabel = null;
        KategorieJLabel produktBaureiheLabel = null;
        KategorieJLabel produktPreisLabel = null;
        KategorieJLabel produktVerfuegbarkeitLabel = null;
        KategorieJLabel bteBedingungsIconLabel = null;
        KategorieJLabel marktBenLabel = null;
        ImageIcon produktGraphikImageIcon = null;
        Double produktPreis = null;
        int produktVerfuegbar = 0;
        ArrayList produktBaureiheList = null;
        ArrayList produktBauartList = null;
        ImageIcon produktDetailGraphikImageIcon = null;
        String produktDetailBeschreibungText = "";
        for (int i = 0; i < count; ++i) {
            Image img;
            ImageIcon unscaledIcon = ImageUtils.getImageIcon(this.mProduktList.get(i).getThumbNail().getImageData());
            produktGraphikImageIcon = this.getScaledThumbNail(unscaledIcon, 100, 70);
            if (produktGraphikImageIcon == null && (img = ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg")) != null) {
                produktGraphikImageIcon = new ImageIcon(img);
            }
            StringBuilder bui = new StringBuilder("");
            if (this.mProduktList.get(i).getProduktName() != null && this.mProduktList.get(i).getProduktName().length() > 0) {
                produktNameLabel = new KategorieJLabel(this.mProduktList.get(i).getProduktName());
            }
            int zeichenProZeile = 90;
            if (this.mProduktList.get(i).getTeaser() != null && this.mProduktList.get(i).getTeaser().length() > 0) {
                String text;
                String aufzaehlungsZeichen = "&#149; ";
                if (this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                    if (this.mProduktList.get(i).getTeaser().contains("#")) {
                        text = this.verkuerzeText(this.mMarkenLayout.cleanTextWithNewLine(this.mProduktList.get(i).getTeaser(), "#", aufzaehlungsZeichen, zeichenProZeile), aufzaehlungsZeichen);
                        text = text.replaceAll("<ul>", "<br>");
                        text = text.replaceAll("</ul>", "");
                        bui.append(text);
                    } else {
                        bui.append(this.verkuerzeTextZeileumbruch(this.mMarkenLayout.formatText(this.mProduktList.get(i).getTeaser(), zeichenProZeile, "<br>"), 2 * zeichenProZeile - 2));
                    }
                } else {
                    text = this.mMarkenLayout.formatTextWithHtml(this.mProduktList.get(i).getTeaser(), zeichenProZeile);
                    bui.append(text);
                }
            }
            produktBaureiheList = (ArrayList)this.mProduktList.get(i).getBaureihen();
            produktBauartList = (ArrayList)this.mProduktList.get(i).getBauarten();
            produktPreis = this.mProduktList.get(i).getPrice();
            produktVerfuegbar = this.mProduktList.get(i).getVerfuegbarkeit();
            produktGraphikLabel = new KategorieJLabel(produktGraphikImageIcon);
            produktGraphikLabel.setCursor(this.mMarkenLayout.getDetailCursor());
            produktBeschreibungLabel = new KategorieJLabel(bui.toString());
            produktBeschreibungLabel.setTeaserText(this.mProduktList.get(i).getTeaser());
            produktBeschreibungLabel.setCursor(this.mMarkenLayout.getDetailCursor());
            if (this.mMarkenLayout.isBMWMotorrad()) {
                if (produktBauartList != null && produktBauartList.size() > 0) {
                    if (produktBauartList.size() > 1) {
                        String bauart = "";
                        bauart = GlobalObjects.getInstance().getIpacData().getFahrzeug() != null ? GlobalObjects.getInstance().getIpacData().getFahrzeug().getBauartBezeichnung() : (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe() != null ? ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBauart().getBezeichnung() : ((Bauart)produktBauartList.get(0)).getBezeichnung());
                        produktBaureiheLabel = new KategorieJLabel(bauart + " ...");
                        produktBaureiheLabel.setCursor(this.mMarkenLayout.getDetailCursor());
                    } else {
                        produktBaureiheLabel = new KategorieJLabel(((Bauart)produktBauartList.get(0)).getBezeichnung());
                        produktBaureiheLabel.setCursor(this.mMarkenLayout.getDetailCursor());
                    }
                } else {
                    produktBaureiheLabel = new KategorieJLabel();
                }
            } else if (produktBaureiheList != null && produktBaureiheList.size() > 0) {
                if (produktBaureiheList.size() > 1) {
                    String baureihe = "";
                    baureihe = GlobalObjects.getInstance().getIpacData().getFahrzeug() != null ? GlobalObjects.getInstance().getIpacData().getFahrzeug().getBaureiheBezeichnung() : (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe() != null ? ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe().getBezeichnung() : ((Baureihe)produktBaureiheList.get(0)).getBezeichnung());
                    produktBaureiheLabel = new KategorieJLabel(baureihe + " ...");
                    produktBaureiheLabel.setCursor(this.mMarkenLayout.getDetailCursor());
                } else {
                    produktBaureiheLabel = new KategorieJLabel(((Baureihe)produktBaureiheList.get(0)).getBezeichnung());
                    produktBaureiheLabel.setCursor(this.mMarkenLayout.getDetailCursor());
                }
            } else {
                produktBaureiheLabel = new KategorieJLabel();
            }
            produktPreisLabel = new KategorieJLabel(Resource.getInstance().getAb() + " " + CurrencyFormatter.getInstance().getFormattedCurrency(produktPreis) + " +");
            LoginInfo sessionInfo = GlobalObjects.getInstance().getSessionInfo();
            if (sessionInfo.getDMSAngeschlossen() && sessionInfo.getDMSVerwenden() && this.isPruefeVerfuegbarkeit()) {
                if (produktVerfuegbar > 0) {
                    produktVerfuegbarkeitLabel = new KategorieJLabel(ImageCache.getInstance().getIcon("circle_green.gif"));
                    produktVerfuegbarkeitLabel.setToolTipText("<html>" + Resource.getInstance().getVerfuegbarGruen() + "</html>");
                } else if (produktVerfuegbar == 0) {
                    produktVerfuegbarkeitLabel = new KategorieJLabel(ImageCache.getInstance().getIcon("circle_orange.gif"));
                    produktVerfuegbarkeitLabel.setToolTipText("<html>" + Resource.getInstance().getVerfuegbarOrange() + "</html>");
                } else {
                    produktVerfuegbarkeitLabel = new KategorieJLabel(ImageCache.getInstance().getIcon("circle_red.gif"));
                    produktVerfuegbarkeitLabel.setToolTipText("<html>" + Resource.getInstance().getVerfuegbarRot() + "</html>");
                }
            } else {
                produktVerfuegbarkeitLabel = new KategorieJLabel();
                produktVerfuegbarkeitLabel.setToolTipText(null);
            }
            ImageIcon icon = ImageUtils.getImageIcon(this.mProduktList.get(i).getThumbNail().getImageData());
            if (icon != null) {
                int width = (int)MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().getPreferredSize().getWidth();
                float factor = (float)width / (float)icon.getIconWidth();
                int newHeight = (int)(factor * (float)icon.getIconHeight());
                Image image = ImageUtils.getImage(this.mProduktList.get(i).getThumbNail().getImageData()).getScaledInstance(width, newHeight, 16);
                produktDetailGraphikImageIcon = new ImageIcon(image);
            }
            if ((produktDetailBeschreibungText = this.mProduktList.get(i).getDetailText()) != null) {
                produktDetailBeschreibungText = produktDetailBeschreibungText.replaceAll("<ul>", "");
                produktDetailBeschreibungText = produktDetailBeschreibungText.replaceAll("</ul>", "");
            }
            produktGraphikLabel.setDetailGraphik(produktDetailGraphikImageIcon);
            produktBeschreibungLabel.setDetailText(produktDetailBeschreibungText);
            if (this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                produktBaureiheLabel.setDetailBaureiheList(produktBaureiheList);
            } else {
                produktBaureiheLabel.setDetailBauartList(produktBauartList);
            }
            produktPreisLabel.setName(KEINE_DETAILANZEIGE);
            produktPreisLabel.setDetailText("");
            produktVerfuegbarkeitLabel.setName(KEINE_DETAILANZEIGE);
            produktVerfuegbarkeitLabel.setDetailText("");
            bteBedingungsIconLabel = new KategorieJLabel();
            bteBedingungsIconLabel.setCursor(Constants.CursorTypen.HAND_CURSOR);
            bteBedingungsIconLabel.setName(BTE_BEDINGUNG);
            bteBedingungsIconLabel.setDetailText("");
            bteBedingungsIconLabel.setBteNr(this.mProduktList.get(i).getBteNr());
            if (this.mProduktList.get(i).getLkz() != null && !this.mProduktList.get(i).getLkz().equals("")) {
                marktBenLabel = new KategorieJLabel(Resource.getInstance().getNurFuerMarkt() + " " + this.mProduktList.get(i).getMarkt());
                marktBenLabel.setOpaque(true);
                marktBenLabel.setBackground(new Color(252, 250, 156));
                marktBenLabel.setForeground(Color.GRAY);
            } else {
                marktBenLabel = new KategorieJLabel("");
            }
            marktBenLabel.setCursor(Constants.CursorTypen.STANDARD_CURSOR);
            marktBenLabel.setName(KEINE_DETAILANZEIGE);
            marktBenLabel.setDetailText("");
            marktBenLabel.setBteNr(this.mProduktList.get(i).getBteNr());
            this.mProduktGraphikList.add(produktGraphikLabel);
            this.mProduktNameList.add(produktNameLabel);
            this.mProduktBeschreibungList.add(produktBeschreibungLabel);
            this.mProduktBaureiheList.add(produktBaureiheLabel);
            this.mProduktPreisList.add(produktPreisLabel);
            this.mProduktVerfuegbarkeitList.add(produktVerfuegbarkeitLabel);
            this.mBteBedingungsIconList.add(bteBedingungsIconLabel);
            this.mMarktBenList.add(marktBenLabel);
            if (this.mProduktList.get(i).getHauptkategorie() != null && this.mProduktList.get(i).getHauptkategorie().getName().length() > 0) {
                this.mHauptKategorieList.add(this.mProduktList.get(i).getHauptkategorie().getName());
            } else if (hauptKategorie != null && hauptKategorie.length() > 0) {
                this.mHauptKategorieList.add(hauptKategorie);
            } else {
                this.mHauptKategorieList.add("");
            }
            if (this.mProduktList.get(i).getUnterkategorie() != null && this.mProduktList.get(i).getUnterkategorie().getName().length() > 0) {
                this.mProduktUnterkategorieList.add(this.mProduktList.get(i).getUnterkategorie().getName());
                continue;
            }
            if (unterkategorie != null && unterkategorie.length() > 0) {
                this.mProduktUnterkategorieList.add(unterkategorie);
                continue;
            }
            this.mProduktUnterkategorieList.add("");
        }
    }

    private String verkuerzeText(String text, String aufzaehlungsZeichen) {
        String dummy = "";
        int index = text.indexOf(aufzaehlungsZeichen, 1);
        dummy = index == -1 ? text : text.substring(0, index) + " ...";
        return "<html>" + dummy + "</html>";
    }

    private String verkuerzeTextZeileumbruch(String text, int startIndex) {
        String dummy = "";
        int index = text.indexOf("<br>", startIndex);
        dummy = index == -1 ? text : text.substring(0, index) + " ...";
        return "<html>" + dummy + "</html>";
    }

    public void setProduktListPanel(int row, int rowInset, HauptKategorie kategorie, HitListenUnterkategorie unterkategorie, ArrayList<ProduktListenElement> newProduktList) {
        this.mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mProduktList = newProduktList;
        this.setzeHKUKzuProduktList(kategorie, unterkategorie);
        this.anzahlSeiten = 0;
        this.blaetternLabelList = null;
        this.aktuellSelectedBlaetternIndex = -1;
        if (this.listPanel != null) {
            this.listPanel.removeAll();
        }
        if (this.listPanelList != null && this.listPanelList.length > 0) {
            for (int i = 0; i < this.listPanelList.length; ++i) {
                if (this.listPanelList[i] == null) continue;
                this.listPanelList[i].removeAll();
            }
        }
        if (this.panelIndexList != null && this.panelIndexList.size() > 0) {
            this.panelIndexList.clear();
        }
        if (this.panelUeberschriftHashtable != null && this.panelUeberschriftHashtable.size() > 0) {
            this.panelUeberschriftHashtable.clear();
        }
        if (this.panelHeadHashtable != null && this.panelHeadHashtable.size() > 0) {
            this.panelHeadHashtable.clear();
        }
        this.containerPanel.removeAll();
        if (newProduktList == null) {
            return;
        }
        this.setUeberschriftPanel();
        this.buildProduktList(unterkategorie == null ? null : unterkategorie.getName(), kategorie.getName());
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new CardLayout());
        this.listPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        if (this.mProduktBeschreibungList == null || this.mProduktBeschreibungList.size() <= 0) {
            this.containerPanel.add((Component)this.listPanel, "Center");
            return;
        }
        int anzahlPanels = this.getAnzahlPanels();
        int aktuellesElementIndex = 0;
        this.listPanelList = new JPanel[anzahlPanels];
        this.panelIndexList = new ArrayList();
        this.panelUeberschriftHashtable = new Hashtable();
        this.panelHeadHashtable = new Hashtable();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 11;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 10, 0, 0);
        KategorieJLabel produktGraphikLabel = null;
        KategorieJLabel produktNameLabel = null;
        KategorieJLabel produktBeschreibungLabel = null;
        KategorieJLabel produktBaureiheLabel = null;
        KategorieJLabel produktPreisLabel = null;
        KategorieJLabel produktVerfuegbarkeitLabel = null;
        KategorieJLabel bteBedingungsIconLabel = null;
        KategorieJLabel marktBenLabel = null;
        KategorieJLabel aktionsPfeil = null;
        ImageIcon AKTIONS_PFEIL_GRAPHIK = new ImageIcon(ImageCache.getInstance().getImage("Icons/Grp/enter-arrow-right.gif"));
        String bteNr = "";
        String bildPosNr = "";
        String cardNumber = "";
        String aktuelleUnterkategorie = "";
        String aktuelleHauptKategorie = "";
        if (this.mProduktUnterkategorieList != null && this.mProduktUnterkategorieList.size() > 0) {
            aktuelleUnterkategorie = this.mProduktUnterkategorieList.get(0);
        }
        if (this.mHauptKategorieList != null && this.mHauptKategorieList.size() > 0) {
            aktuelleHauptKategorie = this.mHauptKategorieList.get(0);
        }
        for (int i = 0; i < anzahlPanels; ++i) {
            this.listPanelList[i] = new JPanel();
            this.listPanelList[i].setLayout(layout);
            this.listPanelList[i].setBackground(this.mMarkenLayout.getPrimaryBackground());
            int j = 0;
            while (true) {
                this.getClass();
                if (j >= 4) break;
                if (j == 0) {
                    if (this.mProduktUnterkategorieList.size() > aktuellesElementIndex) {
                        aktuelleUnterkategorie = this.mProduktUnterkategorieList.get(aktuellesElementIndex);
                    }
                    if (this.mHauptKategorieList.size() > aktuellesElementIndex) {
                        aktuelleHauptKategorie = this.mHauptKategorieList.get(aktuellesElementIndex);
                    }
                }
                if (this.mProduktBeschreibungList.size() <= aktuellesElementIndex || aktuelleUnterkategorie.length() > 0 && this.mProduktUnterkategorieList.size() > aktuellesElementIndex && !this.mProduktUnterkategorieList.get(aktuellesElementIndex).equals(aktuelleUnterkategorie)) {
                    constraints.anchor = 11;
                    constraints.gridx = 0;
                    constraints.gridy = j * 3 + 2 + j;
                    constraints.gridwidth = 6;
                    constraints.gridheight = 1;
                    constraints.weightx = 1.0;
                    constraints.weighty = 100.0;
                    constraints.fill = 2;
                    constraints.insets = new Insets(0, 10, 0, 10);
                    this.listPanelList[i].add((Component)this.getSeparatorLabel(), constraints);
                    if (this.mProduktUnterkategorieList.size() <= aktuellesElementIndex) break;
                    aktuelleUnterkategorie = this.mProduktUnterkategorieList.get(aktuellesElementIndex);
                    break;
                }
                produktGraphikLabel = this.mProduktGraphikList.get(aktuellesElementIndex);
                produktNameLabel = this.mProduktNameList.get(aktuellesElementIndex);
                String produktName = produktNameLabel.getText();
                if (produktName.length() > 50) {
                    produktNameLabel.setToolTipText(produktName);
                    produktNameLabel.setText(produktName.substring(0, 50) + "...");
                }
                produktBeschreibungLabel = this.mProduktBeschreibungList.get(aktuellesElementIndex);
                produktBaureiheLabel = this.mProduktBaureiheList.get(aktuellesElementIndex);
                produktPreisLabel = this.mProduktPreisList.get(aktuellesElementIndex);
                produktVerfuegbarkeitLabel = this.mProduktVerfuegbarkeitList.get(aktuellesElementIndex);
                bteBedingungsIconLabel = this.mBteBedingungsIconList.get(aktuellesElementIndex);
                marktBenLabel = this.mMarktBenList.get(aktuellesElementIndex);
                bteNr = this.mProduktList.get(aktuellesElementIndex).getBteNr();
                bildPosNr = this.mProduktList.get(aktuellesElementIndex).getBildPosNr();
                aktionsPfeil = new KategorieJLabel(AKTIONS_PFEIL_GRAPHIK);
                aktionsPfeil.setBteNr(bteNr);
                aktionsPfeil.setBildPosNr(bildPosNr);
                aktionsPfeil.setDetailText("");
                aktionsPfeil.setUnterkategorieText(aktuelleUnterkategorie);
                aktionsPfeil.setKategorieText(aktuelleHauptKategorie);
                aktionsPfeil.setAktionLabel(true);
                aktionsPfeil.setCursor(Cursor.getPredefinedCursor(12));
                produktBaureiheLabel.setBteNr(bteNr);
                produktBaureiheLabel.setBildPosNr(bildPosNr);
                produktGraphikLabel.setBteNr(bteNr);
                produktGraphikLabel.setBildPosNr(bildPosNr);
                produktNameLabel.setBteNr(bteNr);
                produktNameLabel.setBildPosNr(bildPosNr);
                produktBeschreibungLabel.setBteNr(bteNr);
                produktBeschreibungLabel.setBildPosNr(bildPosNr);
                produktBaureiheLabel.setBteNr(bteNr);
                produktBaureiheLabel.setBildPosNr(bildPosNr);
                produktNameLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
                produktNameLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
                produktBeschreibungLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
                produktBaureiheLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
                produktPreisLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
                produktBeschreibungLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
                produktBaureiheLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
                produktPreisLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
                constraints.gridy = j * 4;
                constraints.anchor = 11;
                constraints.gridx = 0;
                constraints.gridwidth = 6;
                constraints.gridheight = 1;
                constraints.weighty = 1.0;
                constraints.fill = 2;
                constraints.insets = new Insets(0, 10, 0, 10);
                this.listPanelList[i].add((Component)this.getSeparatorLabel(), constraints);
                constraints.gridy = j * 3 + 1 + j;
                constraints.gridwidth = 1;
                constraints.gridheight = 3;
                constraints.weighty = 1.0;
                constraints.fill = 0;
                constraints.insets = new Insets(10, 10, 0, 0);
                constraints.anchor = 11;
                constraints.gridx = 0;
                this.listPanelList[i].add((Component)produktGraphikLabel, constraints);
                constraints.anchor = 18;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.weightx = 100.0;
                constraints.fill = 2;
                this.listPanelList[i].add((Component)produktNameLabel, constraints);
                constraints.insets = new Insets(0, 10, 0, 0);
                constraints.gridy = j * 3 + 2 + j;
                constraints.fill = 2;
                this.listPanelList[i].add((Component)produktBeschreibungLabel, constraints);
                constraints.insets = new Insets(10, 10, 0, 0);
                constraints.gridy = j * 3 + 3 + j;
                constraints.fill = 0;
                this.listPanelList[i].add((Component)aktionsPfeil, constraints);
                constraints.gridy = j * 3 + 1 + j;
                constraints.gridheight = 3;
                constraints.weightx = 1.0;
                constraints.gridx = 2;
                this.listPanelList[i].add((Component)produktBaureiheLabel, constraints);
                constraints.gridx = 3;
                this.listPanelList[i].add((Component)produktPreisLabel, constraints);
                constraints.gridx = 4;
                this.listPanelList[i].add((Component)produktVerfuegbarkeitLabel, constraints);
                String bteBedingungstext = NavigationPanelDataLoader.loadBteBedingung(bteNr);
                constraints.gridx = 5;
                if (marktBenLabel.getText() == "") {
                    constraints.insets = new Insets(10, 10, 0, 14);
                }
                if (!bteBedingungstext.equals("")) {
                    bteBedingungsIconLabel.setIcon(ImageCache.getInstance().getIcon("question.png"));
                    this.listPanelList[i].add((Component)bteBedingungsIconLabel, constraints);
                }
                --constraints.gridy;
                constraints.gridwidth = 6;
                constraints.gridx = 1;
                constraints.anchor = 13;
                constraints.fill = 0;
                constraints.insets = new Insets(10, 10, 0, 12);
                marktBenLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
                this.listPanelList[i].add((Component)marktBenLabel, constraints);
                constraints.fill = 0;
                constraints.gridwidth = 1;
                ++constraints.gridy;
                if (marktBenLabel.getText() != "") {
                    constraints.gridx = 5;
                    constraints.anchor = 17;
                    constraints.insets = new Insets(10, 20, 0, 6);
                    constraints.fill = 3;
                    JPanel line = new JPanel();
                    line.setBackground(this.mMarkenLayout.getPrimaryBackground());
                    line.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 3, new Color(252, 250, 156)));
                    this.listPanelList[i].add((Component)line, constraints);
                }
                constraints.anchor = 11;
                constraints.fill = 0;
                constraints.insets = new Insets(10, 10, 0, 10);
                ++aktuellesElementIndex;
                ++j;
            }
            cardNumber = String.valueOf(i);
            this.listPanel.add((Component)this.listPanelList[i], cardNumber);
            this.panelIndexList.add(cardNumber);
            if (this.panelUeberschriftHashtable != null) {
                if (aktuellesElementIndex > 0) {
                    if (this.mProduktUnterkategorieList.get(aktuellesElementIndex - 1) != null) {
                        this.panelUeberschriftHashtable.put(cardNumber, this.mProduktUnterkategorieList.get(aktuellesElementIndex - 1));
                    }
                } else if (this.mProduktUnterkategorieList.get(0) != null) {
                    this.panelUeberschriftHashtable.put(cardNumber, this.mProduktUnterkategorieList.get(0));
                }
            }
            if (this.panelHeadHashtable == null) continue;
            if (aktuellesElementIndex > 0) {
                if (this.mHauptKategorieList.get(aktuellesElementIndex - 1) == null) continue;
                this.panelHeadHashtable.put(cardNumber, this.mHauptKategorieList.get(aktuellesElementIndex - 1));
                continue;
            }
            if (this.mHauptKategorieList.get(0) == null) continue;
            this.panelHeadHashtable.put(cardNumber, this.mHauptKategorieList.get(0));
        }
        if (this.aktuellesPanel.length() <= 0) {
            ((CardLayout)this.listPanel.getLayout()).first(this.listPanel);
            if (this.panelUeberschriftHashtable.containsKey("0")) {
                this.setUeberschriftPanel(this.panelUeberschriftHashtable.get("0"));
            }
            if (this.panelHeadHashtable.containsKey("0")) {
                this.setHeaderAndStatus(kategorie.getName());
            }
        } else {
            ((CardLayout)this.listPanel.getLayout()).show(this.listPanel, this.aktuellesPanel);
            if (this.panelUeberschriftHashtable.containsKey(this.aktuellesPanel)) {
                this.setUeberschriftPanel(this.panelUeberschriftHashtable.get(this.aktuellesPanel));
            }
        }
        this.listPanel.validate();
        this.listPanel.setVisible(true);
        this.containerPanel.add((Component)this.listPanel, "Center");
        this.setBlaetternPanel();
        if (this.aktuellesPanel.length() > 0) {
            try {
                int panelIndex = Integer.parseInt(this.aktuellesPanel) + 1;
                while (this.aktuellSelectedBlaetternIndex < panelIndex) {
                    this.blaetternVor();
                }
                if (this.blaetternLabelList != null && this.blaetternLabelList.size() >= this.aktuellSelectedBlaetternIndex) {
                    this.aktiviereBlaetternButton(this.blaetternLabelList.get(this.aktuellSelectedBlaetternIndex - 1));
                }
            }
            catch (NumberFormatException e1) {
                log.error((Object)e1.getMessage());
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    private void setzeHKUKzuProduktList(HauptKategorie kategorie, HitListenUnterkategorie unterkategorie) {
        if (this.mProduktList != null && this.mProduktList.size() > 0) {
            for (ProduktListenElement produkt : this.mProduktList) {
                if (produkt.getUnterkategorie() == null) {
                    produkt.setUnterkategorie(unterkategorie);
                }
                if (produkt.getHauptkategorie() != null) continue;
                produkt.setHauptkategorie(kategorie);
            }
        }
    }

    private void setHeaderAndStatus(String kategorie) {
        ControllerStatusBar.getInstance().getStatusBar().removeAllStatusFromIndex(2);
        String kategorieStatus = "";
        kategorieStatus = kategorie != null && !kategorie.equals("") && !kategorie.equals(Resource.getInstance().getKategorie()) ? kategorie : this.panelHeadHashtable.get("0");
        kategorieStatus = ControllerStatusBar.createStatusHauptkat(kategorieStatus);
        if (!ControllerInfoPanel.getInstance().getInfoPanel().isHitlistShown()) {
            ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + kategorieStatus, "SUBCAT");
        } else {
            ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + kategorieStatus, "PRODUCTLIST");
        }
    }

    private int getAnzahlPanels() {
        if (this.mProduktUnterkategorieList == null || this.mProduktUnterkategorieList.size() <= 0) {
            return 0;
        }
        this.getClass();
        if (4 <= 0) {
            return 0;
        }
        int anzahlPanels = 1;
        this.mAktuelleUnterkategorie = this.mProduktUnterkategorieList.get(0);
        int aktuelleAnzahl = 0;
        for (int i = 0; i < this.mProduktUnterkategorieList.size(); ++i) {
            block7: {
                block6: {
                    if (!this.mAktuelleUnterkategorie.equalsIgnoreCase(this.mProduktUnterkategorieList.get(i))) break block6;
                    if (aktuelleAnzahl <= 0) break block7;
                    this.getClass();
                    if (aktuelleAnzahl % 4 != 0) break block7;
                }
                aktuelleAnzahl = 0;
                ++anzahlPanels;
                this.mAktuelleUnterkategorie = this.mProduktUnterkategorieList.get(i);
            }
            ++aktuelleAnzahl;
        }
        this.mAktuelleUnterkategorie = this.mProduktUnterkategorieList.get(0);
        return anzahlPanels;
    }

    public void resetProduktListPanel() {
        this.setProduktListPanel(0, 0, null, null, null);
        this.setChanged();
        this.notifyObservers();
    }

    private void setUeberschriftPanel() {
        this.ueberschriftPanel = new JPanel(new FlowLayout(0, 10, 10));
        this.ueberschriftPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.buildUeberschriftPanel();
        this.containerPanel.add((Component)this.ueberschriftPanel, "North");
    }

    private void buildUeberschriftPanel() {
        this.ueberschriftPanel.removeAll();
        JLabel ueberschriftLabel = new JLabel();
        if (ControllerMainPanel.getInstance().getMainPanel().getSubcategory() == null) {
            return;
        }
        String text = ControllerMainPanel.getInstance().getMainPanel().getSubcategory().getSelectedUnterkategorieText();
        if (text == null || text.length() <= 0) {
            return;
        }
        ueberschriftLabel.setText(text);
        ueberschriftLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.ueberschriftPanel.add(ueberschriftLabel);
    }

    public void setUeberschriftPanel(String text) {
        this.ueberschriftPanel.removeAll();
        if (text == null || text.length() <= 0) {
            return;
        }
        JLabel ueberschriftLabel = new JLabel(text);
        ueberschriftLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.ueberschriftPanel.add(ueberschriftLabel);
    }

    public void clearUeberschriftPanel() {
        if (this.ueberschriftPanel != null) {
            this.ueberschriftPanel.removeAll();
        }
    }

    private void setBlaetternPanel() {
        this.blaetternPanel = new JPanel(new FlowLayout(2));
        this.blaetternPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.buildBlaetternPanel();
        this.containerPanel.add((Component)this.blaetternPanel, "South");
    }

    private void buildBlaetternPanel() {
        this.blaetternPanel.removeAll();
        this.anzahlSeiten = 0;
        this.aktuellSelectedBlaetternIndex = -1;
        if (this.mProduktBeschreibungList == null) {
            return;
        }
        this.anzahlSeiten = this.getAnzahlPanels();
        if (this.anzahlSeiten <= 1) {
            return;
        }
        this.blaetternLabelList = new ArrayList();
        JLabel blaetternLabel = null;
        String text = "";
        boolean blaetternMehrSet = false;
        for (int i = 0; i < this.anzahlSeiten; ++i) {
            blaetternLabel = new JLabel();
            text = String.valueOf(i + 1);
            if (i + 1 < this.anzahlSeiten) {
                text = text + " |";
            }
            blaetternLabel.setText(text);
            blaetternLabel.setName(String.valueOf(i + 1));
            blaetternLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            blaetternLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.blaetternVorLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.blaetternVorLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.blaetternEndeLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.blaetternEndeLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.blaetternZurueckLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.blaetternZurueckLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.blaetternAnfangLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.blaetternAnfangLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.blaetternLabelList.add(blaetternLabel);
            this.getClass();
            if (i < 4) {
                this.blaetternPanel.add(blaetternLabel);
                continue;
            }
            if (blaetternMehrSet) continue;
            this.blaetternPanel.add(this.blaetternVorLabel);
            this.blaetternPanel.add(this.blaetternEndeLabel);
        }
        this.aktuellSelectedBlaetternIndex = 1;
        if (this.panelUeberschriftHashtable.get(this.aktuellesPanel) != null) {
            this.setAktuelleUnterkategorie(this.panelUeberschriftHashtable.get(this.aktuellesPanel));
        }
        if (this.blaetternLabelList != null && this.blaetternLabelList.size() >= this.aktuellSelectedBlaetternIndex) {
            this.aktiviereBlaetternButton(this.blaetternLabelList.get(this.aktuellSelectedBlaetternIndex - 1));
        }
    }

    private void deaktiviereBlaetternButtons() {
        if (this.blaetternLabelList == null) {
            return;
        }
        JLabel blaetternLabel = null;
        for (int i = 0; i < this.blaetternLabelList.size(); ++i) {
            blaetternLabel = this.blaetternLabelList.get(i);
            blaetternLabel.setBigFont();
        }
    }

    private void aktiviereBlaetternButton(JLabel blaetternLabel) {
        this.deaktiviereBlaetternButtons();
        if (this.blaetternLabelList == null) {
            return;
        }
        if (blaetternLabel == null) {
            return;
        }
        if (this.blaetternLabelList.indexOf(blaetternLabel) >= 0) {
            this.blaetternLabelList.get(this.blaetternLabelList.indexOf(blaetternLabel)).setBoldFont();
        }
    }

    private ProduktListenElement getProduktListeElement(String bteNr, String bildPosNr) {
        for (int ii = 0; ii < this.mProduktList.size(); ++ii) {
            ProduktListenElement elem = this.mProduktList.get(ii);
            if ((!bteNr.equals(elem.getBteNr()) || bildPosNr != null || elem.getBildPosNr() != null) && (bildPosNr == null || elem.getBildPosNr() == null || !bildPosNr.equals(elem.getBildPosNr()))) continue;
            return elem;
        }
        return null;
    }

    public boolean handleProduktListeMouseEvent(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.getSource() instanceof KategorieJLabel)) {
            return false;
        }
        this.mSelectedBteNr = ((KategorieJLabel)event.getSource()).getBteNr();
        this.mSelectedBildPosNr = ((KategorieJLabel)event.getSource()).getBildPosNr();
        ProduktListenElement produkt = this.getProduktListeElement(this.mSelectedBteNr, this.mSelectedBildPosNr);
        GlobalObjects.getInstance().getIpacData().setSelectedBnb(this.mSelectedBildPosNr);
        GlobalObjects.getInstance().getIpacData().setSelectedBte(this.mSelectedBteNr);
        GlobalObjects.getInstance().getIpacData().setSelectedProdukt(produkt);
        WorkflowController.getInstance().setUnterkategorie(produkt.getUnterkategorie());
        WorkflowController.getInstance().setHauptKategorie(produkt.getHauptkategorie());
        if (!((KategorieJLabel)event.getSource()).isAktionLabel() && event.getClickCount() < 2) {
            String detailText = ((KategorieJLabel)event.getSource()).getTeaserText();
            if (detailText != null && detailText.length() > 0 && this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                detailText = "<html><div class='menu2'>" + this.mMarkenLayout.cleanTextWithNewLine(detailText, "#", "&#149; ") + "</div></html>";
            }
            ImageIcon detailGraphik = ((KategorieJLabel)event.getSource()).getDetailGraphik();
            ArrayList<Baureihe> baureiheList = ((KategorieJLabel)event.getSource()).getDetailBaureiheList();
            ArrayList<Bauart> bauartList = ((KategorieJLabel)event.getSource()).getDetailBauartList();
            String operationName = ((KategorieJLabel)event.getSource()).getName();
            if (operationName == null) {
                MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("3");
            }
            if (detailGraphik != null) {
                MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().setGraphik(detailGraphik);
            } else if (detailText != null && detailText.length() > 0) {
                MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().setText(detailText);
            } else if (baureiheList != null && baureiheList.size() > 0) {
                baureiheList = NavigationPanelDataLoader.loadBaureihenElemente(this.mSelectedBteNr, this.mSelectedBildPosNr);
                MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().setBaureiheTree(baureiheList);
            } else if (bauartList != null && bauartList.size() > 0) {
                bauartList = NavigationPanelDataLoader.loadBauartenElemente(this.mSelectedBteNr, this.mSelectedBildPosNr);
                MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().setBauartTree(bauartList);
            } else if (operationName != null && operationName.equals(BTE_BEDINGUNG)) {
                String bteBedingungstext = NavigationPanelDataLoader.loadBteBedingung(this.mSelectedBteNr);
                log.info((Object)("bteBedingungstext: " + bteBedingungstext));
                bteBedingungstext = bteBedingungstext.replaceAll("F\u00fcr Fahrzeuge mit", Resource.getInstance().getFuerFahrzeug() + " " + Resource.getInstance().getMit());
                bteBedingungstext = bteBedingungstext.replaceAll("ja", Resource.getInstance().getJa());
                bteBedingungstext = bteBedingungstext.replaceAll("nein", Resource.getInstance().getNein());
                bteBedingungstext = bteBedingungstext.replaceAll("und", Resource.getInstance().getUndOder().substring(0, Resource.getInstance().getUndOder().indexOf(" ")));
                bteBedingungstext = bteBedingungstext.replaceAll("oder", Resource.getInstance().getOder());
                JOptionPane.showConfirmDialog(this.listPanel, bteBedingungstext, Resource.getInstance().getInformation(), -1, 1, 0, 0);
            } else {
                MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().setText("");
            }
        }
        return ((KategorieJLabel)event.getSource()).isAktionLabel();
    }

    public void handleBlaetternPanelMouseEnteredEvent(MouseEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JLabel)) {
            return;
        }
        MainController.getInstance().getMainFrame().setCursor(Constants.CursorTypen.HAND_CURSOR);
    }

    public void handleProduktListeMouseExitedEvent(MouseEvent event) {
        MainController.getInstance().getMainFrame().setCursor(Constants.CursorTypen.STANDARD_CURSOR);
    }

    public void handleBlaetternMouseEvent(MouseEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JLabel)) {
            return;
        }
        MainController.getInstance().getMainFrame().getInfoPanel().getDetailPanel().setText("");
        MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("4");
        JLabel selectedLabel = (JLabel)event.getSource();
        String selectedPanelIndex = selectedLabel.getName();
        if (selectedPanelIndex == null || selectedPanelIndex.length() <= 0) {
            this.handleBlaetternSteuernEvent(selectedLabel);
            return;
        }
        try {
            this.aktuellSelectedBlaetternIndex = Integer.parseInt(selectedPanelIndex);
        }
        catch (NumberFormatException e1) {
            log.error((Object)e1.getMessage());
            return;
        }
        if (!this.getDatenGeladen(selectedPanelIndex)) {
            // empty if block
        }
        this.aktuellesPanel = String.valueOf(this.aktuellSelectedBlaetternIndex - 1);
        ((CardLayout)this.listPanel.getLayout()).show(this.listPanel, this.aktuellesPanel);
        StatusBar statusBar = MainController.getInstance().getMainFrame().getStatusBar();
        statusBar.removeAllStatusFromIndex(2);
        this.setHeaderAndStatus(this.panelHeadHashtable.get(this.aktuellesPanel));
        statusBar.addNewStatus(" > " + this.panelUeberschriftHashtable.get(this.aktuellesPanel), "PRODUCTLIST");
        if (this.blaetternLabelList != null && this.blaetternLabelList.size() >= this.aktuellSelectedBlaetternIndex) {
            this.aktiviereBlaetternButton(this.blaetternLabelList.get(this.aktuellSelectedBlaetternIndex - 1));
        }
        if (this.panelUeberschriftHashtable.containsKey(this.aktuellesPanel)) {
            this.setUeberschriftPanel(this.panelUeberschriftHashtable.get(this.aktuellesPanel));
        }
        MainController.getInstance().getMainFrame().getRootPane().updateUI();
        MainController.getInstance().getMainFrame().getMainPanel().getHeaderPanel().updateUI();
    }

    private void handleBlaetternSteuernEvent(JLabel blaetternLabel) {
        if (blaetternLabel == null) {
            return;
        }
        if (blaetternLabel.getText().equals("<<")) {
            this.blaetternAnfang();
        } else if (blaetternLabel.getText().equals("<")) {
            if (this.aktuellSelectedBlaetternIndex > 0) {
                this.blaetternZurueck();
            }
        } else if (blaetternLabel.getText().equals(">")) {
            if (this.aktuellSelectedBlaetternIndex > 0) {
                this.blaetternVor();
            }
        } else if (blaetternLabel.getText().equals(">>")) {
            this.blaetternEnde();
        }
        this.aktuellesPanel = String.valueOf(this.aktuellSelectedBlaetternIndex - 1);
        ((CardLayout)this.listPanel.getLayout()).show(this.listPanel, this.aktuellesPanel);
        if (this.blaetternLabelList != null && this.blaetternLabelList.size() >= this.aktuellSelectedBlaetternIndex) {
            this.aktiviereBlaetternButton(this.blaetternLabelList.get(this.aktuellSelectedBlaetternIndex - 1));
        }
        if (this.panelHeadHashtable.containsKey(this.aktuellesPanel)) {
            this.setHeaderAndStatus(this.panelHeadHashtable.get(this.aktuellesPanel));
        }
        if (this.panelUeberschriftHashtable.containsKey(this.aktuellesPanel)) {
            this.setUeberschriftPanel(this.panelUeberschriftHashtable.get(this.aktuellesPanel));
            ControllerStatusBar.getInstance().getStatusBar().removeAllStatusFromIndex(3);
            ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + this.panelUeberschriftHashtable.get(this.aktuellesPanel), "PRODUCTLIST");
        }
        MainController.getInstance().getMainFrame().getRootPane().updateUI();
    }

    private void blaetternAnfang() {
        this.aktuellSelectedBlaetternIndex = 1;
        if (this.getBlaetternIndexInIntervall(this.aktuellSelectedBlaetternIndex)) {
            return;
        }
        this.blaetternPanel.removeAll();
        for (int i = 0; i < this.anzahlSeiten; ++i) {
            this.getClass();
            if (i >= 4) break;
            this.blaetternPanel.add(this.blaetternLabelList.get(i));
        }
        this.getClass();
        if (this.anzahlSeiten > 4) {
            this.blaetternPanel.add(this.blaetternVorLabel);
            this.blaetternPanel.add(this.blaetternEndeLabel);
        }
    }

    private void blaetternZurueck() {
        --this.aktuellSelectedBlaetternIndex;
        if (this.getBlaetternIndexInIntervall(this.aktuellSelectedBlaetternIndex)) {
            return;
        }
        this.blaetternPanel.removeAll();
        int intervallBeginn = this.aktuellSelectedBlaetternIndex;
        if (intervallBeginn < 1) {
            intervallBeginn = 1;
        }
        if (intervallBeginn > 1) {
            this.blaetternPanel.add(this.blaetternAnfangLabel);
            this.blaetternPanel.add(this.blaetternZurueckLabel);
        }
        int i = intervallBeginn;
        while (true) {
            this.getClass();
            if (i >= intervallBeginn + 4 || this.anzahlSeiten < i) break;
            if (i >= 1 && this.blaetternLabelList != null) {
                this.blaetternPanel.add(this.blaetternLabelList.get(i - 1));
            }
            ++i;
        }
        this.getClass();
        if (intervallBeginn + 4 - 1 < this.anzahlSeiten) {
            this.blaetternPanel.add(this.blaetternVorLabel);
            this.blaetternPanel.add(this.blaetternEndeLabel);
        }
    }

    private void blaetternVor() {
        ++this.aktuellSelectedBlaetternIndex;
        if (this.getBlaetternIndexInIntervall(this.aktuellSelectedBlaetternIndex)) {
            return;
        }
        this.blaetternPanel.removeAll();
        int intervallBeginn = this.aktuellSelectedBlaetternIndex;
        this.getClass();
        if (intervallBeginn > this.anzahlSeiten - 4 + 1) {
            this.getClass();
            intervallBeginn = this.anzahlSeiten - 4 + 1;
        }
        if (intervallBeginn > 1) {
            this.blaetternPanel.add(this.blaetternAnfangLabel);
            this.blaetternPanel.add(this.blaetternZurueckLabel);
        }
        int i = intervallBeginn;
        while (true) {
            this.getClass();
            if (i >= intervallBeginn + 4 || this.anzahlSeiten < i) break;
            if (i >= 1 && this.blaetternLabelList != null) {
                this.blaetternPanel.add(this.blaetternLabelList.get(i - 1));
            }
            ++i;
        }
        this.getClass();
        if (intervallBeginn + 4 - 1 < this.anzahlSeiten) {
            this.blaetternPanel.add(this.blaetternVorLabel);
            this.blaetternPanel.add(this.blaetternEndeLabel);
        }
    }

    private void blaetternEnde() {
        int intervallBeginn;
        this.aktuellSelectedBlaetternIndex = this.anzahlSeiten;
        if (this.getBlaetternIndexInIntervall(this.aktuellSelectedBlaetternIndex)) {
            return;
        }
        this.blaetternPanel.removeAll();
        this.getClass();
        if (this.anzahlSeiten > 4) {
            this.blaetternPanel.add(this.blaetternAnfangLabel);
            this.blaetternPanel.add(this.blaetternZurueckLabel);
        }
        this.getClass();
        for (int i = intervallBeginn = this.anzahlSeiten - 4 + 1; i <= this.anzahlSeiten && this.anzahlSeiten >= i; ++i) {
            this.blaetternPanel.add(this.blaetternLabelList.get(i - 1));
        }
    }

    private boolean getBlaetternIndexInIntervall(int index) {
        if (index <= 0) {
            return false;
        }
        for (int i = 0; i < this.blaetternPanel.getComponentCount(); ++i) {
            if (((JLabel)this.blaetternPanel.getComponent(i)).getName() == null || !((JLabel)this.blaetternPanel.getComponent(i)).getName().equals(String.valueOf(index))) continue;
            return true;
        }
        return false;
    }

    private boolean getDatenGeladen(String panelIndex) {
        if (panelIndex == null || panelIndex.length() <= 0) {
            return true;
        }
        return this.panelIndexList.contains(panelIndex);
    }

    public JPanel getProduktListPanel() {
        return this.listPanel;
    }

    public String getKategorie() {
        return this.mKategorie;
    }

    public String getUnterkategorie() {
        return this.mUnterkategorie;
    }

    public JPanel getContainerPanel() {
        return this.containerPanel;
    }

    public ArrayList<ProduktListenElement> getProduktList() {
        return this.mProduktList;
    }

    public void setProduktList(ArrayList<ProduktListenElement> newProduktList) {
        this.mProduktList = newProduktList;
    }

    public JPanel getBlaetternPanel() {
        return this.blaetternPanel;
    }

    public String getSelectedBteNr() {
        return this.mSelectedBteNr;
    }

    public String getSelectedBildPosNr() {
        return this.mSelectedBildPosNr;
    }

    public String getAktuellesPanel() {
        return this.aktuellesPanel;
    }

    public void setAktuellesPanel(String aktuellesPanel) {
        this.aktuellesPanel = aktuellesPanel;
    }

    public ArrayList<JLabel> getBlaetternLabelList() {
        return this.blaetternLabelList;
    }

    public JLabel getBlaetternAnfangLabel() {
        return this.blaetternAnfangLabel;
    }

    public JLabel getBlaetternZurueckLabel() {
        return this.blaetternZurueckLabel;
    }

    public JLabel getBlaetternVorLabel() {
        return this.blaetternVorLabel;
    }

    public JLabel getBlaetternEndeLabel() {
        return this.blaetternEndeLabel;
    }

    public String getAktuelleUnterkategorie() {
        return this.mAktuelleUnterkategorie;
    }

    public void setAktuelleUnterkategorie(String aktuelleUnterkategorie) {
        this.mAktuelleUnterkategorie = aktuelleUnterkategorie;
    }

    public boolean isPruefeVerfuegbarkeit() {
        return this.mIsPruefeVerfuegbarkeit;
    }

    public void setPruefeVerfuegbarkeit(boolean isPruefeVerfuegbarkeit) {
        this.mIsPruefeVerfuegbarkeit = isPruefeVerfuegbarkeit;
    }

    private ImageIcon getScaledThumbNail(ImageIcon icon, int width, int height) {
        if (icon != null) {
            Image image = icon.getImage().getScaledInstance(width, height, 16);
            icon = new ImageIcon(image);
        }
        return icon;
    }

    public boolean isFBAVisible() {
        return this.isFBAVisible;
    }

    public void setFBAVisible(boolean isFBAVisible) {
        this.isFBAVisible = isFBAVisible;
    }
}

