/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.ControllerConfigurationPanel;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.ControllerArbeitHinzufuegen;
import de.esg.zub.configurator.content.technisch.ControllerTeileHinzufuegen;
import de.esg.zub.configurator.content.technisch.HilfsTableModel;
import de.esg.zub.configurator.content.technisch.TechnikDataloader;
import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.configurator.content.technisch.TechnikPanel;
import de.esg.zub.configurator.content.technisch.TeileTableModel;
import de.esg.zub.configurator.content.technisch.WrongSelectionException;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.score.ZubScoreDataCreator;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.CommunicationException;
import webetk.communication.JavaAssSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.etkscore.ZubIspaZubehoerpakete;
import webetk.javaclient.dialog.bte.BTEController;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoKleinController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class ControllerTechnikPanel
extends Observable
implements MouseListener,
MouseMotionListener,
Observer,
KeyListener {
    private static ControllerTechnikPanel mInstance;
    private static Logger log;
    private TechnikPanel mTechnikView;
    private TechnikModel mModel;
    private String errorMsg = "";
    private int error = 0;
    public static final int KEIN_PRODUKT = 1;
    public static final int FALSCHE_ALTERNATIVE = 2;
    public static final int FALSCHE_VARIANTE_ALT = 3;
    public static final int FALSCHE_VARIANTE_BESTT = 4;
    public static final int UNGUELTIGE_ZUSATZPRODUKTE = 5;
    private static final String TECHNISCHESICHT = "TechnischeSicht";
    public static final String PRUEFEN = "Pruefen";
    private boolean mAngebotsSicht;

    private ControllerTechnikPanel() {
    }

    public static ControllerTechnikPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerTechnikPanel();
            mInstance.setTechnikView(new TechnikPanel(WorkflowController.getInstance().getMarkenLayout()));
            mInstance.getTechnikViewInternal().addObserver(mInstance);
            mInstance.addListener();
        }
        return mInstance;
    }

    private void addListener() {
        HilfeMouseListener hilfeListener = new HilfeMouseListener("i50074");
        TechnikPanel view = ControllerTechnikPanel.getTechnikView();
        view.getSymbolKern().addMouseListener(mInstance);
        view.getSymbolKern().addMouseListener(hilfeListener);
        view.getSymbolOptional().addMouseListener(mInstance);
        view.getSymbolOptional().addMouseListener(hilfeListener);
        view.getSymbolHilf().addMouseListener(mInstance);
        view.getSymbolHilf().addMouseListener(hilfeListener);
        view.getArbeitHinzufuegenLabel().addMouseListener(mInstance);
        view.getArbeitHinzufuegenLabel().addMouseListener(hilfeListener);
        view.getTeileHinzufuegenLabel().addMouseListener(mInstance);
        view.getTeileHinzufuegenLabel().addMouseListener(hilfeListener);
        view.getISPALabel().addMouseListener(mInstance);
        for (int ii = 0; ii < view.getInfoPanel().getHeadPanel().size(); ++ii) {
            view.getInfoPanel().getHeadPanel().get(ii).addMouseListener(mInstance);
            view.getInfoPanel().getHeadPanel().get(ii).addMouseListener(hilfeListener);
            view.getInfoPanel().getHeadLabel().get(ii).addMouseListener(mInstance);
            view.getInfoPanel().getHeadLabel().get(ii).addMouseListener(hilfeListener);
        }
        view.getEditorInt().addKeyListener(mInstance);
    }

    public void init() {
        if (WorkflowController.getInstance().isNewKonfiguration()) {
            this.newKonfiguration();
            this.setAngebotsSicht(false);
        } else {
            this.oldKonfiguration();
        }
    }

    public void refreshTechnikPanel(TechnikModel model) {
        this.mModel = model;
        this.removeNPZ(this.mModel.getTechnikProdukt());
        this.setArbeiten();
        this.mTechnikView.setModel(this.mModel);
        ControllerMainPanel.getInstance().getMainPanel().addTechnikPanel();
        ControllerMiniaturansicht.getInstance().showMiniaturansichten();
    }

    private void setArbeiten() {
        try {
            this.mModel.setAufwaende(AdminDataLoader.ladeAufwandKonfiguration(GlobalObjects.getInstance().getSessionInfo().getFilialeId(), GlobalObjects.getInstance().getSessionInfo().getMarke(), GlobalObjects.getInstance().getSessionInfo().getProdukart()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void newKonfiguration() {
        this.error = 0;
        if (this.createModel(TECHNISCHESICHT)) {
            ControllerMarketingPanel.getInstance().getModel();
            this.mTechnikView.setLayout(WorkflowController.getInstance().getMarkenLayout());
            MainController.getInstance().getMainFrame().getMainPanel().addTechnikPanel();
            WorkflowController.getInstance().setNewKonfiguration(false);
            if (!WorkflowController.getInstance().isAddKonfiguration()) {
                MainController.getInstance().getMainFrame().getMainPanel().addConfigPanel();
                ControllerMenuBar.getInstance().getMenuBar().addVorgaengePanel();
                if (ControllerMenuBar.getInstance().addVorgang()) {
                    ControllerConfigurationPanel.getInstance().addConfiguration();
                }
            } else {
                Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
                ClientKonfiguration aktuelleKonfiguration = AnfrageHandler.getInstance().createKonfiguration(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt(), anfrage);
                if (aktuelleKonfiguration != null) {
                    ControllerConfigurationPanel.getInstance().addConfiguration();
                }
                WorkflowController.getInstance().setAddKonfiguration(aktuelleKonfiguration != null);
                this.mTechnikView.setLayout(WorkflowController.getInstance().getMarkenLayout());
                MainController.getInstance().getMainFrame().getMainPanel().addTechnikPanel();
                WorkflowController.getInstance().setNewKonfiguration(false);
            }
        } else {
            WorkflowController.getInstance().setNewKonfiguration(true);
            WorkflowController.getInstance().setFzBedIdentified(false);
            MainController.getInstance().getMainFrame().getStatusBar().removeAllStatusFromIndex(4);
            if (this.error == 1) {
                MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(this.errorMsg);
                ControllerNavigationPanel.getInstance().getNavigationPanel().setRefreshForFZChange(true);
                MainController.getInstance().getMainFrame().changeContainerInfoMiniatur("INFOPANEL");
                if (ControllerProduktListPanel.getInstance().getProduktListPanel().getProduktList() == null) {
                    ControllerStatusBar.getInstance().getStatusBar().updateSubcatProd("PRODUCTLIST");
                }
                WorkflowController.getInstance().changeState("PRODUCTLIST");
                throw new WrongSelectionException("Wrong selection im Marketingsicht");
            }
            MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(this.errorMsg);
            this.errorMsg = "";
            MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
            ControllerMiniaturansicht.getInstance().getMiniaturMarketing().setBorder();
            ControllerMiniaturansicht.getInstance().getMiniaturTechnik().removeBorder();
            WorkflowController.getInstance().changeState("MARKETING");
            ControllerMarketingPanel.getInstance().refreshMarketingPanel(model, true, this.error);
            throw new WrongSelectionException("Wrong selection im Marketingsicht");
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void oldKonfiguration() {
        ControllerMiniaturansicht.getInstance().showMiniaturansichten();
        MainController.getInstance().getMainFrame().getMainPanel().addTechnikPanel();
    }

    public boolean createModel(String modus) {
        this.mModel = new TechnikModel();
        this.setArbeiten();
        TechnischesProdukt technikProdukt = this.getData();
        if (technikProdukt == null) {
            this.error = 1;
            return false;
        }
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        boolean wrongZubProdukt = false;
        if (model.getSelectedZusatzprodukte() != null && model.getSelectedZusatzprodukte().size() > 0) {
            StringBuilder bui = new StringBuilder();
            for (ProduktListenElement el : model.getSelectedZusatzprodukte()) {
                if (model.getMarketingProdukt().isFahrzeugUngebunden() || technikProdukt.getVerbaubareZubehoerProdukte().contains(el)) continue;
                wrongZubProdukt = true;
                this.error = 5;
                this.errorMsg = Resource.getInstance().getUngueltigeZusatzprodukte();
                if (bui.length() > 0) {
                    bui.append(", ");
                }
                bui.append(el.getProduktNamePlain() + " " + (el.getVariante() != null ? el.getVariante() : ""));
            }
            if (technikProdukt.getZusatzProduktBnbs().size() == 0) {
                wrongZubProdukt = true;
                this.errorMsg = Resource.getInstance().getUngueltigeZusatzprodukte();
                for (ProduktListenElement el : model.getSelectedZusatzprodukte()) {
                    if (bui.length() > 0) {
                        bui.append(", ");
                    }
                    bui.append(el.getProduktNamePlain() + " " + (el.getVariante() != null ? el.getVariante() : ""));
                }
                this.error = 5;
            }
            this.errorMsg = this.errorMsg.replace("{0}", bui.toString());
        }
        if (wrongZubProdukt) {
            model.setVerbaubareAlternativen(technikProdukt.getVerbaubareAlternativen());
            model.setVerbaubareVarianten(technikProdukt.getVerbaubareVarianten());
            model.setVerbaubareZusatzprodukte(technikProdukt.getVerbaubareZubehoerProdukte());
            return false;
        }
        Fahrzeug fahrzeugDummy = null;
        if (ControllerFBI.getModel() != null) {
            fahrzeugDummy = ControllerFBI.getModel().getFahrzeug();
        }
        if (model.getMarketingProdukt().isFahrzeugUngebunden() || technikProdukt.getKernProduktBnbs().size() != 0) {
            if (modus.equals(TECHNISCHESICHT)) {
                ControllerMarketingPanel.getInstance().getMarketingView().setIcon("KONFIGURATION");
                if (GlobalObjects.getInstance().getIpacData().getAnfrage() == null) {
                    AnfrageHandler.getInstance().createAnfrage(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt(), fahrzeugDummy, technikProdukt);
                } else if (GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang() == null || !WorkflowController.getInstance().isAddKonfiguration()) {
                    AnfrageHandler.getInstance().createVorgang(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt(), fahrzeugDummy, GlobalObjects.getInstance().getIpacData().getAnfrage());
                }
                if (technikProdukt.hasTooManyRows()) {
                    MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(Resource.getInstance().getMehrAlsEinTeil());
                }
                technikProdukt = this.removeNPZ(technikProdukt);
                this.mModel.setTechnikProdukt(technikProdukt);
                this.mTechnikView.setModel(this.mModel);
            }
            return true;
        }
        model.setVerbaubareAlternativen(technikProdukt.getVerbaubareAlternativen());
        model.setVerbaubareVarianten(technikProdukt.getVerbaubareVarianten());
        model.setVerbaubareZusatzprodukte(technikProdukt.getVerbaubareZubehoerProdukte());
        if (model.getMarketingProdukt().getAlleVarianten().size() > 0 && model.getSelectedVariante() != null && technikProdukt.getVerbaubareAlternativen().contains(model.getSelectedAlternative()) && !technikProdukt.getVerbaubareVarianten().isEmpty() && !technikProdukt.getVerbaubareVarianten().contains(model.getSelectedVariante().getVarianteId())) {
            this.error = 3;
            StringBuilder bui = new StringBuilder();
            bui.append("<html>");
            ArrayList<Bnb> bnbMitVarianten = model.getMarketingProdukt().getSelectedBnbsMitVarianten();
            List verbaubareVarianten = technikProdukt.getVerbaubareVarianten();
            String varName = "";
            for (int i = 0; i < bnbMitVarianten.size(); ++i) {
                Variante variante = bnbMitVarianten.get(i).getSelectedVariante();
                if (variante == null || variante.getVarianteId() == 0 || verbaubareVarianten.contains(variante.getVarianteId())) continue;
                varName = variante.getName();
                bui.append(Resource.getInstance().getFalscheVariante1().replace("{0}", varName));
            }
            bui.append(Resource.getInstance().getFalscheVariante2() + "</html>");
            this.errorMsg = bui.toString();
            return false;
        }
        String variantenName = this.checkFehlerVariantenBestandteile(model, technikProdukt);
        if (model.getMarketingProdukt().getAlleVarianten().size() > 0 && !variantenName.equals("") && !technikProdukt.getVerbaubareVarianten().isEmpty()) {
            this.error = 4;
            StringBuilder bui = new StringBuilder();
            bui.append("<html>");
            ArrayList<Bnb> bnbMitVarianten = model.getMarketingProdukt().getSelectedBnbsMitVarianten();
            List verbaubareVarianten = technikProdukt.getVerbaubareVarianten();
            String varName = "";
            for (int i = 0; i < bnbMitVarianten.size(); ++i) {
                Variante variante = bnbMitVarianten.get(i).getSelectedVariante();
                if (variante == null || variante.getVarianteId() == 0 || verbaubareVarianten.contains(variante.getVarianteId())) continue;
                varName = variante.getName();
                bui.append(Resource.getInstance().getFalscheVariante1().replace("{0}", varName));
            }
            bui.append(Resource.getInstance().getFalscheVariante2() + "</html>");
            this.errorMsg = bui.toString();
            return false;
        }
        if (model.getSelectedAlternative() != null && technikProdukt.getVerbaubareAlternativen().size() >= 1 && !technikProdukt.getVerbaubareAlternativen().contains(model.getSelectedAlternative())) {
            this.error = 2;
            Bnb alternative = model.getSelectedAlternative();
            this.errorMsg = "<html>" + Resource.getInstance().getFalscheAlternative1().replace("{0}", alternative.getBnbName()) + "<br>" + Resource.getInstance().getFalscheAlternative2() + "</html>";
            return false;
        }
        this.error = 1;
        this.errorMsg = "<html>" + Resource.getInstance().getKeinProdukt1() + "<br>" + Resource.getInstance().getKeinProdukt2() + "</html>";
        return false;
    }

    private String checkFehlerVariantenBestandteile(MarketingModel model, TechnischesProdukt technikProdukt) {
        ArrayList<Bnb> bnbMitVarianten = model.getMarketingProdukt().getSelectedBnbsMitVarianten();
        List verbaubareVarianten = technikProdukt.getVerbaubareVarianten();
        String varName = "";
        for (int i = 0; i < bnbMitVarianten.size(); ++i) {
            Variante variante;
            Bnb bnb = bnbMitVarianten.get(i);
            if (!bnb.getElementArt().equals("HP_PAKET") && !bnb.getElementArt().equals("HP_OBLIGAT") || (variante = bnb.getSelectedVariante()) == null || variante.getVarianteId() == 0 || verbaubareVarianten.contains(variante.getVarianteId())) continue;
            varName = variante.getName();
            break;
        }
        return varName;
    }

    private TechnischesProdukt removeNPZ(TechnischesProdukt technikProdukt) {
        int j;
        TechnischerBnb bnb;
        int i;
        for (i = 0; i < technikProdukt.getKernProduktBnbs().size(); ++i) {
            bnb = (TechnischerBnb)technikProdukt.getKernProduktBnbs().get(i);
            for (j = 0; j < bnb.getBauteile().size(); ++j) {
                if (!bnb.getBauteile().get(j).getArt().equals("NPZ")) continue;
                bnb.getBauteile().remove(j--);
            }
        }
        if (technikProdukt.getZusatzProduktBnbs() != null) {
            for (i = 0; i < technikProdukt.getZusatzProduktBnbs().size(); ++i) {
                bnb = technikProdukt.getZusatzProduktBnbs().get(i);
                for (j = 0; j < bnb.getBauteile().size(); ++j) {
                    if (!bnb.getBauteile().get(j).getArt().equals("NPZ")) continue;
                    bnb.getBauteile().remove(j--);
                }
            }
        }
        if (technikProdukt.getHilfsStoffeBnbs() != null) {
            for (i = 0; i < technikProdukt.getHilfsStoffeBnbs().size(); ++i) {
                bnb = (TechnischerBnb)technikProdukt.getHilfsStoffeBnbs().get(i);
                for (j = 0; j < bnb.getBauteile().size(); ++j) {
                    if (bnb.getBauteile().get(j).getArt() == null || !bnb.getBauteile().get(j).getArt().equals("NPZ")) continue;
                    bnb.getBauteile().remove(j--);
                }
            }
        }
        return technikProdukt;
    }

    public TechnischesProdukt getData() {
        log.debug((Object)"Performing Getting Data for MarketinView");
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            String mitPreisen = "ALLES";
            if (GlobalObjects.getInstance().getIpacData().getPreise() != null) {
                mitPreisen = "NUR_DMS";
            }
            return TechnikDataloader.getTechnikProdukt(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt(), GlobalObjects.getInstance().getIpacData().getFahrzeug(), mitPreisen, null);
        }
        catch (CommunicationException ex) {
            log.error((Object)"ControllerMarketingPanel: ", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        catch (NoDataFoundException e) {
            log.error((Object)"Keine Daten f\u00fcr die Marketingsicht des Produkts gefunden!", (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        catch (Exception e) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), e.getMessage(), this.mModel.getDialogTitel(), 0);
            return null;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateTechnikController();
    }

    public void updateTechnikController() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            return;
        }
        if (e.getSource() instanceof JLabel) {
            JLabel label = (JLabel)e.getSource();
            if ("IN_TEILELISTE_UEBERNEHMEN".equals(label.getName())) {
                label.setCursor(Cursor.getPredefinedCursor(3));
                this.uebernehmeInTeileliste();
                label.setCursor(Cursor.getPredefinedCursor(0));
            } else if ("ButtonEtkAnsicht".equals(label.getName())) {
                this.showBteViewDialog();
            }
        } else if (e.getSource() instanceof JTable) {
            HilfsTableModel tableModel;
            JTable table = (JTable)e.getSource();
            Point p = e.getPoint();
            int column = table.columnAtPoint(p);
            int row = table.rowAtPoint(p);
            if ("TABELLE_KERN".equals(table.getName())) {
                TeileTableModel tableModel2;
                if (column == 0 && table.getModel() instanceof TeileTableModel && row < (tableModel2 = (TeileTableModel)table.getModel()).getBauteile().size()) {
                    String teileNr = tableModel2.getBauteile().get(row).getTeilenummer();
                    GlobalObjects.getInstance().getSessionInfo();
                    teileNr = teileNr.replaceAll("[ ]", "");
                    this.showTeileinfo(teileNr);
                }
            } else if ("TABELLE_ZUSATZ".equals(table.getName())) {
                TeileTableModel tableModel3;
                if (column == 0 && table.getModel() instanceof TeileTableModel && row < (tableModel3 = (TeileTableModel)table.getModel()).getBauteile().size()) {
                    String teileNr = tableModel3.getBauteile().get(row).getTeilenummer();
                    GlobalObjects.getInstance().getSessionInfo();
                    teileNr = teileNr.replaceAll("[ ]", "");
                    this.showTeileinfo(teileNr);
                }
            } else if ("TABELLE_HILF".equals(table.getName()) && column == 2 && table.getModel() instanceof HilfsTableModel && (tableModel = (HilfsTableModel)table.getModel()).getBauteile().size() > row && tableModel.getBauteile().get(row).isBTEBauteil()) {
                String teileNr = tableModel.getBauteile().get(row).getTeilenummer();
                GlobalObjects.getInstance().getSessionInfo();
                teileNr = teileNr.replaceAll("[ ]", "");
                this.showTeileinfo(teileNr);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            return;
        }
        if (e.getComponent() == this.mTechnikView.getArbeitHinzufuegenLabel()) {
            if (this.mAngebotsSicht) return;
            ControllerArbeitHinzufuegen.getInstance().init();
            if (ControllerArbeitHinzufuegen.getInstance().getArbeitsHinzufuegenDialog().getDialogResult() != 1) return;
            Arbeit arbeit = ControllerArbeitHinzufuegen.getInstance().getArbeitsHinzufuegenDialog().getSelectedArbeit();
            arbeit.setHinzugefuegt(true);
            this.mModel.arbeitHinzuf\u00fcgen(arbeit);
            this.mTechnikView.handleArbeitsHinzuf\u00fcgen(arbeit);
            this.setChanged();
            this.notifyObservers(arbeit);
            return;
        } else if (e.getComponent() == this.mTechnikView.getTeileHinzufuegenLabel()) {
            if (this.mAngebotsSicht) return;
            this.initLookAndFeel();
            do {
                ControllerTeileHinzufuegen.getInstance().init();
                if (ControllerTeileHinzufuegen.getInstance().getDialogResult() != 1) return;
                Bauteil bauteil = ControllerTeileHinzufuegen.getInstance().getBauteil();
                this.mModel.teilHinzuf\u00fcgen(bauteil);
                this.mTechnikView.handleTeilHinzuf\u00fcgen(bauteil);
                this.setChanged();
                this.notifyObservers(bauteil);
            } while (JOptionPane.showConfirmDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getWeitereTeileHinzufuegen(), Resource.getInstance().getTeilHinzufuegen(), 0, 3) == 0);
            return;
        } else if (e.getComponent() == this.mTechnikView.getISPALabel()) {
            System.out.println("RETURN TO ISPA ! ! ! ! ! ! ! ! ! !");
            ZubIspaZubehoerpakete zubPaket = ZubScoreDataCreator.getInstance().calculateAllKonfigurationen();
            if (zubPaket == null) {
                return;
            }
            GlobalObjects.getInstance().getIpacData().setIspaZubpakete(zubPaket);
            MainController.getInstance().getMainFrame().setVisible(false);
            MainController.getInstance().getMainFrame().setHidden(true);
            return;
        } else if (e.getComponent() == this.mTechnikView.getHilfTable()) {
            int aktColumn;
            if (this.mAngebotsSicht || (aktColumn = this.mTechnikView.getHilfTable().columnAtPoint(new Point(e.getX(), e.getY()))) != 1) return;
            this.mTechnikView.handleRemoveRow(e);
            this.setChanged();
            this.notifyObservers();
            return;
        } else if (e.getComponent().getName().equals("SYMBOLKERN")) {
            if (this.mTechnikView.isSymbolKernOpen()) {
                this.mTechnikView.setAufklappenIcon(this.mTechnikView.getSymbolKern());
                this.mTechnikView.getKernScrollPane().setVisible(false);
            } else {
                this.mTechnikView.checkPlatzAnsicht("KERN");
            }
            this.mTechnikView.getTechnikPanel().updateUI();
            return;
        } else if (e.getComponent().getName().equals("SYMBOLOPTIONAL")) {
            if (this.mTechnikView.isSymbolZusatzOpen()) {
                this.mTechnikView.setAufklappenIcon(this.mTechnikView.getSymbolOptional());
                this.mTechnikView.getZusatzScrollPane().setVisible(false);
            } else {
                this.mTechnikView.checkPlatzAnsicht("ZUSATZ");
            }
            this.mTechnikView.getTechnikPanel().updateUI();
            return;
        } else if (e.getComponent().getName().equals("SYMBOLHILF")) {
            if (this.mTechnikView.isSymbolHilfOpen()) {
                this.mTechnikView.setAufklappenIcon(this.mTechnikView.getSymbolHilf());
                this.mTechnikView.getHilfScrollPane().setVisible(false);
                this.mTechnikView.getButtonPanel().setVisible(false);
            } else {
                this.mTechnikView.checkPlatzAnsicht("HILF");
            }
            this.mTechnikView.getTechnikPanel().updateUI();
            return;
        } else {
            if (!e.getComponent().getName().equals("EINBAU") && !e.getComponent().getName().equals("KOSTEN") && !e.getComponent().getName().equals("LINKS")) return;
            this.mTechnikView.getInfoPanel().setSelectedReiter(e.getComponent().getName());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() instanceof JTable) {
            JTable table = (JTable)e.getSource();
            Point p = e.getPoint();
            int column = table.columnAtPoint(p);
            int row = table.rowAtPoint(p);
            if ("TABELLE_KERN".equals(table.getName())) {
                TeileTableModel tableModel;
                if (column == 0 && table.getModel() instanceof TeileTableModel && row < (tableModel = (TeileTableModel)table.getModel()).getBauteile().size()) {
                    table.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                table.setCursor(Cursor.getDefaultCursor());
            } else if ("TABELLE_ZUSATZ".equals(table.getName())) {
                TeileTableModel tableModel;
                if (column == 0 && table.getModel() instanceof TeileTableModel && row < (tableModel = (TeileTableModel)table.getModel()).getBauteile().size()) {
                    table.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                table.setCursor(Cursor.getDefaultCursor());
            } else if ("TABELLE_HILF".equals(table.getName())) {
                HilfsTableModel tableModel;
                if (column == 2 && table.getModel() instanceof HilfsTableModel && (tableModel = (HilfsTableModel)table.getModel()).getBauteile().size() > row && tableModel.getBauteile().get(row).isBTEBauteil()) {
                    table.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                table.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public static TechnikPanel getTechnikView() {
        return ControllerTechnikPanel.getInstance().mTechnikView;
    }

    private void setTechnikView(TechnikPanel technikView) {
        this.mTechnikView = technikView;
    }

    private TechnikPanel getTechnikViewInternal() {
        return this.mTechnikView;
    }

    public void exit() {
        ControllerMiniaturansicht.getInstance().getMiniaturTechnik().removeBorder();
    }

    public void informiereObserver(Object obj) {
        this.mTechnikView.getEinbauInfoPanel().refreshEinbauInfoPanel();
        this.setChanged();
        this.notifyObservers(obj);
    }

    public TechnikModel getModel() {
        return this.mModel;
    }

    public void setModel(TechnikModel model) {
        this.mModel = model;
    }

    private void initLookAndFeel() {
        MetalLookAndFeel.setCurrentTheme((MetalTheme)new WebETKTheme());
        String language = GlobalObjects.getInstance().getLanguage();
        if (language != null) {
            Resource.setLanguage((String)language);
            WebETKTheme.changeFont((String)language.substring(0, 2));
        }
        GlobalObjects.setScore((boolean)false);
    }

    private void showTeileinfo(String teilenummer) {
        this.initLookAndFeel();
        new DlgTeileinfoKleinController((Frame)MainController.getInstance().getMainFrame(), teilenummer);
    }

    private CurrentBTE getCurrentBTE(String modus) {
        String sBte = GlobalObjects.getInstance().getIpacData().getSelectedBte();
        TrfHashMap oTransferable = new TrfHashMap(null);
        ArrayList<String> cBteNr = new ArrayList<String>();
        cBteNr.add(sBte);
        ArrayList<String> cBteTypen = new ArrayList<String>();
        if ("Fahrzeugteile".equals(modus)) {
            cBteTypen.add("FZG");
        } else {
            cBteTypen.add("ASS");
            LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
            oTransferable.setValue("marke", loginInfo.getMarke());
            oTransferable.setValue("produktart", loginInfo.getProdukart());
            oTransferable.setValue("katalogumfang", loginInfo.getKatalogUmfang());
        }
        oTransferable.setValue("bildtafeln_list_of_string", cBteNr);
        oTransferable.setValue("btearten", cBteTypen);
        oTransferable.setValue("btnummer", sBte);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.SET_BTE_MENGE);
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTransferable, Command.BT_SET_CURRENT_BTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("WfTeilesucheFzg: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (oTransferable.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)oTransferable.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainView.getInstance(), oTransferable.getError().getMessage(), Resource.getInstance().getTeilesucheFahrzeugteile(), 0);
            return null;
        }
        return (CurrentBTE)oTransferable.getValue("currentbte");
    }

    private void showBteViewDialog() {
        String modus = "";
        if (ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().isFahrzeugUngebunden()) {
            modus = "Accessoires";
            AssSucheInfo assInfo = new AssSucheInfo();
            assInfo.setMarke(GlobalObjects.getInstance().getSessionInfo().getMarke());
            assInfo.setProduktart(GlobalObjects.getInstance().getSessionInfo().getProdukart());
            assInfo.setKatalogumfang(GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang());
            JavaAssSucheInfo javaAssSucheInfo = new JavaAssSucheInfo(assInfo);
            GlobalObjects.getInstance().getEtkData().setSucheInfo((JavaSucheInfo)javaAssSucheInfo);
            System.out.println(GlobalObjects.getInstance().getEtkData().getAssSucheInfo());
        } else {
            modus = "Fahrzeugteile";
            GlobalObjects.getInstance().getEtkData().setFzgSucheInfo((FzgSucheInfo)GlobalObjects.getInstance().getIpacData().getFahrzeug());
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        this.initLookAndFeel();
        CurrentBTE cBte = this.getCurrentBTE(modus);
        WorkflowStateData oWFStateData = new WorkflowStateData();
        oWFStateData.setWert("currentbte", (Object)cBte);
        oWFStateData.setWert("hasnextbt", (Object)"false");
        oWFStateData.setWert("hasprevbt", (Object)"false");
        oWFStateData.setWert("modus", (Object)modus);
        oWFStateData.setWert("ipacView", (Object)true);
        BTEController bteController = new BTEController();
        bteController.init(oWFStateData);
        JComponent panContent = bteController.getDialogView().getComponent();
        JDialog dlgBteView = new JDialog(MainController.getInstance().getMainFrame());
        dlgBteView.setContentPane(panContent);
        dlgBteView.setSize(MainController.getInstance().getMainFrame().getFrameSize());
        dlgBteView.setModal(true);
        dlgBteView.setVisible(true);
    }

    public static ArrayList<ComboTeilelisteItem> getTeilelisten() {
        ComboTeilelisteItem oItem;
        ArrayList<String> aMarke = new ArrayList<String>();
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null) {
            aMarke.add(GlobalObjects.getInstance().getIpacData().getFahrzeug().getMarke());
        } else {
            aMarke.add(GlobalObjects.getInstance().getSessionInfo().getMarke());
        }
        TrfHashMap trfTeilelistenIDs = DlgTeilelisteController.loadTeilelistenIDs(aMarke, (boolean)false);
        if (trfTeilelistenIDs == null) {
            return new ArrayList<ComboTeilelisteItem>();
        }
        ArrayList<ComboTeilelisteItem> result = new ArrayList<ComboTeilelisteItem>();
        int ii = 1;
        while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
            result.add(oItem);
            ++ii;
        }
        return result;
    }

    public static ComboTeilelisteItem getSelectedTeileliste(Collection<ComboTeilelisteItem> cTeilelisten) {
        return DlgTeilelisteController.ermittleSelTL(cTeilelisten, (boolean)true);
    }

    private void uebernehmeInTeileliste() {
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.initLookAndFeel();
        ComboTeilelisteItem oItem = (ComboTeilelisteItem)this.mTechnikView.getTeilelistenCombobox().getSelectedItem();
        String sMarke = GlobalObjects.getInstance().getIpacData().getAnfrage().getMarke();
        ArrayList<String> cTeile = this.getBauteile();
        DlgTeilelisteController ctrl = new DlgTeilelisteController();
        ctrl.uebernehmeTeile((Frame)MainController.getInstance().getMainFrame(), oItem, sMarke, cTeile, false);
        if (oItem.getName().equals(Resource.getInstance().getNeueListe())) {
            this.mTechnikView.updateTeilelistenCombobox();
        }
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    private ArrayList<String> getBauteile() {
        ArrayList<String> bauteile = new ArrayList<String>();
        ArrayList<TechnischerBnb> mKernProduktBnbs = this.mModel.getKernProduktBnbs();
        for (TechnischerBnb technischerBnb : mKernProduktBnbs) {
            for (Bauteil bauteil : technischerBnb.getBauteile()) {
                String teilenummer = bauteil.getTeilenummer();
                teilenummer = teilenummer.replaceAll("[ ]", "");
                bauteile.add(teilenummer);
            }
        }
        ArrayList<TechnischerBnb> mZusatzProduktBnbs = this.mModel.getZusatzProduktBnbs();
        for (TechnischerBnb technischerBnb : mZusatzProduktBnbs) {
            for (Bauteil bauteil : technischerBnb.getBauteile()) {
                String teilenummer = bauteil.getTeilenummer();
                teilenummer = teilenummer.replaceAll("[ ]", "");
                bauteile.add(teilenummer);
            }
        }
        ArrayList<TechnischerBnb> mHilfsBnbs = this.mModel.getHilfBnbs();
        for (TechnischerBnb technischerBnb : mHilfsBnbs) {
            for (Bauteil bauteil : technischerBnb.getBauteile()) {
                String teilenummer = bauteil.getTeilenummer();
                teilenummer = teilenummer.replaceAll("[ ]", "");
                bauteile.add(teilenummer);
            }
        }
        return bauteile;
    }

    public void setAngebotsSicht(boolean flag) {
        this.mAngebotsSicht = flag;
        this.mTechnikView.setAngebotssicht(flag);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.getSource() == this.mTechnikView.getEditorInt()) {
            this.mTechnikView.getEditorInt().stopCellEditing();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean hasErrors() {
        return this.error > 0;
    }

    public int getError() {
        return this.error;
    }

    static {
        log = Logger.getLogger(ControllerTechnikPanel.class);
    }
}

