/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import webetk.app.bteinfo.Info;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.NPZ;
import webetk.app.zub.technisch.RefaArbeit;
import webetk.resources.Resource;

public class EinbauInfoPanel
extends JPanel {
    private final String ARBEITSWERT = Resource.getInstance().getArbeitswert();
    private final Dimension SIZE_REFA_LABEL = new Dimension(170, 16);
    private final Dimension SIZE_SUM_REFA_LABEL = new Dimension(190, 16);
    private static final long serialVersionUID = 1L;
    public static final String BUTTON_ETK_ANSICHT = "ButtonEtkAnsicht";
    private static final String ABKUERZUNG_AW = "AW";
    private static final String AW_STRING = " AW";
    private final String STUNDE_GLEICH_STRING = " " + Resource.getInstance().getAbkuerzungStunde() + " = ";
    private GridBagConstraints gbc;
    private GridBagConstraints gbc2;
    private int mPlatzhalterY = 0;
    private int ABSTAND = 28;
    private ArrayList<JPanel> mHeadPanel;
    private ArrayList<JLabel> mHeadLabel;
    private JLabel mEinbauReiterLabel = null;
    private JLabel mKostenReiterLabel = null;
    private JLabel mLinkReiterLabel = null;
    private JPanel mEinbauReiterPanel = null;
    private JPanel mKostenReiterPanel = null;
    private JPanel mLinkReiterPanel = null;
    private ArrayList<JPanel> mBodyPanel;
    private JPanel einbauPanel = null;
    private JPanel kostenPanel = null;
    private JPanel linkPanel = null;
    private JLabel komplexLabel = null;
    private JLabel komplexLabel2 = null;
    private JLabel mechLabel = null;
    private JLabel mechLabel1 = null;
    private JLabel mechLabel2 = null;
    private JLabel mechLabel21 = null;
    private JLabel mechLabel3 = null;
    private JLabel elekLabel = null;
    private JLabel elekLabel1 = null;
    private JLabel elekLabel21 = null;
    private JLabel elekLabel2 = null;
    private JLabel elekLabel3 = null;
    private JLabel progLabel = null;
    private JLabel progLabel1 = null;
    private JLabel progLabel21 = null;
    private JLabel progLabel2 = null;
    private JLabel progLabel3 = null;
    private JLabel lackLabel = null;
    private JLabel lackLabel1 = null;
    private JLabel lackLabel2 = null;
    private JLabel lackLabel21 = null;
    private JLabel lackLabel3 = null;
    private JLabel sonstigeLabel = null;
    private JLabel sonstigeLabel1 = null;
    private JLabel sonstigeLabel2 = null;
    private JLabel sonstigeLabel21 = null;
    private JLabel sonstigeLabel3 = null;
    private JLabel arbeitAufwandLabel = null;
    private JLabel arbeitAufwandLabel1 = null;
    private JLabel arbeitAufwandLabel2 = null;
    private JLabel arbeitAufwandLabel21 = null;
    private JLabel arbeitAufwandLabel3 = null;
    private JPanel arbeitsSum = null;
    private JLabel arbeitLabel = null;
    private JLabel arbeitLabel1 = null;
    private JLabel arbeitLabel11 = null;
    private JLabel arbeitLabel2 = null;
    private JLabel arbeitLabel21 = null;
    private JPanel mHinweisPanel = null;
    private JPanel mHinweisKostenPanel = null;
    private JLabel mHinweisEinbau = null;
    private JLabel mHinweisProgrammierung = null;
    private JLabel mHinweisKosten = null;
    private JLabel kostenLabel1 = null;
    private JLabel kostenLabel11 = null;
    private JLabel kostenLabel12 = null;
    private JLabel kostenLabel2 = null;
    private JLabel kostenLabel21 = null;
    private JLabel kostenLabel22 = null;
    private JLabel kostenLabel3 = null;
    private JLabel kostenLabel31 = null;
    private JLabel kostenLabel32 = null;
    private JPanel kostenSum = null;
    private JLabel etkLabel = null;
    private TechnikModel mModel = null;
    private MarkenLayout mMarkenLayout = null;
    private JPanel scrollerPanel = null;
    private JScrollPane scroller;

    public EinbauInfoPanel(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.createComponents();
        this.setReiter();
    }

    public EinbauInfoPanel(TechnikModel model, MarkenLayout layout) {
        this.mModel = model;
        this.mMarkenLayout = layout;
        this.createComponents();
        this.setReiter();
        this.setReiterInhalt();
        this.setLayout(layout);
        this.setSelectedReiter("EINBAU");
        this.setVisible(true);
    }

    public void setData(TechnikModel model, MarkenLayout layout) {
        this.mModel = model;
        this.mMarkenLayout = layout;
        this.setTextArbeiten();
        this.setReiter();
        this.setReiterInhalt();
        this.setLayout(layout);
        this.setSelectedReiter("EINBAU");
        this.setVisible(true);
    }

    private void setTextArbeiten() {
        this.mechLabel.setText(this.mModel.getMechanischeBezeichnung() + ": ");
        this.elekLabel.setText(this.mModel.getElektrischeBezeichnung() + ": ");
        this.progLabel.setText(this.mModel.getProgrammierBezeichnung() + ": ");
        this.lackLabel.setText(this.mModel.getLackierBezeichnung() + ": ");
        this.sonstigeLabel.setText(this.mModel.getSonstigeBezeichnung() + ": ");
        this.arbeitAufwandLabel.setText(this.mModel.getArbeitsaufwandBezeichnung() + ": ");
    }

    private void createComponents() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(331, 200));
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
        this.mHeadPanel = new ArrayList();
        this.mHeadLabel = new ArrayList();
        this.mBodyPanel = new ArrayList();
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mEinbauReiterLabel = new JLabel();
        this.mEinbauReiterLabel.setName("EINBAU");
        this.mHeadLabel.add(this.mEinbauReiterLabel);
        this.mEinbauReiterPanel = new JPanel();
        this.mEinbauReiterPanel.add((Component)this.mEinbauReiterLabel, this.gbc);
        this.mEinbauReiterPanel.setName("EINBAU");
        this.mEinbauReiterPanel.setMaximumSize(new Dimension(162, 26));
        this.mEinbauReiterPanel.setMinimumSize(new Dimension(162, 26));
        this.mEinbauReiterPanel.setPreferredSize(new Dimension(162, 26));
        this.mEinbauReiterPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.mHeadPanel.add(this.mEinbauReiterPanel);
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.mEinbauReiterPanel, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mKostenReiterLabel = new JLabel();
        this.mKostenReiterLabel.setName("KOSTEN");
        this.mHeadLabel.add(this.mKostenReiterLabel);
        this.mKostenReiterPanel = new JPanel();
        this.mKostenReiterPanel.add((Component)this.mKostenReiterLabel, this.gbc);
        this.mKostenReiterPanel.setName("KOSTEN");
        this.mKostenReiterPanel.setMaximumSize(new Dimension(162, 26));
        this.mKostenReiterPanel.setMinimumSize(new Dimension(162, 26));
        this.mKostenReiterPanel.setPreferredSize(new Dimension(162, 26));
        this.mKostenReiterPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.GRAY));
        this.mHeadPanel.add(this.mKostenReiterPanel);
        this.gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.mKostenReiterPanel, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mLinkReiterLabel = new JLabel();
        this.mLinkReiterLabel.setName("LINKS");
        this.mHeadLabel.add(this.mLinkReiterLabel);
        this.mLinkReiterPanel = new JPanel();
        this.mLinkReiterPanel.add((Component)this.mLinkReiterLabel, this.gbc);
        this.mLinkReiterPanel.setName("LINKS");
        this.mLinkReiterPanel.setMaximumSize(new Dimension(162, 26));
        this.mLinkReiterPanel.setMinimumSize(new Dimension(162, 26));
        this.mLinkReiterPanel.setPreferredSize(new Dimension(162, 26));
        this.mLinkReiterPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.GRAY));
        this.mHeadPanel.add(this.mLinkReiterPanel);
        this.gbc = this.setGridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.mLinkReiterPanel, this.gbc);
        this.einbauPanel = new JPanel();
        this.einbauPanel.setName("EINBAU");
        this.einbauPanel.setLayout(new GridBagLayout());
        this.mBodyPanel.add(this.einbauPanel);
        this.komplexLabel = new JLabel(Resource.getInstance().getSchwierigkeitsgrad() + ": ");
        this.komplexLabel2 = new JLabel("");
        this.mechLabel = new JLabel("");
        this.mechLabel1 = new JLabel("");
        this.mechLabel2 = new JLabel(AW_STRING);
        this.mechLabel2.setToolTipText(this.ARBEITSWERT);
        this.mechLabel21 = new JLabel("");
        this.mechLabel3 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.elekLabel = new JLabel("");
        this.elekLabel1 = new JLabel("");
        this.elekLabel2 = new JLabel(AW_STRING);
        this.elekLabel21 = new JLabel("");
        this.elekLabel3 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.progLabel = new JLabel("");
        this.progLabel1 = new JLabel("");
        this.progLabel2 = new JLabel(AW_STRING);
        this.progLabel21 = new JLabel("");
        this.progLabel3 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.lackLabel = new JLabel("");
        this.lackLabel1 = new JLabel("");
        this.lackLabel2 = new JLabel(AW_STRING);
        this.lackLabel21 = new JLabel("");
        this.lackLabel3 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.sonstigeLabel = new JLabel("");
        this.sonstigeLabel1 = new JLabel("");
        this.sonstigeLabel2 = new JLabel(AW_STRING);
        this.sonstigeLabel21 = new JLabel("");
        this.sonstigeLabel3 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.arbeitAufwandLabel = new JLabel("");
        this.arbeitAufwandLabel1 = new JLabel("");
        this.arbeitAufwandLabel2 = new JLabel(AW_STRING);
        this.arbeitAufwandLabel21 = new JLabel("");
        this.arbeitAufwandLabel3 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.arbeitsSum = new JPanel();
        this.arbeitsSum.setLayout(new GridBagLayout());
        this.arbeitsSum.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.GRAY));
        this.arbeitLabel = new JLabel(Resource.getInstance().getGesamteArbeitszeit() + ": ");
        this.arbeitLabel11 = new JLabel("");
        this.arbeitLabel1 = new JLabel(AW_STRING);
        this.arbeitLabel21 = new JLabel("");
        this.arbeitLabel2 = new JLabel(this.STUNDE_GLEICH_STRING);
        this.mHinweisPanel = new JPanel();
        this.mHinweisPanel.setLayout(new GridBagLayout());
        this.mHinweisPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.GRAY));
        this.mHinweisKostenPanel = new JPanel();
        this.mHinweisKostenPanel.setLayout(new GridBagLayout());
        this.mHinweisKostenPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.GRAY));
        this.mHinweisEinbau = this.mMarkenLayout.getLabel();
        this.mHinweisProgrammierung = this.mMarkenLayout.getLabel();
        this.mHinweisKosten = this.mMarkenLayout.getLabel();
        this.kostenPanel = new JPanel();
        this.kostenPanel.setLayout(new GridBagLayout());
        this.kostenPanel.setName("KOSTEN");
        this.mBodyPanel.add(this.kostenPanel);
        this.kostenLabel1 = new JLabel(Resource.getInstance().getKostenTeile() + ": ");
        this.kostenLabel11 = new JLabel("");
        this.kostenLabel12 = new JLabel(" " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.kostenLabel2 = new JLabel(Resource.getInstance().getKostenArbeit() + ": ");
        this.kostenLabel21 = new JLabel("");
        this.kostenLabel22 = new JLabel(" " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.kostenSum = new JPanel();
        this.kostenSum.setLayout(new GridBagLayout());
        this.kostenSum.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, new Color(216, 212, 212)));
        this.kostenLabel3 = new JLabel(Resource.getInstance().getGesamtkosten() + ": ");
        this.kostenLabel31 = new JLabel("");
        this.kostenLabel32 = new JLabel(" " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.linkPanel = new JPanel();
        this.linkPanel.setLayout(new BorderLayout());
        this.linkPanel.setPreferredSize(new Dimension(486, 200));
        this.linkPanel.setName("LINKS");
        this.scroller = new JScrollPane();
        this.scrollerPanel = new JPanel();
        this.scrollerPanel.setLayout(new GridBagLayout());
        this.scrollerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scroller.getViewport().add(this.scrollerPanel);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mBodyPanel.add(this.linkPanel);
        this.gbc = new GridBagConstraints();
        this.gbc2 = new GridBagConstraints();
    }

    private void setReiter() {
        this.mEinbauReiterLabel.setText(Resource.getInstance().getEinbau());
        this.mKostenReiterLabel.setText(Resource.getInstance().getKosten());
        this.mLinkReiterLabel.setText(Resource.getInstance().getWeitereInformationen());
        if (this.mModel != null && (this.mModel.getKommentare().size() > 0 || this.mModel.isNPZsVorhanden())) {
            this.mLinkReiterLabel.setText(Resource.getInstance().getWeitereInformationen() + " *");
        }
        this.updateUI();
    }

    private void setReiterInhalt() {
        this.setInhaltEinbauPanel();
        this.setInhaltKostenPanel();
        this.setInhaltLinkPanel();
    }

    private JPanel setInhaltEinbauPanel() {
        this.einbauPanel.removeAll();
        int counter = 5;
        if (this.mModel.getRefaArbeiten().size() == 0) {
            this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(10, 10, 5, 55));
            this.einbauPanel.add((Component)this.komplexLabel, this.gbc);
            this.gbc = this.setGridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 1, 16, new Insets(10, 0, 5, 5));
            this.komplexLabel2.setText(this.mModel.getSchwierigkeitsgrad());
            this.einbauPanel.add((Component)this.komplexLabel2, this.gbc);
            this.gbc.ipadx = 0;
            if (!this.mModel.getMechanischeArbeit().equals("0")) {
                this.gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 10, 5, 2));
                this.einbauPanel.add((Component)this.mechLabel, this.gbc);
                this.gbc = this.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.mechLabel21.setText(this.berechneMinInStundenToString(this.mModel.getMechanischeArbeit()));
                this.einbauPanel.add((Component)this.mechLabel21, this.gbc);
                this.gbc = this.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.einbauPanel.add((Component)this.mechLabel3, this.gbc);
                this.gbc = this.setGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.mechLabel1.setText(this.mModel.getMechanischeArbeitAw());
                this.einbauPanel.add((Component)this.mechLabel1, this.gbc);
                this.gbc = this.setGridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 5, 0));
                this.einbauPanel.add((Component)this.mechLabel2, this.gbc);
                --counter;
            }
            if (!this.mModel.getElektrikArbeit().equals("0")) {
                this.gbc = this.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 5, 2));
                this.einbauPanel.add((Component)this.elekLabel, this.gbc);
                this.gbc = this.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.elekLabel21.setText(this.berechneMinInStundenToString(this.mModel.getElektrikArbeit()));
                this.einbauPanel.add((Component)this.elekLabel21, this.gbc);
                this.gbc = this.setGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.einbauPanel.add((Component)this.elekLabel3, this.gbc);
                this.gbc = this.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.elekLabel1.setText(this.mModel.getElektrikArbeitAw());
                this.einbauPanel.add((Component)this.elekLabel1, this.gbc);
                this.gbc = this.setGridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 5, 0));
                this.einbauPanel.add((Component)this.elekLabel2, this.gbc);
                --counter;
            }
            if (!this.mModel.getProgrammierArbeit().equals("0")) {
                this.gbc = this.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 5, 2));
                this.einbauPanel.add((Component)this.progLabel, this.gbc);
                this.gbc = this.setGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.progLabel21.setText(this.berechneMinInStundenToString(this.mModel.getProgrammierArbeit()));
                this.einbauPanel.add((Component)this.progLabel21, this.gbc);
                this.gbc = this.setGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.einbauPanel.add((Component)this.progLabel3, this.gbc);
                this.gbc = this.setGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.progLabel1.setText(this.mModel.getProgrammierArbeitAw());
                this.einbauPanel.add((Component)this.progLabel1, this.gbc);
                this.gbc = this.setGridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 5, 0));
                this.einbauPanel.add((Component)this.progLabel2, this.gbc);
                --counter;
            }
            if (!this.mModel.getLackierArbeit().equals("0")) {
                this.gbc = this.setGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 5, 2));
                this.einbauPanel.add((Component)this.lackLabel, this.gbc);
                this.gbc = this.setGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.lackLabel21.setText(this.berechneMinInStundenToString(this.mModel.getLackierArbeit()));
                this.einbauPanel.add((Component)this.lackLabel21, this.gbc);
                this.gbc = this.setGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.einbauPanel.add((Component)this.lackLabel3, this.gbc);
                this.gbc = this.setGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 5, 2));
                this.lackLabel1.setText(this.mModel.getLackierArbeitAw());
                this.einbauPanel.add((Component)this.lackLabel1, this.gbc);
                this.gbc = this.setGridBagConstraints(4, 4, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 5, 0));
                this.einbauPanel.add((Component)this.lackLabel2, this.gbc);
                --counter;
            }
            if (!this.mModel.getSonstigeArbeit().equals("0")) {
                this.gbc = this.setGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 10, 2));
                this.einbauPanel.add((Component)this.sonstigeLabel, this.gbc);
                this.gbc = this.setGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
                this.sonstigeLabel21.setText(this.berechneMinInStundenToString(this.mModel.getSonstigeArbeit()));
                this.einbauPanel.add((Component)this.sonstigeLabel21, this.gbc);
                this.gbc = this.setGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
                this.einbauPanel.add((Component)this.sonstigeLabel3, this.gbc);
                this.gbc = this.setGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
                this.sonstigeLabel1.setText(this.mModel.getSonstigeArbeitAw());
                this.einbauPanel.add((Component)this.sonstigeLabel1, this.gbc);
                this.gbc = this.setGridBagConstraints(4, 5, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 10, 0));
                this.einbauPanel.add((Component)this.sonstigeLabel2, this.gbc);
                --counter;
            }
            if (!this.mModel.getArbeitsAufwand().equals("0")) {
                this.gbc = this.setGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 10, 2));
                this.einbauPanel.add((Component)this.arbeitAufwandLabel, this.gbc);
                this.gbc = this.setGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
                this.arbeitAufwandLabel21.setText(this.berechneMinInStundenToString(this.mModel.getArbeitsAufwand()));
                this.einbauPanel.add((Component)this.arbeitAufwandLabel21, this.gbc);
                this.gbc = this.setGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
                this.einbauPanel.add((Component)this.arbeitAufwandLabel3, this.gbc);
                this.gbc = this.setGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
                this.arbeitAufwandLabel1.setText(this.mModel.getArbeitsAufwandAw());
                this.einbauPanel.add((Component)this.arbeitAufwandLabel1, this.gbc);
                this.gbc = this.setGridBagConstraints(4, 5, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 10, 0));
                this.einbauPanel.add((Component)this.arbeitAufwandLabel2, this.gbc);
                --counter;
            }
        }
        if (this.mModel.getRefaArbeiten().size() > 0) {
            this.gbc = this.setGridBagConstraints(0, 0, 5, 1, 1.0, 1.0, 0, 16, new Insets(0, 0, 0, 0));
            this.einbauPanel.add((Component)this.createRefaCrollPane(), this.gbc);
            counter = 0;
        }
        this.gbc = this.setGridBagConstraints(0, 6, 5, 1, 0.0, 0.0, 1, 11, new Insets(5, 10, 0, 10));
        this.mPlatzhalterY = counter * this.ABSTAND - counter;
        this.arbeitsSum.setMinimumSize(new Dimension(280, 2 + this.mPlatzhalterY));
        this.arbeitsSum.setPreferredSize(new Dimension(280, 2 + this.mPlatzhalterY));
        this.einbauPanel.add((Component)this.arbeitsSum, this.gbc);
        this.gbc2 = this.setGridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 1, 11, new Insets(10, 10, 10, 2));
        if (this.mModel.getRefaArbeiten().size() > 0) {
            this.arbeitLabel.setPreferredSize(this.SIZE_SUM_REFA_LABEL);
            this.arbeitLabel.setMaximumSize(this.SIZE_SUM_REFA_LABEL);
            this.arbeitLabel.setMinimumSize(this.SIZE_SUM_REFA_LABEL);
        } else {
            this.arbeitLabel.setPreferredSize(null);
            this.arbeitLabel.setMaximumSize(null);
            this.arbeitLabel.setMinimumSize(null);
        }
        this.einbauPanel.add((Component)this.arbeitLabel, this.gbc2);
        this.gbc2 = this.setGridBagConstraints(1, 7, 1, 1, 0.0, 1.0, 1, 11, new Insets(10, 0, 10, 2));
        this.arbeitLabel21.setText(this.berechneMinInStundenToString(this.mModel.getGesamteArbeit()));
        this.einbauPanel.add((Component)this.arbeitLabel21, this.gbc2);
        this.gbc2 = this.setGridBagConstraints(2, 7, 1, 1, 0.0, 1.0, 1, 11, new Insets(10, 0, 10, 2));
        this.einbauPanel.add((Component)this.arbeitLabel2, this.gbc2);
        this.gbc2 = this.setGridBagConstraints(3, 7, 1, 1, 0.0, 1.0, 1, 11, new Insets(10, 0, 10, 2));
        this.arbeitLabel11.setText(this.mModel.getGesamteArbeitAw());
        this.einbauPanel.add((Component)this.arbeitLabel11, this.gbc2);
        this.gbc2 = this.setGridBagConstraints(4, 7, 1, 1, 1.0, 1.0, 1, 11, new Insets(10, 0, 10, 2));
        this.einbauPanel.add((Component)this.arbeitLabel1, this.gbc2);
        this.gbc = this.setGridBagConstraints(5, 0, 1, 8, 0.0, 1.0, 1, 11, new Insets(5, 0, 5, 0));
        this.einbauPanel.add((Component)this.getHinweisPanel(), this.gbc);
        return this.einbauPanel;
    }

    private JScrollPane createRefaCrollPane() {
        JScrollPane pane = new JScrollPane();
        pane.setHorizontalScrollBarPolicy(31);
        pane.setBorder(new EmptyBorder(0, 0, 0, 0));
        pane.setMinimumSize(new Dimension(400, 170));
        pane.setPreferredSize(new Dimension(400, 170));
        pane.setMaximumSize(new Dimension(400, 160));
        pane.setForeground(this.mMarkenLayout.getPrimaryForeground());
        pane.setBackground(this.mMarkenLayout.getPrimaryBackground());
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        container.setForeground(this.mMarkenLayout.getPrimaryForeground());
        container.setBackground(this.mMarkenLayout.getPrimaryBackground());
        for (int i = 0; i < this.mModel.getRefaArbeiten().size(); ++i) {
            RefaArbeit refa = this.mModel.getRefaArbeiten().get(i);
            this.gbc2 = this.setGridBagConstraints(0, i, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 10, 2));
            JLabel benLabel = this.getLabel(refa.getAwnummer() + " - " + refa.getBenennung());
            benLabel.setPreferredSize(this.SIZE_REFA_LABEL);
            benLabel.setMaximumSize(this.SIZE_REFA_LABEL);
            benLabel.setToolTipText(refa.getAwnummer() + " - " + refa.getBenennung());
            container.add((Component)benLabel, this.gbc2);
            this.gbc2 = this.setGridBagConstraints(1, i, 1, 1, 0.0, 0.0, 1, 11, new Insets(5, 0, 10, 2));
            container.add((Component)this.getLabel(this.berechneMinInStundenToString(this.berechneAWinMinutenToString(refa))), this.gbc2);
            this.gbc2 = this.setGridBagConstraints(2, i, 1, 1, 0.0, 0.0, 1, 11, new Insets(5, 0, 10, 2));
            container.add((Component)this.getLabel(this.STUNDE_GLEICH_STRING), this.gbc2);
            this.gbc2 = this.setGridBagConstraints(3, i, 1, 1, 0.0, 0.0, 1, 11, new Insets(5, 0, 10, 2));
            container.add((Component)this.getLabel(Integer.toString(refa.getMenge())), this.gbc2);
            this.gbc2 = this.setGridBagConstraints(4, i, 1, 1, 1.0, 0.0, 1, 11, new Insets(5, 0, 10, 0));
            container.add((Component)this.getLabel(AW_STRING), this.gbc2);
        }
        if (!this.mModel.getArbeitsAufwand().equals("0")) {
            this.gbc2 = this.setGridBagConstraints(0, this.mModel.getRefaArbeiten().size() + 1, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 10, 10, 2));
            container.add((Component)this.getLabel(this.mModel.getArbeitsaufwandBezeichnung() + ": "), this.gbc2);
            this.gbc2 = this.setGridBagConstraints(1, this.mModel.getRefaArbeiten().size() + 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
            this.arbeitAufwandLabel21.setText(this.berechneMinInStundenToString(this.mModel.getArbeitsAufwand()));
            container.add((Component)this.arbeitAufwandLabel21, this.gbc2);
            this.gbc2 = this.setGridBagConstraints(2, this.mModel.getRefaArbeiten().size() + 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
            container.add((Component)this.arbeitAufwandLabel3, this.gbc2);
            this.gbc2 = this.setGridBagConstraints(3, this.mModel.getRefaArbeiten().size() + 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(5, 0, 10, 2));
            this.arbeitAufwandLabel1.setText(this.mModel.getArbeitsAufwandAw());
            container.add((Component)this.arbeitAufwandLabel1, this.gbc2);
            this.gbc2 = this.setGridBagConstraints(4, this.mModel.getRefaArbeiten().size() + 1, 1, 1, 1.0, 0.0, 1, 16, new Insets(5, 0, 10, 0));
            container.add((Component)this.arbeitAufwandLabel2, this.gbc2);
        }
        this.gbc2 = this.setGridBagConstraints(5, 0, 1, 1, 10.0, 0.0, 1, 11, new Insets(5, 0, 10, 0));
        container.add((Component)new JLabel(), this.gbc2);
        this.gbc2 = this.setGridBagConstraints(0, this.mModel.getRefaArbeiten().size() + 2, 1, 1, 10.0, 10.0, 1, 11, new Insets(0, 0, 0, 0));
        container.add((Component)new JLabel(), this.gbc2);
        pane.setViewportView(container);
        return pane;
    }

    private JLabel getLabel(String text) {
        JLabel label = new JLabel(text);
        label.setForeground(this.mMarkenLayout.getPrimaryForeground());
        label.setBackground(this.mMarkenLayout.getPrimaryBackground());
        return label;
    }

    private String berechneAWinMinutenToString(RefaArbeit refa) {
        return Long.toString(Math.round(this.mModel.getTechnikProdukt().getPreise().getMinutenZuAW("", refa.getMenge())));
    }

    private String berechneMinInStundenToString(String arbeit) {
        double stunden = Double.valueOf(arbeit) / 60.0;
        stunden = Math.floor(stunden * 100.0 + 0.5) / 100.0;
        return Double.toString(stunden);
    }

    private JPanel getHinweisPanel() {
        this.mHinweisPanel.removeAll();
        this.mHinweisPanel.setMinimumSize(new Dimension(162, 190));
        this.mHinweisPanel.setPreferredSize(new Dimension(162, 190));
        this.mHinweisPanel.setMaximumSize(new Dimension(162, 190));
        this.gbc2 = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.mHinweisPanel.add((Component)this.mHinweisEinbau, this.gbc2);
        if (!this.mModel.getProgrammierArbeit().equals("0")) {
            this.setHinweisText(this.mHinweisEinbau, Resource.getInstance().getEinbauzeitensatz());
            this.setHinweisText(this.mHinweisProgrammierung, Resource.getInstance().getProgrammiersatz1() + " " + Resource.getInstance().getProgrammiersatz2());
            this.gbc2 = this.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 11, new Insets(5, 0, 0, 0));
            this.mHinweisPanel.add((Component)this.mHinweisProgrammierung, this.gbc2);
        } else {
            this.mHinweisEinbau.setText(this.formatText(Resource.getInstance().getEinbauzeitensatz()));
        }
        this.gbc2 = this.setGridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 2, 11, new Insets(0, 0, 0, 0));
        this.mHinweisPanel.add((Component)new JLabel(), this.gbc2);
        return this.mHinweisPanel;
    }

    private JPanel getHinweisKostenPanel() {
        this.mHinweisKostenPanel.removeAll();
        this.mHinweisKostenPanel.setMinimumSize(new Dimension(162, 190));
        this.mHinweisKostenPanel.setPreferredSize(new Dimension(162, 190));
        this.mHinweisKostenPanel.setMaximumSize(new Dimension(162, 190));
        this.gbc2 = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mHinweisKosten.setText(this.formatText(ZubCustomizable.getInstance().getFussnoteVerbindlichkeit()));
        this.mHinweisKostenPanel.add((Component)this.mHinweisKosten, this.gbc2);
        this.gbc2 = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mHinweisKostenPanel.add((Component)new JLabel(), this.gbc2);
        return this.mHinweisKostenPanel;
    }

    private String formatText(String text) {
        String formattedText = "<html>";
        int maximalZeichenAnzahl = 28;
        maximalZeichenAnzahl = text.lastIndexOf(" ") == -1 || GlobalObjects.getInstance().getLanguage().equals("ja") || GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("zh") ? 12 : (GlobalObjects.getInstance().getLanguage().equals("th") ? 19 : 28);
        if (text.length() > maximalZeichenAnzahl) {
            int index = 0;
            while (text.length() > index + maximalZeichenAnzahl) {
                if (text.length() > index + maximalZeichenAnzahl) {
                    String dummy = text.substring(index, index + maximalZeichenAnzahl);
                    int position = dummy.lastIndexOf(" ");
                    if (position > 0) {
                        formattedText = formattedText + text.substring(index, index + position) + "<br>";
                        index += position;
                        continue;
                    }
                    formattedText = formattedText + text.substring(index, index + maximalZeichenAnzahl) + "<br>";
                    index += maximalZeichenAnzahl;
                    continue;
                }
                formattedText = formattedText + text.substring(index, text.length()) + "<br>";
            }
            formattedText = formattedText + text.substring(index, text.length());
        } else {
            formattedText = formattedText + text;
        }
        formattedText = formattedText + "</html>";
        return formattedText;
    }

    private String formatTooltipText(String text) {
        String formattedText = "";
        int maxZeichenAnzahl = 50;
        maxZeichenAnzahl = text.lastIndexOf(" ") == -1 || GlobalObjects.getInstance().getLanguage().equals("ja") || GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("zh") ? 25 : (GlobalObjects.getInstance().getLanguage().equals("th") ? 33 : 50);
        if (text.length() > maxZeichenAnzahl) {
            int index = 0;
            while (text.length() > index + maxZeichenAnzahl) {
                if (text.length() > index + maxZeichenAnzahl) {
                    String dummy = text.substring(index, index + maxZeichenAnzahl);
                    int position = dummy.lastIndexOf(" ");
                    if (position > 0) {
                        formattedText = formattedText + text.substring(index, index + position) + "<br>";
                        index += position;
                        continue;
                    }
                    formattedText = formattedText + text.substring(index, index + maxZeichenAnzahl) + "<br>";
                    index += maxZeichenAnzahl;
                    continue;
                }
                formattedText = formattedText + text.substring(index, text.length()) + "<br>";
            }
            formattedText = formattedText + text.substring(index, text.length()) + "<br>";
        } else {
            formattedText = formattedText + text;
        }
        formattedText = "<html>" + formattedText + "</html>";
        return formattedText;
    }

    private void setHinweisText(JLabel hinweis, String text) {
        int maximalZeichenAnzahl = 120;
        maximalZeichenAnzahl = text.lastIndexOf(" ") == -1 || GlobalObjects.getInstance().getLanguage().equals("ja") || GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("th") || GlobalObjects.getInstance().getLanguage().equals("zh") ? 65 : 120;
        if (text.length() > maximalZeichenAnzahl) {
            String textForLabel = this.formatText(text);
            hinweis.setText(textForLabel.substring(0, maximalZeichenAnzahl) + "...");
            hinweis.setToolTipText(this.formatTooltipText(text));
            hinweis.setCursor(this.mMarkenLayout.getDetailCursor());
        } else {
            hinweis.setCursor(Constants.CursorTypen.STANDARD_CURSOR);
        }
    }

    private JPanel setInhaltKostenPanel() {
        this.kostenPanel.removeAll();
        this.kostenPanel.setPreferredSize(new Dimension(486, 200));
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 16, new Insets(15, 10, 10, 10));
        this.kostenPanel.add((Component)this.kostenLabel1, this.gbc);
        this.gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 14, new Insets(15, 30, 10, 10));
        this.kostenLabel11.setText(this.mModel.getKostenTeile());
        this.kostenPanel.add((Component)this.kostenLabel11, this.gbc);
        this.gbc = this.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 16, new Insets(15, 5, 10, 10));
        this.kostenPanel.add((Component)this.kostenLabel12, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(10, 10, 10, 10));
        this.kostenPanel.add((Component)this.kostenLabel2, this.gbc);
        this.gbc = this.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 14, new Insets(10, 30, 10, 10));
        this.kostenLabel21.setText(this.mModel.getKostenArbeit());
        this.kostenPanel.add((Component)this.kostenLabel21, this.gbc);
        this.gbc = this.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 1, 16, new Insets(10, 5, 10, 10));
        this.kostenPanel.add((Component)this.kostenLabel22, this.gbc);
        this.mPlatzhalterY = 3 * this.ABSTAND;
        JPanel separator = new JPanel();
        separator.setPreferredSize(new Dimension(0, 2));
        separator.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.gbc = this.setGridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 2, 16, new Insets(this.mPlatzhalterY, 10, 0, 10));
        this.kostenPanel.add((Component)separator, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 16, new Insets(10, 10, 10, 10));
        this.kostenPanel.add((Component)this.kostenLabel3, this.gbc);
        this.gbc = this.setGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 0, 14, new Insets(10, 30, 10, 10));
        this.kostenLabel31.setText(this.mModel.getGesamtkosten());
        this.kostenPanel.add((Component)this.kostenLabel31, this.gbc);
        this.gbc = this.setGridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 0, 16, new Insets(10, 5, 10, 20));
        this.kostenPanel.add((Component)this.kostenLabel32, this.gbc);
        this.gbc = this.setGridBagConstraints(3, 0, 1, 4, 0.0, 0.0, 0, 11, new Insets(0, 0, 0, 0));
        this.kostenPanel.add((Component)this.getHinweisKostenPanel(), this.gbc);
        return this.kostenPanel;
    }

    private JScrollPane setInhaltLinkPanel() {
        ArrayList<Info> techniKom;
        JLabel npzLabel;
        String npzText;
        this.scrollerPanel.removeAll();
        int counter = 0;
        if (this.mModel.getTechnikProdukt().getBteKommentar() != null) {
            counter = this.setKommentar(this.mModel.getTechnikProdukt().getBteKommentar(), counter);
        }
        ArrayList bauteileKern = (ArrayList)this.mModel.getTechnikProdukt().getKernProduktTeile();
        ArrayList bauteileZusatz = (ArrayList)this.mModel.getTechnikProdukt().getZusatzProdukte();
        ArrayList bauteileHilf = (ArrayList)this.mModel.getTechnikProdukt().getHilfsStoffe();
        if (bauteileKern != null) {
            for (Bauteil teil : bauteileKern) {
                npzText = "";
                if (teil.getNpzText() == null || teil.getNpzListe() == null) continue;
                npzText = teil.getNpzText() + ":<br>";
                for (NPZ npz : teil.getNpzListe()) {
                    npzText = npzText + npz.getMsTeilenummer() + "     " + npz.getBenennung() + "<br>";
                }
                npzLabel = new JLabel("<html>" + teil.getTeilenummer() + " " + npzText + "</html>");
                this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 20, 10, 0));
                this.scrollerPanel.add((Component)npzLabel, this.gbc);
            }
        }
        if (bauteileZusatz != null) {
            for (Bauteil teil : bauteileZusatz) {
                npzText = "";
                if (teil.getNpzText() == null || teil.getNpzListe() == null) continue;
                npzText = teil.getNpzText() + ":<br>";
                for (NPZ npz : teil.getNpzListe()) {
                    npzText = npzText + npz.getMsTeilenummer() + "     " + npz.getBenennung() + "<br>";
                }
                npzLabel = new JLabel("<html>" + teil.getTeilenummer() + " " + npzText + "</html>");
                this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 20, 10, 0));
                this.scrollerPanel.add((Component)npzLabel, this.gbc);
            }
        }
        if (bauteileHilf != null) {
            for (Bauteil teil : bauteileHilf) {
                npzText = "";
                if (teil.getNpzText() == null || teil.getNpzListe() == null) continue;
                npzText = teil.getNpzText() + ":<br>";
                for (NPZ npz : teil.getNpzListe()) {
                    npzText = npzText + npz.getMsTeilenummer() + "     " + npz.getBenennung() + "<br>";
                }
                npzLabel = new JLabel("<html>" + teil.getTeilenummer() + " " + npzText + "</html>");
                this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 20, 10, 0));
                this.scrollerPanel.add((Component)npzLabel, this.gbc);
            }
        }
        if ((techniKom = this.mModel.getKommentare()) != null) {
            for (int i = 0; i < techniKom.size(); ++i) {
                if (techniKom.get(i) == null) continue;
                counter = this.setKommentar(techniKom.get(i), counter);
            }
        }
        this.setRestriction(counter);
        JLabel test = new JLabel("");
        this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 100.0, 1, 11, new Insets(5, 20, 0, 0));
        this.scrollerPanel.add((Component)test, this.gbc);
        this.etkLabel = new JLabel();
        this.etkLabel.setText("> " + Resource.getInstance().getEtkAnsicht());
        this.etkLabel.setName(BUTTON_ETK_ANSICHT);
        this.etkLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.etkLabel.addMouseListener(ControllerTechnikPanel.getInstance());
        this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 1, 16, new Insets(0, 20, 5, 10));
        this.scrollerPanel.add((Component)this.etkLabel, this.gbc);
        this.linkPanel.add((Component)this.scroller, "Center");
        this.scroller.updateUI();
        this.linkPanel.updateUI();
        return this.scroller;
    }

    private int setKommentar(Info kommentar, int c) {
        int counter = c;
        int insetX = 0;
        if (kommentar.getTitel() != null && !kommentar.getTitel().equals("")) {
            JLabel titel = this.mMarkenLayout.getBoldLabel();
            titel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            titel.setText(this.setTitel(kommentar.getTitel()));
            insetX = 280 - kommentar.getTitel().length();
            this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 20, 5, insetX));
            this.scrollerPanel.add((Component)titel, this.gbc);
        }
        if (kommentar.getHinweise() != null) {
            Iterator iterator = kommentar.getHinweise().iterator();
            StringBuilder bui = new StringBuilder();
            while (iterator.hasNext()) {
                String text = (String)((Hashtable)iterator.next()).get("Text");
                bui.append(text).append("<br>");
            }
            JTextPane hinweisText = new JTextPane();
            hinweisText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            hinweisText.setFont(Constants.Layout.getZubDefaultFont());
            hinweisText.setEditable(false);
            hinweisText.setContentType("text/html; charset=UTF-8");
            hinweisText.setBorder(null);
            hinweisText.setText(bui.toString());
            hinweisText.setForeground(this.mMarkenLayout.getPrimaryForeground());
            hinweisText.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 20, 5, 0));
            this.scrollerPanel.add((Component)hinweisText, this.gbc);
        }
        return counter;
    }

    private void setRestriction(int counter) {
        if (ControllerMarketingPanel.getInstance().getModel() != null && ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getRestriktionen() != null) {
            JTextPane restriktionText = new JTextPane();
            restriktionText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            restriktionText.setFont(Constants.Layout.getZubDefaultFont());
            restriktionText.setEditable(false);
            restriktionText.setContentType("text/html; charset=UTF-8");
            restriktionText.setBorder(null);
            restriktionText.setForeground(this.mMarkenLayout.getPrimaryForeground());
            restriktionText.setBackground(this.mMarkenLayout.getPrimaryBackground());
            String restriktion = "<b>" + Resource.getInstance().getRestriktionen() + "</b><br>";
            String text = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getRestriktionen();
            if (text.contains("#")) {
                restriktionText.setText(restriktion + this.mMarkenLayout.cleanTextWithNewLine(text, "#", " "));
            } else {
                restriktionText.setText(restriktion + text);
            }
            this.gbc = this.setGridBagConstraints(1, counter++, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 20, 10, 0));
            this.scrollerPanel.add((Component)restriktionText, this.gbc);
        }
    }

    private String setTitel(String titel) {
        StringBuilder bui = new StringBuilder();
        bui.append("<html>");
        bui.append("<b>").append(titel).append("</b>");
        bui.append("</html>");
        return bui.toString();
    }

    public void updateInfoPanel() {
    }

    public void setLayout(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mEinbauReiterLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mKostenReiterLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mLinkReiterLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mEinbauReiterPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mKostenReiterPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mLinkReiterPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.einbauPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.kostenPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.linkPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.scroller.getViewport().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.scrollerPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.komplexLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.komplexLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mechLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mechLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mechLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mechLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mechLabel3.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.elekLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.elekLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.elekLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.elekLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.elekLabel3.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.progLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.progLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.progLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.progLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.progLabel3.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.lackLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.lackLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.lackLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.lackLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.lackLabel3.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.sonstigeLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.sonstigeLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.sonstigeLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.sonstigeLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.sonstigeLabel3.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.arbeitsSum.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.arbeitLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.arbeitLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.arbeitLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.arbeitLabel11.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.arbeitLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHinweisPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mHinweisEinbau.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHinweisProgrammierung.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHinweisKosten.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHinweisKostenPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.kostenSum.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.kostenLabel1.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel11.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel12.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel2.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel21.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel22.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel3.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel31.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.kostenLabel32.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.etkLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.etkLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.etkLabel.setBoldFont();
        this.validate();
        this.updateUI();
    }

    private GridBagConstraints setGridBagConstraints(int gx, int gy, int gw, int gh, double wx, double wy, int fill, int anchor, Insets inset) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.anchor = anchor;
        c.weightx = wx;
        c.weighty = wy;
        c.fill = fill;
        c.insets = inset;
        return c;
    }

    public void setSelectedReiter(String name) {
        for (JPanel head : this.mHeadPanel) {
            if (head.getName().equals(name)) {
                head.setBackground(this.mMarkenLayout.getSelectedReiterBackground());
                head.getComponent(0).setForeground(this.mMarkenLayout.getSelectedReiterForeground());
                continue;
            }
            head.setBackground(this.mMarkenLayout.getDeselectedReiterBackground());
            head.getComponent(0).setForeground(this.mMarkenLayout.getDeselectedReiterForeground());
        }
        for (JPanel body : this.mBodyPanel) {
            if (body.getName().equals(name)) {
                this.gbc = this.setGridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
                this.add((Component)body, this.gbc);
                continue;
            }
            this.remove(body);
        }
        this.validate();
        this.updateUI();
    }

    public JPanel getReiterEinbauPanel() {
        return this.mEinbauReiterPanel;
    }

    public JPanel getReiterKostenPanel() {
        return this.mKostenReiterPanel;
    }

    public JPanel getReiterInfoPanel() {
        return this.mLinkReiterPanel;
    }

    public ArrayList<JPanel> getHeadPanel() {
        return this.mHeadPanel;
    }

    public ArrayList<JLabel> getHeadLabel() {
        return this.mHeadLabel;
    }

    public void refreshEinbauInfoPanel() {
        this.setInhaltEinbauPanel();
        this.setInhaltKostenPanel();
        this.updateUI();
    }
}

