/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.zub.common.Constants;
import de.esg.zub.configurator.content.technisch.HilfsTableModel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import webetk.app.zub.technisch.Bauteil;

class HilfsTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private int rowCount = 0;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.rowCount = table.getRowCount();
        if (value != null) {
            if (column == 1 || column == 2) {
                this.setHorizontalAlignment(0);
                this.setIcon((ImageIcon)value);
                this.setText("");
                this.setToolTipText(null);
            } else {
                if (column == 3) {
                    this.setHorizontalAlignment(2);
                    this.setToolTipText(null);
                } else if (column == 4) {
                    this.setHorizontalAlignment(2);
                    FontMetrics fontMetrics = this.getFontMetrics(Constants.Layout.getZubDefaultFont());
                    this.setText(value.toString());
                    int textBreite = fontMetrics.stringWidth(value.toString());
                    int columnWidth = table.getColumnModel().getColumn(column).getWidth();
                    if (textBreite > columnWidth - 5) {
                        this.setToolTipText(value.toString());
                    } else {
                        this.setToolTipText(null);
                    }
                } else if (column == 9) {
                    this.setHorizontalAlignment(0);
                    if (value.getClass().equals(String.class) && value.toString().equals("*")) {
                        ArrayList<Bauteil> bauteile = ((HilfsTableModel)table.getModel()).getBauteile();
                        if (row < bauteile.size() && bauteile.size() > 0) {
                            this.setToolTipText(((HilfsTableModel)table.getModel()).getBauteile().get(row).getBemerkung());
                        } else {
                            this.setToolTipText(((HilfsTableModel)table.getModel()).getArbeit().get(row - bauteile.size()).getBemerkung());
                        }
                    } else {
                        this.setToolTipText(null);
                    }
                } else {
                    this.setHorizontalAlignment(4);
                }
                this.setText(value.toString());
                this.setIcon(null);
                if (((HilfsTableModel)table.getModel()).getBauteile().size() > row && ((HilfsTableModel)table.getModel()).getBauteile().get(row).isBTEBauteil()) {
                    if (!((HilfsTableModel)table.getModel()).getBauteile().get(row).isAktiv()) {
                        this.setForeground(Color.LIGHT_GRAY);
                    } else if (WorkflowController.getInstance().getMarkenLayout().isMINI()) {
                        this.setForeground(Color.WHITE);
                    } else if (WorkflowController.getInstance().getMarkenLayout().isBMW() || WorkflowController.getInstance().getMarkenLayout().isBMWi() || WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
                        this.setForeground(Color.BLACK);
                    }
                } else if (WorkflowController.getInstance().getMarkenLayout().isMINI()) {
                    this.setForeground(Color.WHITE);
                } else if (WorkflowController.getInstance().getMarkenLayout().isBMW() || WorkflowController.getInstance().getMarkenLayout().isBMWi() || WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
                    this.setForeground(Color.BLACK);
                }
            }
        }
        return this;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

