/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import webetk.WebetkUtils;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.resources.Resource;

public class HilfsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    ArrayList<TechnischerBnb> mTechnischeBnb;
    private ArrayList<Bauteil> mBauteile;
    private ArrayList<ImageIcon> mInfoImages;
    private ArrayList<ImageIcon> mRecyleImages;
    private ArrayList<Arbeit> mArbeit;
    private ArrayList<Integer> mHinzugef\u00fcgteZeile;
    private ArrayList<Integer> mBauteilInTechnikBnb;
    private int counter = 0;
    private String mImagePath;
    private boolean mAngebotsSicht;
    private final String TNRAWNR = "TNR / AW-Nr";
    private final String K = "K";
    private boolean mAbPreiseMitSteuer = true;

    public HilfsTableModel(ArrayList<TechnischerBnb> technischeBnb, ArrayList<Arbeit> arbeit, boolean abPreiseMitSteuer) {
        this.mTechnischeBnb = technischeBnb;
        this.mAbPreiseMitSteuer = abPreiseMitSteuer;
        this.mBauteile = new ArrayList();
        this.mBauteilInTechnikBnb = new ArrayList();
        this.mHinzugef\u00fcgteZeile = new ArrayList();
        int ii = 0;
        for (TechnischerBnb tbnb : technischeBnb) {
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                this.mBauteile.add(bauteil);
                this.mBauteilInTechnikBnb.add(ii);
                if (!bauteil.isBTEBauteil() || tbnb.isHinzugefuegt()) {
                    this.mHinzugef\u00fcgteZeile.add(this.counter);
                }
                ++this.counter;
            }
            ++ii;
        }
        this.mArbeit = arbeit;
        this.mInfoImages = new ArrayList();
        this.mRecyleImages = new ArrayList();
        this.mImagePath = WorkflowController.getInstance().getMarkenLayout().isMINI() ? "Icons/leer_mini.gif" : "Icons/leer_bmw.gif";
        while (this.mInfoImages.size() != this.mBauteile.size() + this.mArbeit.size()) {
            int idx = this.mInfoImages.size();
            boolean hinzugefuegt = false;
            boolean isRefa = false;
            for (int counter : this.mHinzugef\u00fcgteZeile) {
                if (idx != counter) continue;
                hinzugefuegt = true;
            }
            if (idx >= this.mBauteile.size()) {
                hinzugefuegt = this.mArbeit.get(idx - this.mBauteile.size()).isHinzugefuegt();
                isRefa = this.mArbeit.get(idx - this.mBauteile.size()).isRefaArbeit();
            }
            if (!hinzugefuegt && !isRefa) {
                this.mInfoImages.add(new ImageIcon(ImageCache.getInstance().getImage("Icons/info.gif")));
                this.mRecyleImages.add(new ImageIcon(ImageCache.getInstance().getImage(this.mImagePath)));
                continue;
            }
            if (isRefa) {
                this.mInfoImages.add(new ImageIcon(ImageCache.getInstance().getImage(this.mImagePath)));
                this.mRecyleImages.add(new ImageIcon(ImageCache.getInstance().getImage(this.mImagePath)));
                continue;
            }
            this.mInfoImages.add(new ImageIcon(ImageCache.getInstance().getImage(this.mImagePath)));
            this.mRecyleImages.add(new ImageIcon(ImageCache.getInstance().getImage("Icons/recycle.gif")));
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.mAngebotsSicht) {
            if (rowIndex < this.mBauteile.size() && rowIndex < this.counter) {
                if (columnIndex == 0) {
                    return this.mBauteile.get(rowIndex).isBTEBauteil();
                }
                if (columnIndex == 5) {
                    return !this.mBauteile.get(rowIndex).isBTEBauteil();
                }
            } else if (rowIndex < this.mBauteile.size() && rowIndex > this.counter) {
                if (columnIndex == 5) {
                    return true;
                }
            } else if (rowIndex >= this.mBauteile.size() && columnIndex == 5) {
                return !this.mArbeit.get(rowIndex - this.mBauteile.size()).isRefaArbeit();
            }
            return false;
        }
        return false;
    }

    public void addRowArbeit(Arbeit newArbeit) {
        boolean set = false;
        if (!set) {
            this.mArbeit.add(newArbeit);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            this.mInfoImages.add(new ImageIcon(ImageCache.getInstance().getImage(this.mImagePath)));
            this.mRecyleImages.add(new ImageIcon(ImageCache.getInstance().getImage("Icons/recycle.gif")));
            this.mHinzugef\u00fcgteZeile.add(this.mBauteile.size() + this.mArbeit.size());
        }
    }

    public void addRowTeil(Bauteil bauteil) {
        this.mBauteile.add(bauteil);
        this.mInfoImages.add(this.mBauteile.size() - 1, new ImageIcon(ImageCache.getInstance().getImage(this.mImagePath)));
        this.mRecyleImages.add(this.mBauteile.size() - 1, new ImageIcon(ImageCache.getInstance().getImage("Icons/recycle.gif")));
        this.fireTableRowsInserted(this.mBauteile.size() - 1, this.mBauteile.size() - 1);
        this.mHinzugef\u00fcgteZeile.add(this.mBauteile.size());
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ArrayList<Bauteil> bauteileToUpdate = new ArrayList<Bauteil>();
        if (columnIndex == 0) {
            boolean aktiv = false;
            Bauteil bauteil = this.mBauteile.get(rowIndex);
            if (bauteil.isBTEBauteil()) {
                aktiv = !bauteil.isAktiv();
                bauteil.setAktiv(aktiv);
                if (!bauteileToUpdate.contains(bauteil)) {
                    bauteileToUpdate.add(bauteil);
                }
                if (rowIndex < this.mBauteilInTechnikBnb.size()) {
                    int bnbIndex = this.mBauteilInTechnikBnb.get(rowIndex);
                    String teilenummer = bauteil.getTeilenummer();
                    for (int ii = 0; ii < this.mTechnischeBnb.get(bnbIndex).getBauteile().size(); ++ii) {
                        bauteil = this.mTechnischeBnb.get(bnbIndex).getBauteile().get(ii);
                        if (!bauteil.getTeilenummer().equals(teilenummer)) continue;
                        bauteil.setAktiv(aktiv);
                        if (bauteileToUpdate.contains(bauteil)) continue;
                        bauteileToUpdate.add(bauteil);
                    }
                    ControllerTechnikPanel.getInstance().getModel().setBauteilAktiv(teilenummer, aktiv, bnbIndex);
                    ControllerTechnikPanel.getInstance().informiereObserver(bauteileToUpdate);
                }
            }
        } else if (columnIndex == 5) {
            if (rowIndex < this.mBauteile.size()) {
                int alteMenge = this.mBauteile.get(rowIndex).getMenge();
                int mengenDifferenz = alteMenge - (Integer)aValue;
                this.mBauteile.get(rowIndex).setMenge((Integer)aValue);
                bauteileToUpdate.add(this.mBauteile.get(rowIndex));
                float kostenDifferenz = 0.0f;
                if (this.mBauteile.get(rowIndex).getEinzelPreis() != null) {
                    kostenDifferenz = (float)((double)mengenDifferenz * this.mBauteile.get(rowIndex).getEinzelPreis());
                }
                ControllerTechnikPanel.getInstance().getModel().setKostenTeile(ControllerTechnikPanel.getInstance().getModel().getKostenTeileDouble() - (double)kostenDifferenz);
                ControllerTechnikPanel.getInstance().getModel().setAnzahlTeile(ControllerTechnikPanel.getInstance().getModel().getAnzahlTeile() - mengenDifferenz);
            } else {
                int alteMenge = this.mArbeit.get(rowIndex - this.mBauteile.size()).getMenge();
                this.mArbeit.get(rowIndex - this.mBauteile.size()).setMenge((Integer)aValue);
                int mengenDifferenz = alteMenge - (Integer)aValue;
                float gesamtpreis = (float)((Integer)aValue).intValue() * Float.valueOf(this.mArbeit.get(rowIndex - this.mBauteile.size()).getEinzelPreisBrutto()).floatValue();
                this.mArbeit.get(rowIndex - this.mBauteile.size()).setGesamtPreisBrutto(gesamtpreis);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
                ControllerTechnikPanel.getInstance().getModel().setAnzahlArbeit(ControllerTechnikPanel.getInstance().getModel().getAnzahlArbeit() - mengenDifferenz);
                ControllerTechnikPanel.getInstance().getModel().changeMengeArbeit("HILFS", this.mArbeit.get(rowIndex - this.mBauteile.size()).getBenennung(), this.mArbeit.get(rowIndex - this.mBauteile.size()).getAwnummer(), this.mArbeit.get(rowIndex - this.mBauteile.size()).getMenge(), alteMenge);
                ControllerTechnikPanel.getInstance().informiereObserver(this.mArbeit.get(rowIndex - this.mBauteile.size()));
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (columnIndex == 1) {
            return "";
        }
        if (columnIndex == 2) {
            return "";
        }
        if (columnIndex == 3) {
            return "TNR / AW-Nr";
        }
        if (columnIndex == 4) {
            return Resource.getInstance().getBenennung();
        }
        if (columnIndex == 5) {
            return Resource.getInstance().getMe();
        }
        if (columnIndex == 6) {
            return Resource.getInstance().getBestand();
        }
        if (columnIndex == 7) {
            return Resource.getInstance().getEinzelpreis();
        }
        if (columnIndex == 8) {
            return Resource.getInstance().getGesamtpreis();
        }
        if (columnIndex == 9) {
            return "K";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return ImageIcon.class;
        }
        if (columnIndex == 2) {
            return ImageIcon.class;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        if (columnIndex == 5) {
            return Integer.class;
        }
        if (columnIndex == 6) {
            return Integer.class;
        }
        if (columnIndex == 7) {
            return Integer.class;
        }
        if (columnIndex == 8) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public int getRowCount() {
        return this.mBauteile.size() + this.mArbeit.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.mBauteile.size() && this.mBauteile.size() > 0) {
            Bauteil actuallBauteil = this.mBauteile.get(rowIndex);
            if (columnIndex == 0) {
                return actuallBauteil.isAktiv();
            }
            if (columnIndex == 1) {
                return this.mRecyleImages.get(rowIndex);
            }
            if (columnIndex == 2) {
                return this.mInfoImages.get(rowIndex);
            }
            if (columnIndex == 3) {
                return actuallBauteil.getTeilenummer();
            }
            if (columnIndex == 4) {
                return actuallBauteil.getBenennung();
            }
            if (columnIndex == 5) {
                return actuallBauteil.getMenge();
            }
            if (columnIndex == 6) {
                if (actuallBauteil.getBestand() == 0) {
                    return "-";
                }
                return actuallBauteil.getBestand();
            }
            if (columnIndex == 7) {
                double preis = actuallBauteil.getEinzelPreis();
                if (!actuallBauteil.isBTEBauteil() && this.mAbPreiseMitSteuer) {
                    preis += preis * (double)actuallBauteil.getMwStSatz() / 100.0;
                    preis = Math.floor(preis * 100.0 + 0.5) / 100.0;
                }
                return WebetkUtils.getPriceString(preis);
            }
            if (columnIndex == 8) {
                double preis = actuallBauteil.getGesamtPreis();
                if (!actuallBauteil.isBTEBauteil() && this.mAbPreiseMitSteuer) {
                    preis += preis * (double)actuallBauteil.getMwStSatz() / 100.0;
                    preis = Math.floor(preis * 100.0 + 0.5) / 100.0;
                }
                return WebetkUtils.getPriceString(preis);
            }
            if (columnIndex == 9) {
                if (actuallBauteil.isBemerkungVorhanden()) {
                    return "*";
                }
                return "";
            }
            return null;
        }
        Arbeit actuallArbeit = this.mArbeit.get(rowIndex - this.mBauteile.size());
        if (columnIndex == 0) {
            return true;
        }
        if (columnIndex == 1) {
            return this.mRecyleImages.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.mInfoImages.get(rowIndex);
        }
        if (columnIndex == 3) {
            return actuallArbeit.getAwnummer();
        }
        if (columnIndex == 4) {
            return actuallArbeit.getBenennung();
        }
        if (columnIndex == 5) {
            return actuallArbeit.getMenge();
        }
        if (columnIndex == 6) {
            return "";
        }
        if (columnIndex == 7) {
            return WebetkUtils.getPriceString(Float.valueOf(actuallArbeit.getEinzelPreisBrutto()).floatValue());
        }
        if (columnIndex == 8) {
            return WebetkUtils.getPriceString(Float.valueOf(actuallArbeit.getGesamtPreisBrutto()).floatValue());
        }
        if (columnIndex == 9) {
            if (actuallArbeit.isBemerkungVorhanden()) {
                return "*";
            }
            return "";
        }
        return null;
    }

    public ArrayList<Bauteil> getBauteile() {
        return this.mBauteile;
    }

    public ArrayList<TechnischerBnb> getTechnischeBnb() {
        return this.mTechnischeBnb;
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < this.mBauteile.size() && this.mBauteile.size() > 0) {
            Bauteil bauteil = this.mBauteile.get(rowIndex);
            if (!bauteil.isBTEBauteil()) {
                ControllerTechnikPanel.getInstance().getModel().removeTeil(bauteil);
                ControllerTechnikPanel.getInstance().informiereObserver(null);
                this.mBauteile.remove(rowIndex);
            }
        } else {
            Arbeit arbeit = this.mArbeit.get(rowIndex - this.mBauteile.size());
            if (arbeit.isHinzugefuegt()) {
                ControllerTechnikPanel.getInstance().getModel().removeArbeit(arbeit);
                ControllerTechnikPanel.getInstance().informiereObserver(null);
                this.mArbeit.remove(rowIndex - this.mBauteile.size());
            }
        }
        this.mInfoImages.remove(rowIndex);
        this.mRecyleImages.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public ArrayList<Integer> getHinzugef\u00fcgteZeile() {
        return this.mHinzugef\u00fcgteZeile;
    }

    public boolean isAngebotsSicht() {
        return this.mAngebotsSicht;
    }

    public void setAngebotsSicht(boolean angebotsSicht) {
        this.mAngebotsSicht = angebotsSicht;
    }

    public ArrayList<Arbeit> getArbeit() {
        return this.mArbeit;
    }

    public void setArbeit(ArrayList<Arbeit> arbeit) {
        this.mArbeit = arbeit;
    }
}

