/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.utilities.ImageCache;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import webetk.WebetkUtils;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.resources.Resource;

public class TeileTableModel
extends AbstractTableModel {
    ArrayList<TechnischerBnb> mTechnischeBnb;
    private ArrayList<Bauteil> mBauteile;
    private ArrayList<ImageIcon> mInfoImages;
    private ArrayList<Arbeit> mArbeit;
    private ArrayList<Integer> mBauteilInTechnikBnb;
    private String mTypOfTable = null;
    public static final String TYPKERN = "KERNPRODUKT";
    public static final String TYPZUSATZP = "ZUSATZPRODUKT";
    private final String TNRAWNR = "TNR / AW-Nr";
    private final String K = "K";
    private boolean mAngebotsSicht;

    public TeileTableModel(ArrayList<TechnischerBnb> technischeBnb, ArrayList<Arbeit> arbeit, String typ, boolean hasPrice) {
        this.mTechnischeBnb = technischeBnb;
        this.mBauteile = new ArrayList();
        this.mBauteilInTechnikBnb = new ArrayList();
        this.mInfoImages = new ArrayList();
        int ii = 0;
        for (TechnischerBnb tbnb : technischeBnb) {
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                if (tbnb.getTechnischerKommentar() != null) {
                    bauteil.setKommentarVorhanden(true);
                } else {
                    bauteil.setKommentarVorhanden(false);
                }
                this.mBauteile.add(bauteil);
                this.mBauteilInTechnikBnb.add(ii);
                this.mInfoImages.add(new ImageIcon(ImageCache.getInstance().getImage("Icons/info.gif")));
            }
            ++ii;
        }
        this.mArbeit = arbeit;
        this.mTypOfTable = typ;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ArrayList<Bauteil> bauteileToUpdate = new ArrayList<Bauteil>();
        if (columnIndex == 3) {
            aValue.getClass();
            if (rowIndex < this.mBauteile.size()) {
                if ((Integer)aValue != 0) {
                    int bnbIndex = this.mBauteilInTechnikBnb.get(rowIndex);
                    int alteMenge = this.mBauteile.get(rowIndex).getMenge();
                    int mengenDifferenz = alteMenge - (Integer)aValue;
                    this.mBauteile.get(rowIndex).setMenge((Integer)aValue);
                    bauteileToUpdate.add(this.mBauteile.get(rowIndex));
                    float kostenDifferenz = 0.0f;
                    if (this.mBauteile.get(rowIndex).getEinzelPreis() != null) {
                        kostenDifferenz = (float)((double)mengenDifferenz * this.mBauteile.get(rowIndex).getEinzelPreis());
                    }
                    ControllerTechnikPanel.getInstance().getModel().setKostenTeile(ControllerTechnikPanel.getInstance().getModel().getKostenTeileDouble() - (double)kostenDifferenz);
                    ControllerTechnikPanel.getInstance().getModel().setAnzahlTeile(ControllerTechnikPanel.getInstance().getModel().getAnzahlTeile() - mengenDifferenz);
                    Bauteil bauteil = this.mBauteile.get(rowIndex);
                    String teilenummer = bauteil.getTeilenummer();
                    for (int ii = 0; ii < this.mTechnischeBnb.get(bnbIndex).getBauteile().size(); ++ii) {
                        bauteil = this.mTechnischeBnb.get(bnbIndex).getBauteile().get(ii);
                        if (!bauteil.getTeilenummer().equals(teilenummer)) continue;
                        bauteil.setMenge((Integer)aValue);
                    }
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ControllerTechnikPanel.getInstance().informiereObserver(bauteileToUpdate);
                }
            } else if (rowIndex > this.mBauteile.size() - 1) {
                int alteMenge = this.mArbeit.get(rowIndex - this.mBauteile.size()).getMenge();
                this.mArbeit.get(rowIndex - this.mBauteile.size()).setMenge((Integer)aValue);
                int mengenDifferenz = alteMenge - (Integer)aValue;
                float gesamtpreis = (float)((Integer)aValue).intValue() * Float.valueOf(this.mArbeit.get(rowIndex - this.mBauteile.size()).getEinzelPreisBrutto()).floatValue();
                this.mArbeit.get(rowIndex - this.mBauteile.size()).setGesamtPreisBrutto(gesamtpreis);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
                ControllerTechnikPanel.getInstance().getModel().setAnzahlArbeit(ControllerTechnikPanel.getInstance().getModel().getAnzahlArbeit() - mengenDifferenz);
                ControllerTechnikPanel.getInstance().getModel().changeMengeArbeit(this.mTypOfTable, this.mArbeit.get(rowIndex - this.mBauteile.size()).getBenennung(), this.mArbeit.get(rowIndex - this.mBauteile.size()).getAwnummer(), this.mArbeit.get(rowIndex - this.mBauteile.size()).getMenge(), alteMenge);
                ControllerTechnikPanel.getInstance().informiereObserver(this.mArbeit.get(rowIndex - this.mBauteile.size()));
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.mAngebotsSicht) {
            if (this.mTypOfTable.equals(TYPKERN)) {
                if (rowIndex < this.mBauteile.size() && this.mBauteile.get(rowIndex).getElementArt().equals("HP_EINZELTEIL") && columnIndex == 3) {
                    return true;
                }
                if (rowIndex > this.mBauteile.size() - 1 && columnIndex == 3) {
                    return !this.mArbeit.get(rowIndex - this.mBauteile.size()).isRefaArbeit();
                }
            } else if (this.mTypOfTable.equals(TYPZUSATZP) && rowIndex > this.mBauteile.size() - 1 && columnIndex == 3) {
                return !this.mArbeit.get(rowIndex - this.mBauteile.size()).isRefaArbeit();
            }
            return false;
        }
        return false;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (columnIndex == 1) {
            return "TNR / AW-Nr";
        }
        if (columnIndex == 2) {
            return Resource.getInstance().getBenennung();
        }
        if (columnIndex == 3) {
            return Resource.getInstance().getMe();
        }
        if (columnIndex == 4) {
            return Resource.getInstance().getBestand();
        }
        if (columnIndex == 5) {
            return Resource.getInstance().getEinzelpreis();
        }
        if (columnIndex == 6) {
            return Resource.getInstance().getGesamtpreis();
        }
        if (columnIndex == 7) {
            return "K";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ImageIcon.class;
        }
        if (columnIndex == 3) {
            return Integer.class;
        }
        if (columnIndex == 4) {
            return Integer.class;
        }
        if (columnIndex == 5) {
            return Integer.class;
        }
        if (columnIndex == 6) {
            return Integer.class;
        }
        if (columnIndex == 7) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.mBauteile.size() + this.mArbeit.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.mBauteile.size() && this.mBauteile.size() > 0) {
            Bauteil actuallBauteil = this.mBauteile.get(rowIndex);
            if (columnIndex == 0) {
                return new ImageIcon(ImageCache.getInstance().getImage("Icons/info.gif"));
            }
            if (columnIndex == 1) {
                return actuallBauteil.getTeilenummer();
            }
            if (columnIndex == 2) {
                return actuallBauteil.getBenennung();
            }
            if (columnIndex == 3) {
                return actuallBauteil.getMenge();
            }
            if (columnIndex == 4) {
                if (actuallBauteil.getBestand() == 0) {
                    return "-";
                }
                return actuallBauteil.getBestand();
            }
            if (columnIndex == 5) {
                double preis = actuallBauteil.getEinzelPreis();
                return WebetkUtils.getPriceString(preis);
            }
            if (columnIndex == 6) {
                double preis = actuallBauteil.getGesamtPreis();
                return WebetkUtils.getPriceString(preis);
            }
            if (columnIndex == 7) {
                if (actuallBauteil.isKommentarVorhanden() || actuallBauteil.getNpzText() != null) {
                    return "*";
                }
                return "";
            }
            return null;
        }
        Arbeit actuallArbeit = this.mArbeit.get(rowIndex - this.mBauteile.size());
        if (columnIndex == 0) {
            return new ImageIcon();
        }
        if (columnIndex == 1) {
            return actuallArbeit.getAwnummer();
        }
        if (columnIndex == 2) {
            return actuallArbeit.getBenennung();
        }
        if (columnIndex == 3) {
            return actuallArbeit.getMenge();
        }
        if (columnIndex == 4) {
            return "";
        }
        if (columnIndex == 5) {
            return WebetkUtils.getPriceString(Float.valueOf(actuallArbeit.getEinzelPreisBrutto()).floatValue());
        }
        if (columnIndex == 6) {
            return WebetkUtils.getPriceString(Float.valueOf(actuallArbeit.getGesamtPreisBrutto()).floatValue());
        }
        if (columnIndex == 7) {
            return "";
        }
        return null;
    }

    public ArrayList<Bauteil> getBauteile() {
        return this.mBauteile;
    }

    public ArrayList<TechnischerBnb> getMTechnischeBnb() {
        return this.mTechnischeBnb;
    }

    public boolean isAngebotsSicht() {
        return this.mAngebotsSicht;
    }

    public void setAngebotsSicht(boolean angebotsSicht) {
        this.mAngebotsSicht = angebotsSicht;
    }
}

