/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.ControllerDialogKundeKeyReader;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.MainPanel;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.navigation.ControllerETKSearch;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.HitListenHauptKategorie;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.resources.Resource;

public class ControllerNavigationPanel
implements ActionListener,
KeyListener,
TreeSelectionListener,
ItemListener,
MouseListener,
FocusListener,
Observer {
    private static ControllerNavigationPanel mInstance = null;
    private NavigationPanel mNavigationPanel = new NavigationPanel(WorkflowController.getInstance().getMarkenLayout());
    public static final String MELDUNG_ANZAHL_ZEICHEN_FAHRZEUG = Resource.getInstance().getFzgidInvalidFzgnr();
    public static final String MELDUNG_UNBEKANNTE_VIN = Resource.getInstance().getFahrgestellnummerNoData();
    public static final String ETK_SUCHE_FORTSETZEN = Resource.getInstance().getEtkSucheFortfahren();
    public static final int FAHRZEUG_ID_LAENGE = 7;

    private ControllerNavigationPanel() {
        this.mNavigationPanel.addObserver(this);
        this.addListeners();
    }

    public static ControllerNavigationPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerNavigationPanel();
        }
        return mInstance;
    }

    private void addListeners() {
        this.mNavigationPanel.getCategoryList().addItemListener(this);
        this.mNavigationPanel.getCategoryList().addMouseListener(new HilfeMouseListener("i50011"));
        this.mNavigationPanel.getSubCategoryComboBox().addItemListener(this);
        this.mNavigationPanel.getSearchTextField().addKeyListener(this);
        this.mNavigationPanel.getSearchTextField().addFocusListener(this);
        this.mNavigationPanel.getSearchTextField().addMouseListener(new HilfeMouseListener("i50012"));
        this.mNavigationPanel.getVinTextField().addActionListener(this);
        this.mNavigationPanel.getVinTextField().addFocusListener(this);
        this.mNavigationPanel.getVinTextField().addMouseListener(new HilfeMouseListener("i50015"));
        this.mNavigationPanel.getKundenDialogLabel().addMouseListener(this);
        this.mNavigationPanel.getKundenDialogLabel().addMouseListener(new HilfeMouseListener("i50017"));
        this.mNavigationPanel.getBauartComboBox().addItemListener(this);
        this.mNavigationPanel.getBaureiheComboBox().addItemListener(this);
        this.mNavigationPanel.getKarosserieFormComboBox().addItemListener(this);
        this.mNavigationPanel.getModellComboBox().addItemListener(this);
        this.mNavigationPanel.getKatalogausfuehrungComboBox().addItemListener(this);
        this.mNavigationPanel.getSucheStartenButton().addMouseListener(this);
        this.mNavigationPanel.getActionPanel().addMouseListener(this);
    }

    public void addFahrzeugListener() {
        this.mNavigationPanel.getBaureiheComboBox().addItemListener(this);
        this.mNavigationPanel.getKarosserieFormComboBox().addItemListener(this);
        this.mNavigationPanel.getModellComboBox().addItemListener(this);
        this.mNavigationPanel.getKatalogausfuehrungComboBox().addItemListener(this);
    }

    public void removeFahrzeugListener() {
        this.mNavigationPanel.getBaureiheComboBox().removeItemListener(this);
        this.mNavigationPanel.getKarosserieFormComboBox().removeItemListener(this);
        this.mNavigationPanel.getModellComboBox().removeItemListener(this);
        this.mNavigationPanel.getKatalogausfuehrungComboBox().removeItemListener(this);
    }

    public void selectUnterkategorieItem(String unterkategorie) {
        if (unterkategorie.length() <= 0) {
            return;
        }
        this.mNavigationPanel.getSubCategoryComboBox().removeItemListener(this);
        this.mNavigationPanel.getSubCategoryComboBox().setSelectedItem(unterkategorie);
        this.mNavigationPanel.getSubCategoryComboBox().addItemListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mNavigationPanel.getVinTextField().setCursor(Cursor.getPredefinedCursor(3));
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(3));
            if (this.mNavigationPanel.getVinTextField().hasFocus()) {
                this.handleVinTextfeldActionEvent(event);
            }
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(0));
            this.mNavigationPanel.getVinTextField().setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        if (arg0.getKeyChar() == '\n' && this.mNavigationPanel.getSearchTextField().hasFocus()) {
            this.handleSuchTextfeldKeyEvent(arg0);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemStateChanged(ItemEvent arg0) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(3));
            if (arg0.getSource() == this.mNavigationPanel.getCategoryComboBox() && this.mNavigationPanel.getCategoryComboBox().hasFocus() && arg0.getStateChange() == 1) {
                this.mNavigationPanel.getSubCategoryComboBox().removeItemListener(this);
                this.handleCategoryItemStateChangedEvent(arg0);
                this.mNavigationPanel.getSubCategoryComboBox().addItemListener(this);
                WorkflowController.getInstance().setNewKonfiguration(true);
                if (this.mNavigationPanel.getCategoryComboBox().getSelectedIndex() != 0) {
                    WorkflowController.getInstance().changeState("SUBCAT");
                }
            } else if (arg0.getSource() == this.mNavigationPanel.getSubCategoryComboBox() && this.mNavigationPanel.getSubCategoryComboBox().hasFocus() && arg0.getStateChange() == 1) {
                if (this.handleSubCategoryItemStateChangedEvent()) {
                    WorkflowController.getInstance().setNewKonfiguration(true);
                    WorkflowController.getInstance().changeState("PRODUCTLIST");
                } else {
                    this.mNavigationPanel.getSubCategoryComboBox().removeItemListener(this);
                    this.handleCategoryItemStateChangedEvent(this.mNavigationPanel.getCategoryComboBox().getSelectedIndex());
                    this.mNavigationPanel.getSubCategoryComboBox().addItemListener(this);
                    WorkflowController.getInstance().changeState("SUBCAT");
                }
            } else if ((this.mNavigationPanel.getBauartComboBox().hasFocus() || this.mNavigationPanel.getBaureiheComboBox().hasFocus() || this.mNavigationPanel.getKarosserieFormComboBox().hasFocus() || this.mNavigationPanel.getModellComboBox().hasFocus() || this.mNavigationPanel.getKatalogausfuehrungComboBox().hasFocus()) && arg0.getStateChange() == 1) {
                MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("0");
                this.mNavigationPanel.getBauartComboBox().removeItemListener(this);
                this.mNavigationPanel.getBaureiheComboBox().removeItemListener(this);
                this.mNavigationPanel.getKarosserieFormComboBox().removeItemListener(this);
                this.mNavigationPanel.getModellComboBox().removeItemListener(this);
                this.mNavigationPanel.getKatalogausfuehrungComboBox().removeItemListener(this);
                this.handleFahrzeugdatenItemStateChangedEvent(arg0);
                this.mNavigationPanel.getBauartComboBox().addItemListener(this);
                this.mNavigationPanel.getBaureiheComboBox().addItemListener(this);
                this.mNavigationPanel.getKarosserieFormComboBox().addItemListener(this);
                this.mNavigationPanel.getModellComboBox().addItemListener(this);
                this.mNavigationPanel.getKatalogausfuehrungComboBox().addItemListener(this);
                WorkflowController.getInstance().setNewKonfiguration(true);
            }
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void showUnterkategorienListe() {
        MainPanel containerPanel = MainController.getInstance().getMainFrame().getMainPanel();
        ControllerStatusBar.getInstance().getStatusBar().removeAllStatusFromIndex(2);
        String kategorie = this.mNavigationPanel.getSelectedKategorieText();
        kategorie = ControllerStatusBar.createStatusHauptkat(kategorie);
        MainController.getInstance().getMainFrame().getStatusBar().addNewStatus(" > " + kategorie, "SUBCAT");
        this.mNavigationPanel.getSubCategoryComboBox().removeItemListener(this);
        if (this.mNavigationPanel.getSubCategoryComboBox().getItemCount() > 0) {
            this.mNavigationPanel.getSubCategoryComboBox().setSelectedIndex(0);
        }
        this.mNavigationPanel.getSubCategoryComboBox().addItemListener(this);
        containerPanel.showUnterkategorien(kategorie, MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getUnterkategorieListe());
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (event.getSource() == this.mNavigationPanel.getSucheStartenButton()) {
            this.handleMouseEnteredEvent(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.handleMouseExitedEvent(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        if (event == null) {
            return;
        }
        if (event.getButton() == 3) {
            return;
        }
        if (event.getComponent() == null || event.getComponent().getName() == null) {
            return;
        }
        if (event.getComponent().getName().equals("DIALOG_VIN")) {
            if (GlobalObjects.getInstance().getIpacData().getFahrzeug() == null) {
                ControllerDialogKundeKeyReader.getInstance().getDialogKunde().showDialog(WorkflowController.getInstance().getMarkenLayout());
                if (ControllerDialogKundeKeyReader.getInstance().getDialogKunde().getDialogResult() == 1 && ControllerDialogKundeKeyReader.getInstance().getDialogKunde().getVin() != "") {
                    this.mNavigationPanel.setVinText(ControllerDialogKundeKeyReader.getInstance().getDialogKunde().getVin());
                    this.mNavigationPanel.getVinTextField().requestFocusInWindow();
                    this.mNavigationPanel.clearFahrzeugFelder();
                    MainController.getInstance().getMainFrame().getPrototypeMenuBar().disableIcon("add");
                    MainController.getInstance().getMainFrame().getPrototypeMenuBar().disableIcon("remove");
                    MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("0");
                }
            }
        } else if (event.getComponent() == this.mNavigationPanel.getSucheStartenButton() || event.getComponent() == this.mNavigationPanel.getActionPanel()) {
            try {
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mNavigationPanel.getVinTextField().setCursor(Cursor.getPredefinedCursor(3));
                this.mNavigationPanel.getSucheStartenButton().setCursor(Cursor.getPredefinedCursor(3));
                this.handleSucheStartenButtonActionEvent();
            }
            finally {
                MainController.getInstance().getMainFrame().setDefaultCursor();
                this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(0));
                this.mNavigationPanel.getSucheStartenButton().setCursor(Cursor.getPredefinedCursor(12));
                this.mNavigationPanel.getVinTextField().setCursor(Constants.CursorTypen.STANDARD_CURSOR);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.mNavigationPanel.setAktuelleFahrzeugId(this.mNavigationPanel.getVinTextField().getText());
        if (event.getComponent().getName().equals("VIN") && ((JTextField)event.getComponent()).getText().equals("VIN")) {
            ((JTextField)event.getComponent()).setText("");
        }
        if (event.getComponent().getName().equals("Suchbegriff") && ((JTextField)event.getComponent()).getText().equals(Resource.getInstance().getSuchbegriff())) {
            ((JTextField)event.getComponent()).setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (!this.mNavigationPanel.getAktuelleFahrzeugId().equals(this.mNavigationPanel.getVinTextField().getText())) {
            this.handleFahrzeugIdFocusEvent(event);
        }
        if (event.getComponent().getName().equals("Suchbegriff") && ((JTextField)event.getComponent()).getText().equals("")) {
            ((JTextField)event.getComponent()).setText(Resource.getInstance().getSuchbegriff());
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }

    public NavigationPanel getNavigationPanel() {
        return this.mNavigationPanel;
    }

    public void initDialogData() {
        MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("0");
        this.mNavigationPanel.clearAllFields();
        this.mNavigationPanel.setSelectedUnterkategorieText("");
        this.mNavigationPanel.getSubCategoryComboBox().setVisible(false);
        if (MainController.getInstance().getMainFrame().getMainPanel() != null && MainController.getInstance().getMainFrame().getMainPanel().getSubcategory() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getSubcategory().setAktuellesPanel("");
        }
        if (MainController.getInstance().getMainFrame().getMainPanel() != null && MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setAktuellesPanel("");
        }
        WorkflowController.getInstance().setNewKonfiguration(true);
        WorkflowController.getInstance().setAddKonfiguration(false);
        WorkflowController.getInstance().setAddKonfigurationDataSet(true);
    }

    public void handleCategoryItemStateChangedEvent(ItemEvent event, int selectedIndex) {
        if (selectedIndex < 0) {
            if (event == null) {
                return;
            }
            if (!(event.getSource() instanceof JComboBox)) {
                return;
            }
            JComboBox cBox = (JComboBox)event.getSource();
            if (!cBox.equals(this.mNavigationPanel.getCategoryComboBox()) && !cBox.equals(this.mNavigationPanel.getSubCategoryComboBox())) {
                return;
            }
            selectedIndex = ((JComboBox)event.getSource()).getSelectedIndex();
            if (cBox.equals(this.mNavigationPanel.getCategoryComboBox())) {
                if (this.mNavigationPanel.getSelectedKategorieText().length() > NavigationPanel.getMaxZeichenAnzahl()) {
                    this.mNavigationPanel.getCategoryComboBox().setToolTipText(this.mNavigationPanel.getSelectedKategorieText());
                } else {
                    this.mNavigationPanel.getCategoryComboBox().setToolTipText(null);
                }
            }
        }
        this.mNavigationPanel.clearSuchTextfelder();
        MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("0");
        if (MainController.getInstance().getMainFrame().getMainPanel() != null && MainController.getInstance().getMainFrame().getMainPanel().getSubcategory() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getSubcategory().setAktuellesPanel("");
        }
        if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setAktuellesPanel("");
        }
        if (selectedIndex > 0) {
            if (selectedIndex == 1) {
                this.mNavigationPanel.setAlleUnterkategorien();
            } else {
                this.mNavigationPanel.setUnterkategorien(this.mNavigationPanel.getKategorieListe().get(selectedIndex - 1).getId(), true);
            }
            WorkflowController.getInstance().setNewKonfiguration(true);
            WorkflowController.getInstance().setAddKonfiguration(false);
            WorkflowController.getInstance().setAddKonfigurationDataSet(true);
        } else {
            ControllerNavigationPanel.getInstance().resetUnterkategorien();
            MainController.getInstance().getMainFrame().getMainPanel().showInitialisierungGraphik();
        }
        this.mNavigationPanel.getSubCategoryComboBox().setVisible(selectedIndex > 0);
        this.mNavigationPanel.setSelectedUnterkategorieText("");
        if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().clearUeberschriftPanel();
        }
        if (ControllerMainPanel.getInstance().getMainPanel().getSubcategory() != null) {
            ControllerMainPanel.getInstance().getMainPanel().getSubcategory().setSelectedUnterkategorieText("");
        }
        MainController.getInstance().getMainFrame().getStatusBar().removeAllStatusFromIndex(2);
    }

    public void handleCategoryItemStateChangedEvent(ItemEvent event) {
        this.handleCategoryItemStateChangedEvent(event, -1);
    }

    public void handleCategoryItemStateChangedEvent(int selectedIndex) {
        this.handleCategoryItemStateChangedEvent(null, selectedIndex);
    }

    public boolean handleSubCategoryItemStateChangedEvent() {
        int fetchPage;
        this.mNavigationPanel.clearSuchTextfelder();
        if (MainController.getInstance().getMainFrame().getMainPanel() != null && MainController.getInstance().getMainFrame().getMainPanel().getSubcategory() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getSubcategory().setAktuellesPanel("");
        }
        if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setAktuellesPanel("");
        }
        int unterkategorieId = -1;
        int hauptkategorieId = -1;
        int selectedIndex = this.mNavigationPanel.getSubCategoryComboBox().getSelectedIndex();
        if (selectedIndex <= 0) {
            MainController.getInstance().getMainFrame().getMainPanel().getSubcategory().setSelectedUnterkategorieText("");
            if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().resetProduktListPanel();
            }
            return false;
        }
        if (this.mNavigationPanel.getUnterkategorieListe().size() < selectedIndex) {
            return false;
        }
        unterkategorieId = this.mNavigationPanel.getUnterkategorieListe().get(selectedIndex - 1).getId();
        if (this.mNavigationPanel.getSelectedKategorie() == null) {
            return false;
        }
        hauptkategorieId = this.mNavigationPanel.getSelectedKategorie().getId();
        boolean selectWasOK = this.requeryZubehoerList(hauptkategorieId, unterkategorieId, fetchPage = 1);
        if (!selectWasOK) {
            return false;
        }
        this.mNavigationPanel.setSelectedUnterkategorieText(this.mNavigationPanel.getUnterkategorieListe().get(selectedIndex - 1).getName());
        if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setUeberschriftPanel(this.mNavigationPanel.getSelectedUnterkategorieText());
        }
        if (ControllerMainPanel.getInstance().getMainPanel().getSubcategory() != null) {
            ControllerMainPanel.getInstance().getMainPanel().getSubcategory().setSelectedUnterkategorieText(this.mNavigationPanel.getUnterkategorieListe().get(selectedIndex - 1).getName());
        }
        WorkflowController.getInstance().setNewKonfiguration(true);
        WorkflowController.getInstance().setAddKonfiguration(false);
        WorkflowController.getInstance().setAddKonfigurationDataSet(true);
        return true;
    }

    public void handleFahrzeugdatenItemStateChangedEvent(ItemEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JComboBox)) {
            return;
        }
        this.mNavigationPanel.handleFahrzeugdatenItemStateChanged((JComboBox)event.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSuchTextfeldKeyEvent(KeyEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JTextField)) {
            return;
        }
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mNavigationPanel.getSearchTextField().setCursor(Cursor.getPredefinedCursor(3));
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(3));
            if (!this.checkPlausibilitaetenZubehoersuche()) {
                return;
            }
            WorkflowController.getInstance().setNewKonfiguration(true);
            WorkflowController.getInstance().setAddKonfiguration(false);
            WorkflowController.getInstance().setAddKonfigurationDataSet(true);
            this.handleSucheStartenButtonActionEvent();
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.mNavigationPanel.getSearchTextField().setCursor(Cursor.getPredefinedCursor(2));
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void handleVinTextfeldActionEvent(ActionEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JTextField)) {
            return;
        }
        if (!this.checkPlausibilitaetenVin()) {
            return;
        }
        String vin = ((JTextField)event.getSource()).getText();
        Fahrzeug fahrzeug = NavigationPanelDataLoader.loadFahrzeugdatenVin(vin);
        FzgSucheInfo oFzgSucheInfo = FBIDataloader.getFIByFahrgesellnummer(vin);
        if (oFzgSucheInfo == null) {
            this.mNavigationPanel.setVinText("VIN");
            this.mNavigationPanel.getNavigationPanel().updateUI();
            return;
        }
        fahrzeug.setFzgSucheInfo(oFzgSucheInfo);
        GlobalObjects.getInstance().getIpacData().setFahrzeug(fahrzeug);
        this.mNavigationPanel.initFahrzeugData(fahrzeug);
        MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("add");
        MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("remove");
        this.handleSucheStartenButtonActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSucheStartenButtonActionEvent() {
        try {
            String suchText;
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mNavigationPanel.getSucheStartenButton().setCursor(Cursor.getPredefinedCursor(3));
            this.mNavigationPanel.getActionPanel().setCursor(Cursor.getPredefinedCursor(3));
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(3));
            if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().resetProduktListPanel();
            }
            MainController.getInstance().getMainFrame().getMainPanel().showInitialisierungGraphik();
            ControllerInfoPanel.getInstance().getInfoPanel().changeStatus("0");
            int kategorieId = -1;
            if (this.mNavigationPanel.getSelectedKategorie() != null) {
                kategorieId = this.mNavigationPanel.getSelectedKategorie().getId();
            }
            int unterkategorieId = -1;
            if (this.mNavigationPanel.getSelectedUnterkategorie() != null) {
                unterkategorieId = this.mNavigationPanel.getSelectedUnterkategorie().getId();
            }
            if ((suchText = this.mNavigationPanel.getSearchTextField().getText()).equals(Resource.getInstance().getSuchbegriff())) {
                suchText = "";
            }
            String vin = this.mNavigationPanel.getVinTextField().getText();
            Fahrzeug fahrzeugdaten = null;
            if (vin.length() > 0 && !vin.equals("VIN") && this.checkPlausibilitaetenVin()) {
                fahrzeugdaten = NavigationPanelDataLoader.loadFahrzeugdatenVin(vin);
                FzgSucheInfo oFzgSucheInfo = null;
                oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug() == null || !GlobalObjects.getInstance().getIpacData().getFahrzeug().getFahrgestellnummer().equals(vin) ? FBIDataloader.getFIByFahrgesellnummer(vin) : GlobalObjects.getInstance().getIpacData().getFahrzeug();
                if (oFzgSucheInfo == null) {
                    this.mNavigationPanel.setVinText("VIN");
                    return;
                }
                if (GlobalObjects.getInstance().getIpacData().getFahrzeug() == null) {
                    fahrzeugdaten.setFzgSucheInfo(oFzgSucheInfo);
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(fahrzeugdaten);
                    this.mNavigationPanel.initFahrzeugData(fahrzeugdaten);
                }
                MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("add");
                MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("remove");
            }
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mNavigationPanel.getSucheStartenButton().setCursor(Cursor.getPredefinedCursor(3));
            this.mNavigationPanel.getActionPanel().setCursor(Cursor.getPredefinedCursor(3));
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(3));
            MainController.getInstance().getMainFrame().getStatusBar().removeAllStatusFromIndex(2);
            Baureihe selectedFahrzeugdaten = this.mNavigationPanel.getSelectedFahrzeugdaten();
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("add");
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("remove");
            ArrayList<HitListenHauptKategorie> trefferliste = NavigationPanelDataLoader.loadZubehoer(suchText, kategorieId, unterkategorieId, selectedFahrzeugdaten, fahrzeugdaten);
            if (trefferliste != null && trefferliste.size() > 0) {
                MainController.getInstance().getMainFrame().getInfoPanel().getTrefferlistePanel().setTree(trefferliste);
                MainController.getInstance().getMainFrame().getInfoPanel().getTrefferlistePanel().getScrollPane().getHorizontalScrollBar().setValue(MainController.getInstance().getMainFrame().getInfoPanel().getTrefferlistePanel().getScrollPane().getHorizontalScrollBar().getMinimum());
                MainController.getInstance().getMainFrame().getInfoPanel().getTrefferlistePanel().getScrollPane().getVerticalScrollBar().setValue(MainController.getInstance().getMainFrame().getInfoPanel().getTrefferlistePanel().getScrollPane().getVerticalScrollBar().getMinimum());
                MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("1");
            } else if (suchText != null && suchText.length() >= 3) {
                MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("0");
                int selection = JOptionPane.showConfirmDialog((Component)MainController.getIMainControllerInstance().getMainFrame(), ETK_SUCHE_FORTSETZEN, Resource.getInstance().getInformation(), 0, 1);
                if (selection == 0) {
                    ControllerETKSearch.getInstance().performSearch(suchText);
                }
            } else {
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getSuchanfrageKeineDaten(), Resource.getInstance().getInformation(), 1);
            }
            if (MainController.getInstance().getMainFrame().getMainPanel() != null && MainController.getInstance().getMainFrame().getMainPanel().getSubcategory() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getSubcategory().setAktuellesPanel("");
            }
            if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setAktuellesPanel("");
            }
            if (!WorkflowController.getInstance().isFzBedIdentified() && GlobalObjects.getInstance().getIpacData().getFahrzeug() == null) {
                ControllerMenuBar.getInstance().getMenuBar().disableIcon("add");
                ControllerMenuBar.getInstance().getMenuBar().disableIcon("remove");
            }
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.mNavigationPanel.getSucheStartenButton().setCursor(Cursor.getPredefinedCursor(12));
            this.mNavigationPanel.getActionPanel().setCursor(Cursor.getPredefinedCursor(12));
            this.mNavigationPanel.getNavigationPanel().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void handleMouseEnteredEvent(MouseEvent event) {
    }

    public void handleMouseExitedEvent(MouseEvent event) {
    }

    public void handleFahrzeugIdFocusEvent(FocusEvent event) {
        String vin = ((JTextField)event.getSource()).getText();
        if (vin.equals("")) {
            this.mNavigationPanel.setVinText("VIN");
        }
        if (vin.length() <= 0 || vin.length() > 7) {
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().disableIcon("add");
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().disableIcon("remove");
            if (vin.length() > 7) {
                JOptionPane.showMessageDialog((Component)this.mNavigationPanel.getNavigationPanel(), MELDUNG_UNBEKANNTE_VIN, Resource.getInstance().getInformation(), 1);
                this.mNavigationPanel.setVinText("VIN");
            }
            return;
        }
        Fahrzeug fahrzeug = NavigationPanelDataLoader.loadFahrzeugdatenVin(vin);
        if (FBIDataloader.checkFahrzeugDaten(fahrzeug)) {
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("add");
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("remove");
        } else {
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().disableIcon("add");
            MainController.getInstance().getMainFrame().getPrototypeMenuBar().disableIcon("remove");
            this.mNavigationPanel.setVinText("VIN");
        }
    }

    public boolean checkPlausibilitaetenZubehoersuche() {
        int MIN_LENGTH_ZUBEHOER = 3;
        int MAX_LENGTH_ZUBEHOER = 40;
        String text = this.mNavigationPanel.getSearchTextField().getText();
        return text.length() >= 3 && text.length() <= 40;
    }

    public boolean requeryZubehoerList(int hauptkategorieId, int unterkategorieId, int fetchPage) {
        boolean test;
        ArrayList<ProduktListenElement> zubehoerList = null;
        Fahrzeug fahrzeug = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
            test = fahrzeug != null && (!fahrzeug.getBaureiheBezeichnung().equals(this.mNavigationPanel.getBaureiheComboBox().getSelectedItem()) || !fahrzeug.getModellBezeichnung().equals(this.mNavigationPanel.getModellComboBox().getSelectedItem()) || !fahrzeug.getKatalogausf().equals(this.mNavigationPanel.getKatalogausfuehrungComboBox().getSelectedItem()));
        } else {
            boolean bl = test = fahrzeug != null && (!fahrzeug.getBaureiheBezeichnung().equals(this.mNavigationPanel.getBaureiheComboBox().getSelectedItem()) || !fahrzeug.getKarosserieBezeichnung().equals(this.mNavigationPanel.getKarosserieFormComboBox().getSelectedItem()) || !fahrzeug.getModellBezeichnung().equals(this.mNavigationPanel.getModellComboBox().getSelectedItem()) || !fahrzeug.getKatalogausf().equals(this.mNavigationPanel.getKatalogausfuehrungComboBox().getSelectedItem()));
        }
        if (test) {
            zubehoerList = ControllerSubCategoryPanel.getInstance().getSubCategoryPanel().getFahrzeugZubehoerList(fetchPage);
        } else {
            boolean isLifestyle = false;
            if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie() != null) {
                isLifestyle = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie().isLifestyle();
            }
            zubehoerList = NavigationPanelDataLoader.loadZubehoerUnterkategorie(Integer.valueOf(hauptkategorieId).longValue(), Integer.valueOf(unterkategorieId).longValue(), fetchPage, isLifestyle);
        }
        if (zubehoerList == null) {
            ControllerSubCategoryPanel.getInstance().getSubCategoryPanel().setZubehoerList(new ArrayList<ProduktListenElement>());
            return false;
        }
        ControllerSubCategoryPanel.getInstance().getSubCategoryPanel().setZubehoerList(zubehoerList);
        return true;
    }

    public boolean requeryZubehoerList(JComboBox subCategoryCombobox, int fetchPage) {
        int selectedIndex = subCategoryCombobox.getSelectedIndex();
        if (selectedIndex <= 0) {
            return false;
        }
        int unterkategorieId = this.mNavigationPanel.getUnterkategorieListe().get(selectedIndex - 1).getId();
        int hauptkategorieId = this.mNavigationPanel.getSelectedKategorie().getId();
        return this.requeryZubehoerList(hauptkategorieId, unterkategorieId, fetchPage);
    }

    public boolean checkPlausibilitaetenVin() {
        String text = this.mNavigationPanel.getVinTextField().getText();
        if (text.length() <= 0) {
            return false;
        }
        if (text.length() != 7) {
            this.mNavigationPanel.setVinText("");
            JOptionPane.showMessageDialog((Component)this.mNavigationPanel.getNavigationPanel(), MELDUNG_ANZAHL_ZEICHEN_FAHRZEUG, Resource.getInstance().getInformation(), 1);
        }
        return text.length() == 7;
    }

    private void resetUnterkategorien() {
        this.mNavigationPanel.setUnterkategorien(-1, false);
        WorkflowController.getInstance().setNewKonfiguration(true);
        WorkflowController.getInstance().setAddKonfiguration(false);
        WorkflowController.getInstance().setAddKonfigurationDataSet(true);
    }

    public void handleSuche(String hk, String uk) {
        this.mNavigationPanel.setSelectedKategorieText(hk);
        this.mNavigationPanel.getSubCategoryComboBox().removeItemListener(this);
        this.handleCategoryItemStateChangedEvent(this.mNavigationPanel.getCategoryComboBox().getSelectedIndex());
        this.mNavigationPanel.getSubCategoryComboBox().addItemListener(this);
        this.mNavigationPanel.setSelectedUnterkategorieText(uk);
        this.mNavigationPanel.getSubCategoryComboBox().setSelectedItem(uk);
        this.handleSucheStartenButtonActionEvent();
    }
}

