/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.miniatur;

import de.esg.zub.common.Constants;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.ViewComponent;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.navigation.miniatur.AbstractMiniaturPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.MarketingState;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;
import webetk.resources.Resource;

public class MiniaturMarketingPanel
extends AbstractMiniaturPanel {
    private ViewComponent mViewComponent;
    private JLabel mLabProduktname;
    private JPanel mZusatzPanel1;
    private JPanel mZusatzPanel2;
    private JPanel mZusatzPanel3;

    public MiniaturMarketingPanel() {
        this.mLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setName("MARKETING");
        if (!ControllerMiniaturansicht.getInstance().isAngebotsSicht()) {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.updatePanel();
    }

    private void updatePanel() {
        this.mPanel.removeAll();
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.getHeadPanel(), gbc);
        gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 14, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.getMainPanel(), gbc);
        if (WorkflowController.getInstance().getActiveState() instanceof MarketingState) {
            this.setBorder();
        } else {
            this.removeBorder();
        }
        this.mPanel.validate();
    }

    private JPanel getHeadPanel() {
        if (this.mHead == null) {
            Color background = this.mLayout.getPrimaryBackground();
            Color foreground = this.mLayout.getPrimaryForeground();
            if (this.mLayout.isBMW() || this.mLayout.isBMWi() || this.mLayout.isBMWMotorrad()) {
                background = this.mLayout.getTertiaryBackground();
                foreground = this.mLayout.getTertiaryForeground();
            } else if (this.mLayout.isMINI()) {
                foreground = new Color(224, 224, 224);
            }
            this.mHead = new JPanel();
            this.mHead.setBackground(background);
            this.mHead.setLayout(new GridBagLayout());
            JLabel labMarketing = new JLabel(Resource.getInstance().getMarketingsicht());
            labMarketing.setBigBoldFont();
            labMarketing.setForeground(foreground);
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(10, 5, 0, 0));
            this.mHead.add((Component)labMarketing, gbc);
            JLabel step = new JLabel("1/3");
            step.setBigBoldFont();
            step.setForeground(foreground);
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 14, new Insets(0, 0, 0, 5));
            this.mHead.add((Component)step, gbc);
        }
        return this.mHead;
    }

    private JPanel getMainPanel() {
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        this.mMain = new JPanel();
        this.mMain.setLayout(new GridBagLayout());
        this.mMain.setBackground(this.mLayout.getPrimaryBackground());
        ImageIcon thumbnail = model.getThumbnail();
        int width = thumbnail.getIconWidth();
        int height = thumbnail.getIconHeight();
        int x = (Constants.BildGroessen.THUMBNAIL_MAX_SIZE.width - width) / 2;
        int y = (Constants.BildGroessen.THUMBNAIL_MAX_SIZE.height - height) / 2;
        this.mViewComponent = new ViewComponent();
        this.mViewComponent.setImage(thumbnail, x, y, width, height);
        int insetsInt = 49;
        if (height == 70) {
            insetsInt = 42;
        }
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 10, new Insets(10, insetsInt, 0, 25));
        gbc.ipadx = Constants.BildGroessen.THUMBNAIL_MAX_SIZE.width;
        gbc.ipady = Constants.BildGroessen.THUMBNAIL_MAX_SIZE.height;
        this.mMain.add((Component)this.mViewComponent, gbc);
        JPanel prodPanel = new JPanel(new GridBagLayout());
        prodPanel.setBackground(this.mLayout.getPrimaryBackground());
        String produktName = model.getProductNamePlain();
        if (WorkflowController.getInstance().isNewKonfiguration()) {
            this.mLabProduktname = new JLabel(produktName, 0);
            if (this.mLabProduktname.getText().length() > 20) {
                this.mLabProduktname.setToolTipText(model.getProductNamePlain());
            }
            this.mLabProduktname.setBoldFont();
            this.mLabProduktname.setForeground(this.mLayout.getPrimaryForeground());
            this.mLabProduktname.addMouseListener(ControllerMiniaturansicht.getInstance());
            this.mLabProduktname.addMouseListener(new HilfeMouseListener("i500511"));
            this.mLabProduktname.setName("MARKETING");
            prodPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 10, new Insets(0, 0, 0, 0));
            prodPanel.add((Component)this.mLabProduktname, gbc);
            gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 10, new Insets(0, 0, 0, 0));
            this.mMain.add((Component)prodPanel, gbc);
            JLabel empty = new JLabel(" ");
            gbc = this.setGridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            this.mMain.add((Component)empty, gbc);
        } else {
            if (model.getSelectedAlternative() != null) {
                produktName = produktName + " " + model.getSelectedAlternative().getBnbName();
            }
            this.mLabProduktname = new JLabel(produktName, 0);
            if (this.mLabProduktname.getText().length() > 20) {
                this.mLabProduktname.setToolTipText(produktName);
            }
            this.mLabProduktname.setBoldFont();
            this.mLabProduktname.setForeground(this.mLayout.getPrimaryForeground());
            this.mLabProduktname.addMouseListener(ControllerMiniaturansicht.getInstance());
            this.mLabProduktname.addMouseListener(new HilfeMouseListener("i500511"));
            this.mLabProduktname.setName("MARKETING");
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 10, new Insets(0, 0, 0, 0));
            prodPanel.add((Component)this.mLabProduktname, gbc);
            boolean gibtsVariante = false;
            if (model.getMarketingProdukt().getSelectedBnbsMitVarianten() != null && model.getMarketingProdukt().getSelectedBnbsMitVarianten().size() > 0) {
                prodPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                for (int i = 0; i < model.getMarketingProdukt().getSelectedBnbsMitVarianten().size(); ++i) {
                    Variante variante = model.getMarketingProdukt().getSelectedBnbsMitVarianten().get(i).getSelectedVariante();
                    if (variante == null || variante.getVarianteId() == 0) continue;
                    gibtsVariante = true;
                    this.mZusatzPanel1 = this.getVariantePanel(variante.getName());
                    break;
                }
            }
            if (gibtsVariante) {
                switch (model.getSelectedZusatzprodukte().size()) {
                    case 0: {
                        this.mZusatzPanel2 = this.getEmptyPanel();
                        this.mZusatzPanel3 = this.getEmptyPanel();
                        break;
                    }
                    case 1: {
                        this.mZusatzPanel2 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel3 = this.getEmptyPanel();
                        break;
                    }
                    case 2: {
                        this.mZusatzPanel2 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel3 = this.getZusatzProduktPanel("", model.getSelectedZusatzprodukte().get(1).getProduktNamePlain());
                        break;
                    }
                    default: {
                        this.mZusatzPanel2 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel3 = this.getWeiterProduktePanel(model.getSelectedZusatzprodukte());
                        break;
                    }
                }
            } else {
                switch (model.getSelectedZusatzprodukte().size()) {
                    case 0: {
                        this.mZusatzPanel1 = this.getEmptyPanel();
                        this.mZusatzPanel2 = this.getEmptyPanel();
                        this.mZusatzPanel3 = this.getEmptyPanel();
                        break;
                    }
                    case 1: {
                        prodPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                        this.mZusatzPanel1 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel2 = this.getEmptyPanel();
                        this.mZusatzPanel3 = this.getEmptyPanel();
                        break;
                    }
                    case 2: {
                        prodPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                        this.mZusatzPanel1 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel2 = this.getZusatzProduktPanel("", model.getSelectedZusatzprodukte().get(1).getProduktNamePlain());
                        this.mZusatzPanel3 = this.getEmptyPanel();
                        break;
                    }
                    case 3: {
                        prodPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                        this.mZusatzPanel1 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel2 = this.getZusatzProduktPanel("", model.getSelectedZusatzprodukte().get(1).getProduktNamePlain());
                        this.mZusatzPanel3 = this.getZusatzProduktPanel("", model.getSelectedZusatzprodukte().get(2).getProduktNamePlain());
                        break;
                    }
                    default: {
                        prodPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                        this.mZusatzPanel1 = this.getZusatzProduktPanel(Resource.getInstance().getMit(), model.getSelectedZusatzprodukte().get(0).getProduktNamePlain());
                        this.mZusatzPanel2 = this.getZusatzProduktPanel("", model.getSelectedZusatzprodukte().get(1).getProduktNamePlain());
                        this.mZusatzPanel3 = this.getWeiterProduktePanel(model.getSelectedZusatzprodukte());
                    }
                }
            }
            JPanel spacer = new JPanel();
            spacer.setBackground(this.mLayout.getPrimaryBackground());
            gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
            this.mMain.add((Component)spacer, gbc);
            gbc = this.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 18, new Insets(0, 2, 0, 2));
            this.mMain.add((Component)prodPanel, gbc);
            gbc = this.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 2, 14, new Insets(0, 2, 0, 2));
            if (this.mZusatzPanel1 != null) {
                this.mMain.add((Component)this.mZusatzPanel1, gbc);
            }
            gbc = this.setGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 2, 14, new Insets(0, 2, 0, 2));
            if (this.mZusatzPanel2 != null) {
                this.mMain.add((Component)this.mZusatzPanel2, gbc);
            }
            gbc = this.setGridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 2, 14, new Insets(0, 2, 0, 2));
            if (this.mZusatzPanel3 != null) {
                this.mMain.add((Component)this.mZusatzPanel3, gbc);
            }
            JLabel empty = new JLabel(" ");
            empty.setMinimumSize(new Dimension(0, 1));
            empty.setBackground(this.mLayout.getPrimaryBackground());
            gbc = this.setGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 0, 14, new Insets(0, 0, 0, 0));
            this.mMain.add((Component)empty, gbc);
        }
        return this.mMain;
    }

    private JPanel getVariantePanel(String name) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(this.mLayout.getPrimaryBackground());
        JLabel left = new JLabel(Resource.getInstance().getIn(), 0);
        left.addMouseListener(ControllerMiniaturansicht.getInstance());
        left.setName("MARKETING");
        left.setMinimumSize(new Dimension(40, 17));
        left.setPreferredSize(new Dimension(40, 17));
        left.setOpaque(true);
        left.setForeground(Color.BLACK);
        left.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.WHITE));
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        panel.add((Component)left, gbc);
        JLabel right = new JLabel("   " + name);
        right.addMouseListener(ControllerMiniaturansicht.getInstance());
        right.setName("MARKETING");
        right.setToolTipText(name);
        right.setOpaque(true);
        right.setBackground(Color.WHITE);
        right.setForeground(Color.BLACK);
        right.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        panel.add((Component)right, gbc);
        return panel;
    }

    private JPanel getZusatzProduktPanel(String header, String name) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(this.mLayout.getPrimaryBackground());
        JLabel left = new JLabel(header, 0);
        left.addMouseListener(ControllerMiniaturansicht.getInstance());
        left.setName("MARKETING");
        left.setMinimumSize(new Dimension(40, 17));
        left.setPreferredSize(new Dimension(40, 17));
        left.setOpaque(true);
        left.setForeground(Color.BLACK);
        left.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.WHITE));
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        panel.add((Component)left, gbc);
        JLabel right = new JLabel("   " + name);
        right.addMouseListener(ControllerMiniaturansicht.getInstance());
        right.setName("MARKETING");
        right.setToolTipText(name);
        right.setOpaque(true);
        right.setBackground(Color.WHITE);
        right.setForeground(Color.BLACK);
        right.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        panel.add((Component)right, gbc);
        return panel;
    }

    private JPanel getWeiterProduktePanel(ArrayList<ProduktListenElement> list) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(this.mLayout.getPrimaryBackground());
        JLabel left = new JLabel("", 0);
        left.addMouseListener(ControllerMiniaturansicht.getInstance());
        left.setName("MARKETING");
        left.setMinimumSize(new Dimension(40, 17));
        left.setPreferredSize(new Dimension(40, 17));
        left.setOpaque(true);
        left.setForeground(Color.BLACK);
        left.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.WHITE));
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        panel.add((Component)left, gbc);
        JLabel right = new JLabel("   ...");
        right.addMouseListener(ControllerMiniaturansicht.getInstance());
        right.setName("MARKETING");
        right.setOpaque(true);
        right.setBackground(Color.WHITE);
        right.setForeground(Color.BLACK);
        right.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        panel.add((Component)right, gbc);
        panel.setToolTipText(this.getTooltipText(list));
        return panel;
    }

    private JPanel getEmptyPanel() {
        JPanel pan = new JPanel();
        pan.setMinimumSize(new Dimension(40, 17));
        pan.setPreferredSize(new Dimension(40, 17));
        pan.setBackground(this.mLayout.getPrimaryBackground());
        return pan;
    }

    private String getTooltipText(ArrayList<ProduktListenElement> list) {
        StringBuilder sb = new StringBuilder("<html><b>");
        sb.append(Resource.getInstance().getAusgewaehlteZusatzprodukte());
        sb.append("</b>");
        for (ProduktListenElement element : list) {
            sb.append("<br>");
            sb.append(element.getProduktName());
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void update() {
        this.updatePanel();
    }

    public void setAngebotsSicht(boolean flag) {
        if (flag) {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public JLabel getLabProduktname() {
        return this.mLabProduktname;
    }
}

