/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.miniatur;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.configurator.navigation.miniatur.AbstractMiniaturPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.TechnikState;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rasterviewer.ImageViewerComponent;
import rasterviewer.hotspot.HotspotManager;
import rasterviewer.hotspot.IHotspotManager;
import webetk.communication.LoginInfo;
import webetk.resources.Resource;

public class MiniaturTechnikPanel
extends AbstractMiniaturPanel {
    private JLabel labTechniksicht;
    private ImageViewerComponent mImageViewer;
    private JLabel anzTeile;
    private JLabel anzArbeit;
    private JLabel verfAmpel;

    public MiniaturTechnikPanel() {
        this.mLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mPanel = new JPanel();
        Dimension topComp2 = new Dimension(208, 222);
        this.mPanel.setMaximumSize(topComp2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setName("TECHNIK");
        if (!ControllerMiniaturansicht.getInstance().isAngebotsSicht()) {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        HotspotManager hotspotManager = new HotspotManager();
        this.mImageViewer = new ImageViewerComponent((IHotspotManager)hotspotManager, (JFrame)MainController.getInstance().getMainFrame(), false);
        this.mImageViewer.getPaintPanel().setName("TECHNIK");
        hotspotManager.setImageViewer(this.mImageViewer);
        this.mImageViewer.setScrollbarsVisible(false);
        ClientKonfiguration.getClientKonfiguration().addMiniaturAnsicht(this);
        this.updatePanel();
    }

    private void updatePanel() {
        if (WorkflowController.getInstance().isNewKonfiguration()) {
            this.setInitPanel();
        } else {
            this.setDetailPanel();
            if (WorkflowController.getInstance().getActiveState() instanceof TechnikState) {
                this.setBorder();
            } else {
                this.removeBorder();
            }
        }
    }

    private void setInitPanel() {
        this.mPanel.removeAll();
        JLabel lab = new JLabel(Resource.getInstance().getTechnischeSicht() + "    2/3");
        lab.setHorizontalAlignment(0);
        lab.setBigBoldFont();
        this.mPanel.setBackground(this.mLayout.getPrimaryBackground());
        if (this.mLayout.isBMW() || this.mLayout.isBMWi() || this.mLayout.isBMWMotorrad()) {
            lab.setForeground(this.mLayout.getPrimaryForeground());
        } else if (this.mLayout.isMINI()) {
            lab.setForeground(this.mLayout.getSecondaryForeground());
        }
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)lab, gbc);
        this.mPanel.updateUI();
    }

    private void setDetailPanel() {
        this.mPanel.removeAll();
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.getHeadPanel(), gbc);
        gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.getMainPanel(), gbc);
        this.setLayout();
        this.updateData();
        this.mPanel.updateUI();
        this.mPanel.validate();
    }

    private JPanel getHeadPanel() {
        if (this.mHead == null) {
            Color background = this.mLayout.getPrimaryBackground();
            Color foreground = this.mLayout.getPrimaryForeground();
            if (this.mLayout.isBMW() || this.mLayout.isBMWi() || this.mLayout.isBMWMotorrad()) {
                background = this.mLayout.getTertiaryBackground();
                foreground = this.mLayout.getTertiaryForeground();
            } else if (this.mLayout.isMINI()) {
                foreground = this.mLayout.getSecondaryForeground();
            }
            this.mHead = new JPanel();
            this.mHead.setMinimumSize(new Dimension(20, 20));
            this.mHead.setBackground(background);
            this.mHead.setLayout(new GridBagLayout());
            this.labTechniksicht = new JLabel(Resource.getInstance().getTechnischeSicht());
            this.labTechniksicht.setBigBoldFont();
            this.labTechniksicht.setForeground(foreground);
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(10, 5, 0, 0));
            this.mHead.add((Component)this.labTechniksicht, gbc);
            JLabel step = new JLabel("2/3");
            step.setBigBoldFont();
            step.setForeground(foreground);
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 18, new Insets(10, 5, 0, 5));
            this.mHead.add((Component)step, gbc);
        }
        return this.mHead;
    }

    private JPanel getMainPanel() {
        if (this.mMain == null) {
            this.mMain = new JPanel();
            this.mMain.setLayout(new GridBagLayout());
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 15, new Insets(0, 10, 0, 10));
            this.mImageViewer.setMaximumSize(new Dimension(150, 100));
            this.mImageViewer.setImagePanelBackgroundColor(Color.WHITE);
            gbc.ipadx = 150;
            gbc.ipady = 100;
            this.mMain.add((Component)this.mImageViewer, gbc);
            JPanel spacer = new JPanel();
            spacer.setBackground(this.mLayout.getPrimaryBackground());
            gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
            this.mMain.add((Component)spacer, gbc);
            JPanel kernPanel = new JPanel(new GridBagLayout());
            kernPanel.setBackground(this.mLayout.getPrimaryBackground());
            kernPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            JLabel kern = new JLabel(Resource.getInstance().getAnzahlTeile() + ":", 0);
            kern.setOpaque(true);
            kern.setBackground(new Color(216, 212, 212));
            kern.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.WHITE));
            kern.setPreferredSize(new Dimension(100, 15));
            kern.setMinimumSize(new Dimension(100, 15));
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 1, 12, new Insets(0, 0, 0, 0));
            kernPanel.add((Component)kern, gbc);
            this.anzTeile = new JLabel();
            this.anzTeile.setForeground(this.mLayout.getPrimaryForeground());
            this.anzTeile.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 12, new Insets(0, 0, 0, 0));
            kernPanel.add((Component)this.anzTeile, gbc);
            gbc = this.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 18, new Insets(0, 2, 0, 2));
            this.mMain.add((Component)kernPanel, gbc);
            JPanel optionalPanel = new JPanel(new GridBagLayout());
            optionalPanel.setBackground(this.mLayout.getPrimaryBackground());
            JLabel optional = new JLabel(Resource.getInstance().getAnzahlArbeit() + ":", 0);
            optional.setOpaque(true);
            optional.setBackground(new Color(216, 212, 212));
            optional.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.WHITE));
            optional.setPreferredSize(new Dimension(100, 15));
            optional.setMinimumSize(new Dimension(100, 15));
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            optionalPanel.add((Component)optional, gbc);
            this.anzArbeit = new JLabel();
            this.anzArbeit.setForeground(this.mLayout.getPrimaryForeground());
            this.anzArbeit.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 12, new Insets(0, 0, 0, 0));
            optionalPanel.add((Component)this.anzArbeit, gbc);
            gbc = this.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 2, 18, new Insets(0, 2, 0, 2));
            this.mMain.add((Component)optionalPanel, gbc);
            JPanel hilfsPanel = new JPanel(new GridBagLayout());
            hilfsPanel.setBackground(this.mLayout.getPrimaryBackground());
            hilfsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            LoginInfo sessionInfo = GlobalObjects.getInstance().getSessionInfo();
            if (sessionInfo.getDMSAngeschlossen() && sessionInfo.getDMSVerwenden() && ControllerProduktListPanel.getInstance().isIsPruefeVerfuegbarkeit()) {
                JLabel verfTeile = new JLabel(Resource.getInstance().getVerfuegbarkeitTeile() + ":", 0);
                verfTeile.setOpaque(true);
                verfTeile.setBackground(new Color(216, 212, 212));
                verfTeile.setPreferredSize(new Dimension(100, 15));
                verfTeile.setMinimumSize(new Dimension(100, 15));
                gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
                hilfsPanel.add((Component)verfTeile, gbc);
                this.verfAmpel = new JLabel(new ImageIcon(), 2);
                gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 12, new Insets(0, 8, 0, 0));
                hilfsPanel.add((Component)this.verfAmpel, gbc);
            }
            gbc = this.setGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 2, 16, new Insets(0, 2, 0, 2));
            this.mMain.add((Component)hilfsPanel, gbc);
        }
        return this.mMain;
    }

    private void setLayout() {
        this.mMain.setBackground(this.mLayout.getPrimaryBackground());
        this.mPanel.setBackground(this.mLayout.getPrimaryBackground());
    }

    private void updateData() {
        TechnikModel model = ClientKonfiguration.getClientKonfiguration().getTechnikModel();
        if (model == null) {
            return;
        }
        this.mImageViewer.setImage(model.getCurrentGrafikAsImage());
        this.anzTeile.setText("    " + Integer.toString(model.getAnzahlTeile()));
        this.anzArbeit.setText("    " + Integer.toString(model.getAnzahlArbeit()));
        if (this.verfAmpel != null) {
            this.verfAmpel.setIcon(new ImageIcon(ImageCache.getInstance().getImage("circle_small.gif")));
        }
    }

    @Override
    public void update() {
        this.updatePanel();
    }

    public ImageViewerComponent getImageViewer() {
        return this.mImageViewer;
    }

    public void setAngebotsSicht(boolean flag) {
        if (flag) {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.mPanel.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

