/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.Modell;
import webetk.resources.Resource;

public class BauartenPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JTree bauartenTree = null;
    protected DefaultTreeModel model = null;
    private BaureihenCellRenderer treeCellRenderer = null;
    private DefaultMutableTreeNode topTreeNode = null;
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();

    public BauartenPanel() {
        this.setLayout(new GridBagLayout());
        this.initTree();
        this.setBackground(this.mLayout.getPrimaryBackground());
    }

    private void initTree() {
        if (this.bauartenTree == null) {
            this.bauartenTree = new JTree();
            BaureihenCellRenderer renderer = new BaureihenCellRenderer();
            this.bauartenTree.setCellRenderer(renderer);
            this.bauartenTree.getSelectionModel().setSelectionMode(1);
            this.bauartenTree.setShowsRootHandles(true);
            this.bauartenTree.setBackground(this.mLayout.getPrimaryBackground());
            this.bauartenTree.setForeground(this.mLayout.getPrimaryForeground());
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            this.add((Component)this.bauartenTree, gbc);
            this.bauartenTree.setEditable(false);
        }
    }

    public void buildTree(ArrayList<Bauart> bauartList) {
        int i;
        String selectedBauart = "";
        String selectedBaureihe = "";
        String selectedKarosserie = "";
        String selectedModell = "";
        if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBauart() != null) {
            selectedBauart = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBauart().getBezeichnung();
            if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe() != null) {
                selectedBaureihe = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe().getBezeichnung();
                if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKarosserieForm() != null) {
                    selectedKarosserie = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKarosserieForm().getBezeichnung();
                    if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedModell() != null) {
                        selectedModell = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedModell().getModell();
                    }
                }
            }
        }
        boolean selectFlag = false;
        TreePath treePath = null;
        if (bauartList == null || bauartList.size() <= 0) {
            this.model = null;
            this.bauartenTree.setModel(this.model);
            return;
        }
        this.topTreeNode = new DefaultMutableTreeNode(Resource.getInstance().getBauart());
        DefaultMutableTreeNode nodeBauart = null;
        DefaultMutableTreeNode nodeBaureihe = null;
        Object nodeKarosserieForm = null;
        DefaultMutableTreeNode nodeModell = null;
        DefaultMutableTreeNode nodeKatalogAusfuehrung = null;
        Bauart aktuelleBauart = null;
        Baureihe aktuelleBaureihe = null;
        KarosserieForm aktuelleKarosserieform = null;
        Modell aktuellesModell = null;
        KatalogAusfuehrung aktuelleKatalogAusfuehrung = null;
        for (int i2 = 0; i2 < bauartList.size(); ++i2) {
            aktuelleBauart = bauartList.get(i2);
            nodeBauart = new DefaultMutableTreeNode(aktuelleBauart.getBezeichnung());
            this.topTreeNode.add(nodeBauart);
            if (!selectedBauart.equals("") && aktuelleBauart.getBezeichnung().equals(selectedBauart)) {
                selectFlag = true;
                treePath = new TreePath(nodeBauart.getPath());
            } else {
                selectFlag = false;
            }
            if (aktuelleBauart.getBaureihe() == null) continue;
            for (int m = 0; m < aktuelleBauart.getBaureihe().size(); ++m) {
                aktuelleBaureihe = aktuelleBauart.getBaureihe().get(m);
                nodeBaureihe = new DefaultMutableTreeNode(aktuelleBaureihe.getBezeichnung());
                nodeBauart.add(nodeBaureihe);
                if (selectFlag && aktuelleBauart.getBaureihe().size() == 1) {
                    treePath = new TreePath(nodeBaureihe.getPath());
                } else if (selectFlag && aktuelleBaureihe.getBezeichnung().equals(selectedBaureihe)) {
                    treePath = new TreePath(nodeBaureihe.getPath());
                }
                if (aktuelleBaureihe.getKarosserieForm() == null) continue;
                for (int j = 0; j < aktuelleBaureihe.getKarosserieForm().size(); ++j) {
                    aktuelleKarosserieform = aktuelleBaureihe.getKarosserieForm().get(j);
                    if (aktuelleKarosserieform.getModelle() == null) continue;
                    for (int k = 0; k < aktuelleKarosserieform.getModelle().size(); ++k) {
                        aktuellesModell = aktuelleKarosserieform.getModelle().get(k);
                        nodeModell = new DefaultMutableTreeNode(aktuellesModell.getModell());
                        nodeBaureihe.add(nodeModell);
                        if (selectFlag && aktuelleKarosserieform.getBezeichnung().equals(selectedKarosserie) && aktuellesModell.getModell().equals(selectedModell)) {
                            treePath = new TreePath(nodeModell.getPath());
                        }
                        if (aktuellesModell.getKatalogausfuehrungen() == null) continue;
                        for (int l = 0; l < aktuellesModell.getKatalogausfuehrungen().size(); ++l) {
                            aktuelleKatalogAusfuehrung = aktuellesModell.getKatalogausfuehrungen().get(l);
                            nodeKatalogAusfuehrung = new DefaultMutableTreeNode(aktuelleKatalogAusfuehrung.getKatalogAusfuehrung());
                            nodeModell.add(nodeKatalogAusfuehrung);
                        }
                    }
                }
            }
        }
        this.model = new DefaultTreeModel(this.topTreeNode);
        this.bauartenTree.setModel(this.model);
        int anzeigeTiefe = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getFahrzeugAnzeigeTiefeMotorrad();
        for (i = 0; i <= 4; ++i) {
            this.bauartenTree.collapseRow(i);
        }
        if (treePath != null) {
            this.bauartenTree.expandPath(treePath);
        } else {
            for (i = 0; i <= anzeigeTiefe; ++i) {
                this.bauartenTree.expandRow(i);
            }
        }
    }

    public void setForegroundAll(Color c) {
    }

    public void setStyle() {
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.bauartenTree.setBackground(this.mLayout.getPrimaryBackground());
        this.treeCellRenderer = new BaureihenCellRenderer();
        this.bauartenTree.setCellRenderer(this.treeCellRenderer);
    }

    public class BaureihenCellRenderer
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = 1L;
        private JPanel nodePanel = new JPanel(new CardLayout());
        private JLabel nodeLabel = new JLabel();

        public BaureihenCellRenderer() {
            this.nodeLabel.setBackground(BauartenPanel.this.mLayout.getPrimaryBackground());
            this.nodeLabel.setForeground(BauartenPanel.this.mLayout.getPrimaryForeground());
            this.nodePanel.setBackground(BauartenPanel.this.mLayout.getPrimaryBackground());
            this.nodePanel.add((Component)this.nodeLabel, "");
            this.setLeafIcon(null);
            this.setOpenIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeObject = node.getUserObject();
            if (nodeObject != null) {
                this.nodeLabel.setText(nodeObject.toString());
            }
            return this.nodePanel;
        }
    }
}

