/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.Modell;
import webetk.resources.Resource;

public class BaureihenPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JTree baureihenTree = null;
    protected DefaultTreeModel model = null;
    private BaureihenCellRenderer treeCellRenderer = null;
    private DefaultMutableTreeNode topTreeNode = null;
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();

    public BaureihenPanel() {
        this.setLayout(new GridBagLayout());
        this.initTree();
        this.setBackground(this.mLayout.getPrimaryBackground());
    }

    private void initTree() {
        if (this.baureihenTree == null) {
            this.baureihenTree = new JTree();
            BaureihenCellRenderer renderer = new BaureihenCellRenderer();
            this.baureihenTree.setCellRenderer(renderer);
            this.baureihenTree.getSelectionModel().setSelectionMode(1);
            this.baureihenTree.setShowsRootHandles(true);
            this.baureihenTree.setBackground(this.mLayout.getPrimaryBackground());
            this.baureihenTree.setForeground(this.mLayout.getPrimaryForeground());
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            this.add((Component)this.baureihenTree, gbc);
            this.baureihenTree.setEditable(false);
        }
    }

    public void buildTree(ArrayList<Baureihe> baureiheList) {
        int i;
        String selectedBaureihe = "";
        String selectedKarosserie = "";
        String selectedModell = "";
        if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe() != null) {
            selectedBaureihe = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedBaureihe().getBezeichnung();
            if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKarosserieForm() != null) {
                selectedKarosserie = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKarosserieForm().getBezeichnung();
                if (ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedModell() != null) {
                    selectedModell = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedModell().getModell();
                }
            }
        }
        boolean selectFlag = false;
        TreePath treePath = null;
        if (baureiheList == null || baureiheList.size() <= 0) {
            this.model = null;
            this.baureihenTree.setModel(this.model);
            return;
        }
        this.topTreeNode = new DefaultMutableTreeNode(Resource.getInstance().getBaureihe());
        DefaultMutableTreeNode nodeBaureihe = null;
        DefaultMutableTreeNode nodeKarosserieForm = null;
        DefaultMutableTreeNode nodeModell = null;
        DefaultMutableTreeNode nodeKatalogAusfuehrung = null;
        Baureihe aktuelleBaureihe = null;
        KarosserieForm aktuelleKarosserieform = null;
        Modell aktuellesModell = null;
        KatalogAusfuehrung aktuelleKatalogAusfuehrung = null;
        for (int i2 = 0; i2 < baureiheList.size(); ++i2) {
            aktuelleBaureihe = baureiheList.get(i2);
            nodeBaureihe = new DefaultMutableTreeNode(aktuelleBaureihe.getBezeichnung());
            this.topTreeNode.add(nodeBaureihe);
            if (!selectedBaureihe.equals("") && aktuelleBaureihe.getBezeichnung().equals(selectedBaureihe)) {
                selectFlag = true;
                treePath = new TreePath(nodeBaureihe.getPath());
            } else {
                selectFlag = false;
            }
            if (aktuelleBaureihe.getKarosserieForm() == null) continue;
            for (int j = 0; j < aktuelleBaureihe.getKarosserieForm().size(); ++j) {
                aktuelleKarosserieform = aktuelleBaureihe.getKarosserieForm().get(j);
                nodeKarosserieForm = new DefaultMutableTreeNode(aktuelleKarosserieform.getBezeichnung());
                nodeBaureihe.add(nodeKarosserieForm);
                if (selectFlag && aktuelleBaureihe.getKarosserieForm().size() == 1) {
                    treePath = new TreePath(nodeKarosserieForm.getPath());
                } else if (selectFlag && aktuelleKarosserieform.getBezeichnung().equals(selectedKarosserie)) {
                    treePath = new TreePath(nodeKarosserieForm.getPath());
                }
                if (aktuelleKarosserieform.getModelle() == null) continue;
                for (int k = 0; k < aktuelleKarosserieform.getModelle().size(); ++k) {
                    aktuellesModell = aktuelleKarosserieform.getModelle().get(k);
                    nodeModell = new DefaultMutableTreeNode(aktuellesModell.getModell());
                    nodeKarosserieForm.add(nodeModell);
                    if (selectFlag && aktuelleKarosserieform.getBezeichnung().equals(selectedKarosserie) && aktuellesModell.getModell().equals(selectedModell)) {
                        treePath = new TreePath(nodeModell.getPath());
                    }
                    if (aktuellesModell.getKatalogausfuehrungen() == null) continue;
                    for (int l = 0; l < aktuellesModell.getKatalogausfuehrungen().size(); ++l) {
                        aktuelleKatalogAusfuehrung = aktuellesModell.getKatalogausfuehrungen().get(l);
                        nodeKatalogAusfuehrung = new DefaultMutableTreeNode(aktuelleKatalogAusfuehrung.getKatalogAusfuehrung());
                        nodeModell.add(nodeKatalogAusfuehrung);
                    }
                }
            }
        }
        this.model = new DefaultTreeModel(this.topTreeNode);
        this.baureihenTree.setModel(this.model);
        int anzeigeTiefe = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getFahrzeugAnzeigeTiefe();
        for (i = 0; i <= 4; ++i) {
            this.baureihenTree.collapseRow(i);
        }
        if (treePath != null) {
            this.baureihenTree.expandPath(treePath);
        } else {
            for (i = 0; i <= anzeigeTiefe; ++i) {
                this.baureihenTree.expandRow(i);
            }
        }
    }

    public void setForegroundAll(Color c) {
    }

    public void setStyle() {
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.baureihenTree.setBackground(this.mLayout.getPrimaryBackground());
        this.treeCellRenderer = new BaureihenCellRenderer();
        this.baureihenTree.setCellRenderer(this.treeCellRenderer);
    }

    public class BaureihenCellRenderer
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = 1L;
        private JPanel nodePanel = new JPanel(new CardLayout());
        private JLabel nodeLabel = new JLabel();

        public BaureihenCellRenderer() {
            this.nodeLabel.setBackground(BaureihenPanel.this.mLayout.getPrimaryBackground());
            this.nodeLabel.setForeground(BaureihenPanel.this.mLayout.getPrimaryForeground());
            this.nodePanel.setBackground(BaureihenPanel.this.mLayout.getPrimaryBackground());
            this.nodePanel.add((Component)this.nodeLabel, "");
            this.setLeafIcon(null);
            this.setOpenIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeObject = node.getUserObject();
            if (nodeObject != null) {
                this.nodeLabel.setText(nodeObject.toString());
            }
            return this.nodePanel;
        }
    }
}

