/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.LimitedComboBoxRenderer;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.NavigationModel;
import de.esg.zub.configurator.navigation.suche.IFahrzeugdaten;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.Modell;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class NavigationPanel
extends Observable
implements IFahrzeugdaten {
    public static final String SUCHBEGRIFF_NAME = "Suchbegriff";
    private static final String SUCHEN = "SUCHEN";
    public static final String KEY_READER = "DIALOG_VIN";
    public static final String VIN = "VIN";
    private JComboBox mCategoryComboBox = null;
    private JComboBox mSubcategoryComboBox = null;
    private JLabel vehicleLabel = null;
    private JLabel customerLabel = null;
    private JTextField searchTextField = null;
    private JPanel kategorienPanel = null;
    private JPanel fahrzeugdatenPanel = null;
    private JLabel nameLabel = null;
    private JLabel numberLabel = null;
    private JLabel kundenDialogLabel = null;
    private JTextField vinTextField = null;
    private JPanel actionPanel = null;
    private JLabel sucheStartenButton = null;
    private JLabel undOder = null;
    private JPanel navigationPanel = null;
    private JLabel openVehicleIconLabel = null;
    private JLabel openCustomerIconLabel = null;
    private JComboBox bauartComboBox = null;
    private JComboBox baureiheComboBox = null;
    private JComboBox karosserieFormComboBox = null;
    private JComboBox modellComboBox = null;
    private JComboBox katalogausfuehrungComboBox = null;
    private boolean refreshForFZChange;
    private String selectedUnterkategorieText = "";
    private String aktuelleFahrzeugId = "";
    private JPanel mainHeaderPanel = null;
    private JPanel fuerPanel = null;
    private JPanel ueberPanel = null;
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();
    private NavigationModel mNavModel = null;

    public NavigationPanel(MarkenLayout newLayout) {
        this.navigationPanel = new JPanel();
        this.createNavigationPanel();
        this.setStyle(newLayout);
        this.mNavModel = new NavigationModel();
    }

    private void createNavigationPanel() {
        this.navigationPanel.setLayout(new GridBagLayout());
        if (this.mainHeaderPanel == null) {
            this.mainHeaderPanel = new JPanel(new GridBagLayout());
            this.mainHeaderPanel.setMinimumSize(new Dimension(200, 28));
            this.mainHeaderPanel.setPreferredSize(new Dimension(200, 28));
            JLabel headerName = new JLabel(Resource.getInstance().getSuche(), 2);
            headerName.setBoldFont();
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 5, 0, 0));
            this.mainHeaderPanel.add((Component)headerName, gbc);
        }
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 2, 0));
        this.navigationPanel.add((Component)this.mainHeaderPanel, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 10, 0));
        this.ueberPanel = this.setSubHeaderPanel(Resource.getInstance().getUeber());
        this.navigationPanel.add((Component)this.ueberPanel, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(0, 0, 0, 0));
        this.navigationPanel.add((Component)this.getCategoryPanel(), gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 1, 18, new Insets(10, 0, 0, 0));
        this.fuerPanel = this.setSubHeaderPanel(Resource.getInstance().getFuer());
        this.navigationPanel.add((Component)this.fuerPanel, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 1, 17, new Insets(10, 0, 10, 0));
        this.navigationPanel.add((Component)this.getVehiclePanel(), gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 1, 17, new Insets(10, 0, 0, 0));
        this.navigationPanel.add((Component)this.getActionPanel(), gbc);
    }

    public void initFahrzeugData(Fahrzeug aktuellesFahrzeug) {
        if (aktuellesFahrzeug == null) {
            return;
        }
        this.vinTextField.setText(aktuellesFahrzeug.getFahrgestellnummer());
        this.vinTextField.setEnabled(false);
        if (this.bauartComboBox != null && this.bauartComboBox.getItemCount() > 0 && aktuellesFahrzeug.getBauartBezeichnung() != null && aktuellesFahrzeug.getBauartBezeichnung().length() > 0) {
            this.bauartComboBox.setVisible(true);
            if (this.mLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                this.bauartComboBox.setVisible(false);
            }
            this.bauartComboBox.setSelectedItem(aktuellesFahrzeug.getBauartBezeichnung());
            this.handleFahrzeugdatenItemStateChanged(this.bauartComboBox);
            this.bauartComboBox.setEnabled(false);
        }
        if (this.baureiheComboBox != null && this.baureiheComboBox.getItemCount() > 0 && aktuellesFahrzeug.getBaureiheBezeichnung() != null && aktuellesFahrzeug.getBaureiheBezeichnung().length() > 0) {
            this.baureiheComboBox.setSelectedItem(aktuellesFahrzeug.getBaureiheBezeichnung());
            this.handleFahrzeugdatenItemStateChanged(this.baureiheComboBox);
            this.baureiheComboBox.setEnabled(false);
        }
        if (this.karosserieFormComboBox != null && this.karosserieFormComboBox.getItemCount() > 0 && aktuellesFahrzeug.getKarosserieBezeichnung() != null && aktuellesFahrzeug.getKarosserieBezeichnung().length() > 0) {
            this.karosserieFormComboBox.setSelectedItem(aktuellesFahrzeug.getKarosserieBezeichnung());
            this.handleFahrzeugdatenItemStateChanged(this.karosserieFormComboBox);
            this.karosserieFormComboBox.setEnabled(false);
        }
        if (this.modellComboBox != null && this.modellComboBox.getItemCount() > 0 && aktuellesFahrzeug.getModellBezeichnung() != null && aktuellesFahrzeug.getModellBezeichnung().length() > 0) {
            this.modellComboBox.setSelectedItem(aktuellesFahrzeug.getModellBezeichnung());
            this.handleFahrzeugdatenItemStateChanged(this.modellComboBox);
            this.modellComboBox.setEnabled(false);
        }
        if (this.katalogausfuehrungComboBox != null && this.katalogausfuehrungComboBox.getItemCount() > 0 && aktuellesFahrzeug.getKatalogausf() != null && aktuellesFahrzeug.getKatalogausf().length() > 0) {
            this.katalogausfuehrungComboBox.setSelectedItem(aktuellesFahrzeug.getKatalogausf());
            this.katalogausfuehrungComboBox.setEnabled(false);
        }
        this.fahrzeugdatenPanel.updateUI();
        this.fahrzeugdatenPanel.validate();
    }

    public void handleFahrzeugdatenItemStateChanged(JComboBox comboBox) {
        if (comboBox == null) {
            return;
        }
        if (!MainController.getInstance().getMainFrame().getInfoPanel().getTrefferlistePanel().isVisible()) {
            MainController.getInstance().getMainFrame().getInfoPanel().changeStatus("0");
        }
        if (comboBox == this.bauartComboBox) {
            this.baureiheComboBox.setVisible(false);
            this.karosserieFormComboBox.setVisible(false);
            this.modellComboBox.setVisible(false);
            this.katalogausfuehrungComboBox.setVisible(false);
            if (this.karosserieFormComboBox.getItemCount() > 0) {
                this.karosserieFormComboBox.setSelectedIndex(0);
            }
            if (this.modellComboBox.getItemCount() > 0) {
                this.modellComboBox.setSelectedIndex(0);
            }
            if (this.katalogausfuehrungComboBox.getItemCount() > 0) {
                this.katalogausfuehrungComboBox.setSelectedIndex(0);
            }
            if (this.baureiheComboBox.getSelectedIndex() > 0) {
                this.baureiheComboBox.setSelectedIndex(0);
            }
            if (this.bauartComboBox.getSelectedIndex() == 0) {
                return;
            }
            this.initBaureihen();
        } else if (comboBox == this.baureiheComboBox) {
            this.baureiheComboBox.setVisible(true);
            this.karosserieFormComboBox.setVisible(false);
            this.modellComboBox.setVisible(false);
            this.katalogausfuehrungComboBox.setVisible(false);
            if (this.karosserieFormComboBox.getItemCount() > 0) {
                this.karosserieFormComboBox.setSelectedIndex(0);
            }
            if (this.modellComboBox.getItemCount() > 0) {
                this.modellComboBox.setSelectedIndex(0);
            }
            if (this.katalogausfuehrungComboBox.getItemCount() > 0) {
                this.katalogausfuehrungComboBox.setSelectedIndex(0);
            }
            if (this.baureiheComboBox.getSelectedIndex() == 0) {
                return;
            }
            this.initKarosserieformen();
        } else if (comboBox == this.karosserieFormComboBox) {
            this.modellComboBox.setVisible(false);
            this.katalogausfuehrungComboBox.setVisible(false);
            if (this.modellComboBox.getItemCount() > 0) {
                this.modellComboBox.setSelectedIndex(0);
            }
            if (this.katalogausfuehrungComboBox.getItemCount() > 0) {
                this.katalogausfuehrungComboBox.setSelectedIndex(0);
            }
            if (this.karosserieFormComboBox.getSelectedIndex() == 0) {
                return;
            }
            this.initModelle();
        } else if (comboBox == this.modellComboBox) {
            this.katalogausfuehrungComboBox.setVisible(false);
            if (this.katalogausfuehrungComboBox.getItemCount() > 0) {
                this.katalogausfuehrungComboBox.setSelectedIndex(0);
            }
            if (this.modellComboBox.getSelectedIndex() > 0) {
                this.initKatalogausfuehrungen();
            }
            if (this.getSelectedModellText().length() > NavigationPanel.getMaxZeichenAnzahl()) {
                this.modellComboBox.setToolTipText(this.getSelectedModellText());
            } else {
                this.modellComboBox.setToolTipText(null);
            }
        }
    }

    public void enableFahrzeugAuswahlControls() {
        this.vinTextField.setEnabled(true);
        this.bauartComboBox.setEnabled(true);
        this.baureiheComboBox.setEnabled(true);
        this.karosserieFormComboBox.setEnabled(true);
        this.modellComboBox.setEnabled(true);
        this.katalogausfuehrungComboBox.setEnabled(true);
    }

    private JPanel getCategoryPanel() {
        if (this.kategorienPanel == null) {
            this.kategorienPanel = new JPanel();
            this.kategorienPanel.setLayout(new GridBagLayout());
            this.mCategoryComboBox = new JComboBox();
            this.mCategoryComboBox.setRenderer(new LimitedComboBoxRenderer(NavigationPanel.getMaxZeichenAnzahl()));
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.kategorienPanel.add((Component)this.mCategoryComboBox, gbc);
            gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.kategorienPanel.add((Component)this.getSubCategoryComboBox(), gbc);
            this.getSubCategoryComboBox().setVisible(false);
            this.undOder = new JLabel(Resource.getInstance().getUndOder(), 2);
            this.undOder.setBoldFont();
            gbc = this.mLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 1, 18, new Insets(10, 10, 0, 10));
            this.kategorienPanel.add((Component)this.undOder, gbc);
            this.searchTextField = new JTextField(Resource.getInstance().getSuchbegriff());
            this.searchTextField.setMaxCharacters(40);
            this.searchTextField.setName(SUCHBEGRIFF_NAME);
            this.searchTextField.setPreferredSize(new Dimension(100, 22));
            this.searchTextField.setMinimumSize(new Dimension(100, 22));
            gbc = this.mLayout.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 1, 18, new Insets(10, 10, 10, 10));
            this.kategorienPanel.add((Component)this.searchTextField, gbc);
        }
        return this.kategorienPanel;
    }

    public boolean setKategorien() {
        if (this.mCategoryComboBox.getComponentCount() > 0) {
            this.mCategoryComboBox.removeAllItems();
        }
        if (!this.mNavModel.loadKategorien()) {
            return false;
        }
        if (this.mNavModel.getKategorieListe().size() <= 0) {
            return true;
        }
        this.mNavModel.getKategorieListe().get(0).setName(Resource.getInstance().getAlleProdukte());
        this.mCategoryComboBox.addItem(Resource.getInstance().getKategorie());
        for (HauptKategorie kategorie : this.mNavModel.getKategorieListe()) {
            this.mCategoryComboBox.addItem(kategorie.getName());
        }
        this.mCategoryComboBox.setMaximumRowCount(this.mNavModel.getKategorieListe().size() + 1);
        return true;
    }

    public boolean setUnterkategorien(int kategorieID, boolean loadEntries) {
        if (this.mCategoryComboBox.getComponentCount() > 0) {
            this.mSubcategoryComboBox.removeAllItems();
        }
        if (kategorieID < 0) {
            return false;
        }
        if (this.mNavModel.getKategorieListe() == null || this.mNavModel.getKategorieListe().size() <= 0) {
            return false;
        }
        if (loadEntries) {
            if (!this.mNavModel.loadUnterkategorien(kategorieID)) {
                return false;
            }
        } else if (kategorieID == 0) {
            if (this.mNavModel.getUnterkategorieListe() == null) {
                this.mNavModel.setUnterkategorieListe(new ArrayList<HitListenUnterkategorie>());
            } else {
                this.mNavModel.getUnterkategorieListe().clear();
            }
            HitListenUnterkategorie tmpUnterkategorie = null;
            for (int i = 0; i < this.mNavModel.getKategorieListe().size(); ++i) {
                for (int j = 0; j < this.mNavModel.getKategorieListe().get(i).getUnterkategorie().size(); ++j) {
                    tmpUnterkategorie = this.mNavModel.getKategorieListe().get(i).getUnterkategorie().get(j);
                    if (this.mNavModel.getUnterkategorieListe().contains(tmpUnterkategorie)) continue;
                    this.mNavModel.getUnterkategorieListe().add(tmpUnterkategorie);
                }
            }
        } else {
            for (int i = 0; i < this.mNavModel.getKategorieListe().size(); ++i) {
                if (this.mNavModel.getKategorieListe().get(i).getId() != kategorieID) continue;
                this.mNavModel.setUnterkategorieListe((ArrayList)this.mNavModel.getKategorieListe().get(i).getUnterkategorie());
                break;
            }
        }
        if (this.mNavModel.getUnterkategorieListe().size() <= 0) {
            return true;
        }
        this.getSubCategoryComboBox().removeItemListener(ControllerNavigationPanel.getInstance());
        this.mSubcategoryComboBox.addItem(Resource.getInstance().getUnterkategorie());
        for (HitListenUnterkategorie unterKategorie : this.mNavModel.getUnterkategorieListe()) {
            this.mSubcategoryComboBox.addItem(unterKategorie);
        }
        if (this.mSubcategoryComboBox.getItemCount() > 30) {
            this.mSubcategoryComboBox.setMaximumRowCount(30);
        } else {
            this.mSubcategoryComboBox.setMaximumRowCount(this.mNavModel.getUnterkategorieListe().size() + 1);
        }
        return true;
    }

    public void setAlleUnterkategorien() {
        this.setUnterkategorien(0, false);
    }

    public void initBauarten() {
        this.bauartComboBox.removeAllItems();
        this.baureiheComboBox.setVisible(false);
        this.modellComboBox.setVisible(false);
        this.katalogausfuehrungComboBox.setVisible(false);
        this.mNavModel.setBauart(null);
        this.mNavModel.setBaureihe(null);
        this.mNavModel.setKarosserieform(null);
        this.mNavModel.setModell(null);
        this.bauartComboBox.addItem("Alle Bauarten");
        if (this.mNavModel.loadBauarten() && this.mNavModel.getBauartListe() != null) {
            for (int i = 0; i < this.mNavModel.getBauartListe().size(); ++i) {
                this.bauartComboBox.addItem(this.mNavModel.getBauartListe().get(i).getBezeichnung());
            }
            this.bauartComboBox.setVisible(true);
            if (this.mLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                this.bauartComboBox.setVisible(false);
            }
            if (this.mNavModel.getBauartListe().size() > 21) {
                this.bauartComboBox.setMaximumRowCount(21);
            } else {
                this.bauartComboBox.setMaximumRowCount(this.mNavModel.getBauartListe().size() + 1);
            }
            if (this.bauartComboBox.getItemCount() == 2) {
                this.bauartComboBox.setSelectedIndex(1);
                this.initBaureihen();
            }
        }
    }

    public void initBaureihen() {
        int index;
        this.baureiheComboBox.removeAllItems();
        this.karosserieFormComboBox.setVisible(false);
        this.modellComboBox.setVisible(false);
        this.katalogausfuehrungComboBox.setVisible(false);
        this.mNavModel.setBaureihe(null);
        this.mNavModel.setKarosserieform(null);
        this.mNavModel.setModell(null);
        this.baureiheComboBox.addItem(Resource.getInstance().getAlleBaureihen());
        if (this.mNavModel.getBauartListe() != null && this.mNavModel.getBauartListe().size() > 0 && (index = this.bauartComboBox.getSelectedIndex()) > 0 && this.mNavModel.loadBaureihen(this.mNavModel.getBauartListe().get(index - 1).getBauart()) && this.mNavModel.getBaureiheListe() != null) {
            for (int i = 0; i < this.mNavModel.getBaureiheListe().size(); ++i) {
                this.baureiheComboBox.addItem(this.mNavModel.getBaureiheListe().get(i).getBezeichnung());
            }
            this.baureiheComboBox.setVisible(this.baureiheComboBox.getItemCount() > 1);
            if (this.mNavModel.getBaureiheListe().size() > 21) {
                this.baureiheComboBox.setMaximumRowCount(21);
            } else {
                this.baureiheComboBox.setMaximumRowCount(this.mNavModel.getBaureiheListe().size() + 1);
            }
            if (this.baureiheComboBox.getItemCount() == 2) {
                this.baureiheComboBox.setSelectedIndex(1);
                this.initKarosserieformen();
            }
        }
    }

    public void initKarosserieformen() {
        int index;
        this.karosserieFormComboBox.removeAllItems();
        this.modellComboBox.setVisible(false);
        this.katalogausfuehrungComboBox.setVisible(false);
        this.mNavModel.setKarosserieform(null);
        this.mNavModel.setModell(null);
        this.karosserieFormComboBox.addItem(Resource.getInstance().getAlleKarosserieformen());
        if (this.mNavModel.getBaureiheListe() != null && this.mNavModel.getBaureiheListe().size() > 0 && (index = this.baureiheComboBox.getSelectedIndex()) > 0 && this.mNavModel.loadKarosserieformen(this.mNavModel.getBaureiheListe().get(index - 1)) && this.mNavModel.getBaureihe() != null) {
            this.mNavModel.setKarosserieformListe((ArrayList)this.mNavModel.getBaureihe().getKarosserieForm());
            for (int i = 0; i < this.mNavModel.getBaureihe().getKarosserieForm().size(); ++i) {
                this.karosserieFormComboBox.addItem(this.mNavModel.getBaureihe().getKarosserieForm().get(i).getBezeichnung());
            }
            this.karosserieFormComboBox.setVisible(this.karosserieFormComboBox.getItemCount() > 1);
            if (this.mLayout.isBMWMotorrad()) {
                this.karosserieFormComboBox.setVisible(false);
            }
            if (this.karosserieFormComboBox.getItemCount() == 2) {
                this.karosserieFormComboBox.setSelectedIndex(1);
                this.initModelle();
            }
        }
    }

    public void initModelle() {
        this.modellComboBox.removeAllItems();
        this.katalogausfuehrungComboBox.setVisible(false);
        this.mNavModel.setModell(null);
        this.modellComboBox.addItem(Resource.getInstance().getAlleModelle());
        if (this.mNavModel.getBaureihe() != null && this.mNavModel.getBaureihe().getKarosserieForm() != null && this.mNavModel.getBaureihe().getKarosserieForm().size() > 0) {
            int index;
            int selectedKarosserieform = this.karosserieFormComboBox.getSelectedIndex() - 1;
            if (selectedKarosserieform < 0) {
                selectedKarosserieform = 0;
            }
            if ((index = this.baureiheComboBox.getSelectedIndex()) > 0 && this.mNavModel.loadModelle(this.mNavModel.getBaureiheListe().get(index - 1), this.mNavModel.getBaureihe().getKarosserieForm().get(selectedKarosserieform)) && this.mNavModel.getKarosserieform() != null) {
                this.mNavModel.setModellListe((ArrayList)this.mNavModel.getKarosserieform().getModelle());
                for (int i = 0; i < this.mNavModel.getKarosserieform().getModelle().size(); ++i) {
                    String modell = this.mNavModel.getKarosserieform().getModelle().get(i).getModell();
                    this.modellComboBox.addItem(modell);
                }
                this.modellComboBox.setVisible(this.modellComboBox.getItemCount() > 1);
                if (this.modellComboBox.getItemCount() == 2) {
                    this.modellComboBox.setSelectedIndex(1);
                    this.initKatalogausfuehrungen();
                }
            }
        }
    }

    public void initKatalogausfuehrungen() {
        this.katalogausfuehrungComboBox.removeAllItems();
        this.katalogausfuehrungComboBox.addItem(Resource.getInstance().getAlleKatalogausfuehrungen());
        if (this.mNavModel.getKarosserieform() != null && this.mNavModel.getKarosserieform().getModelle() != null && this.mNavModel.getKarosserieform().getModelle().size() > 0) {
            int index;
            int selectedKarosserieform = this.karosserieFormComboBox.getSelectedIndex() - 1;
            if (selectedKarosserieform < 0) {
                selectedKarosserieform = 0;
            }
            if ((index = this.modellComboBox.getSelectedIndex() - 1) < 0) {
                index = 0;
            }
            if (this.mNavModel.loadKatalogausfuehrungen(this.mNavModel.getKarosserieform().getModelle().get(index), this.mNavModel.getBaureiheListe().get(this.baureiheComboBox.getSelectedIndex() - 1).getBaureihe(), this.mNavModel.getBaureihe().getKarosserieForm().get(selectedKarosserieform).getKarosserieForm()) && this.mNavModel.getModell() != null) {
                this.mNavModel.setKatalogausfuehrungListe((ArrayList)this.mNavModel.getModell().getKatalogausfuehrungen());
                for (int i = 0; i < this.mNavModel.getModell().getKatalogausfuehrungen().size(); ++i) {
                    this.katalogausfuehrungComboBox.addItem(this.mNavModel.getModell().getKatalogausfuehrungen().get(i).getKatalogAusfuehrung());
                }
                this.katalogausfuehrungComboBox.setVisible(this.katalogausfuehrungComboBox.getItemCount() > 1);
            }
        }
    }

    public void clearAllFields() {
        if (this.mCategoryComboBox != null && this.mCategoryComboBox.getItemCount() > 0) {
            this.mCategoryComboBox.setSelectedIndex(0);
        }
        if (this.mSubcategoryComboBox != null && this.mSubcategoryComboBox.getItemCount() > 0) {
            this.mSubcategoryComboBox.setSelectedIndex(0);
        }
        this.clearFahrzeugFelder();
        this.searchTextField.setText(Resource.getInstance().getSuchbegriff());
        this.vinTextField.setText(VIN);
    }

    public void clearFahrzeugFelder() {
        if (this.bauartComboBox != null && this.bauartComboBox.getItemCount() > 0) {
            this.bauartComboBox.setSelectedIndex(0);
        }
        if (this.baureiheComboBox != null && this.baureiheComboBox.getItemCount() > 0) {
            this.baureiheComboBox.setSelectedIndex(0);
        }
        if (this.karosserieFormComboBox != null && this.karosserieFormComboBox.getItemCount() > 0) {
            this.karosserieFormComboBox.setSelectedIndex(0);
        }
        if (this.modellComboBox != null && this.modellComboBox.getItemCount() > 0) {
            this.modellComboBox.setSelectedIndex(0);
        }
        if (this.katalogausfuehrungComboBox != null && this.katalogausfuehrungComboBox.getItemCount() > 0) {
            this.katalogausfuehrungComboBox.setSelectedIndex(0);
        }
        this.enableFahrzeugAuswahlControls();
        this.initBauarten();
    }

    public void clearSuchTextfelder() {
        this.searchTextField.setText(Resource.getInstance().getSuchbegriff());
    }

    private JPanel getVehiclePanel() {
        if (this.baureiheComboBox == null) {
            this.createVehicleComponents();
        }
        return this.getFahrzeugPanel();
    }

    private void createVehicleComponents() {
        this.getVinTextField();
        this.getKundenDialogLabel();
        this.bauartComboBox = new JComboBox();
        this.baureiheComboBox = new JComboBox();
        this.karosserieFormComboBox = new JComboBox();
        this.modellComboBox = new JComboBox();
        this.katalogausfuehrungComboBox = new JComboBox();
    }

    private JPanel getFahrzeugPanel() {
        GridBagConstraints gbc;
        if (this.fahrzeugdatenPanel == null) {
            this.fahrzeugdatenPanel = new JPanel(new GridBagLayout());
            int startYCoordinate = 1;
            gbc = this.mLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.fahrzeugdatenPanel.add((Component)this.bauartComboBox, gbc);
            startYCoordinate = 2;
            gbc = this.mLayout.setGridBagConstraints(0, startYCoordinate, 2, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.fahrzeugdatenPanel.add((Component)this.baureiheComboBox, gbc);
            gbc = this.mLayout.setGridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.fahrzeugdatenPanel.add((Component)this.karosserieFormComboBox, gbc);
            this.karosserieFormComboBox.setVisible(false);
            this.modellComboBox.setRenderer(new LimitedComboBoxRenderer(NavigationPanel.getMaxZeichenAnzahl()));
            gbc = this.mLayout.setGridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.fahrzeugdatenPanel.add((Component)this.modellComboBox, gbc);
            this.modellComboBox.setVisible(false);
            gbc = this.mLayout.setGridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
            this.fahrzeugdatenPanel.add((Component)this.katalogausfuehrungComboBox, gbc);
            this.katalogausfuehrungComboBox.setVisible(false);
        }
        gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 0, 5));
        this.fahrzeugdatenPanel.add((Component)this.getVinTextField(), gbc);
        gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 18, new Insets(10, 10, 0, 10));
        this.fahrzeugdatenPanel.add((Component)this.getKundenDialogLabel(), gbc);
        return this.fahrzeugdatenPanel;
    }

    public JLabel getKundenDialogLabel() {
        if (this.kundenDialogLabel == null) {
            Image img = ImageCache.getInstance().getImage("Icons/kunde_keyreader.jpg");
            this.kundenDialogLabel = img != null ? new JLabel(new ImageIcon(img)) : new JLabel();
            this.kundenDialogLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.kundenDialogLabel.setName(KEY_READER);
        }
        return this.kundenDialogLabel;
    }

    public JTextField getVinTextField() {
        if (this.vinTextField == null) {
            this.vinTextField = new JTextField();
            this.vinTextField.setMaxCharacters(7);
            this.vinTextField.setPreferredSize(new Dimension(100, 22));
            this.vinTextField.setName(VIN);
        }
        return this.vinTextField;
    }

    public void setVinText(String fahrzeugdaten) {
        this.vinTextField.setText(fahrzeugdaten);
    }

    public JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel(new GridBagLayout());
            this.actionPanel.setMinimumSize(new Dimension(200, 20));
            this.actionPanel.setPreferredSize(new Dimension(200, 20));
            this.actionPanel.setName(SUCHEN);
            this.actionPanel.setCursor(Cursor.getPredefinedCursor(12));
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 18, new Insets(0, 5, 0, 0));
            this.actionPanel.add((Component)this.getSucheStartenButton(), gbc);
            JLabel headerName1 = new JLabel(Resource.getInstance().getFinden(), 2);
            headerName1.setBoldFont();
            gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 5, 0, 0));
            this.actionPanel.add((Component)headerName1, gbc);
        }
        return this.actionPanel;
    }

    public JLabel getSucheStartenButton() {
        if (this.sucheStartenButton == null) {
            this.sucheStartenButton = ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "suchen_aktiv.gif") != null ? new JLabel(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "suchen_aktiv.gif"), Color.white)) : new JLabel();
            this.sucheStartenButton.setBorder(BorderFactory.createEmptyBorder());
            this.sucheStartenButton.setName(SUCHEN);
            this.sucheStartenButton.setToolTipText(Resource.getInstance().getSucheStarten());
            this.sucheStartenButton.setCursor(Cursor.getPredefinedCursor(12));
        }
        return this.sucheStartenButton;
    }

    public void setStyle(MarkenLayout newLayout) {
        this.mLayout = newLayout;
        this.navigationPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.getCategoryPanel().setBackground(this.mLayout.getPrimaryBackground());
        this.getVehiclePanel().setBackground(this.mLayout.getPrimaryBackground());
        this.getActionPanel().setBackground(Constants.Layout.LIGHTGRAY_COLOR);
        this.getCategoryComboBox().setBackground(this.mLayout.getPrimaryBackground());
        this.getCategoryComboBox().setForeground(this.mLayout.getPrimaryForeground());
        this.getSubCategoryComboBox().setBackground(this.mLayout.getPrimaryBackground());
        this.getSubCategoryComboBox().setForeground(this.mLayout.getPrimaryForeground());
        this.searchTextField.setStyle(this.mLayout, true);
        this.vinTextField.setStyle(this.mLayout, true);
        this.baureiheComboBox.setBackground(this.mLayout.getPrimaryBackground());
        this.baureiheComboBox.setForeground(this.mLayout.getPrimaryForeground());
        this.karosserieFormComboBox.setBackground(this.mLayout.getPrimaryBackground());
        this.karosserieFormComboBox.setForeground(this.mLayout.getPrimaryForeground());
        this.modellComboBox.setBackground(this.mLayout.getPrimaryBackground());
        this.modellComboBox.setForeground(this.mLayout.getPrimaryForeground());
        this.katalogausfuehrungComboBox.setBackground(this.mLayout.getPrimaryBackground());
        this.katalogausfuehrungComboBox.setForeground(this.mLayout.getPrimaryForeground());
        this.undOder.setForeground(this.mLayout.getBorderTextColor());
        this.searchTextField.setCaretColor(this.mLayout.getCaretColor());
        this.vinTextField.setCaretColor(this.mLayout.getCaretColor());
        this.sucheStartenButton.setBoldFont();
        this.sucheStartenButton.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "suchen_aktiv.gif"), this.mLayout.getPrimaryBackground()));
        this.setHeadersColor();
        this.navigationPanel.validate();
    }

    private void setHeadersColor() {
        this.mainHeaderPanel.setBackground(this.mLayout.getNaviHeaderColor());
        this.mainHeaderPanel.getComponent(0).setForeground(this.mLayout.getNaviHeaderFont());
        this.mainHeaderPanel.setBorder(this.mLayout.getNaviBorderOpenheader());
        this.fuerPanel.setBackground(this.mLayout.getNaviSubHeaderColor());
        this.fuerPanel.getComponent(0).setForeground(this.mLayout.getNaviSubHeaderFont());
        this.ueberPanel.setBackground(this.mLayout.getNaviSubHeaderColor());
        this.ueberPanel.getComponent(0).setForeground(this.mLayout.getNaviSubHeaderFont());
        this.actionPanel.setBackground(this.mLayout.getNaviSubHeaderColor());
        this.actionPanel.getComponent(1).setForeground(this.mLayout.getNaviSubHeaderFont());
        this.navigationPanel.setBorder(this.mLayout.getNaviBorderSelect());
    }

    public HauptKategorie getSelectedKategorie() {
        boolean INDEX_OFFSET = true;
        if (this.mCategoryComboBox != null) {
            int selectedIndex = this.mCategoryComboBox.getSelectedIndex();
            if (selectedIndex < 1 || selectedIndex >= this.mNavModel.getKategorieListe().size() + 1) {
                return null;
            }
            return this.mNavModel.getKategorieListe().get(selectedIndex - 1);
        }
        return null;
    }

    public HitListenUnterkategorie getSelectedUnterkategorie() {
        boolean INDEX_OFFSET = true;
        if (this.mSubcategoryComboBox != null) {
            int selectedIndex = this.mSubcategoryComboBox.getSelectedIndex();
            if (selectedIndex < 1 || selectedIndex >= this.mNavModel.getUnterkategorieListe().size() + 1) {
                return null;
            }
            return this.mNavModel.getUnterkategorieListe().get(selectedIndex - 1);
        }
        return null;
    }

    public Color getSelectedKategorieBorderColor() {
        if (this.mCategoryComboBox == null) {
            return Color.BLACK;
        }
        if (this.mCategoryComboBox.getSelectedIndex() < 2) {
            return Color.LIGHT_GRAY;
        }
        switch (this.mCategoryComboBox.getSelectedIndex()) {
            case 2: {
                return Constants.Layout.AUSSENZUBEHOER_BLAU_RAHMEN_COLOR;
            }
            case 3: {
                return Constants.Layout.INNENZUBEHOER_GRUEN_RAHMEN_COLOR;
            }
            case 4: {
                return Constants.Layout.MOBILE_KOMMUNIKATION_BLAU_RAHMEN_COLOR;
            }
            case 5: {
                return Constants.Layout.TRANSPORT_BLAU_RAHMEN_COLOR;
            }
            case 6: {
                return Constants.Layout.SICHERHEIT_BRAUN_RAHMEN_COLOR;
            }
            case 7: {
                return Constants.Layout.CAR_CARE_BLAU_RAHMEN_COLOR;
            }
            case 8: {
                return Constants.Layout.COMFORT_BLAU_RAHMEN_COLOR;
            }
        }
        return Color.LIGHT_GRAY;
    }

    public JComboBox getCategoryComboBox() {
        return this.mCategoryComboBox;
    }

    public JComboBox getCategoryList() {
        return this.mCategoryComboBox;
    }

    public void setCategoryComboBox(JComboBox categoryComboBox) {
        this.mCategoryComboBox = categoryComboBox;
    }

    public String getSelectedKategorieText() {
        if (this.mCategoryComboBox != null) {
            return (String)this.mCategoryComboBox.getSelectedItem();
        }
        return "";
    }

    public void setSelectedKategorieText(String hk) {
        if (this.mCategoryComboBox != null) {
            this.mCategoryComboBox.setSelectedItem(hk);
        }
    }

    public void setSelectedUnterkategorie(String unterkategorieText) {
        if (this.mSubcategoryComboBox != null) {
            for (int i = 1; i < this.mSubcategoryComboBox.getItemCount(); ++i) {
                if (!((HitListenUnterkategorie)this.mSubcategoryComboBox.getItemAt(i)).toString().equals(unterkategorieText)) continue;
                this.mSubcategoryComboBox.setSelectedIndex(i);
                this.navigationPanel.updateUI();
                this.navigationPanel.validate();
                break;
            }
        }
    }

    public String getSelectedModellText() {
        if (this.modellComboBox != null) {
            return (String)this.modellComboBox.getSelectedItem();
        }
        return "";
    }

    public JComboBox getSubCategoryComboBox() {
        if (this.mSubcategoryComboBox == null) {
            this.mSubcategoryComboBox = new JComboBox();
            this.mSubcategoryComboBox.setRenderer(new LimitedComboBoxRenderer(NavigationPanel.getMaxZeichenAnzahl()));
        }
        return this.mSubcategoryComboBox;
    }

    public String getSelectedUnterkategorieText() {
        if (this.selectedUnterkategorieText.length() > 0) {
            return this.selectedUnterkategorieText;
        }
        if (this.mSubcategoryComboBox != null) {
            return (String)this.mSubcategoryComboBox.getSelectedItem();
        }
        return "";
    }

    public void setSelectedUnterkategorieText(String text) {
        this.selectedUnterkategorieText = text;
        if (this.getSelectedUnterkategorieText() != null && this.getSelectedUnterkategorieText().length() > NavigationPanel.getMaxZeichenAnzahl()) {
            this.getSubCategoryComboBox().setToolTipText(this.getSelectedUnterkategorieText());
        } else {
            this.getSubCategoryComboBox().setToolTipText(null);
        }
    }

    public JLabel getVehicleLabel() {
        return this.vehicleLabel;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JLabel getNumberLabel() {
        return this.numberLabel;
    }

    public JLabel getCustomerLabel() {
        return this.customerLabel;
    }

    public JPanel getNavigationPanel() {
        return this.navigationPanel;
    }

    public JLabel getOpenCustomerIconLabel() {
        return this.openCustomerIconLabel;
    }

    public void setOpenCustomerIconLabel(String s) {
        this.openCustomerIconLabel.setText(s);
        this.openCustomerIconLabel.validate();
    }

    public JLabel getOpenVehicleIconLabel() {
        return this.openVehicleIconLabel;
    }

    public ArrayList<HauptKategorie> getKategorieListe() {
        return this.mNavModel.getKategorieListe();
    }

    public HauptKategorie getHauptKategorieZuId(int id) {
        ArrayList<HauptKategorie> katListe = this.getKategorieListe();
        if (katListe == null) {
            return null;
        }
        for (HauptKategorie kat : katListe) {
            if (kat.getId() != id) continue;
            return kat;
        }
        return null;
    }

    public ArrayList<HitListenUnterkategorie> getUnterkategorieListe() {
        return this.mNavModel.getUnterkategorieListe();
    }

    public HitListenUnterkategorie getUnterkategorieBenZuId(int id) {
        ArrayList<HitListenUnterkategorie> katListe = this.getUnterkategorieListe();
        if (katListe == null) {
            return null;
        }
        for (HitListenUnterkategorie kat : katListe) {
            if (kat.getId() != id) continue;
            return kat;
        }
        return null;
    }

    public JComboBox getBaureiheComboBox() {
        return this.baureiheComboBox;
    }

    public JComboBox getKarosserieFormComboBox() {
        return this.karosserieFormComboBox;
    }

    public JComboBox getKatalogausfuehrungComboBox() {
        return this.katalogausfuehrungComboBox;
    }

    public JComboBox getModellComboBox() {
        return this.modellComboBox;
    }

    public JTextField getSearchTextField() {
        return this.searchTextField;
    }

    public String getAktuelleFahrzeugId() {
        return this.aktuelleFahrzeugId;
    }

    public void setAktuelleFahrzeugId(String aktuelleFahrzeugId) {
        this.aktuelleFahrzeugId = aktuelleFahrzeugId;
    }

    @Override
    public Baureihe getSelectedFahrzeugdaten() {
        Baureihe selectedBaureihe = null;
        KarosserieForm selectedKarosserieForm = null;
        Modell selectedModell = null;
        KatalogAusfuehrung selectedKatalogAusfuehrung = null;
        int selectedIndex = -1;
        selectedIndex = this.baureiheComboBox.getSelectedIndex();
        if (this.mNavModel.getBaureiheListe() == null || this.mNavModel.getBaureiheListe().size() <= 0 || selectedIndex < 1) {
            return null;
        }
        selectedBaureihe = new Baureihe(null, null, null);
        selectedBaureihe.setBaureihe(this.mNavModel.getBaureiheListe().get(selectedIndex - 1).getBaureihe());
        selectedBaureihe.setBezeichnung(this.mNavModel.getBaureiheListe().get(selectedIndex - 1).getBezeichnung());
        selectedIndex = this.karosserieFormComboBox.getSelectedIndex();
        if (this.mNavModel.getKarosserieformListe() != null && this.mNavModel.getKarosserieformListe().size() > 0 && selectedIndex >= 1) {
            selectedKarosserieForm = new KarosserieForm(null);
            selectedKarosserieForm.setBezeichnung(this.mNavModel.getKarosserieformListe().get(selectedIndex - 1).getBezeichnung());
            selectedKarosserieForm.setKarosserieForm(this.mNavModel.getKarosserieformListe().get(selectedIndex - 1).getKarosserieForm());
            if (selectedBaureihe.getKarosserieForm() == null) {
                selectedBaureihe.setKarosserieForm(new ArrayList<KarosserieForm>());
            }
            selectedBaureihe.getKarosserieForm().add(selectedKarosserieForm);
        }
        selectedIndex = this.modellComboBox.getSelectedIndex();
        if (this.mNavModel.getModellListe() != null && this.mNavModel.getModellListe().size() > 0 && selectedIndex >= 1) {
            selectedModell = new Modell(null);
            selectedModell.setModell(this.mNavModel.getModellListe().get(selectedIndex - 1).getModell());
            if (selectedKarosserieForm.getModelle() == null) {
                selectedKarosserieForm.setModelle(new ArrayList<Modell>());
            }
            selectedKarosserieForm.getModelle().add(selectedModell);
        }
        selectedIndex = this.katalogausfuehrungComboBox.getSelectedIndex();
        if (this.mNavModel.getKatalogausfuehrungListe() != null && this.mNavModel.getKatalogausfuehrungListe().size() > 0 && selectedIndex >= 1) {
            selectedKatalogAusfuehrung = new KatalogAusfuehrung(null);
            selectedKatalogAusfuehrung.setKatalogAusfuehrung(this.mNavModel.getKatalogausfuehrungListe().get(selectedIndex - 1).getKatalogAusfuehrung());
            if (selectedModell.getKatalogausfuehrungen() == null) {
                selectedModell.setKatalogausfuehrungen(new ArrayList<KatalogAusfuehrung>());
            }
            selectedModell.getKatalogausfuehrungen().add(selectedKatalogAusfuehrung);
        }
        return selectedBaureihe;
    }

    public Bauart getSelectedBauart() {
        int selectedIndex = -1;
        selectedIndex = this.bauartComboBox.getSelectedIndex();
        if (selectedIndex < 1) {
            return null;
        }
        if (this.mNavModel.getBauartListe() != null && this.mNavModel.getBauartListe().size() >= selectedIndex) {
            return this.mNavModel.getBauartListe().get(selectedIndex - 1);
        }
        return null;
    }

    public Baureihe getSelectedBaureihe() {
        int selectedIndex = -1;
        selectedIndex = this.baureiheComboBox.getSelectedIndex();
        if (selectedIndex < 1) {
            return null;
        }
        if (this.mNavModel.getBaureiheListe() != null && this.mNavModel.getBaureiheListe().size() >= selectedIndex) {
            return this.mNavModel.getBaureiheListe().get(selectedIndex - 1);
        }
        return null;
    }

    public KarosserieForm getSelectedKarosserieForm() {
        int selectedIndex = -1;
        selectedIndex = this.karosserieFormComboBox.getSelectedIndex();
        if (selectedIndex < 1) {
            return null;
        }
        if (this.mNavModel.getKarosserieformListe() != null && this.mNavModel.getKarosserieformListe().size() >= selectedIndex) {
            return this.mNavModel.getKarosserieformListe().get(selectedIndex - 1);
        }
        return null;
    }

    public Modell getSelectedModell() {
        int selectedIndex = -1;
        selectedIndex = this.modellComboBox.getSelectedIndex();
        if (selectedIndex < 1) {
            return null;
        }
        if (this.mNavModel.getModellListe() != null && this.mNavModel.getModellListe().size() >= selectedIndex) {
            return this.mNavModel.getModellListe().get(selectedIndex - 1);
        }
        return null;
    }

    public KatalogAusfuehrung getSelectedKatalogAusfuehrung() {
        int selectedIndex = -1;
        selectedIndex = this.katalogausfuehrungComboBox.getSelectedIndex();
        if (selectedIndex < 1) {
            return null;
        }
        if (this.mNavModel.getKatalogausfuehrungListe() != null && this.mNavModel.getKatalogausfuehrungListe().size() >= selectedIndex) {
            return this.mNavModel.getKatalogausfuehrungListe().get(selectedIndex - 1);
        }
        return null;
    }

    public int getFahrzeugAnzeigeTiefe() {
        if (this.katalogausfuehrungComboBox.getSelectedIndex() > 0 && this.katalogausfuehrungComboBox.isVisible()) {
            return 4;
        }
        if (this.modellComboBox.getSelectedIndex() > 0 && this.modellComboBox.isVisible()) {
            return 3;
        }
        if (this.karosserieFormComboBox.getSelectedIndex() > 0 && this.karosserieFormComboBox.isVisible()) {
            return 2;
        }
        if (this.baureiheComboBox.getSelectedIndex() > 0 && this.baureiheComboBox.isVisible()) {
            return 1;
        }
        return 0;
    }

    public int getFahrzeugAnzeigeTiefeMotorrad() {
        if (this.katalogausfuehrungComboBox.getSelectedIndex() > 0 && this.katalogausfuehrungComboBox.isVisible()) {
            return 4;
        }
        if (this.modellComboBox.getSelectedIndex() > 0 && this.modellComboBox.isVisible()) {
            return 3;
        }
        if (this.baureiheComboBox.getSelectedIndex() > 0 && this.baureiheComboBox.isVisible()) {
            return 2;
        }
        if (this.bauartComboBox.getSelectedIndex() > 0 && this.bauartComboBox.isVisible()) {
            return 1;
        }
        return 0;
    }

    public boolean isRefreshForFZChange() {
        return this.refreshForFZChange;
    }

    public void setRefreshForFZChange(boolean refreshForFZChange) {
        this.refreshForFZChange = refreshForFZChange;
    }

    private JPanel setSubHeaderPanel(String name) {
        JPanel header = new JPanel(new GridBagLayout());
        header.setMinimumSize(new Dimension(200, 20));
        JLabel headerName1 = new JLabel(name, 2);
        headerName1.setBoldFont();
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 5, 0, 0));
        header.add((Component)headerName1, gbc);
        return header;
    }

    public NavigationModel getNavModel() {
        return this.mNavModel;
    }

    public void setNavModel(NavigationModel navModel) {
        this.mNavModel = navModel;
    }

    public static int getMaxZeichenAnzahl() {
        int maxZeichenAnzahl = 27;
        if (GlobalObjects.getInstance().getLanguage().equals("ja")) {
            maxZeichenAnzahl = 14;
        } else if (GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("zh")) {
            maxZeichenAnzahl = 18;
        }
        return maxZeichenAnzahl;
    }

    public JComboBox getBauartComboBox() {
        return this.bauartComboBox;
    }

    public void setBauartComboBox(JComboBox bauartComboBox) {
        this.bauartComboBox = bauartComboBox;
    }
}

