/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.marketing.MarketingDataloader;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.BaureiheMotorrad;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenHauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.Modell;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Kunde;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubSuche;
import webetk.resources.Resource;

public class NavigationPanelDataLoader {
    private static final int FETCHSIZE_ZUBEHOER = 100000;
    private static final int FETCHSIZE_ZUBEHOER_UNTERKATEGORIE = 100000;
    private static Logger log = Logger.getLogger(NavigationPanelDataLoader.class);

    private static Object loadDaten(Command pServerCommand, String pResponseParameter) {
        return NavigationPanelDataLoader.loadDaten("", "", pServerCommand, pResponseParameter);
    }

    private static Object loadDaten(String pRequestParameter, Object value, Command pServerCommand, String pResponseParameter) {
        if (pServerCommand == null) {
            return null;
        }
        if (pResponseParameter.length() <= 0) {
            return null;
        }
        Hashtable<String, Object> requestParameterHashtable = null;
        if (pRequestParameter.length() > 0 && value != null) {
            requestParameterHashtable = new Hashtable<String, Object>(1);
            requestParameterHashtable.put(pRequestParameter, value);
        }
        return NavigationPanelDataLoader.loadDaten(requestParameterHashtable, pServerCommand, pResponseParameter);
    }

    private static Object loadDaten(String pRequestParameter, String value, Command pServerCommand, String pResponseParameter) {
        if (pServerCommand == null) {
            return null;
        }
        if (pResponseParameter.length() <= 0) {
            return null;
        }
        Hashtable<String, String> requestParameterHashtable = null;
        if (pRequestParameter.length() > 0 && value.length() > 0) {
            requestParameterHashtable = new Hashtable<String, String>(1);
            requestParameterHashtable.put(pRequestParameter, value);
        }
        return NavigationPanelDataLoader.loadDaten(requestParameterHashtable, pServerCommand, pResponseParameter);
    }

    private static Object loadDaten(String pRequestParameter, int value, Command pServerCommand, String pResponseParameter) {
        if (pServerCommand == null) {
            return null;
        }
        if (pResponseParameter.length() <= 0) {
            return null;
        }
        Hashtable<String, Integer> requestParameterHashtable = null;
        if (pRequestParameter.length() > 0 && value >= 0) {
            requestParameterHashtable = new Hashtable<String, Integer>(1);
            requestParameterHashtable.put(pRequestParameter, value);
        }
        return NavigationPanelDataLoader.loadDaten(requestParameterHashtable, pServerCommand, pResponseParameter);
    }

    private static Object loadDaten(String pRequestParameter, boolean value, Command pServerCommand, String pResponseParameter) {
        if (pServerCommand == null) {
            return null;
        }
        if (pResponseParameter.length() <= 0) {
            return null;
        }
        Hashtable<String, Boolean> requestParameterHashtable = null;
        if (pRequestParameter.length() > 0) {
            requestParameterHashtable = new Hashtable<String, Boolean>(1);
            requestParameterHashtable.put(pRequestParameter, value);
        }
        return NavigationPanelDataLoader.loadDaten(requestParameterHashtable, pServerCommand, pResponseParameter);
    }

    private static Object loadDaten(Hashtable<String, ?> requestParameterHashtable, Command pServerCommand, String pResponseParameter) {
        Object resultObject = null;
        log.debug((Object)"Laden von Daten");
        if (pServerCommand == null) {
            return null;
        }
        if (pResponseParameter.length() <= 0) {
            return null;
        }
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        TrfZubSuche trfDaten = new TrfZubSuche(null);
        if (requestParameterHashtable != null) {
            Enumeration<String> keys = requestParameterHashtable.keys();
            Iterator<?> valuesIterator = requestParameterHashtable.values().iterator();
            while (keys.hasMoreElements() && valuesIterator.hasNext()) {
                trfDaten.setValue(keys.nextElement(), valuesIterator.next());
            }
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfDaten, pServerCommand);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException: ", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfDaten.getError() != null) {
            Exception ex = trfDaten.getError();
            MarketingDataloader.setDMSErrorMessage(ex);
        }
        resultObject = trfDaten.getValue(pResponseParameter);
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        return resultObject;
    }

    public static ArrayList<HauptKategorie> loadKategorien() {
        log.debug((Object)"Laden der Kategorien");
        return (ArrayList)NavigationPanelDataLoader.loadDaten("ermittleHkOhneUK", false, Command.LADE_KATEGORIEN, "kategorienListe");
    }

    public static ArrayList<HitListenUnterkategorie> loadUnterkategorien(int kategorieID) {
        log.debug((Object)"Laden von Unterkategorien");
        if (kategorieID <= 0) {
            return null;
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten("hauptKategorie", kategorieID, Command.LADE_UNTERKATEGORIEN_ZU_HAUPTKATEGORIE, "unterkategorieListe");
    }

    public static ArrayList<HitListenHauptKategorie> loadZubehoer(String suchText, int kategorieId, int unterkategorieId, Baureihe fahrzeugdatenKombination, Fahrzeug fahrzeugdaten) {
        log.debug((Object)"Laden der Zubeh\u00f6rliste");
        int ELEMENT_COUNT = 5;
        Hashtable<String, Object> requestParameterHashtable = new Hashtable<String, Object>(5);
        if (suchText.length() > 0) {
            requestParameterHashtable.put("keywordSucheString", suchText);
        }
        if (kategorieId > 0) {
            requestParameterHashtable.put("hauptKategorie", kategorieId);
        }
        if (unterkategorieId > 0) {
            requestParameterHashtable.put("unterkategorie", unterkategorieId);
        }
        if (fahrzeugdatenKombination != null) {
            requestParameterHashtable.put("BAUREIHE_ZUB", fahrzeugdatenKombination);
        }
        if (fahrzeugdaten != null) {
            requestParameterHashtable.put("fahrzeug", fahrzeugdaten);
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.ERMITTLE_HITLISTE_KEYWORDSUCHE, "ergebnisHitliste");
    }

    public static ArrayList<ProduktListenElement> loadZubehoer(List<?> produktIdList, int fetchPage, boolean isLifestyle) {
        log.debug((Object)"Laden der Elemente der Zubeh\u00f6rliste");
        if (produktIdList == null || produktIdList.size() <= 0) {
            return null;
        }
        int marktId = GlobalObjects.getInstance().getSessionInfo().getMarktId();
        int ELEMENT_COUNT = 4;
        Hashtable<String, Object> requestParameterHashtable = new Hashtable<String, Object>(4);
        requestParameterHashtable.put("markt", marktId);
        requestParameterHashtable.put("bteListe", produktIdList);
        requestParameterHashtable.put("marketingFetchSize", 100000);
        requestParameterHashtable.put("marketingPageNr", fetchPage);
        requestParameterHashtable.put("isLifestyle", isLifestyle ? "J" : "N");
        Fahrzeug fahrzeug = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (fahrzeug != null) {
            requestParameterHashtable.put("fahrzeug", fahrzeug);
        } else {
            FzgSucheInfo fzgSucheInfo = NavigationPanelDataLoader.getFzgZuSuche();
            if (fzgSucheInfo != null) {
                requestParameterHashtable.put("fzgsucheinfo_app", fzgSucheInfo);
            }
        }
        String kundennr = GlobalObjects.getInstance().getIpacData().getIspaKundenNr();
        if (kundennr != null && !kundennr.equals("")) {
            requestParameterHashtable.put("kundennr", kundennr);
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LADE_PRODUKTE_ZU_BTELISTE, "marketingListe");
    }

    public static ArrayList<ProduktListenElement> loadZubehoerUnterkategorie(long hauptkategorieId, long unterkategorieId, int fetchPage, boolean isLifestyle) {
        String kundennr;
        log.debug((Object)"Laden der Zubeh\u00f6rliste zu einer Unterkategorie");
        int marktId = GlobalObjects.getInstance().getSessionInfo().getMarktId();
        int ELEMENT_COUNT = 5;
        Hashtable<String, Object> requestParameterHashtable = new Hashtable<String, Object>(5);
        requestParameterHashtable.put("markt", marktId);
        requestParameterHashtable.put("hauptKategorie", Long.valueOf(hauptkategorieId).intValue());
        requestParameterHashtable.put("unterkategorie", Long.valueOf(unterkategorieId).intValue());
        requestParameterHashtable.put("marketingFetchSize", 100000);
        requestParameterHashtable.put("marketingPageNr", fetchPage);
        requestParameterHashtable.put("refreshBTEListe", true);
        requestParameterHashtable.put("isLifestyle", isLifestyle ? "J" : "N");
        FzgSucheInfo fzgSucheInfo = NavigationPanelDataLoader.getFzgZuSuche();
        if (fzgSucheInfo != null) {
            requestParameterHashtable.put("fzgsucheinfo_app", fzgSucheInfo);
        }
        if ((kundennr = GlobalObjects.getInstance().getIpacData().getIspaKundenNr()) != null && !kundennr.equals("")) {
            requestParameterHashtable.put("kundennr", kundennr);
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.SUCHE_PRODUKTE_UK, "marketingListe");
    }

    public static String loadBteBedingung(String btnr) {
        log.debug((Object)("Laden der BTEBedingungen zu BTE " + btnr));
        return (String)NavigationPanelDataLoader.loadDaten("btnummer", btnr, Command.ERMITTLE_BTE_BEDINGUNG, "bteBedingungString");
    }

    public static Fahrzeug loadFahrzeugdatenVin(String vin) {
        log.debug((Object)"Laden von Fahrzeugdaten anhand einer VIN");
        if (vin.length() <= 0) {
            return null;
        }
        return (Fahrzeug)NavigationPanelDataLoader.loadDaten("vin", vin, Command.ERMITTLE_FAHRZEUGDATEN, "fahrzeug");
    }

    public static ArrayList<Bauart> loadBauartenMotorrad() {
        log.debug((Object)"Laden der Bauarten");
        return (ArrayList)NavigationPanelDataLoader.loadDaten(Command.LOAD_BAUARTEN_MOTORAD, "bauartenmotorradliste");
    }

    public static Bauart loadBaureihenMotorrad(Bauart bauartRequest) {
        log.debug((Object)"Laden der Baureihen");
        return (Bauart)NavigationPanelDataLoader.loadDaten("bauart", bauartRequest, Command.LOAD_BAUREIHEN_MOTORAD, "bauart");
    }

    public static BaureiheMotorrad loadModelleMotorrad(BaureiheMotorrad baureiheRequest) {
        log.debug((Object)"Laden der Modelle");
        if (baureiheRequest == null) {
            return null;
        }
        Hashtable<String, BaureiheMotorrad> requestParameterHashtable = new Hashtable<String, BaureiheMotorrad>(2);
        requestParameterHashtable.put("baureiheMotorrad", baureiheRequest);
        return (BaureiheMotorrad)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LOAD_MODELLE_MOTORAD, "baureiheMotorrad");
    }

    public static ArrayList<Bauart> loadBauarten() {
        log.debug((Object)"Laden der Bauarten");
        return (ArrayList)NavigationPanelDataLoader.loadDaten(Command.LOAD_BAUARTEN, "bauartenliste");
    }

    public static ArrayList<Baureihe> loadBaureihen(String bauart) {
        log.debug((Object)"Laden der Baureihen");
        return (ArrayList)NavigationPanelDataLoader.loadDaten("bauart", bauart, Command.LADE_BAUREIHEN, "baureihenListeZUB");
    }

    public static Baureihe loadKarosserieformen(Baureihe baureiheRequest) {
        log.debug((Object)"Laden der Karosserieformen");
        if (baureiheRequest == null) {
            return null;
        }
        return (Baureihe)NavigationPanelDataLoader.loadDaten("BAUREIHE_ZUB", baureiheRequest, Command.LADE_KAROSSERIEFORMEN, "BAUREIHE_ZUB");
    }

    public static KarosserieForm loadModelle(Baureihe baureiheRequest, KarosserieForm karosserieFormRequest) {
        log.debug((Object)"Laden der Modelle");
        if (baureiheRequest == null || karosserieFormRequest == null) {
            return null;
        }
        Hashtable<String, Serializable> requestParameterHashtable = new Hashtable<String, Serializable>(2);
        requestParameterHashtable.put("BAUREIHE_ZUB", baureiheRequest);
        requestParameterHashtable.put("karosserie", karosserieFormRequest);
        return (KarosserieForm)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LADE_MODELLE, "karosserie");
    }

    public static Modell loadKatalogausfuehrungen(Modell modellRequest, String baureiheRequest, String karosserieFormRequest) {
        log.debug((Object)"Laden der Katalogausf\u00fchrungen");
        if (modellRequest == null || baureiheRequest == null || karosserieFormRequest == null) {
            return null;
        }
        Hashtable<String, Object> requestParameterHashtable = new Hashtable<String, Object>(3);
        requestParameterHashtable.put("modell", modellRequest);
        requestParameterHashtable.put("baureihe", baureiheRequest);
        requestParameterHashtable.put("karosserie", karosserieFormRequest);
        return (Modell)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LADE_KATALOGAUSFUEHRUNGEN, "modell");
    }

    public static ArrayList<Bauart> loadBauartenElemente(String elementNr, String bildPosNr) {
        log.debug((Object)"Laden der Baureihen");
        Hashtable<String, String> requestParameterHashtable = new Hashtable<String, String>(2);
        requestParameterHashtable.put("btnummer", elementNr);
        if (bildPosNr != null && bildPosNr.length() > 0) {
            requestParameterHashtable.put("bildPosNr", bildPosNr);
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LOAD_BAUARTENBAUM, "bauartenliste");
    }

    public static ArrayList<Baureihe> loadBaureihenElemente(String elementNr, String bildPosNr, String bauart) {
        log.debug((Object)"Laden der Baureihen");
        Hashtable<String, String> requestParameterHashtable = new Hashtable<String, String>(2);
        requestParameterHashtable.put("btnummer", elementNr);
        requestParameterHashtable.put("bauart", bauart);
        if (bildPosNr != null && bildPosNr.length() > 0) {
            requestParameterHashtable.put("bildPosNr", bildPosNr);
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LOAD_BAUREIHENBAUM_WITH_BAUART, "baureihenListeZUB");
    }

    public static ArrayList<Baureihe> loadBaureihenElemente(String elementNr, String bildPosNr) {
        log.debug((Object)"Laden der Baureihen");
        Hashtable<String, String> requestParameterHashtable = new Hashtable<String, String>(2);
        requestParameterHashtable.put("btnummer", elementNr);
        if (bildPosNr != null && bildPosNr.length() > 0) {
            requestParameterHashtable.put("bildPosNr", bildPosNr);
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten(requestParameterHashtable, Command.LADE_BAUREIHENBAUM, "baureihenListeZUB");
    }

    public static ArrayList<Kunde> loadKundeZuNummer(String kundennummer) {
        log.debug((Object)"Laden der Kundendaten");
        if (kundennummer.length() <= 0) {
            return null;
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten("kundennr", kundennummer, Command.ERMITTLE_KUNDE_AUS_NUMMER, "kundenListe");
    }

    public static ArrayList<Kunde> loadKundeZuName(String kundenName) {
        log.debug((Object)"Laden der Kundendaten");
        if (kundenName.length() <= 0) {
            return new ArrayList<Kunde>();
        }
        return (ArrayList)NavigationPanelDataLoader.loadDaten("kundenname", kundenName, Command.ERMITTLE_KUNDE_AUS_NAME, "kundenListe");
    }

    public static FzgSucheInfo getFzgZuSuche() {
        FzgSucheInfo fzgSucheInfo = null;
        NavigationPanel navPanel = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel();
        Baureihe baureihe = navPanel.getSelectedBaureihe();
        KarosserieForm karrosserieForm = navPanel.getSelectedKarosserieForm();
        Modell modell = navPanel.getSelectedModell();
        KatalogAusfuehrung katalogAusfuehrung = navPanel.getSelectedKatalogAusfuehrung();
        if (baureihe != null) {
            log.debug((Object)"ermittle Modellspalten");
            fzgSucheInfo = new FzgSucheInfo();
            fzgSucheInfo.setBaureihe(baureihe.getBaureihe());
            if (karrosserieForm != null) {
                fzgSucheInfo.setKarosserie(karrosserieForm.getKarosserieForm());
            }
            if (modell != null) {
                fzgSucheInfo.setModell(modell.getModell());
            }
            if (katalogAusfuehrung != null) {
                fzgSucheInfo.setRegion(katalogAusfuehrung.getKatalogAusfuehrung());
            }
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            TrfZubSuche trfSuche = new TrfZubSuche(null);
            trfSuche.setValue("baureihe", baureihe.getBaureihe());
            if (karrosserieForm != null) {
                trfSuche.setValue("karosserie", karrosserieForm.getKarosserieForm());
            }
            if (modell != null) {
                trfSuche.setValue("ErwVerkaufsBez", modell.getModell());
            }
            if (katalogAusfuehrung != null) {
                trfSuche.setValue("KatalogAusfuehrung", katalogAusfuehrung.getKatalogAusfuehrung());
            }
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.LADE_MOSPIDS);
            }
            catch (CommunicationException ex) {
                log.error((Object)"ermittle Modellspalten: ", (Throwable)ex);
                MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
            if (trfSuche.getError() != null) {
                if (trfSuche.getError() instanceof NoDataFoundException) {
                    log.warn((Object)"Keine Modellspalten gefunden!");
                    MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
                    MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), trfSuche.getError().getMessage(), "", 0);
                }
            }
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            ArrayList mospids = (ArrayList)trfSuche.getValue("modellspaltenidsInt");
            fzgSucheInfo.setModellspalten(mospids);
        }
        return fzgSucheInfo;
    }

    public static HitListenUnterkategorie getHkUkZuProdukt(String btenr, StringBuffer hk) {
        TrfZubSuche trf = new TrfZubSuche(null);
        trf.setValue("btnummer", btenr);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_HK_UK_ZU_PRODUKT);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trf.getError() != null) {
            Exception ex = trf.getError();
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), ex.getMessage(), Resource.getInstance().getMarketingsicht(), 0);
            return null;
        }
        NavigationPanel navPanel = ControllerNavigationPanel.getInstance().getNavigationPanel();
        Integer hkId = (Integer)trf.getValue("hauptKategorie");
        hk.append(hkId.toString());
        navPanel.getNavModel().loadUnterkategorien(hkId);
        Integer ukId = (Integer)trf.getValue("unterkategorie");
        return navPanel.getUnterkategorieBenZuId(ukId);
    }
}

