/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MainFrame;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.StatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import webetk.ObjectLockedException;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class ControllerStatusBar
implements Observer,
MouseListener {
    private static ControllerStatusBar mInstance = null;
    private StatusBar mStatusBar = null;
    private MainFrame mMainFrame;
    private static Logger log = Logger.getLogger(ControllerStatusBar.class);

    private ControllerStatusBar() {
    }

    public static ControllerStatusBar getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerStatusBar();
            log = Logger.getLogger(ControllerMenuBar.class);
            log.debug((Object)"WelcomeController initialisieren");
            mInstance.init();
        }
        return mInstance;
    }

    public static void reset() {
        mInstance = null;
    }

    private void init() {
        this.mStatusBar = new StatusBar(WorkflowController.getInstance().getMarkenLayout());
        this.mStatusBar.addObserver(mInstance);
        this.mMainFrame = MainController.getInstance().getMainFrame();
        this.mMainFrame.addStatusBar(this.mStatusBar, WorkflowController.getInstance().getMarkenLayout());
        ArrayList<JLabel> statusList = MainController.getInstance().getMainFrame().getStatusBar().getStatusList();
        for (JLabel b : statusList) {
            b.addMouseListener(mInstance);
        }
    }

    public void addListener(int buttonPosition) {
        JLabel button = MainController.getInstance().getMainFrame().getStatusBar().getStatusList().get(buttonPosition);
        button.addMouseListener(this);
    }

    public void clearDialoge() {
        ControllerNavigationPanel.getInstance().initDialogData();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    public void emptyStatusBar() {
        int size = MainController.getInstance().getMainFrame().getStatusBar().getStatusList().size();
        for (int i = size - 1; i > 1; --i) {
            MainController.getInstance().getMainFrame().getStatusBar().removeStatus(i);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        block14: {
            try {
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mStatusBar.getStatusBar().setCursor(Cursor.getPredefinedCursor(3));
                if (event.getComponent().getName().equals("HOME_BIG")) {
                    if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA() && (!GlobalObjects.getInstance().getIpacData().hasAnfrageAngebotWithVIN() || GlobalObjects.getInstance().getIpacData().getIspaAngebotsNr() != 0)) {
                        return;
                    }
                    MainController.getInstance().getMainFrame().removeMenuBar();
                    this.emptyStatusBar();
                    Angebot angebot = ClientKonfiguration.getClientKonfiguration().getAngebot();
                    ClientKonfiguration.getClientKonfiguration().getMiniPanels().clear();
                    this.clearDialoge();
                    ControllerMenuBar.getInstance().getMenuBar().enableMenuSpeichern(false);
                    WorkflowController.getInstance().changeState("WELCOME");
                    ControllerFBI.getModel().setFahrzeug(null);
                    ControllerMainPanel.getInstance().getMainPanel().removeFBA();
                    if (GlobalObjects.getInstance().getIpacData().getAnfrage() != null && angebot == null && GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgangsId().size() > 0) {
                        ControllerAnfragenPanel.getInstance().getAnfragenPanel().getAnfragenleiste().addAnfrageContainer(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getPlainProduktName(), GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
                    }
                    try {
                        if (GlobalObjects.getInstance().getIpacData().getAnfrage() != null) {
                            AnfragenDataLoader.entsperreAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
                        }
                        break block14;
                    }
                    catch (ObjectLockedException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block14;
                }
                if (event.getComponent().getName().equals("HOME_SMALL")) {
                    this.clearDialoge();
                    if (ControllerMainPanel.getInstance().getMainPanel().getConfigPanel() != null) {
                        ControllerMainPanel.getInstance().getMainPanel().getConfigPanel().removeAllConfigurations();
                        MainController.getInstance().getMainFrame().getMainPanel().removeConfigPanel();
                    }
                    ControllerMenuBar.getInstance().getMenuBar().deselectAllButtons();
                    WorkflowController.getInstance().changeState("CONFIG");
                } else {
                    this.handleStatusBarMouseEvent(event);
                }
            }
            finally {
                MainController.getInstance().getMainFrame().setDefaultCursor();
                MainController.getInstance().getMainFrame().getMainPanel().setCursor(Cursor.getPredefinedCursor(0));
                ControllerNavigationPanel.getInstance().getNavigationPanel().getNavigationPanel().setCursor(Cursor.getPredefinedCursor(0));
                ControllerInfoPanel.getInstance().getInfoPanel().setCursor(Cursor.getPredefinedCursor(0));
                this.mStatusBar.getStatusBar().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void handleStatusBarMouseEvent(MouseEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JLabel)) {
            return;
        }
        JLabel selectedItem = (JLabel)event.getSource();
        if (selectedItem == null) {
            return;
        }
        if (this.mStatusBar.getHashtable().containsKey(selectedItem)) {
            String statusName = this.mStatusBar.getHashtable().get(selectedItem);
            if (statusName.equals("KALKULATION") && ControllerMiniaturansicht.getInstance().getMiniaturKalkulation().isInitial()) {
                return;
            }
            if (ControllerMenuBar.getInstance().getMenuBar().isVorgangSelected()) {
                if (statusName.equals("SUBCAT") || statusName.equals("PRODUCTLIST")) {
                    this.mStatusBar.updateSubcatProd(statusName);
                }
            } else if (statusName.equals("SUBCAT")) {
                int hauptKategorieID = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKategorie().getId();
                if (hauptKategorieID == 0) {
                    ControllerNavigationPanel.getInstance().getNavigationPanel().setUnterkategorien(hauptKategorieID, false);
                } else {
                    ControllerNavigationPanel.getInstance().getNavigationPanel().setUnterkategorien(hauptKategorieID, true);
                }
            } else if (statusName.equals("PRODUCTLIST") && WorkflowController.getInstance().getUnterkategorie() != null && WorkflowController.getInstance().getUnterkategorie().getName().length() > 0) {
                MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().setSelectedUnterkategorieText(WorkflowController.getInstance().getUnterkategorie().getName());
            }
            WorkflowController.getInstance().changeState(statusName);
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        this.addListener((Integer)obj);
    }

    public StatusBar getStatusBar() {
        return this.mStatusBar;
    }

    public String buildHKStatus(Fahrzeug fzg) {
        StringBuilder bui = new StringBuilder("");
        if (fzg != null) {
            bui.append(" ");
            bui.append(Resource.getInstance().getFuer());
            bui.append(" ");
            if (fzg.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                bui.append(fzg.getBauartBezeichnung()).append(" ").append(fzg.getBaureiheBezeichnung());
            } else {
                bui.append(fzg.getBaureiheBezeichnung()).append(" ").append(fzg.getKarosserieBezeichnung());
            }
            bui.append(" ").append(fzg.getModellBezeichnung());
            bui.append(" ").append(fzg.getKatalogausf());
        }
        return bui.toString();
    }

    public static String createStatusHauptkat(String kategorie) {
        String kategorieStatus = kategorie;
        Fahrzeug fzg = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (fzg != null) {
            StringBuilder bui = new StringBuilder(" ");
            bui.append(Resource.getInstance().getFuer());
            bui.append(" ");
            if (fzg.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                bui.append(fzg.getBauartBezeichnung()).append(" ").append(fzg.getBaureiheBezeichnung());
            } else {
                bui.append(fzg.getBaureiheBezeichnung()).append(" ").append(fzg.getKarosserieBezeichnung());
            }
            bui.append(" ").append(fzg.getModellBezeichnung());
            bui.append(" ").append(fzg.getKatalogausf());
            kategorieStatus = kategorieStatus + bui.toString();
        }
        return kategorieStatus;
    }
}

