/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import java.util.ArrayList;
import java.util.HashMap;
import webetk.app.zub.suche.Bnb;
import webetk.resources.Resource;

public class FBIState
extends AbstractState {
    public static final String STATE_NAME = "FBI";

    public FBIState() {
        super.setName(STATE_NAME);
    }

    @Override
    public void entry() {
        if (ControllerMainPanel.getInstance().getMainPanel().isFbaVisible()) {
            ControllerMainPanel.getInstance().getMainPanel().removeFBA();
        }
        if (!this.checkAuswahl()) {
            MainController.getInstance().getMainFrame().showErrorMessage(Resource.getInstance().getKeineSelektion() + "!");
            return;
        }
        ControllerMenuBar.getInstance().getMenuBar().disableIcon("add");
        if (!WorkflowController.getInstance().isNewKonfiguration() && !WorkflowController.getInstance().isAddKonfiguration()) {
            WorkflowController.getInstance().changeState("TECHNIK");
            return;
        }
        ControllerMarketingPanel.getInstance().setViewAktiv(false);
        ControllerMiniaturansicht.getInstance().getMiniaturMarketing().removeBorder();
        if (ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().isFahrzeugUngebunden()) {
            WorkflowController.getInstance().setFzBedIdentified(true);
            WorkflowController.getInstance().setAddKonfigurationDataSet(true);
            WorkflowController.getInstance().changeState("TECHNIK");
            return;
        }
        ControllerFBI.getInstance().init();
    }

    @Override
    public void exit() {
        if (WorkflowController.getInstance().isFzBedIdentified() || ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().isFahrzeugUngebunden()) {
            ControllerMarketingPanel.getInstance().getMarketingView().setIcon("KONFIGURATION");
            ControllerMiniaturansicht.getInstance().getMiniaturMarketing().removeBorder();
            ControllerMiniaturansicht.getInstance().getMiniaturKalkulation().removeBorder();
        } else {
            ControllerMarketingPanel.getInstance().setViewAktiv(true);
        }
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null) {
            ControllerMenuBar.getInstance().getMenuBar().enableIcon("add");
        }
        ControllerFBI.getInstance().exit();
    }

    private boolean checkAuswahl() {
        ArrayList<Bnb> selBnbs = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getSelectedBnbsMitVarianten();
        HashMap alt = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getVariantenZuAlternativen();
        HashMap bestandteile = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getVariantenZuBestandteile();
        HashMap einzelteile = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getVariantenZuEinzelteile();
        if (selBnbs != null && selBnbs.size() > 0) {
            boolean check = true;
            for (Bnb bnb : selBnbs) {
                if (bnb.getElementArt().equals("HP_ALTERNATIV") && alt.get(bnb.getBildPos()) != null && !((ArrayList)alt.get(bnb.getBildPos())).isEmpty() && bnb.getSelectedVariante() == null) {
                    WorkflowController.getInstance().changeState("MARKETING");
                    ControllerMarketingPanel.getInstance().getMarketingView().getTextPanel().showAlternativenPanel();
                    return false;
                }
                if ((bnb.getElementArt().equals("HP_OBLIGAT") || bnb.getElementArt().equals("HP_PAKET")) && bestandteile.get(bnb.getBildPos()) != null && !((ArrayList)bestandteile.get(bnb.getBildPos())).isEmpty() && bnb.getSelectedVariante() == null) {
                    WorkflowController.getInstance().changeState("MARKETING");
                    ControllerMarketingPanel.getInstance().getMarketingView().getTextPanel().showBestandteilePanel();
                    return false;
                }
                if (!bnb.getElementArt().equals("HP_EINZELTEIL") || einzelteile.get(bnb.getBildPos()) == null || ((ArrayList)einzelteile.get(bnb.getBildPos())).isEmpty() || bnb.getSelectedVariante() != null) continue;
                ControllerMarketingPanel.getInstance().getMarketingView().getTextPanel().showEinzelteilePanel();
                return false;
            }
            return true;
        }
        WorkflowController.getInstance().changeState("MARKETING");
        if (!alt.isEmpty()) {
            ControllerMarketingPanel.getInstance().getMarketingView().getTextPanel().showAlternativenPanel();
        } else if (!bestandteile.isEmpty()) {
            ControllerMarketingPanel.getInstance().getMarketingView().getTextPanel().showBestandteilePanel();
        } else if (!einzelteile.isEmpty()) {
            ControllerMarketingPanel.getInstance().getMarketingView().getTextPanel().showEinzelteilePanel();
        }
        return false;
    }
}

