/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class KalkulationsState
extends AbstractState {
    Logger logger = Logger.getLogger(KalkulationsState.class);
    public static final String STATE_NAME = "KALKULATION";

    public KalkulationsState() {
        super.setName(STATE_NAME);
    }

    @Override
    public void entry() {
        ControllerKalkulationPanel.getInstance().init();
        ControllerMiniaturansicht.getInstance().getMiniaturKalkulation().setBorder();
        ControllerMenuBar.getInstance().getMenuBar().enableIcon("print");
        if (!ClientKonfiguration.getClientKonfiguration().isKalkulationSet()) {
            ClientKonfiguration.getClientKonfiguration().setKalkulationSet(true);
        }
        ControllerMenuBar.getInstance().setSpeichern();
    }

    @Override
    public void exit() {
        String stateName = WorkflowController.getInstance().getNewState().getName();
        if (stateName.equals("TECHNIK") || stateName.equals(STATE_NAME) || stateName.equals("MARKETING")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(KalkulationsState.STATE_NAME);
                    }
                    catch (Exception e) {
                        KalkulationsState.this.logger.error((Object)"Error saving Konfiguration data:", (Throwable)e);
                        JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame().getMainPanel(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getSpeicherfehler(), 1);
                    }
                }
            });
        } else {
            try {
                ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(STATE_NAME);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error saving Konfiguration data:", (Throwable)e);
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame().getMainPanel(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getSpeicherfehler(), 1);
            }
        }
        ControllerMiniaturansicht.getInstance().getMiniaturKalkulation().removeBorder();
        ControllerMenuBar.getInstance().getMenuBar().disableIcon("print");
    }
}

