/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class MarketingState
extends AbstractState {
    Logger logger = Logger.getLogger(MarketingState.class);
    public static final String STATE_NAME = "MARKETING";

    public MarketingState() {
        super.setName(STATE_NAME);
    }

    @Override
    public void entry() {
        ControllerMarketingPanel.getInstance().init();
        ControllerMiniaturansicht.getInstance().getMiniaturMarketing().setBorder();
        ControllerMenuBar.getInstance().getMenuBar().enableIcon("print");
        ControllerMenuBar.getInstance().setSpeichern();
        ControllerMiniaturansicht.getInstance().showMiniaturansichten();
        ControllerMiniaturansicht.getInstance().getMiniaturKalkulation().removeBorder();
        ControllerMiniaturansicht.getInstance().getMiniaturTechnik().removeBorder();
        MainController.getInstance().getMainFrame().getContainerMiniaturansichten().updateUI();
    }

    @Override
    public void exit() {
        String stateName = WorkflowController.getInstance().getNewState().getName();
        if (stateName.equals("TECHNIK") || stateName.equals("KALKULATION") || stateName.equals(STATE_NAME)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (WorkflowController.getInstance().isFzBedIdentified() && ControllerTechnikPanel.getInstance().getModel() != null) {
                            ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(MarketingState.STATE_NAME);
                        }
                    }
                    catch (Exception e) {
                        MarketingState.this.logger.error((Object)"Error saving Konfiguration data:", (Throwable)e);
                        JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame().getMainPanel(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getSpeicherfehler(), 1);
                    }
                }
            });
        } else {
            try {
                if (WorkflowController.getInstance().isFzBedIdentified() && ControllerTechnikPanel.getInstance().getModel() != null) {
                    ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(STATE_NAME);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Error saving Konfiguration data:", (Throwable)e);
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame().getMainPanel(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getSpeicherfehler(), 1);
            }
        }
        ControllerMiniaturansicht.getInstance().getMiniaturMarketing().removeBorder();
        ControllerMenuBar.getInstance().getMenuBar().disableIcon("print");
    }
}

