/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.ControllerAgbDialog;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.configurator.content.angebot.ControllerAngebotsPanel;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.welcome.ControllerWelcomePanel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.communication.LoginInfo;
import webetk.resources.Resource;

public class WelcomeState
extends AbstractState {
    private static Logger log = Logger.getLogger(WelcomeState.class);
    boolean hasFilialeMarkt = false;
    boolean firstStepIn = true;

    public WelcomeState() {
        super.setName("WELCOME");
    }

    @Override
    public void entry() {
        WorkflowController.getInstance().setMarkenLayout(null, null);
        ControllerWelcomePanel.getInstance().entry();
        if (GlobalObjects.getInstance().getIpacData().getFilialName() != null) {
            MainController.getIMainControllerInstance().getMainFrame().setTitle(Resource.getInstance().getIpacTitel() + " - " + GlobalObjects.getInstance().getIpacData().getFilialName());
        } else {
            MainController.getIMainControllerInstance().getMainFrame().setTitle(Resource.getInstance().getIpacTitel());
        }
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (!loginInfo.getSettings().getEinstellungenGesetzt()) {
            String errorMsg = Resource.getInstance().getMsgEinstellungen();
            errorMsg = errorMsg.replace("{0}", "(" + Resource.getInstance().getExtras() + " - " + Resource.getInstance().getEinstellungen() + ")");
            MainController.getInstance().getMainFrame().showErrorMessage(errorMsg);
            MainController.getInstance().exit(0);
        }
        ControllerAgbDialog.getInstance().checkAgbBestaetigt();
        if (this.firstStepIn) {
            this.firstStepIn = false;
            this.checkFilialMarktZuordnung();
        }
    }

    @Override
    public void exit() {
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null && !ControllerAnfragenPanel.getInstance().isAnfrageGeladen() && !ControllerAngebotsPanel.getInstance().isAngebotGeladen()) {
            GlobalObjects.getInstance().getIpacData().setKunde(null);
            if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                GlobalObjects.getInstance().getIpacData().setFahrzeug(null);
            } else {
                MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getNavModel().setFirstStepIn(true);
            }
            WorkflowController.getInstance().setFzBedIdentified(false);
        }
        if (!ControllerAngebotsPanel.getInstance().isAngebotGeladen()) {
            ControllerMarketingPanel.getInstance().setAngebotsSicht(false);
            ControllerTechnikPanel.getInstance().setAngebotsSicht(false);
            ControllerKalkulationPanel.getInstance().setAngebotsSicht(false);
            ControllerMiniaturansicht.getInstance().setAngebotsSicht(false);
        }
        this.setKundeSpeichern();
        if (!ControllerAngebotsPanel.getInstance().isAngebotGeladen() && ControllerStatusBar.getInstance().getStatusBar() != null) {
            ControllerStatusBar.getInstance().getStatusBar().setIntialState();
        }
        MarkenLayout.setSessionMarke(WorkflowController.getInstance().getMarkenLayout().getMarke(), WorkflowController.getInstance().getMarkenLayout().getProdukt());
        ControllerMenuBar.getInstance();
        ControllerStatusBar.getInstance();
        ControllerNavigationPanel.getInstance();
        ControllerSubCategoryPanel.getInstance();
        ControllerProduktListPanel.getInstance();
        if (ControllerMainPanel.getInstance().getMainPanel().getConfigPanel() != null) {
            ControllerMainPanel.getInstance().getMainPanel().getConfigPanel().removeAllConfigurations();
        }
        ControllerMenuBar.getInstance().getMenuBar().removeVorgaengePanel();
        ControllerMainPanel.getInstance().getMainPanel().removeConfigPanel();
        MainController.getInstance().getMainFrame().addConfiguratorPanel(ControllerMainPanel.getInstance().getMainPanel(), WorkflowController.getInstance().getMarkenLayout());
    }

    private void setKundeSpeichern() {
        List<FilialeZub> filialenList = null;
        try {
            filialenList = AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId());
        }
        catch (Exception e) {
            log.error((Object)"Error ladeFilialListeZub: ", (Throwable)e);
            e.printStackTrace();
        }
        FilialeZub filiale = null;
        if (filialenList != null) {
            for (int i = 0; i < filialenList.size(); ++i) {
                if (!filialenList.get(i).getId().equals(GlobalObjects.getInstance().getSessionInfo().getFilialeId())) continue;
                filiale = filialenList.get(i);
            }
        }
        try {
            GlobalObjects.getInstance().getIpacData().setSpeicherKunde(filiale.isSpeicherKunde());
            ControllerWelcomePanel.getInstance().setEnableReiter(true);
        }
        catch (NullPointerException e) {
            log.error((Object)"NullPointerException setSpeicherKunde: ", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void checkFilialMarktZuordnung() {
        this.hasFilialeMarkt = false;
        ArrayList filialen = new ArrayList();
        try {
            filialen = (ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String aktFilialId = GlobalObjects.getInstance().getSessionInfo().getFilialeId();
        for (FilialeZub zub : filialen) {
            if (!zub.getId().equals(aktFilialId) || zub.getMarktId() == null) continue;
            this.hasFilialeMarkt = true;
            return;
        }
        if (!this.hasFilialeMarkt) {
            ControllerWelcomePanel.getInstance().setAdminVisible();
            ControllerWelcomePanel.getInstance().setEnableReiter(false);
        }
    }
}

