/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.zub.common.MainFrame;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.AdminState;
import de.esg.zub.configurator.workflow.ConfigState;
import de.esg.zub.configurator.workflow.FBIState;
import de.esg.zub.configurator.workflow.KalkulationsState;
import de.esg.zub.configurator.workflow.KundenDialogState;
import de.esg.zub.configurator.workflow.LoginState;
import de.esg.zub.configurator.workflow.MarketingState;
import de.esg.zub.configurator.workflow.ProductlistState;
import de.esg.zub.configurator.workflow.SubCatState;
import de.esg.zub.configurator.workflow.TechnikState;
import de.esg.zub.configurator.workflow.WelcomeState;
import java.util.ArrayList;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;

public class WorkflowController {
    private static WorkflowController mInstance = null;
    private ArrayList<AbstractState> allStates;
    private AbstractState mActiveState = null;
    private AbstractState mPreviousState = null;
    private AbstractState mNewState = null;
    private String mProductart;
    private String mMarke;
    private HauptKategorie hauptKategorie;
    private HitListenUnterkategorie unterkategorie;
    private boolean mFzBedIdentified = false;
    private boolean mNewKonfiguration = true;
    private boolean mAddKonfiguration = false;
    private boolean mAddKonfigurationDataSet = true;
    private MarkenLayout mMarkenLayout = new MarkenLayout();

    private WorkflowController() {
    }

    public static WorkflowController getInstance() {
        if (mInstance == null) {
            mInstance = new WorkflowController();
            mInstance.initStates();
        }
        return mInstance;
    }

    public static void reset() {
        mInstance = null;
    }

    public void initStates() {
        LoginState login = new LoginState();
        this.allStates = new ArrayList();
        this.allStates.add(login);
        this.allStates.add(new WelcomeState());
        this.allStates.add(new ConfigState());
        this.allStates.add(new SubCatState());
        this.allStates.add(new KundenDialogState());
        this.allStates.add(new ProductlistState());
        this.allStates.add(new MarketingState());
        this.allStates.add(new FBIState());
        this.allStates.add(new TechnikState());
        this.allStates.add(new KalkulationsState());
        this.allStates.add(new AdminState());
        this.mActiveState = null;
        this.mPreviousState = null;
        this.setFzBedIdentified(false);
    }

    public void changeState(String newState) {
        for (AbstractState state : this.allStates) {
            if (!state.getName().equals(newState)) continue;
            this.mNewState = state;
            break;
        }
        this.mPreviousState = this.mActiveState;
        String activeName = null;
        if (this.mActiveState != null) {
            activeName = this.mActiveState.getName();
        }
        if (this.mActiveState != null && !activeName.equals(newState)) {
            this.mActiveState.exit();
        }
        this.mActiveState = this.mNewState;
        this.mNewState = null;
        this.mActiveState.entry();
    }

    public void changeToLoginState(String nutzer, MainFrame mainFrame) {
        if (this.mActiveState != null) {
            this.mActiveState.exit();
        }
        for (AbstractState state : this.allStates) {
            if (!(state instanceof LoginState)) continue;
            LoginState login = (LoginState)state;
            login.setMainFrame(mainFrame);
            login.setNutzer(nutzer);
            this.mActiveState = state;
            state.entry();
        }
    }

    public void changeToPeviousState() {
        this.mActiveState = this.mPreviousState;
        if (this.mActiveState != null) {
            this.mActiveState.entry();
        }
    }

    public void setPreviousState() {
        this.mActiveState = this.mPreviousState;
    }

    public MarkenLayout getMarkenLayout() {
        return this.mMarkenLayout;
    }

    public String getProductart() {
        return this.mProductart;
    }

    public void setProductart(String productart) {
        this.mProductart = productart;
    }

    public String getMarke() {
        return this.mMarke;
    }

    public void setMarke(String marke) {
        this.mMarke = marke;
    }

    public HauptKategorie getHauptKategorie() {
        return this.hauptKategorie;
    }

    public void setHauptKategorie(HauptKategorie kategorie) {
        this.hauptKategorie = kategorie;
    }

    public HitListenUnterkategorie getUnterkategorie() {
        return this.unterkategorie;
    }

    public void setUnterkategorie(HitListenUnterkategorie unterkat) {
        this.unterkategorie = unterkat;
    }

    public boolean isFzBedIdentified() {
        return this.mFzBedIdentified;
    }

    public void setFzBedIdentified(boolean fzBedIdentified) {
        this.mFzBedIdentified = fzBedIdentified;
    }

    public boolean isNewKonfiguration() {
        return this.mNewKonfiguration;
    }

    public void setNewKonfiguration(boolean newKonfiguration) {
        this.mNewKonfiguration = newKonfiguration;
    }

    public AbstractState getActiveState() {
        return this.mActiveState;
    }

    public void setMarkenLayout(String marke, String produkt) {
        this.mMarkenLayout.changeLayout(marke, produkt);
    }

    public AbstractState getPreviousState() {
        return this.mPreviousState;
    }

    public boolean isAddKonfiguration() {
        return this.mAddKonfiguration;
    }

    public void setAddKonfiguration(boolean addKonfiguration) {
        this.mAddKonfiguration = addKonfiguration;
    }

    public boolean isAddKonfigurationDataSet() {
        return this.mAddKonfigurationDataSet;
    }

    public void setAddKonfigurationDataSet(boolean addKonfigurationDataSet) {
        this.mAddKonfigurationDataSet = addKonfigurationDataSet;
    }

    public AbstractState getNewState() {
        return this.mNewState;
    }
}

