/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.jasper.AnfrageFactory;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.FilialeZub;

public class MarketingDataSource
implements JRDataSource {
    MarketingModel mModel;
    String mFirmenName;
    String mFilialName;
    int index = -1;

    public MarketingDataSource(MarketingModel model) {
        this.mModel = model;
        this.setFirma();
    }

    private void setFirma() {
        FilialeZub fil = AnfrageFactory.getFiliale();
        this.mFilialName = fil.getBezeichnung();
        this.mFirmenName = fil.getBezeichnungFirma();
    }

    public Object getFieldValue(JRField arg0) throws JRException {
        if (arg0.getName().equals("Produktbezeichnung")) {
            return this.mModel.getProductNamePlain();
        }
        if (arg0.getName().equals("Teasertext")) {
            String cleanText = "";
            if (WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
                if (this.mModel.getMaketingText() != null) {
                    cleanText = "<html>" + this.mModel.getMaketingText().replaceAll("&#149;", "") + "</html>";
                }
            } else {
                cleanText = "<html>" + WorkflowController.getInstance().getMarkenLayout().cleanTextWithNewLine(this.mModel.getMaketingText(), "#", "&#149; ") + "</html>";
            }
            return cleanText;
        }
        if (arg0.getName().equals("UVP")) {
            return this.mModel.getPriceAsDouble();
        }
        if (arg0.getName().equals("MarketingBild")) {
            return this.mModel.getSelectedImage(this.mModel.getErsteSelektierteVariante()).getImage();
        }
        if (arg0.getName().equals("SelectedVariante")) {
            return this.mModel.getSelectedVariante() == null ? null : this.mModel.getSelectedVariante().getName();
        }
        if (arg0.getName().equals("SelectedAlternative")) {
            return this.mModel.getSelectedAlternative() == null ? null : this.mModel.getSelectedAlternative().getBnbName();
        }
        if (arg0.getName().equals("Firmenname")) {
            return this.getFirmenName();
        }
        if (arg0.getName().equals("Filialname")) {
            return this.getFilialName();
        }
        if (arg0.getName().equals("Nutzen")) {
            if (this.mModel.getMarketingProdukt().getNutzen() != null) {
                return "<html>" + WorkflowController.getInstance().getMarkenLayout().cleanTextWithNewLine(this.mModel.getMarketingProdukt().getNutzen(), "#", "&#149; ") + "</html>";
            }
            return "";
        }
        if (arg0.getName().equals("AllElemente")) {
            return this.mModel.getNamesZusatzprodukte();
        }
        if (arg0.getName().equals("SelectedProdukte")) {
            ArrayList<String> selectedProdukte = new ArrayList<String>();
            for (ProduktListenElement el : this.mModel.getSelectedZusatzprodukte()) {
                selectedProdukte.add(el.getProduktName());
            }
            return selectedProdukte;
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index == 0;
    }

    public String getFirmenName() {
        return this.mFirmenName;
    }

    public String getFilialName() {
        return this.mFilialName;
    }
}

