/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.score;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import org.apache.log4j.Logger;
import webetk.app.settings.EinstellungenBasis;
import webetk.communication.LoginInfo;
import webetk.etkclientws.IZubScoreService;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.etkscore.ZubIspaZubehoerpakete;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenController;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.resources.Resource;

public class ZubScoreService
implements IZubScoreService {
    private static Logger log = Logger.getLogger(ZubScoreService.class);

    public ZubIspaZubehoerpakete holeZubehoerpakete(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, Integer angebotsnummer) {
        this.startIPAC(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, angebotsnummer);
        ZubIspaZubehoerpakete result = GlobalObjects.getInstance().getIpacData().getIspaZubpakete();
        if (result != null) {
            return result;
        }
        return new ZubIspaZubehoerpakete();
    }

    private void startIPAC(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, Integer angebotsnummer) {
        log.debug((Object)("Parameter nutzerID " + nutzerID + ", passwort " + passwort + ", filialID " + filialID + ", Sprache " + sprache + ", vin " + vin + ", kundennummer " + kundennummer + ", angebotsnummer " + angebotsnummer));
        MainController mci = ZubScoreService.getMainControllerInstance(nutzerID, passwort, filialID, sprache);
        if (mci == null) {
            log.error((Object)"Error: Could not get MainViewController instance!");
            return;
        }
        mci.initFromISPA(nutzerID, passwort, filialID, sprache, vin, kundennummer, angebotsnummer);
        mci.getMainFrame().initFromISPA(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, angebotsnummer);
        this.showMainView(mci);
    }

    protected static MainController getMainControllerInstance(String nutzerID, String passwort, String filialID, String sprache) {
        log.debug((Object)("nutzerID: " + nutzerID + " passwort: " + passwort + " filialID: " + filialID + " sprache: " + sprache));
        MainController mainController = MainController.getInstance();
        return mainController;
    }

    protected static void setLanguage(String sprache) {
        log.debug((Object)("Sprache setzen: " + sprache));
        String etkSprache = ZubScoreService.changeScoreSpracheToEtkSprache(sprache);
        Resource.setLanguage((String)etkSprache);
        WebETKTheme.changeFont((String)etkSprache.substring(0, 2));
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        EinstellungenBasis settings = oLoginInfo.getSettings();
        settings.setSprache(etkSprache.substring(0, 2));
        if (etkSprache.length() == 4) {
            settings.setSpracheRegion(etkSprache.substring(2, 4));
        } else {
            settings.setSpracheRegion("  ");
        }
        DlgEinstellungenController.setEinstellungenInServerSessionInfo((EinstellungenBasis)settings);
    }

    protected static String changeScoreSpracheToEtkSprache(String scoreSprache) {
        log.debug((Object)("scoreSprache: " + scoreSprache));
        if (scoreSprache.indexOf("_") > -1) {
            scoreSprache = scoreSprache.substring(0, 2) + scoreSprache.substring(3, 5);
        }
        if (scoreSprache.indexOf("-") > -1) {
            scoreSprache = scoreSprache.substring(0, 2) + scoreSprache.substring(3, 5);
        }
        if (Resource.canSetLanguage((String)scoreSprache)) {
            return scoreSprache;
        }
        if (Resource.canSetLanguage((String)(scoreSprache = scoreSprache.substring(0, 2)))) {
            return scoreSprache;
        }
        scoreSprache = "en";
        log.debug((Object)("umgewandelt in: " + scoreSprache));
        return scoreSprache;
    }

    public void closeETK() {
        log.debug((Object)"closeETK");
        System.exit(0);
    }

    protected void showMainView(MainController mci) {
        log.debug((Object)"MainViewController");
        ShowMainViewThread showMainViewThread = new ShowMainViewThread(mci);
        showMainViewThread.start();
        try {
            showMainViewThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class ShowMainViewThread
    extends Thread {
        private MainController mci;

        public ShowMainViewThread(MainController mci) {
            log.debug((Object)"ShowMainViewThread()instanciated");
            this.mci = mci;
        }

        @Override
        public void run() {
            log.debug((Object)"Die GUI wird angezeigt!");
            this.mci.getMainFrame().setVisible(true);
            this.mci.getMainFrame().validate();
            if (!GlobalObjects.getInstance().getIpacData().hasAnfrageAngebotWithVIN() || GlobalObjects.getInstance().getIpacData().getIspaAngebotsNr() != 0) {
                this.mci.getMainFrame().showStatusBar();
            }
            if (GlobalObjects.getInstance().getIpacData().getIspaErrorMessage() != null && GlobalObjects.getInstance().getIpacData().getIspaErrorMessage() != null) {
                JOptionPane.showMessageDialog((Component)this.mci.getMainFrame(), GlobalObjects.getInstance().getIpacData().getIspaErrorMessage(), Resource.getInstance().getInformation(), 1);
                this.mci.getMainFrame().setHidden(true);
            }
            while (!this.mci.getMainFrame().isHidden()) {
                try {
                    ShowMainViewThread.sleep(1011L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

