/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities;

import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ImageCache {
    protected Logger log = Logger.getLogger(ImageCache.class);
    protected HashMap<String, Image> images = new HashMap();
    protected HashMap<String, ImageIcon> icons = new HashMap();
    protected static ImageCache instance;
    private static final String PREFIX = "/img/";

    protected ImageCache() {
    }

    public static ImageCache getInstance() {
        if (instance == null) {
            instance = new ImageCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        try {
            HashMap<String, Image> hashMap = this.images;
            synchronized (hashMap) {
                Image o = this.images.get(name);
                if (o == null) {
                    URL url = ImageCache.class.getResource(PREFIX + name);
                    Image img = null;
                    try {
                        ImageIcon icon = new ImageIcon(url);
                        img = icon.getImage();
                        this.log.debug((Object)("Lade Bild " + name + " neu von URL " + url + " width=" + img.getWidth(null)));
                    }
                    catch (NullPointerException nex) {
                        this.log.error((Object)("Bild " + name + " konnte von URL " + url + " nicht geladen werden"));
                    }
                    this.images.put(name, img);
                    return img;
                }
                this.log.debug((Object)("Bild " + name + " bereits im Cache"));
                return o;
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Fehler bei getImage(" + name + ") :"), t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(String name) {
        try {
            HashMap<String, ImageIcon> hashMap = this.icons;
            synchronized (hashMap) {
                ImageIcon o = this.icons.get(name);
                if (o == null) {
                    URL url = ImageCache.class.getResource(PREFIX + name);
                    ImageIcon icon = new ImageIcon(url);
                    this.icons.put(name, icon);
                    this.log.debug((Object)("Lade Bild " + name + " neu von URL " + url));
                    return icon;
                }
                this.log.debug((Object)("Icon " + name + " bereits im Cache"));
                return o;
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Fehler bei getIcon(" + name + ") :"), t);
            return null;
        }
    }
}

