/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities.viewcomp;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class JLabelButton
extends JLabel {
    private Dimension dimension;
    private boolean isEnabled = false;

    public JLabelButton(String text, String name, boolean isEnabled, MarkenLayout mMarkenLayout) {
        super(text, 0);
        this.setEnabled(isEnabled, mMarkenLayout);
        super.setFont(Constants.Layout.getZubBoldFont());
        this.setOpaque(true);
        this.dimension = Constants.Layout.ZUB_BUTTON_DIMENSION;
        this.setPreferredSize(this.dimension);
        this.setMinimumSize(this.dimension);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setName(name);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void setEnabled(boolean isEnabled, MarkenLayout mMarkenLayout) {
        this.setEnabled(isEnabled);
        if (mMarkenLayout != null) {
            if (isEnabled) {
                this.setForeground(mMarkenLayout.getEnabledButtonForeground());
                this.setBackground(mMarkenLayout.getEnabledButtonBackground());
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setForeground(mMarkenLayout.getDisabledButtonForeground());
                this.setBackground(mMarkenLayout.getDisabledButtonBackground());
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setSmallboldFont() {
        super.setFont(Constants.Layout.getZubSmallBoldFont());
    }

    public void setDefaultFont() {
        super.setFont(Constants.Layout.getZubDefaultFont());
    }

    public void setLayout(MarkenLayout mMarkenLayout) {
        if (mMarkenLayout != null) {
            if (this.isEnabled()) {
                this.setForeground(mMarkenLayout.getEnabledButtonForeground());
                this.setBackground(mMarkenLayout.getEnabledButtonBackground());
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setForeground(mMarkenLayout.getDisabledButtonForeground());
                this.setBackground(mMarkenLayout.getDisabledButtonBackground());
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setFont(Font font) {
    }
}

