/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities.viewcomp;

import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class JOptionPane
extends javax.swing.JOptionPane
implements MouseListener {
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static final int BUTTON_DISTANCE = 10;
    private static final String BUT_OK = "butOK";
    private static final String BUT_YES = "butYes";
    private static final String BUT_NO = "butNo";
    private static final String BUT_CANCEL = "butCancel";
    private JFrame mOwner;
    private JDialog mDialog;
    private int mDialogResult;
    private MarkenLayout mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();

    public JOptionPane(MarkenLayout markenLayout, String title) {
        this.mMarkenLayout = markenLayout;
        this.mOwner = MainController.getInstance().getMainFrame();
        this.mDialogResult = -1;
        this.mDialog = new JDialog(MainController.getInstance().getMainFrame(), title, true);
    }

    public static int showMessageDialog(Component parentComponent, String message, String title, int messageType) {
        return JOptionPane.showConfirmDialog(parentComponent, message, title, -1, messageType);
    }

    public static int showMessageDialog(Component parentComponent, String message) {
        return JOptionPane.showMessageDialog(parentComponent, message, Resource.getInstance().getInformation(), 1);
    }

    public static int showConfirmDialog(Component parentComponent, String message, String title, int optionType, int messageType) {
        return JOptionPane.showDialog(parentComponent, message, title, optionType, messageType);
    }

    public static int showConfirmDialog(Component parentComponent, String message, String title, int optionType, int messageType, int x, int y) {
        return JOptionPane.showDialog(parentComponent, message, title, optionType, messageType, x, y);
    }

    private static int showDialog(Component parentComponent, String message, String title, int optionType, int messageType) {
        JOptionPane pane = new JOptionPane(WorkflowController.getInstance().getMarkenLayout(), title);
        pane.getDialog().getContentPane().add(pane.getDialogPanel(message, optionType, messageType));
        pane.getDialog().pack();
        pane.setDialogLocation();
        pane.getDialog().setVisible(true);
        return pane.getDialogResult();
    }

    private static int showDialog(Component parentComponent, String message, String title, int optionType, int messageType, int x, int y) {
        JOptionPane pane = new JOptionPane(WorkflowController.getInstance().getMarkenLayout(), title);
        pane.getDialog().getContentPane().add(pane.getDialogPanel(message, optionType, messageType));
        pane.getDialog().pack();
        pane.setDialogLocation(x, y);
        pane.getDialog().setVisible(true);
        return pane.getDialogResult();
    }

    private JPanel getDialogPanel(String message, int optionType, int messageType) {
        JPanel pan = new JPanel();
        pan.setBackground(this.mMarkenLayout.getPrimaryBackground());
        pan.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 18, new Insets(10, 10, 10, 0));
        JComponent ico = this.getIconPanel(messageType);
        if (ico != null) {
            pan.add((Component)ico, gbc);
        }
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 18, new Insets(10, 10, 10, 10));
        pan.add((Component)this.getTextPanel(message), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 2, 15, new Insets(0, 10, 10, 10));
        pan.add((Component)this.getButtonPanel(optionType), gbc);
        return pan;
    }

    private JComponent getTextPanel(String message) {
        if (!message.trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        JLabel lab = new JLabel(message);
        lab.setBoldFont();
        lab.setForeground(this.mMarkenLayout.getPrimaryForeground());
        Dimension d = lab.getPreferredSize();
        int w = d.width;
        int h = d.height;
        int pw = 450;
        if (message.contains("DMS")) {
            pw = 620;
        }
        int mult = w / pw + 1;
        int ph = mult * (h + 3);
        lab.setPreferredSize(new Dimension(pw, ph));
        return lab;
    }

    private JComponent getIconPanel(int messageType) {
        return null;
    }

    private JPanel getButtonPanel(int optionType) {
        JPanel pan = new JPanel();
        pan.setLayout(new GridBagLayout());
        pan.setOpaque(false);
        switch (optionType) {
            case 0: {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 0, 0, 0));
                pan.add((Component)this.getYesButton(), gbc);
                gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 10, 0, 0));
                pan.add((Component)this.getNoButton(), gbc);
                break;
            }
            case 1: {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 0, 0, 0));
                pan.add((Component)this.getYesButton(), gbc);
                gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 10, 0, 0));
                pan.add((Component)this.getNoButton(), gbc);
                gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 10, 0, 0));
                pan.add((Component)this.getCancelButton(), gbc);
                break;
            }
            case 2: {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 0, 0, 0));
                pan.add((Component)this.getOkButton(), gbc);
                gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 10, 0, 0));
                pan.add((Component)this.getCancelButton(), gbc);
                break;
            }
            default: {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(0, 0, 0, 0));
                pan.add((Component)this.getOkButton(), gbc);
            }
        }
        return pan;
    }

    private JLabelButton getOkButton() {
        JLabelButton but = new JLabelButton(Resource.getInstance().getOk(), BUT_OK, true, this.mMarkenLayout);
        but.setLayout(this.mMarkenLayout);
        but.addMouseListener(this);
        return but;
    }

    private JLabelButton getYesButton() {
        JLabelButton but = new JLabelButton(Resource.getInstance().getJa(), BUT_YES, true, this.mMarkenLayout);
        but.setLayout(this.mMarkenLayout);
        but.addMouseListener(this);
        return but;
    }

    private JLabelButton getNoButton() {
        JLabelButton but = new JLabelButton(Resource.getInstance().getNein(), BUT_NO, true, this.mMarkenLayout);
        but.setLayout(this.mMarkenLayout);
        but.addMouseListener(this);
        return but;
    }

    private JLabelButton getCancelButton() {
        JLabelButton but = new JLabelButton(Resource.getInstance().getAbbrechen(), BUT_CANCEL, true, this.mMarkenLayout);
        but.setLayout(this.mMarkenLayout);
        but.addMouseListener(this);
        return but;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof JLabelButton) {
            JLabelButton button = (JLabelButton)e.getSource();
            if (BUT_OK.equals(button.getName())) {
                this.mDialogResult = 0;
                this.mDialog.dispose();
            } else if (BUT_YES.equals(button.getName())) {
                this.mDialogResult = 0;
                this.mDialog.dispose();
            } else if (BUT_NO.equals(button.getName())) {
                this.mDialogResult = 1;
                this.mDialog.dispose();
            } else if (BUT_CANCEL.equals(button.getName())) {
                this.mDialogResult = 2;
                this.mDialog.dispose();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void setDialogLocation() {
        int xOwner = this.mOwner.getX();
        int yOwner = this.mOwner.getY();
        int wOwner = this.mOwner.getWidth();
        int hOwner = this.mOwner.getHeight();
        this.mDialog.setLocation(xOwner + wOwner / 2 - this.mDialog.getWidth() / 2, yOwner + hOwner / 2 - this.mDialog.getHeight() / 2);
    }

    private void setDialogLocation(int x, int y) {
        int xOwner = this.mOwner.getX();
        int yOwner = this.mOwner.getY();
        int wOwner = this.mOwner.getWidth();
        int hOwner = this.mOwner.getHeight();
        this.mDialog.setLocation(xOwner + wOwner / 2 - this.mDialog.getWidth() / 2 + x, yOwner + hOwner / 2 - this.mDialog.getHeight() / 2 + y);
    }

    private JDialog getDialog() {
        return this.mDialog;
    }

    private int getDialogResult() {
        return this.mDialogResult;
    }
}

