/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.welcome;

import de.esg.zub.common.MainController;
import de.esg.zub.common.MainFrame;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.AbstractWelcomeContent;
import de.esg.zub.welcome.MarkenTabelPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class MarkenPanel
extends AbstractWelcomeContent {
    private static Logger log = Logger.getLogger(MainFrame.class);
    private MarkenLayout mMarkenLayout;
    private MarkenTabelPanel markenTblPnl;

    public MarkenPanel(Dimension panelSize, MarkenLayout markenLayout) {
        super(panelSize, markenLayout);
        this.mContentPanel.setName("Marken Panel");
        this.mMarkenLayout = markenLayout;
        if (markenLayout.getPossibleMarks() == null) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getKeineMarkenberechtigung(), Resource.getInstance().getAnmeldung(), 0);
            log.error((Object)"Der Nutzer hat keine Markenberechtigung.");
            MainController.getInstance().exit(-1);
            return;
        }
        this.createMarkenPanel();
    }

    private JPanel createMarkenPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{33, 0, 33, 0};
        gridBagLayout.rowHeights = new int[]{50, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.mContentPanel.setLayout(gridBagLayout);
        JLabel anw1 = new JLabel(Resource.getInstance().getWaehlenSie() + " ...");
        anw1.setHeaderFont();
        anw1.setForeground(Color.WHITE);
        GridBagConstraints gbc_anw1 = new GridBagConstraints();
        gbc_anw1.anchor = 17;
        gbc_anw1.insets = new Insets(0, 0, 5, 5);
        gbc_anw1.fill = 10;
        gbc_anw1.gridx = 1;
        gbc_anw1.gridy = 0;
        this.mContentPanel.add((Component)anw1, gbc_anw1);
        this.markenTblPnl = new MarkenTabelPanel(this.mMarkenLayout);
        GridBagConstraints gbc_markenTblPnl = new GridBagConstraints();
        gbc_markenTblPnl.anchor = 10;
        gbc_markenTblPnl.insets = new Insets(0, 0, 0, 5);
        gbc_markenTblPnl.fill = 1;
        gbc_markenTblPnl.gridx = 1;
        gbc_markenTblPnl.gridy = 1;
        this.mContentPanel.add((Component)this.markenTblPnl, gbc_markenTblPnl);
        this.mContentPanel.validate();
        this.mContentPanel.setVisible(true);
        this.mContentPanel.setOpaque(false);
        this.mContentPanel.setForeground(this.mMarkenLayout.getSecondaryForeground());
        this.mContentPanel.setBackground(this.mMarkenLayout.getSecondaryBackground());
        return this.mContentPanel;
    }

    public ArrayList<JLabel> getMarkenImages() {
        return this.markenTblPnl.getMarkenImages();
    }

    public ArrayList<JLabel> getMarkenBeschriftungen() {
        return this.markenTblPnl.getMarkenText();
    }
}

