/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.welcome;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class MarkenTabelPanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JPanel panel;
    private ArrayList<JLabel> markenImages;
    private JLabel jlImg;
    private ArrayList<JLabel> markenText;
    private JLabel jlTxt;
    private ArrayList<String> mrkPrd = new ArrayList();

    public MarkenTabelPanel(MarkenLayout markenLayout) {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.setBackground(markenLayout.getSecondaryBackground());
        this.setForeground(markenLayout.getSecondaryForeground());
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setBackground(markenLayout.getSecondaryBackground());
        this.panel.setForeground(markenLayout.getSecondaryForeground());
        this.setViewportView(this.panel);
        this.getViewport().setBackground(markenLayout.getSecondaryBackground());
        this.getViewport().setForeground(markenLayout.getSecondaryForeground());
        this.markenImages = new ArrayList();
        this.markenText = new ArrayList();
        ArrayList<String> userMarkenList = markenLayout.getPossibleMarks();
        ArrayList<String> userProdukteList = markenLayout.getPossibleProdukte();
        boolean isUs = GlobalObjects.getInstance().getIpacData().isUs();
        ArrayList<MarkeProdukt> ldarfMarkenProdukte = MarkenProdukte.getInstance(2).getBerechtigteMarkenProdukte(userMarkenList, userProdukteList, isUs);
        int iRow = 0;
        for (MarkeProdukt oMarkeProdukt : ldarfMarkenProdukte) {
            ++iRow;
            String sName = oMarkeProdukt.getMarke() + ";" + oMarkeProdukt.getProdukt();
            this.jlImg = new JLabel(ImageCache.getInstance().getIcon(oMarkeProdukt.getImageMarken()));
            this.jlImg.setPreferredSize(new Dimension(125, 125));
            this.jlImg.setName(sName);
            this.jlImg.setCursor(Constants.CursorTypen.HAND_CURSOR);
            boolean bImgVorhanden = false;
            for (String sMrkPrd : this.mrkPrd) {
                if (!sMrkPrd.equalsIgnoreCase(sName)) continue;
                bImgVorhanden = true;
                break;
            }
            if (bImgVorhanden) continue;
            this.mrkPrd.add(sName);
            this.markenImages.add(this.jlImg);
            StringBuffer sbName = new StringBuffer(Resource.getInstance().getNameMarke(oMarkeProdukt.getMarke()));
            if (oMarkeProdukt.getProdukt().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sbName.append(" ");
                sbName.append(Resource.getInstance().getNameProdukt(oMarkeProdukt.getProdukt()));
            }
            this.jlTxt = iRow % 2 > 0 ? new JLabel(sbName + " . . . . . . . . ") : new JLabel(" . . . . . . . . " + sbName);
            this.jlTxt.setName(sName);
            this.jlTxt.setCursor(Constants.CursorTypen.HAND_CURSOR);
            this.jlTxt.setForeground(markenLayout.getPrimaryForeground());
            this.jlTxt.setBigBoldFont();
            this.markenText.add(this.jlTxt);
        }
        int rows = this.markenImages.size();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0};
        int[] iRowHeights = new int[rows];
        double[] dRowWeights = new double[rows];
        for (iRow = 0; iRow < rows; ++iRow) {
            iRowHeights[iRow] = 0;
            dRowWeights[iRow] = 1.0;
        }
        gridBagLayout.rowHeights = iRowHeights;
        gridBagLayout.rowWeights = dRowWeights;
        this.panel.setLayout(gridBagLayout);
        Insets oInsets = new Insets(0, 0, 5, 5);
        for (iRow = 0; iRow < rows; ++iRow) {
            GridBagConstraints gbc_oJLabel;
            if ((iRow + 1) % 2 > 0) {
                gbc_oJLabel = new GridBagConstraints();
                gbc_oJLabel.anchor = 13;
                gbc_oJLabel.insets = oInsets;
                gbc_oJLabel.gridy = iRow;
                gbc_oJLabel.gridx = 0;
                this.panel.add((Component)this.markenImages.get(iRow), gbc_oJLabel);
                gbc_oJLabel.anchor = 17;
                gbc_oJLabel = new GridBagConstraints();
                gbc_oJLabel.insets = oInsets;
                gbc_oJLabel.gridy = iRow;
                gbc_oJLabel.gridx = 1;
                this.panel.add((Component)this.markenText.get(iRow), gbc_oJLabel);
                continue;
            }
            gbc_oJLabel = new GridBagConstraints();
            gbc_oJLabel.anchor = 13;
            gbc_oJLabel.insets = oInsets;
            gbc_oJLabel.gridy = iRow;
            gbc_oJLabel.gridx = 2;
            this.panel.add((Component)this.markenText.get(iRow), gbc_oJLabel);
            gbc_oJLabel.anchor = 17;
            gbc_oJLabel = new GridBagConstraints();
            gbc_oJLabel.insets = oInsets;
            gbc_oJLabel.gridy = iRow;
            gbc_oJLabel.gridx = 3;
            this.panel.add((Component)this.markenImages.get(iRow), gbc_oJLabel);
        }
    }

    public ArrayList<JLabel> getMarkenImages() {
        return this.markenImages;
    }

    public ArrayList<JLabel> getMarkenText() {
        return this.markenText;
    }
}

