/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.ServerConstants;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.AllgemeinDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BmwNetz
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(BmwNetz.class);
    private String msNetz;
    private String msKrit;
    private String msAsapURL;
    private String msAsapTunnel;
    private String msCentralServerUrl;
    private String msProxyName;
    private int mnProxyPort;
    private String msProxyUserName;
    private String msProxyPasswort;
    private String msProxyRealm;
    private String msProxyNtHost;
    private String msProxyNtDomain;
    private String msIGDOMBasicsServerUrl;
    private String msIGDOMOptionsServerUrl;

    public String getAsapURL() {
        return this.msAsapURL;
    }

    public String getAsapTunnel() {
        return this.msAsapTunnel;
    }

    public String getCentralServerUrl() {
        return this.msCentralServerUrl;
    }

    public void setCentralServerUrl(String centralServerUrl) {
        this.msCentralServerUrl = centralServerUrl;
    }

    public String getProxyName() {
        return this.msProxyName;
    }

    public int getProxyPort() {
        return this.mnProxyPort;
    }

    public String getProxyUserName() {
        return this.msProxyUserName;
    }

    public String getProxyPasswort() {
        return this.msProxyPasswort;
    }

    public String getProxyRealm() {
        return this.msProxyRealm;
    }

    public String getProxyNtHost() {
        return this.msProxyNtHost;
    }

    public String getProxyNtDomain() {
        return this.msProxyNtDomain;
    }

    public String getIGDOMBasicsServerUrl() {
        return this.msIGDOMBasicsServerUrl;
    }

    public void setIGDOMBasicsServerUrl(String newUrl) {
        this.msIGDOMBasicsServerUrl = newUrl;
    }

    public String getIGDOMOptionsServerUrl() {
        return this.msIGDOMOptionsServerUrl;
    }

    public void setIGDOMOptionsServerUrl(String newUrl) {
        this.msIGDOMOptionsServerUrl = newUrl;
    }

    public String getNetz() {
        return this.msNetz;
    }

    public void load() throws SQLException, DatabaseBusyException {
        this.load(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String sIbaseConnectionType) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block13: {
            block12: {
                block10: {
                    gObj = ServerGlobalObjects.getInstance();
                    log.info((Object)"Loading");
                    con = null;
                    res = null;
                    this.msNetz = null;
                    this.msKrit = null;
                    if (sIbaseConnectionType != null && sIbaseConnectionType.length() != 0) break block12;
                    try {
                        con = gObj.getDBConnectionNutzer("BmwNetz.load");
                        res = AllgemeinDbAccess.loadBmwNetzNutzer(con);
                        if (res != null && res.next()) {
                            this.msNetz = res.getString("Netz");
                            this.msKrit = res.getString("Krit");
                        }
                        WebetkUtils.closeQuery(res);
                        res = AllgemeinDbAccess.loadBmwProxy(con);
                        if (res == null || !res.next()) break block10;
                        this.msProxyName = res.getString("ProxyName");
                        this.mnProxyPort = res.getInt("Port");
                        this.msProxyUserName = res.getString("UserName");
                        this.msProxyPasswort = res.getString("Passwort");
                        this.msProxyRealm = res.getString("Realm");
                        this.msProxyNtHost = res.getString("NtHost");
                        this.msProxyNtDomain = res.getString("NtDomain");
                    }
                    catch (Throwable throwable) {
                        WebetkUtils.closeQuery(res);
                        gObj.freeDBConnectionNutzer(con, "BmwNetz.load");
                        throw throwable;
                    }
                }
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnectionNutzer(con, "BmwNetz.load");
                break block13;
            }
            ServerConstants.IbaseConnectionType.ConType conType = ServerConstants.IbaseConnectionType.CONTYPES.get(sIbaseConnectionType);
            if (conType != null) {
                this.msNetz = conType.netz;
                this.msKrit = conType.krit;
                log.debug((Object)("mapped IbaseConnectionType: " + sIbaseConnectionType + " to netz: " + this.msNetz + " and krit:" + this.msKrit));
            } else {
                String msg = "no mapping for IbaseConnectionType: " + sIbaseConnectionType;
                log.fatal((Object)msg, (Throwable)new Exception(msg));
            }
        }
        if (this.msNetz != null) {
            try {
                con = gObj.getDBConnection("BmwNetz.load");
                res = AllgemeinDbAccess.loadBmwNetzPubl(con, this.msNetz, this.msKrit);
                if (res != null && res.next()) {
                    this.msAsapURL = res.getString("AsapUrl");
                    this.msAsapTunnel = res.getString("AsapTunnel");
                    this.msCentralServerUrl = res.getString("CentralURL");
                    this.msIGDOMBasicsServerUrl = res.getString("IGDOMBasicsUrl");
                    this.msIGDOMOptionsServerUrl = res.getString("IGDOMOptionsUrl");
                }
            }
            finally {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "BmwNetz.load");
            }
        }
    }

    public String toString() {
        return "mnProxyPort: " + this.mnProxyPort + " msAsapTunnel: " + this.msAsapTunnel + " msAsapURL: " + this.msAsapURL + " msCentralServerUrl: " + this.msCentralServerUrl + " msIGDOMBasicsServerUrl: " + this.msIGDOMBasicsServerUrl + " msIGDOMOptionsServerUrl: " + this.msIGDOMOptionsServerUrl + " msKrit: " + this.msKrit + " msNetz: " + this.msNetz + " msProxyName: " + this.msProxyName + " msProxyNtDomain: " + this.msProxyNtDomain + " msProxyNtHost: " + this.msProxyNtHost + " msProxyPasswort: " + this.msProxyNtHost + " msProxyRealm: " + this.msProxyRealm + " msProxyUserName: " + this.msProxyUserName;
    }
}

