/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.bteanzeige.Bedingung;
import webetk.app.bteanzeige.Element;

@XmlRootElement(name="webetk.app.bteanzeige.Obergruppe")
@XmlType(name="webetk.app.bteanzeige.Obergruppe")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Obergruppe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Obergruppe.class);
    @XmlElement
    private String msId = null;
    @XmlElement
    private String msVArt = null;
    @XmlElement
    private String msFZeile = null;
    @XmlElement
    private String msAusweisung = null;
    @XmlElements(value={@XmlElement(type=Element.class)})
    private ArrayList<Element> mcElemente;

    Obergruppe() {
    }

    public Obergruppe(String sId, String sVArt, String sFZeile) {
        this.msId = sId;
        this.msVArt = sVArt;
        this.msFZeile = sFZeile;
        if (this.msVArt.equals("E") || this.msVArt.equals("B")) {
            this.msAusweisung = "";
            for (int i = 0; i < this.msFZeile.length(); ++i) {
                this.msAusweisung = this.msFZeile.charAt(i) == 'X' ? this.msAusweisung + " " : this.msAusweisung + "-";
            }
        } else {
            this.msAusweisung = " ";
        }
    }

    public String getOGId() {
        return this.msId == null ? "" : this.msId;
    }

    public String getVArt() {
        return this.msVArt == null ? "" : this.msVArt;
    }

    public String getFZeile() {
        return this.msFZeile == null ? "" : this.msFZeile;
    }

    public ArrayList<Element> getElemente() {
        return this.mcElemente;
    }

    public String getAusweisung() {
        return this.msAusweisung == null ? "" : this.msAusweisung;
    }

    public char getAusweisungChar() {
        return this.msAusweisung.charAt(0);
    }

    public char getAusweisungChar(int nIndex) {
        if (this.msAusweisung == null) {
            return ' ';
        }
        if (this.msAusweisung.length() == 1) {
            return this.msAusweisung.charAt(0);
        }
        return this.msAusweisung.charAt(nIndex);
    }

    public void setAusweisung(char cAusw) {
        this.msAusweisung = new Character(cAusw).toString();
    }

    public void setAusweisung(char cAusw, int nIndex) {
        this.msAusweisung = this.msAusweisung.substring(0, nIndex) + new Character(cAusw).toString() + this.msAusweisung.substring(nIndex + 1);
    }

    public void appendElement(Element Elem) {
        if (this.mcElemente == null) {
            this.mcElemente = new ArrayList();
        }
        this.mcElemente.add(Elem);
    }

    public boolean auswerten() {
        boolean bAlleWerteBekannt = false;
        if (this.msVArt.equals("O") || this.msVArt.equals("U") || this.msVArt.equals("A") || this.msVArt.equals("R")) {
            bAlleWerteBekannt = this.auswertenIndex(0);
        } else if (this.msVArt.equals("E") || this.msVArt.equals("B")) {
            String sAusweisung = this.getAusweisung();
            int nLength = sAusweisung.length();
            for (int i = 1; i <= nLength; ++i) {
                boolean bWertBekannt;
                if (sAusweisung.charAt(i - 1) == '-' || !(bWertBekannt = this.auswertenIndex(i - 1))) continue;
                bAlleWerteBekannt = true;
            }
        } else if (this.msVArt.equals("T")) {
            if (this.msFZeile == null) {
                return false;
            }
            boolean cAusw = false;
            try {
                Expression expression = WebetkUtils.getJexlEngine().createExpression(this.msFZeile);
                MapContext jexlContext = new MapContext();
                int nSize = this.mcElemente.size();
                for (int i = 0; i < nSize; ++i) {
                    Element elem = this.mcElemente.get(i);
                    String sAusweisung = elem.getAusweisung();
                    Boolean bAusweisung = WebetkUtils.getBoolFromAusweisung(sAusweisung);
                    jexlContext.set(elem.getCode(), (Object)bAusweisung);
                }
                cAusw = (Boolean)expression.evaluate((JexlContext)jexlContext);
            }
            catch (Exception ex) {
                log.error((Object)"Fehler waehrend Bedingungsauswertung bei boolschen Ausdruecken", (Throwable)ex);
                return false;
            }
            this.setAusweisung(cAusw ? (char)'T' : 'F');
            bAlleWerteBekannt = true;
        }
        return bAlleWerteBekannt;
    }

    private boolean auswertenIndex(int nIndex) {
        boolean bAlleWerteBekannt = true;
        char cAusw = ' ';
        int nSize = this.mcElemente.size();
        for (int i = 0; i < nSize; ++i) {
            Element Elem = this.mcElemente.get(i);
            char cAuswAkt = Elem.getAusweisungChar(nIndex);
            if (this.msVArt.equals("O") || this.msVArt.equals("R")) {
                cAusw = Bedingung.ODER(cAuswAkt, cAusw);
            }
            if (this.msVArt.equals("U") || this.msVArt.equals("A") || this.msVArt.equals("E") || this.msVArt.equals("B")) {
                cAusw = Bedingung.UND(cAuswAkt, cAusw);
            }
            if (cAusw == '?') {
                bAlleWerteBekannt = false;
            }
            if ((this.msVArt.equals("O") || this.msVArt.equals("R")) && (cAusw == '?' || cAusw == 'T') || (this.msVArt.equals("U") || this.msVArt.equals("E") || this.msVArt.equals("B") || this.msVArt.equals("A")) && cAusw == 'F') {
                this.setAusweisung(cAusw, nIndex);
                break;
            }
            this.setAusweisung(cAusw, nIndex);
        }
        return bAlleWerteBekannt;
    }

    public void convertFZeile() {
        int i;
        if (this.msFZeile == null) {
            return;
        }
        String sHelp = "";
        for (i = 0; i < this.msFZeile.length(); ++i) {
            if (this.msFZeile.charAt(i) == 'X') {
                sHelp = sHelp + '0';
            }
            if (this.msFZeile.charAt(i) != '0') continue;
            sHelp = sHelp + 'X';
        }
        this.msFZeile = sHelp;
        this.msAusweisung = "";
        for (i = 0; i < this.msFZeile.length(); ++i) {
            this.msAusweisung = this.msFZeile.charAt(i) == 'X' ? this.msAusweisung + " " : this.msAusweisung + "-";
        }
    }

    public String toString() {
        String sString = "";
        sString = sString + "\n*OgId: " + this.msId + " VArt: " + this.msVArt + " FZeile: " + this.msFZeile;
        sString = sString + "\n*Ausweisung: " + this.msAusweisung;
        if (this.mcElemente == null) {
            sString = sString + "\n**Achtung: Obergruppe hat keine Elemente!";
            return sString;
        }
        Iterator<Element> iterator = this.mcElemente.iterator();
        while (iterator.hasNext()) {
            sString = sString + iterator.next().toString();
        }
        return sString;
    }

    public String getMsId() {
        return this.msId;
    }

    public void setMsId(String msId) {
        this.msId = msId;
    }

    public String getMsVArt() {
        return this.msVArt;
    }

    public void setMsVArt(String msVArt) {
        this.msVArt = msVArt;
    }

    public String getMsFZeile() {
        return this.msFZeile;
    }

    public void setMsFZeile(String msFZeile) {
        this.msFZeile = msFZeile;
    }

    public String getMsAusweisung() {
        return this.msAusweisung;
    }

    public void setMsAusweisung(String msAusweisung) {
        this.msAusweisung = msAusweisung;
    }

    public ArrayList<Element> getMcElemente() {
        return this.mcElemente;
    }

    public void setMcElemente(ArrayList<Element> mcElemente) {
        this.mcElemente = mcElemente;
    }
}

