/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.KonfigurationDbAccess;
import webetk.mrkprd.MarkenProdukteBerechtigungen;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.konfiguration.Berechtigungen")
public class Berechtigungen
extends MarkenProdukteBerechtigungen {
    @XmlTransient
    private static Logger log = Logger.getLogger(Berechtigungen.class);
    private Boolean msKatalogumfangVT;
    private Boolean msKatalogumfangST;
    private Boolean msProdDatum;
    private String msFirmaId = null;
    private String msUserId = null;

    Berechtigungen() {
    }

    public Berechtigungen(String sFirmaId) {
        this.msFirmaId = sFirmaId;
        this.msKatalogumfangVT = Boolean.FALSE;
        this.msKatalogumfangST = Boolean.FALSE;
    }

    public Berechtigungen(String sFirmaId, String sUserId) {
        this.msFirmaId = sFirmaId;
        this.msUserId = sUserId;
        this.msKatalogumfangVT = Boolean.FALSE;
        this.msKatalogumfangST = Boolean.FALSE;
        this.msProdDatum = Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBerechtigungen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Berechtigungen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Berechtigungen.load");
            res = KonfigurationDbAccess.loadBerechtigungen(con, this.msFirmaId);
            if (res != null) {
                while (res.next()) {
                    String sArt = res.getString("Art");
                    String sWert = res.getString("Wert");
                    this.setzenBerechtigungenMarkenProdukte(sArt, sWert);
                    this.setzenBerechtigungen(sArt, sWert);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Berechtigungen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Berechtigungen.load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNutzerBerechtigungen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading NutzerBerechtigungen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Berechtigungen.load");
            res = KonfigurationDbAccess.loadNutzerBerechtigungen(con, this.msFirmaId, this.msUserId);
            if (res != null) {
                while (res.next()) {
                    String sArt = res.getString("Art");
                    String sWert = res.getString("Wert");
                    this.setzenBerechtigungenMarkenProdukte(sArt, sWert);
                    this.setzenBerechtigungen(sArt, sWert);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Berechtigungen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Berechtigungen.load");
    }

    private void setzenBerechtigungen(String sArt, String sWert) {
        if (sArt.equalsIgnoreCase("Katalogumfang") && sWert.equalsIgnoreCase("VT")) {
            this.msKatalogumfangVT = Boolean.TRUE;
        } else if (sArt.equalsIgnoreCase("Katalogumfang") && sWert.equalsIgnoreCase("ST")) {
            this.msKatalogumfangST = Boolean.TRUE;
        } else if (sArt.equalsIgnoreCase("ProdDatum") && sWert.equalsIgnoreCase("J")) {
            this.msProdDatum = Boolean.TRUE;
        }
    }

    public void store(Connection con) throws SQLException, DatabaseBusyException {
        log.info((Object)"Store NutzerBerechtigungen");
        Vector<String[]> cBerechtigungen = new Vector<String[]>();
        this.uebernehmenBerechtigungenMarkenProdukte(cBerechtigungen);
        if (this.msKatalogumfangVT.equals(Boolean.TRUE)) {
            cBerechtigungen.add(new String[]{"Katalogumfang", "VT"});
        }
        if (this.msKatalogumfangST.equals(Boolean.TRUE)) {
            cBerechtigungen.add(new String[]{"Katalogumfang", "ST"});
        }
        if (this.msProdDatum.equals(Boolean.TRUE)) {
            cBerechtigungen.add(new String[]{"ProdDatum", "J"});
        }
        KonfigurationDbAccess.storeNutzerBerechtigungen(con, this.msFirmaId, this.msUserId, cBerechtigungen);
    }

    public Boolean isKatalogumfangST() {
        return this.msKatalogumfangST;
    }

    public Boolean isKatalogumfangVT() {
        return this.msKatalogumfangVT;
    }

    public Boolean isProdDatum() {
        return this.msProdDatum;
    }

    public void setKatalogumfangST(Boolean boolean1) {
        this.msKatalogumfangST = boolean1;
    }

    public void setKatalogumfangVT(Boolean boolean1) {
        this.msKatalogumfangVT = boolean1;
    }

    public void setProdDatum(Boolean boolean1) {
        this.msProdDatum = boolean1;
    }
}

