/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.polstercode.neu;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.polstercode.neu.PolsterCodeAusstattungFarbeZeile;
import webetk.app.polstercode.neu.PolsterCodeAusstattungZeile;
import webetk.db.dbaccess.PolstercodeDbAccess;

public class PCZeilen {
    private static Logger log = Logger.getLogger(PCZeilen.class);
    private String mSprache;

    public PCZeilen(String sLang) throws SQLException, DatabaseBusyException {
        this.mSprache = sLang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PolsterCodeAusstattungZeile> load() throws SQLException, DatabaseBusyException {
        ArrayList<PolsterCodeAusstattungZeile> arrayList;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        TreeMap<String, PolsterCodeAusstattungZeile> retval = new TreeMap<String, PolsterCodeAusstattungZeile>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("PCZeilen.load");
            log.debug((Object)"Loading Polstercode...");
            res = PolstercodeDbAccess.loadPolstercode(con, this.mSprache);
            while (res != null && res.next()) {
                String sArt = res.getString("Art");
                String sCode = res.getString("Code");
                String sBenennung = res.getString("Benennung");
                String sPCode = res.getString("PCode");
                long lGueltigVon = res.getLong("GueltigVon");
                long lGueltigBis = res.getLong("GueltigBis");
                if (sArt.equalsIgnoreCase("A")) {
                    PolsterCodeAusstattungZeile polsterCodeAusstattungZeile = (PolsterCodeAusstattungZeile)retval.get(sCode);
                    if (polsterCodeAusstattungZeile == null) {
                        polsterCodeAusstattungZeile = new PolsterCodeAusstattungZeile(sCode, sBenennung, lGueltigVon, lGueltigBis);
                        retval.put(sCode, polsterCodeAusstattungZeile);
                        continue;
                    }
                    polsterCodeAusstattungZeile.setBenennung(sBenennung);
                    polsterCodeAusstattungZeile.setGueltigVon(lGueltigVon);
                    polsterCodeAusstattungZeile.setGueltigBis(lGueltigBis);
                    continue;
                }
                String ausstattungsCode = sCode.substring(0, 2);
                PolsterCodeAusstattungZeile polsterCodeAusstattungZeile = (PolsterCodeAusstattungZeile)retval.get(ausstattungsCode);
                if (polsterCodeAusstattungZeile == null) {
                    polsterCodeAusstattungZeile = new PolsterCodeAusstattungZeile(ausstattungsCode, "dummy", 0L, 0L);
                    retval.put(ausstattungsCode, polsterCodeAusstattungZeile);
                }
                polsterCodeAusstattungZeile.addPolsterCodeAusstattungFarbeZeile(new PolsterCodeAusstattungFarbeZeile(sCode, sBenennung, sPCode, lGueltigVon, lGueltigBis));
            }
            arrayList = new ArrayList<PolsterCodeAusstattungZeile>(retval.values());
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareUgb");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareUgb");
        return arrayList;
    }
}

