/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.satzeinzelteile;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.satzeinzelteile.SEZeile;
import webetk.db.dbaccess.SatzEinzelteileDbAccess;
import webetk.db.dbaccess.TeileListeDbAccess;

public class SEZeilen
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(SEZeilen.class);
    private String msMarke = null;
    private String msProduktart = null;
    private String msTeilenummerSatz = null;
    private String msTeilebenennungSatz = null;
    private int mnTitelCounter = 0;
    private int mnIndex = 0;
    private Collection<SEZeile> mcZeilen = new Vector<SEZeile>();
    private transient Iterator miZeilen = null;
    private SEZeile moZeile;

    public SEZeilen(String sMarke, String sProduktart, String sUserKatalogumfang, String sLang, String sParameter, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        this.mcZeilen.clear();
        this.miZeilen = null;
        this.moZeile = null;
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        if (sParameter == null || sParameter.length() == 2) {
            this.performLoad(sMarke, sProduktart, sUserKatalogumfang, sLang, sParameter, sLandkuerzel);
        } else {
            this.performSearch(sMarke, sProduktart, sUserKatalogumfang, sLang, sParameter, sLandkuerzel);
        }
    }

    public SEZeilen() {
    }

    public void first() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            if (this.miZeilen.hasNext()) {
                try {
                    this.moZeile = (SEZeile)this.miZeilen.next();
                }
                catch (ClassCastException e) {
                    log.error((Object)"Store object in row collection is no SEZeile!", (Throwable)e);
                    this.moZeile = null;
                }
            } else {
                this.moZeile = null;
            }
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
        this.mnTitelCounter = 0;
        this.mnIndex = 0;
    }

    public void next() {
        if (this.miZeilen != null && this.miZeilen.hasNext()) {
            try {
                this.moZeile = (SEZeile)this.miZeilen.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Store object in row collection is no SEZeile!", (Throwable)e);
                this.moZeile = null;
                return;
            }
            ++this.mnIndex;
            if (++this.mnTitelCounter == 16) {
                this.mnTitelCounter = 1;
            }
        } else {
            log.log((Priority)Level.ALL, (Object)"No more Zeilen.");
        }
    }

    public boolean hasNext() {
        return this.miZeilen != null && this.miZeilen.hasNext();
    }

    public boolean isEmpty() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0;
    }

    public boolean isValidPosition() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0 || this.miZeilen == null || this.moZeile == null;
    }

    public boolean isTitel() {
        return this.mnTitelCounter == 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLoad(String sMarke, String sProduktart, String sUserKatalogumfang, String sLang, String sHGExp, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Vector<SEZeile> cHGs = new Vector<SEZeile>();
        Connection con = null;
        ResultSet resHG = null;
        ResultSet resSatz = null;
        try {
            con = gObj.getDBConnection("SEZeilen.performLoad");
            log.debug((Object)"Loading HG-Zeilen...");
            resHG = SatzEinzelteileDbAccess.loadHGs(con, sLang, sMarke, sProduktart);
            while (resHG != null && resHG.next()) {
                String sHG = resHG.getString("HG");
                String sBenennung = resHG.getString("Benennung");
                boolean bExpanded = sHGExp != null && sHGExp.equals(sHG);
                SEZeile oZeileHG = new SEZeile(sHG, sBenennung, bExpanded);
                cHGs.add(oZeileHG);
            }
            for (SEZeile oZeileHG : cHGs) {
                this.mcZeilen.add(oZeileHG);
                String sHG = oZeileHG.getHG();
                if (sHGExp == null || !sHGExp.equals(sHG)) continue;
                log.debug((Object)"Loading Satz-Zeilen...");
                resSatz = SatzEinzelteileDbAccess.loadSaetze(con, sLang, sMarke, sProduktart, sUserKatalogumfang, sHG, sLandkuerzel);
                while (resSatz != null && resSatz.next()) {
                    String sHGSatz = resSatz.getString("HG");
                    String sUGSatz = resSatz.getString("UG");
                    String sSachnummerSatz = resSatz.getString("Sachnummer");
                    String sTeilenummerSatz = sHGSatz + sUGSatz + sSachnummerSatz;
                    String sBenennungSatz = resSatz.getString("Benennung");
                    String sZusatzSatz = resSatz.getString("Zusatz");
                    String sVorhandenSISatz = resSatz.getString("vorhandenSI");
                    String sIdKommentar = resSatz.getString("BenKommentarId");
                    boolean bIsReach = resSatz.getString("Reach") != null && resSatz.getString("Reach").equals("J");
                    boolean bIsDiebstahlrelevant = resSatz.getString("Teil_Diebstahlrelevant") != null && resSatz.getString("Teil_Diebstahlrelevant").equals("J");
                    String sZISatz = sVorhandenSISatz != null && sVorhandenSISatz.equalsIgnoreCase("J") || sIdKommentar != null && !sIdKommentar.equals("0") || bIsReach ? "I" : "";
                    String sTC = resSatz.getString("TC") == null ? "" : "C";
                    SEZeile oZeileSatz = new SEZeile(sSachnummerSatz, sTeilenummerSatz, sBenennungSatz, sZusatzSatz, sZISatz + sTC, bIsDiebstahlrelevant);
                    this.mcZeilen.add(oZeileSatz);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resHG);
            WebetkUtils.closeQuery(resSatz);
            gObj.freeDBConnection(con, "SEZeilen.performLoad");
            throw throwable;
        }
        WebetkUtils.closeQuery(resHG);
        WebetkUtils.closeQuery(resSatz);
        gObj.freeDBConnection(con, "SEZeilen.performLoad");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSearch(String sMarke, String sProduktart, String sUserKatalogumfang, String sLang, String sSachnummer, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("SEZeilen.performSearch");
            log.debug((Object)"Loading Satz-Info...");
            res = TeileListeDbAccess.loadTeil(con, sSachnummer, sLang);
            res.next();
            String sHG = res.getString("Hg");
            String sUG = res.getString("Ug");
            this.msTeilenummerSatz = sHG + " " + sUG + " " + WebetkUtils.formatiereSachnummer(sSachnummer);
            this.msTeilebenennungSatz = res.getString("Benennung");
            String sZusatz = res.getString("Zusatz");
            if (sZusatz != null) {
                this.msTeilebenennungSatz = this.msTeilebenennungSatz + " " + sZusatz;
            }
            WebetkUtils.closeQuery(res);
            log.debug((Object)"Loading Einzelteil-Zeilen...");
            res = SatzEinzelteileDbAccess.loadEinzelteile(con, sLang, sSachnummer, sMarke, sProduktart, sUserKatalogumfang, sLandkuerzel);
            while (res != null && res.next()) {
                String sHGR = res.getString("HG");
                String sUGR = res.getString("UG");
                String sSachnummerR = res.getString("Sachnummer");
                String sTeilenummerR = sHGR + sUGR + sSachnummerR;
                String sBenennungR = res.getString("Benennung");
                String sZusatzR = res.getString("Zusatz");
                String sMengeR = res.getString("Menge");
                String sVorhandenSI = res.getString("vorhandenSI");
                String sIdKommentar = res.getString("BenKommentarId");
                boolean bIsReach = res.getString("Reach") != null && res.getString("Reach").equals("J");
                boolean bIsDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null && res.getString("Teil_Diebstahlrelevant").equals("J");
                String sZIR = sVorhandenSI != null && sVorhandenSI.equalsIgnoreCase("J") || sIdKommentar != null && !sIdKommentar.equals("0") || bIsReach ? "I" : "";
                String sTC = res.getString("TC") == null ? "" : "C";
                String sIstBeziehbar = res.getString("istBeziehbar");
                String sIstEBA = res.getString("istEBA");
                boolean bBeziehbar = sIstBeziehbar != null && sIstBeziehbar.equalsIgnoreCase("J");
                boolean bIstEBA = sIstEBA != null && sIstEBA.equalsIgnoreCase("J");
                SEZeile oZeile = new SEZeile(sSachnummerR, sTeilenummerR, sBenennungR, sZusatzR, sMengeR, sZIR + sTC, bBeziehbar, bIstEBA, bIsDiebstahlrelevant);
                this.mcZeilen.add(oZeile);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "SEZeilen.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "SEZeilen.performSearch");
    }

    public String getTeilenummerSatz() {
        if (this.msTeilenummerSatz == null) {
            return "";
        }
        return this.msTeilenummerSatz;
    }

    public String getTeilebenennungrSatz() {
        if (this.msTeilebenennungSatz == null) {
            return "";
        }
        return this.msTeilebenennungSatz;
    }

    public String getMarke() {
        if (this.msMarke == null) {
            return "";
        }
        return this.msMarke;
    }

    public String getProduktart() {
        if (this.msProduktart == null) {
            return "";
        }
        return this.msProduktart;
    }

    public String getCurrentIndex() {
        if (this.moZeile == null) {
            return "0";
        }
        return new Integer(this.mnIndex).toString();
    }

    public String getCurrentArt() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getArt();
    }

    public String getCurrentHG() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getHG();
    }

    public String getCurrentSachnummer() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getSachnummer();
    }

    public String getCurrentTeilenummer() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTeilenummer();
    }

    public boolean isCurrentDiebstahlrelevant() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.isTeilDiebstahlrelevant();
    }

    public String getCurrentBenennung() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getBenennung();
    }

    public String getCurrentZusatz() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getZusatz();
    }

    public String getCurrentMenge() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getMenge();
    }

    public String getCurrentZI() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getZI();
    }

    public boolean isCurrentBeziehbar() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.isBeziehbar();
    }

    public boolean isCurrentExpandiert() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.isExpandiert();
    }

    public boolean isCurrentEBA() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.isEBA();
    }

    public int getSize() {
        return this.mcZeilen.size();
    }

    public boolean hasScrollTarget() {
        for (SEZeile oZeile : this.mcZeilen) {
            if (!oZeile.isExpandiert()) continue;
            return true;
        }
        return false;
    }
}

