/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.settings;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.Markt;
import webetk.app.ServerGlobalObjects;
import webetk.app.settings.EinstellungenBasis;
import webetk.db.dbaccess.SettingsDbAccess;
import webetk.mrkprd.Produkte;

public class Einstellungen
extends EinstellungenBasis
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Einstellungen.class);

    public Einstellungen() {
    }

    public Einstellungen(EinstellungenBasis oEinstellungen) {
        Iterator<Object> iterator;
        this.msMarke = oEinstellungen.getMarke();
        this.msProdukart = oEinstellungen.getProduktart();
        this.msKatalogUmfang = oEinstellungen.getKatalogumfang();
        this.msLenkung = oEinstellungen.getLenkung();
        this.msLanguage = oEinstellungen.getSprache();
        this.msLangRegion = oEinstellungen.getSpracheRegion();
        this.mbAlwaysDisplayProduktDate = oEinstellungen.getAlwaysDisplayProduktDate();
        this.mbDisplayPreise = oEinstellungen.getDisplayPreise();
        this.mbDisplayTippsTricks = oEinstellungen.displayTippsTricks();
        this.mbSuchwegVerkuerzen = oEinstellungen.getSuchwegVerkuerzen();
        this.mbNachruestungenRelevant = oEinstellungen.getNachruestungenRelevant();
        this.mbBnKomprimiert = oEinstellungen.getDarstellungBN();
        this.mbIsLoaded = oEinstellungen.isLoaded();
        this.msTabellenanzeige = oEinstellungen.getTabellenanzeige();
        this.msSchriftgroesse = oEinstellungen.getSchriftgroesse();
        this.msSuchraum = oEinstellungen.getSuchraum();
        this.mbEinstellungenGesetzt = true;
        this.mIPACMarkt = oEinstellungen.getIPACMarkt();
        this.mEtkPrimaerMarkt = oEinstellungen.getEtkPrimaerMarkt();
        this.mbVerbaumenge = oEinstellungen.getVerbaumenge();
        if (oEinstellungen.getRegionen() != null) {
            this.mcRegionen = new Vector();
            iterator = oEinstellungen.getRegionen().iterator();
            while (iterator.hasNext()) {
                this.mcRegionen.add(iterator.next());
            }
        } else {
            this.mcRegionen = null;
        }
        if (oEinstellungen.getEtkSonstigeMaerkte() != null) {
            this.mEtkSonstigeMaerkte = new ArrayList();
            iterator = oEinstellungen.getEtkSonstigeMaerkte().iterator();
            while (iterator.hasNext()) {
                this.mEtkSonstigeMaerkte.add(iterator.next());
            }
        } else {
            this.mEtkSonstigeMaerkte = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String sNutzerID, String sFirmaID) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block22: {
            boolean bl;
            gObj = ServerGlobalObjects.getInstance();
            log.info((Object)("Loading Settings for user with ID: " + sNutzerID));
            con = null;
            res = null;
            try {
                con = gObj.getDBConnection("settings.load");
                res = SettingsDbAccess.loadSettings(con, sNutzerID, sFirmaID);
                if (res != null && res.next()) break block22;
                bl = false;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "settings.load");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "settings.load");
            return bl;
        }
        String sWert = res.getString("user_marke");
        this.setMarke(sWert);
        sWert = res.getString("user_produktart");
        this.setProduktart(sWert);
        sWert = res.getString("user_lenkung");
        this.setLenkung(sWert);
        sWert = res.getString("user_katalogumfang");
        this.setKatalogumfang(sWert);
        sWert = res.getString("user_iso");
        this.setSprache(sWert);
        sWert = res.getString("user_regiso");
        if (sWert.equals("  ")) {
            sWert = null;
        }
        this.setSpracheRegion(sWert);
        sWert = res.getString("user_expand_bnb");
        if (sWert.equals("J")) {
            this.setDarstellungBN(true);
        } else {
            this.setDarstellungBN(false);
        }
        sWert = res.getString("user_short_searchpath");
        if (sWert.equals("J")) {
            this.setSuchwegVerkuerzen(true);
        } else {
            this.setSuchwegVerkuerzen(false);
        }
        sWert = res.getString("user_dft_verbaumenge");
        if (sWert.equals("N")) {
            this.setVerbaumenge(false);
        } else {
            this.setVerbaumenge(true);
        }
        sWert = res.getString("user_request_saz");
        if (sWert.equals("J")) {
            this.setNachruestungenRelevant(true);
        } else {
            this.setNachruestungenRelevant(false);
        }
        if (sFirmaID == null) {
            sWert = res.getString("user_vinBlockRequired");
            this.setVinBlockRequired(true);
            if (sWert != null) {
                if (sWert.equals("N")) {
                    this.setVinBlockRequired(false);
                } else {
                    this.setVinBlockRequired(true);
                }
            }
        }
        sWert = res.getString("user_show_proddate");
        Boolean bDisplayProduktDate = null;
        if (sWert != null) {
            bDisplayProduktDate = sWert.equals("J") ? Boolean.TRUE : Boolean.FALSE;
        }
        this.setAlwaysDisplayProduktDate(bDisplayProduktDate);
        int primaerMarktId = res.getInt("user_primaermarkt_id");
        if (sFirmaID != null) {
            sWert = res.getString("user_tablestretch");
            this.setTabellenanzeige(sWert);
            sWert = res.getString("user_fontsize");
            this.setSchriftgroesse(sWert);
            sWert = res.getString("user_suchraum");
            this.setSuchraum(sWert);
            sWert = res.getString("user_show_preise");
            this.mbDisplayPreise = null;
            if (sWert != null) {
                this.mbDisplayPreise = sWert.equals("J") ? Boolean.TRUE : Boolean.FALSE;
            }
            sWert = res.getString("user_show_tipps");
            this.mbDisplayTippsTricks = true;
            if (sWert != null) {
                this.mbDisplayTippsTricks = sWert.equals("J");
            }
        }
        WebetkUtils.closeQuery(res);
        this.loadRegionen(con, sNutzerID, sFirmaID);
        if (sFirmaID != null) {
            WebetkUtils.closeQuery(res);
            this.mIPACMarkt = this.loadIPACMarkt(con, sNutzerID, sFirmaID);
        }
        if (primaerMarktId > 0) {
            this.mEtkPrimaerMarkt = Einstellungen.loadETKPrioMarkt(con, primaerMarktId, this.msLanguage);
        }
        this.mEtkSonstigeMaerkte = this.loadETKWeitereMaerkte(con, sNutzerID, sFirmaID);
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "settings.load");
        this.mbIsLoaded = true;
        this.mbEinstellungenGesetzt = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRegionen(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ResultSet res = null;
        try {
            res = SettingsDbAccess.loadUserRegionen(con, sNutzerID, sFirmaID);
            if (res != null) {
                while (res.next()) {
                    String sRegion = res.getString("user_region");
                    this.addRegion(sRegion);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Markt loadIPACMarkt(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ResultSet res;
        block3: {
            Markt markt;
            res = null;
            try {
                res = SettingsDbAccess.loadMarktId(con, sNutzerID, sFirmaID);
                if (res == null || !res.next()) break block3;
                int id = res.getInt("Id");
                String kuerzel = res.getString("Kuerzel");
                String lkz = res.getString("Lkz");
                String produktart = res.getString("Produktart");
                Markt ipacMarkt = new Markt(id, "", kuerzel);
                Collection<String> produkte = Produkte.mapProdukt(produktart);
                ipacMarkt.setProdukte(produkte);
                ipacMarkt.setLkz(lkz);
                markt = ipacMarkt;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return markt;
        }
        Markt markt = null;
        WebetkUtils.closeQuery(res);
        return markt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Markt loadIPACMarkt(Connection con, int marktId) throws SQLException {
        ResultSet res = null;
        try {
            res = SettingsDbAccess.loadIpacMarkt(con, marktId);
            if (res != null && res.next()) {
                String kuerzel = res.getString("Kuerzel");
                String lkz = res.getString("Lkz");
                Markt ipacMarkt = new Markt(marktId, "", kuerzel);
                ipacMarkt.setLkz(lkz);
                Markt markt = ipacMarkt;
                return markt;
            }
            Markt markt = null;
            return markt;
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Markt loadETKPrioMarkt(Connection con, int primaerMarktId, String sLanguage) throws SQLException {
        ResultSet res;
        block3: {
            Markt markt;
            res = null;
            try {
                Markt etkPrimaerMarkt;
                res = SettingsDbAccess.loadEtkMarkt(con, primaerMarktId, sLanguage);
                if (res == null || !res.next()) break block3;
                String name = res.getString("name");
                String kuerzel = res.getString("kuerzel");
                markt = etkPrimaerMarkt = new Markt(primaerMarktId, name, kuerzel);
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return markt;
        }
        Markt markt = null;
        WebetkUtils.closeQuery(res);
        return markt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Markt> loadETKWeitereMaerkte(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ArrayList<Markt> arrayList;
        ResultSet res = null;
        try {
            ArrayList<Markt> etkSonstigeMaerkte = new ArrayList<Markt>();
            res = SettingsDbAccess.loadUserWeitereMaerkte(con, sFirmaID, sNutzerID, this.msLanguage);
            while (res != null && res.next()) {
                int id = res.getInt("user_markt_id");
                String name = res.getString("name");
                String kuerzel = res.getString("kuerzel");
                String lkz = res.getString("lkz");
                Markt weitererMarkt = new Markt(id, name, kuerzel);
                weitererMarkt.setLkz(lkz);
                etkSonstigeMaerkte.add(weitererMarkt);
            }
            arrayList = etkSonstigeMaerkte;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Markt> loadMaerkteEtkLokaleProdukte(String sSprache) throws SQLException, DatabaseBusyException {
        ArrayList<Markt> maerkte = new ArrayList<Markt>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Einstellungen.loadMaerkteEtkLokaleProdukte");
            res = SettingsDbAccess.loadMaerkteEtkLokaleProdukte(con, sSprache);
            while (res != null && res.next()) {
                int marktId = res.getInt("id");
                String name = res.getString("name");
                String kuerzel = res.getString("kuerzel");
                String lkz = res.getString("lkz");
                Markt markt = new Markt(marktId, name, kuerzel);
                markt.setLkz(lkz);
                maerkte.add(markt);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Einstellungen.loadMaerkteEtkLokaleProdukte");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Einstellungen.loadMaerkteEtkLokaleProdukte");
        return maerkte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDB(String sNutzerID) throws SQLException, DatabaseBusyException {
        boolean bStored = true;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Storing Settings for user with ID: " + sNutzerID));
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Einstellungen.writeToDB");
            SettingsDbAccess.saveSettings(con, sNutzerID, this);
        }
        catch (SQLException e) {
            log.error((Object)("Error during saving of settings: " + e.getMessage()), (Throwable)e);
            bStored = false;
        }
        catch (DatabaseBusyException e) {
            log.error((Object)("Error during saving of settings: " + e.getMessage()), (Throwable)e);
            bStored = false;
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Einstellungen.writeToDB");
            this.mbIsLoaded = bStored;
            this.mbEinstellungenGesetzt = bStored;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDB(String sFirmaID, String sNutzerID) throws SQLException, DatabaseBusyException {
        boolean bStored = true;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Storing Settings for user with ID: " + sNutzerID));
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Einstellungen.writeToDB");
            SettingsDbAccess.saveSettings(con, sFirmaID, sNutzerID, this);
        }
        catch (SQLException e) {
            log.error((Object)("Error during saving of settings: " + e.getMessage()), (Throwable)e);
            bStored = false;
        }
        catch (DatabaseBusyException e) {
            log.error((Object)("Error during saving of settings: " + e.getMessage()), (Throwable)e);
            bStored = false;
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Einstellungen.writeToDB");
            this.mbIsLoaded = bStored;
            this.mbEinstellungenGesetzt = bStored;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkModellspalte() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Pruefe Modellspalte");
        boolean bResult = false;
        Connection con = null;
        try {
            con = gObj.getDBConnection("Einstellungen.checkModellspalte");
            bResult = SettingsDbAccess.checkModellspalte(con, this);
        }
        finally {
            gObj.freeDBConnection(con, "Einstellungen.checkModellspalte");
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMarktId(int marktId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("Einstellungen.setMarktId");
            this.mIPACMarkt = this.loadIPACMarkt(con, marktId);
        }
        finally {
            gObj.freeDBConnection(con, "Einstellungen.setMarktId");
        }
    }
}

