/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.settings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.settings.Sprache;
import webetk.db.dbaccess.SettingsDbAccess;
import webetk.db.dbaccess.TechnischeLiteraturDbAccess;

public class WertebereichSprachen {
    private static Logger log = Logger.getLogger(WertebereichSprachen.class);
    private Vector<Sprache> mcSprachen = new Vector();

    public Iterator<Sprache> iteratorSprachen() {
        return this.mcSprachen.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Sprachen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("WertebereichSprachen.load");
            res = SettingsDbAccess.loadSprachen(con);
            if (res != null) {
                while (res.next()) {
                    String sISO = res.getString("ISO");
                    String sRegISO = res.getString("RegISO");
                    if (sRegISO.equals("  ")) {
                        sRegISO = null;
                    }
                    String sBenennung = res.getString("Benennung");
                    this.mcSprachen.add(new Sprache(sBenennung, sISO, sRegISO));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "WertebereichSprachen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "WertebereichSprachen.load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFuerTL(String sSprache) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Sprachen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("WertebereichSprachen.loadFuerTL");
            res = TechnischeLiteraturDbAccess.selectSprachen(con, sSprache);
            if (res != null) {
                while (res.next()) {
                    String sISO = res.getString("SpracheISO");
                    String sRegISO = res.getString("SpracheRegISO");
                    if (sRegISO.equals("  ")) {
                        sRegISO = null;
                    }
                    String sBenennung = res.getString("Benennung");
                    this.mcSprachen.add(new Sprache(sBenennung, sISO, sRegISO));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "WertebereichSprachen.loadFuerTL");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "WertebereichSprachen.loadFuerTL");
    }
}

