/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileliste;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.DuplicateValueException;
import webetk.InvalidDataException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.db.dbaccess.TeileListeDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Bestellliste
extends Teileliste
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Bestellliste.class);
    @XmlElement
    private String msBezeichnung;

    public Bestellliste(String sID) {
        this.msID = sID;
    }

    public Bestellliste() {
    }

    public Bestellliste(String sID, String sSprache, String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.msID = sID;
        this.msLanguage = sSprache;
        this.msFiliale = sFiliale;
        this.reload(sID, sSprache, sFirma, sFiliale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean bNeuanlage, String sFirma) throws SQLException, DatabaseBusyException, DuplicateValueException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Storing Bestellliste");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Bestellliste.save");
            TeileListeDbAccess.storeTeileliste(con, this, bNeuanlage, sFirma);
        }
        finally {
            gObj.freeDBConnection(con, "Bestellliste.save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String sID, String sSprache, String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Loading Bestellliste ID: " + sID));
        Connection con = null;
        ResultSet res = null;
        try {
            long lGesperrtAm;
            con = gObj.getDBConnection("Bestellliste.reload");
            res = TeileListeDbAccess.loadBestelllisteAllgemein(con, sID, sFirma, sFiliale);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            this.msID = sID;
            this.msFiliale = sFiliale;
            this.msGesperrtVon = res.getString("GesperrtVon");
            if (this.msGesperrtVon != null) {
                this.mbGesperrt = true;
            }
            if ((lGesperrtAm = res.getLong("GesperrtAm")) > 0L) {
                this.mdatGesperrtAm = WebetkUtils.getDateFromLong(lGesperrtAm);
            }
            WebetkUtils.closeQuery(res);
            res = TeileListeDbAccess.loadBestelllistePositionen(con, sID, sSprache, sFirma, sFiliale);
            this.mcTeile = new Vector();
            if (res != null) {
                while (res.next()) {
                    String sSachnummer = res.getString("SachNr").trim();
                    String sHgUg = res.getString("HgUg");
                    String sHg = "";
                    String sUg = "";
                    if (sHgUg != null && sHgUg.length() == 4) {
                        sHg = sHgUg.substring(0, 2);
                        sUg = sHgUg.substring(2, 4);
                    }
                    int nPos = res.getInt("Pos");
                    String sMenge = res.getString("Menge");
                    String sBemerkung = res.getString("Bemerkung");
                    String sBenennung = res.getString("Benennung");
                    String sZusatz = res.getString("Zusatz");
                    boolean bLokalteil = res.getString("Lokalteil") != null && res.getString("Lokalteil").equals("J");
                    Teil objTeil = null;
                    if (!bLokalteil) {
                        objTeil = new Teil(sSachnummer, nPos, sMenge, sBemerkung, sSprache);
                        objTeil.setHG(sHg);
                        objTeil.setUG(sUg);
                        objTeil.setBenennung(sBenennung);
                        objTeil.setZusatz(sZusatz);
                    } else {
                        objTeil = new Teil(sSachnummer, sHg, sUg, nPos, sMenge, sBemerkung, sBenennung, sZusatz);
                    }
                    Double oDValue = new Double(res.getDouble("Lagerbestand"));
                    objTeil.setLagerbestand(oDValue);
                    oDValue = new Double(res.getDouble("Minimalbestand"));
                    objTeil.setMinimalbestand(oDValue);
                    Integer nIValue = null;
                    if (res.getString("Bedarfshinweis") != null) {
                        nIValue = new Integer(res.getInt("Bedarfshinweis"));
                    }
                    objTeil.setBedarfshinweis(nIValue);
                    String sValue = res.getString("Lagerort");
                    objTeil.setLagerort(sValue);
                    if (res.getString("AuMe") != null) {
                        oDValue = new Double(res.getDouble("AuMe"));
                    }
                    objTeil.setAuMe(oDValue);
                    sValue = res.getString("AuftragsNr");
                    objTeil.setAuftragsnummer(sValue);
                    Long lKundenNr = null;
                    String sKundenNr = res.getString("KundenNr");
                    if (sKundenNr != null) {
                        lKundenNr = Long.valueOf(sKundenNr);
                    }
                    objTeil.setKundennummer(lKundenNr);
                    objTeil.setLokalteil(res.getString("Lokalteil") != null && res.getString("Lokalteil").equals("J"));
                    this.mcTeile.add(objTeil);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Bestellliste.reload");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Bestellliste.reload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTeile(Collection cTeile, String sSprache, boolean bReplaceMenge, boolean bLoadPubldaten) throws SQLException, DatabaseBusyException, NoDataFoundException, InvalidDataException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Entering Function addTeile");
        for (Teil objTeil : cTeile) {
            if (this.mcTeile == null) {
                this.mcTeile = new Vector();
            }
            if (!objTeil.getLokalteil() && bLoadPubldaten) {
                ResultSet res;
                Connection con;
                block7: {
                    con = null;
                    res = null;
                    try {
                        con = gObj.getDBConnection("Bestellliste.addTeile");
                        res = TeileListeDbAccess.loadTeil(con, objTeil.getSachnummer(), sSprache);
                        boolean bTeilVorhanden = false;
                        while (res.next()) {
                            bTeilVorhanden = true;
                            String sMarke = res.getString("Marke");
                            objTeil.appendMarke(sMarke);
                            objTeil.setTeileart(res.getString("Teileart"));
                            objTeil.setHG(res.getString("Hg"));
                            objTeil.setUG(res.getString("Ug"));
                            objTeil.setBenennung(res.getString("Benennung"));
                            objTeil.setZusatz(res.getString("Zusatz"));
                            objTeil.setMAM(res.getInt("MAM"));
                        }
                        if (bTeilVorhanden) break block7;
                        throw new NoDataFoundException();
                    }
                    catch (Throwable throwable) {
                        WebetkUtils.closeQuery(res);
                        gObj.freeDBConnection(con, "Bestellliste.addTeile");
                        throw throwable;
                    }
                }
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Bestellliste.addTeile");
            }
            if (!bReplaceMenge || objTeil.getMenge() == null || objTeil.getMenge().length() < 1) {
                objTeil.setMenge("1");
            }
            objTeil.setPos(this.mcTeile.size() + 1);
            objTeil.setInsert(true);
            this.mcTeile.add(objTeil);
        }
    }

    public void saveTeile(Collection cTeile, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"saveTeile");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.saveTeile");
            con.setAutoCommit(false);
            for (Teil oTeil : cTeile) {
                if (!oTeil.getMustSave()) continue;
                TeileListeDbAccess.saveTeilInBestellliste(con, oTeil, this.msID, sFirma, this.msFiliale);
            }
            Calendar rightNow = Calendar.getInstance();
            Date datAenderung = rightNow.getTime();
            this.setDatAenderung(datAenderung);
            this.saveAenderungsdatum(sFirma);
        }
        catch (SQLException ex) {
            if (con != null) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
                gObj.freeDBConnectionNutzer(con, "Teileliste.saveTeile");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<ComboTeilelisteItem> getBestelllisten(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        Vector<ComboTeilelisteItem> cBestelllisten = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Bestelllisten");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Bestelllist.getBestelllisten");
            res = TeileListeDbAccess.selectBestelllistenIDs(con, sFirma, sFiliale);
            if (res != null) {
                cBestelllisten = new Vector<ComboTeilelisteItem>();
                while (res.next()) {
                    String sId = res.getString("ListeId");
                    ComboTeilelisteItem oBestellliste = new ComboTeilelisteItem(sId);
                    cBestelllisten.add(oBestellliste);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Bestellliste.getBestelllisten");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Bestellliste.getBestelllisten");
        return cBestelllisten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sperre(boolean bGesperrt, boolean bForce, String sNutzer, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"sperre");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Bestellliste.sperre");
            if (TeileListeDbAccess.updateSperre(con, bGesperrt, bForce, this, sNutzer, sFirma)) {
                this.mbGesperrt = true;
                this.msGesperrtVon = sNutzer;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gObj.freeDBConnection(con, "Bestellliste.sperre");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteParts(Collection<Teil> cPartsToDelete, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Deleting Parts from Bestellliste");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Bestellliste.deleteParts");
            TeileListeDbAccess.deleteTeileAusTeileliste(con, cPartsToDelete, this.msID, null, sFirma, this.msFiliale, true, false);
        }
        finally {
            gObj.freeDBConnection(con, "Bestellliste.deleteParts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllParts(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Deleting all Parts from Bestellliste");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Bestellliste.deleteAllParts");
            TeileListeDbAccess.deleteAllPartsFromBestellliste(con, this.msID, sFirma, this.msFiliale);
        }
        finally {
            gObj.freeDBConnection(con, "Bestellliste.deleteAllParts");
        }
    }

    @Override
    public Date getDatGesperrtAm() {
        return this.mdatGesperrtAm;
    }

    @Override
    public String getDatGesperrtAmString() {
        if (this.mdatGesperrtAm == null) {
            return "";
        }
        return WebetkUtils.getStringFromDateTime(this.mdatGesperrtAm, this.msLanguage, 3, 3);
    }

    @Override
    public void setDatGesperrtAm(Date datGesperrtAm) {
        this.mdatGesperrtAm = datGesperrtAm;
    }

    @Override
    public String getGesperrtVon() {
        return this.msGesperrtVon;
    }

    @Override
    public void setGesperrtVon(String sGesperrtVon) {
        this.msGesperrtVon = sGesperrtVon;
    }

    public String getBezeichnung() {
        return this.msBezeichnung;
    }

    public void setBezeichnung(String sBezeichnung) {
        this.msBezeichnung = sBezeichnung;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String sId, String sFilialId, String sFirmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("Bestellliste.insert");
            log.debug((Object)"Insert Bestellliste...");
            TeileListeDbAccess.storeBestellliste(con, sId, sFilialId, sFirmaId);
        }
        finally {
            gObj.freeDBConnection(con, "Bestellliste.insert");
        }
    }

    @Override
    public Date getMdatGesperrtAm() {
        return this.mdatGesperrtAm;
    }

    @Override
    public void setMdatGesperrtAm(Date mdatGesperrtAm) {
        this.mdatGesperrtAm = mdatGesperrtAm;
    }

    @Override
    public String getMsGesperrtVon() {
        return this.msGesperrtVon;
    }

    @Override
    public void setMsGesperrtVon(String msGesperrtVon) {
        this.msGesperrtVon = msGesperrtVon;
    }

    public String getMsBezeichnung() {
        return this.msBezeichnung;
    }

    public void setMsBezeichnung(String msBezeichnung) {
        this.msBezeichnung = msBezeichnung;
    }
}

