/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.visualisierungteil;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.VisualisierungsTeilDbAccess;

public class VisualisierungTeil
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(VisualisierungTeil.class);
    private String msBildnummer = null;
    private String msTeilenummer = null;
    private String msTeilebenennung = null;
    private String msTeilebenennungZusatz = null;
    private String msBildtafelNummer = null;
    private String msBildtafelUeberschrift = null;
    private String msGrafikId = null;
    private String msGrafikFormat = null;
    private String msGrafikTimestamp = null;

    public VisualisierungTeil(String sLang, Collection<String> aMarken, Collection<String> aProdukte, String sSachnummer) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.load(sLang, aMarken, aProdukte, sSachnummer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String sLang, Collection<String> aMarken, Collection<String> aProdukte, String sSachnummer) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("VisualisierungTeil.load");
            log.debug((Object)"Loading Information...");
            res = VisualisierungsTeilDbAccess.retrieveVisualisierungsInfo(con, sLang, aMarken, aProdukte, sSachnummer);
            String sHG = res.getString("HG");
            String sUG = res.getString("UG");
            String sSachnummerR = res.getString("Sachnummer");
            this.msTeilenummer = sHG + " " + sUG + " " + WebetkUtils.formatiereSachnummer(sSachnummerR);
            this.msTeilebenennung = res.getString("Teilebenennung");
            this.msTeilebenennungZusatz = res.getString("TeilebenennungZusatz");
            this.msBildtafelNummer = res.getString("BildtafelNummer");
            this.msBildtafelUeberschrift = res.getString("BildtafelUeberschrift");
            this.msBildnummer = res.getString("Bildnummer");
            this.msGrafikId = res.getString("GrafikId");
            this.msGrafikFormat = res.getString("GrafikFormat");
            this.msGrafikTimestamp = res.getString("GrafikTimestamp");
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "visualisierungteil.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "visualisierungteil.load");
    }

    public String getBildnummer() {
        if (this.msBildnummer == null) {
            return "";
        }
        return this.msBildnummer;
    }

    public String getTeilenummer() {
        if (this.msTeilenummer == null) {
            return "";
        }
        return this.msTeilenummer;
    }

    public String getTeilebenennung() {
        if (this.msTeilebenennung == null) {
            return "";
        }
        return this.msTeilebenennung;
    }

    public String getTeilebenennungZusatz() {
        if (this.msTeilebenennungZusatz == null) {
            return "";
        }
        return this.msTeilebenennungZusatz;
    }

    public String getBildtafelNummer() {
        if (this.msBildtafelNummer == null) {
            return "";
        }
        return this.msBildtafelNummer;
    }

    public String getBildtafelUeberschrift() {
        if (this.msBildtafelUeberschrift == null) {
            return "";
        }
        return this.msBildtafelUeberschrift;
    }

    public String getGrafikId() {
        if (this.msGrafikId == null) {
            return "";
        }
        return this.msGrafikId;
    }

    public String getGrafikFormat() {
        if (this.msGrafikFormat == null) {
            return "";
        }
        return this.msGrafikFormat;
    }

    public String getGrafikTimestamp() {
        if (this.msGrafikTimestamp == null) {
            return "";
        }
        return this.msGrafikTimestamp;
    }
}

