/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.technisch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.app.bteinfo.Info;
import webetk.app.zub.common.Preise;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.technisch.TechnischerBnb;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TechnischesProdukt
implements Comparable,
Serializable,
Cloneable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    String mBteNr;
    String mBildPosNr;
    int mMospId;
    String mProduktBenennung;
    List<Zubehoergrafik> mImages = new ArrayList<Zubehoergrafik>();
    List<TechnischerBnb> mKernProduktBnbs = new ArrayList<TechnischerBnb>();
    List<TechnischerBnb> mZusatzProduktBnbs = new ArrayList<TechnischerBnb>();
    List<TechnischerBnb> mHilfsStoffeBnbs = new ArrayList<TechnischerBnb>();
    List<TechnischerBnb> mSonstigeBnbs = new ArrayList<TechnischerBnb>();
    List<EinbauInfo> mEinbauInfoVariante = new ArrayList<EinbauInfo>();
    List<EinbauInfo> mEinbauInfoProdukt = new ArrayList<EinbauInfo>();
    Preise mPreise;
    Info mBteKommentar;
    List<Integer> mVerbaubareVarianten = new ArrayList<Integer>();
    List<Bnb> mVerbaubareAlternativen = new ArrayList<Bnb>();
    List<ProduktListenElement> mVerbaubareZubehoerProdukte = new ArrayList<ProduktListenElement>();
    boolean mTooManyBauteile = false;

    public TechnischesProdukt() {
    }

    public TechnischesProdukt(String bteNr, int mospId) {
        this.mBteNr = bteNr;
        this.mMospId = mospId;
        this.mTooManyBauteile = false;
    }

    public TechnischesProdukt(String bteNr, int mospId, String produktBenennung, List<Zubehoergrafik> images, List<TechnischerBnb> kernProduktBnbs, List<TechnischerBnb> zusatzProduktBnbs, List<TechnischerBnb> hilfsStoffeBnbs) {
        this.mBteNr = bteNr;
        this.mMospId = mospId;
        this.mProduktBenennung = produktBenennung;
        this.mImages = images;
        this.mKernProduktBnbs = kernProduktBnbs;
        this.mZusatzProduktBnbs = zusatzProduktBnbs;
        this.mHilfsStoffeBnbs = hilfsStoffeBnbs;
        this.mTooManyBauteile = false;
    }

    public TechnischesProdukt(String bteNr, String bildPosNr, int mospId, String produktBenennung, List images, List kernProduktBnbs, List zusatzProduktBnbs, List hilfsStoffeBnbs) {
        this.mBteNr = bteNr;
        this.mBildPosNr = bildPosNr;
        this.mMospId = mospId;
        this.mProduktBenennung = produktBenennung;
        this.mImages = images;
        this.mKernProduktBnbs = kernProduktBnbs;
        this.mZusatzProduktBnbs = zusatzProduktBnbs;
        this.mHilfsStoffeBnbs = hilfsStoffeBnbs;
        this.mTooManyBauteile = false;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mBildPosNr == null ? 0 : this.mBildPosNr.hashCode());
        result = 31 * result + (this.mBteNr == null ? 0 : this.mBteNr.hashCode());
        result = 31 * result + this.mMospId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TechnischesProdukt other = (TechnischesProdukt)obj;
        if (this.mBildPosNr == null ? other.mBildPosNr != null : !this.mBildPosNr.equals(other.mBildPosNr)) {
            return false;
        }
        if (this.mBteNr == null ? other.mBteNr != null : !this.mBteNr.equals(other.mBteNr)) {
            return false;
        }
        return this.mMospId == other.mMospId;
    }

    public String getBteNr() {
        return this.mBteNr;
    }

    public void setBteNr(String bteNr) {
        this.mBteNr = bteNr;
    }

    public List getHilfsStoffe() {
        ArrayList<Bauteil> teileListe = new ArrayList<Bauteil>();
        for (TechnischerBnb bnb : this.getHilfsStoffeBnbs()) {
            teileListe.addAll(bnb.getBauteile());
        }
        return teileListe;
    }

    public List getImages() {
        return this.mImages;
    }

    public void setImages(List images) {
        this.mImages = images;
    }

    public List getKernProduktTeile() {
        ArrayList<Bauteil> teileListe = new ArrayList<Bauteil>();
        for (TechnischerBnb bnb : this.getKernProduktBnbs()) {
            teileListe.addAll(bnb.getBauteile());
        }
        return teileListe;
    }

    public int getMospId() {
        return this.mMospId;
    }

    public void setMospId(int mospId) {
        this.mMospId = mospId;
    }

    public String getProduktBenennung() {
        return this.mProduktBenennung;
    }

    public void setProduktBenennung(String produktBenennung) {
        this.mProduktBenennung = produktBenennung;
    }

    public List getZusatzProdukte() {
        ArrayList<Bauteil> teileListe = new ArrayList<Bauteil>();
        for (TechnischerBnb bnb : this.getZusatzProduktBnbs()) {
            teileListe.addAll(bnb.getBauteile());
        }
        return teileListe;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof TechnischesProdukt)) {
            return 0;
        }
        TechnischesProdukt prod = (TechnischesProdukt)obj;
        return this.hashCode() - prod.hashCode();
    }

    public List getHilfsStoffeBnbs() {
        return this.mHilfsStoffeBnbs;
    }

    public void setHilfsStoffeBnbs(List hilfsStoffeBnbs) {
        this.mHilfsStoffeBnbs = hilfsStoffeBnbs;
    }

    public List getKernProduktBnbs() {
        return this.mKernProduktBnbs;
    }

    public void setKernProduktBnbs(List kernProduktBnbs) {
        this.mKernProduktBnbs = kernProduktBnbs;
    }

    public List<TechnischerBnb> getZusatzProduktBnbs() {
        return this.mZusatzProduktBnbs;
    }

    public void setZusatzProduktBnbs(List<TechnischerBnb> zusatzProduktBnbs) {
        this.mZusatzProduktBnbs = zusatzProduktBnbs;
    }

    public String getBildPosNr() {
        return this.mBildPosNr;
    }

    public boolean hasTooManyRows() {
        return this.mTooManyBauteile;
    }

    public void setBildPosNr(String bildPosNr) {
        this.mBildPosNr = bildPosNr;
    }

    public List getEinbauInfoProdukt() {
        return this.mEinbauInfoProdukt;
    }

    public void setEinbauInfoProdukt(List<EinbauInfo> einbauInfoProdukt) {
        this.mEinbauInfoProdukt = einbauInfoProdukt;
    }

    public List<EinbauInfo> getEinbauInfoVariante() {
        return this.mEinbauInfoVariante;
    }

    public void setEinbauInfoVariante(List<EinbauInfo> einbauInfoVariante) {
        this.mEinbauInfoVariante = einbauInfoVariante;
    }

    public TechnischerBnb findTechnischenBnb(TechnischerBnb oBnbComp) {
        TechnischerBnb oBnb;
        int i;
        for (i = 0; i < this.mKernProduktBnbs.size(); ++i) {
            oBnb = this.mKernProduktBnbs.get(i);
            if (!oBnb.getBildPos().equals(oBnbComp.getBildPos())) continue;
            return oBnb;
        }
        for (i = 0; i < this.mZusatzProduktBnbs.size(); ++i) {
            oBnb = this.mZusatzProduktBnbs.get(i);
            if (!oBnb.getBildPos().equals(oBnbComp.getBildPos())) continue;
            return oBnb;
        }
        for (i = 0; i < this.mHilfsStoffeBnbs.size(); ++i) {
            oBnb = this.mHilfsStoffeBnbs.get(i);
            if (!oBnb.getBildPos().equals(oBnbComp.getBildPos())) continue;
            return oBnb;
        }
        return null;
    }

    public List getSonstigeBnbs() {
        return this.mSonstigeBnbs;
    }

    public void setSonstigeBnbs(List<TechnischerBnb> sonstigeBnbs) {
        this.mSonstigeBnbs = sonstigeBnbs;
    }

    public Preise getPreise() {
        return this.mPreise;
    }

    public void setPreise(Preise preise) {
        this.mPreise = preise;
        for (TechnischerBnb bnb : this.getKernProduktBnbs()) {
            for (Bauteil teil : bnb.getBauteile()) {
                teil.setEinzelPreis(preise.getPreisZuSachnummer(teil.getTeilenummer()));
                teil.setMwStSatz((float)preise.getMwstSatzZuSachnummer(teil.getTeilenummer()));
            }
        }
        for (TechnischerBnb bnb : this.getZusatzProduktBnbs()) {
            for (Bauteil teil : bnb.getBauteile()) {
                teil.setEinzelPreis(preise.getPreisZuSachnummer(teil.getTeilenummer()));
                teil.setMwStSatz((float)preise.getMwstSatzZuSachnummer(teil.getTeilenummer()));
            }
        }
        for (TechnischerBnb bnb : this.getHilfsStoffeBnbs()) {
            for (Bauteil teil : bnb.getBauteile()) {
                teil.setEinzelPreis(preise.getPreisZuSachnummer(teil.getTeilenummer()));
                teil.setMwStSatz((float)preise.getMwstSatzZuSachnummer(teil.getTeilenummer()));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TechnischesProdukt produkt = new TechnischesProdukt();
        produkt.setBildPosNr(this.getBildPosNr());
        produkt.setBteNr(this.getBteNr());
        produkt.setMospId(this.getMospId());
        produkt.setProduktBenennung(this.getProduktBenennung());
        if (this.getEinbauInfoProdukt() != null) {
            ArrayList<EinbauInfo> einbauInfoProdukt = new ArrayList<EinbauInfo>();
            for (EinbauInfo info : this.getEinbauInfoProdukt()) {
                einbauInfoProdukt.add(info);
            }
            produkt.setEinbauInfoProdukt(einbauInfoProdukt);
        }
        if (this.getEinbauInfoVariante() != null) {
            ArrayList<EinbauInfo> einbauInfoVariante = new ArrayList<EinbauInfo>();
            for (EinbauInfo info : this.getEinbauInfoVariante()) {
                einbauInfoVariante.add(info);
            }
            produkt.setEinbauInfoVariante(einbauInfoVariante);
        }
        if (this.getHilfsStoffeBnbs() != null) {
            ArrayList<Object> hilfsStoffe = new ArrayList<Object>();
            for (TechnischerBnb bnb : this.getHilfsStoffeBnbs()) {
                hilfsStoffe.add(bnb.clone());
            }
            produkt.setHilfsStoffeBnbs(hilfsStoffe);
        }
        if (this.getKernProduktBnbs() != null) {
            ArrayList<Object> kernProdukte = new ArrayList<Object>();
            for (TechnischerBnb bnb : this.getKernProduktBnbs()) {
                kernProdukte.add(bnb.clone());
            }
            produkt.setKernProduktBnbs(kernProdukte);
        }
        if (this.getZusatzProduktBnbs() != null) {
            ArrayList<TechnischerBnb> zusatzProdukte = new ArrayList<TechnischerBnb>();
            for (TechnischerBnb bnb : this.getZusatzProduktBnbs()) {
                zusatzProdukte.add((TechnischerBnb)bnb.clone());
            }
            produkt.setZusatzProduktBnbs(zusatzProdukte);
        }
        if (this.getSonstigeBnbs() != null) {
            ArrayList<TechnischerBnb> sonstigeBnbs = new ArrayList<TechnischerBnb>();
            for (TechnischerBnb bnb : this.getSonstigeBnbs()) {
                sonstigeBnbs.add((TechnischerBnb)bnb.clone());
            }
            produkt.setSonstigeBnbs(sonstigeBnbs);
        }
        if (this.getImages() != null) {
            ArrayList<Object> images = new ArrayList<Object>();
            for (Zubehoergrafik grafik : this.getImages()) {
                images.add(grafik.clone());
            }
            produkt.setImages(images);
        }
        if (this.getPreise() != null) {
            produkt.setPreise(this.getPreise());
        }
        return produkt;
    }

    public Info getBteKommentar() {
        return this.mBteKommentar;
    }

    public void setBteKommentar(Info bteKommentar) {
        this.mBteKommentar = bteKommentar;
    }

    public List getVerbaubareAlternativen() {
        return this.mVerbaubareAlternativen;
    }

    public void setVerbaubareAlternativen(List<Bnb> verbaubareAlternativen) {
        this.mVerbaubareAlternativen = verbaubareAlternativen;
    }

    public List getVerbaubareVarianten() {
        return this.mVerbaubareVarianten;
    }

    public void setVerbaubareVarianten(List<Integer> verbaubareVarianten) {
        this.mVerbaubareVarianten = verbaubareVarianten;
    }

    public List getVerbaubareZubehoerProdukte() {
        return this.mVerbaubareZubehoerProdukte;
    }

    public void setVerbaubareZubehoerProdukte(List<ProduktListenElement> verbaubareZubehoerProdukte) {
        this.mVerbaubareZubehoerProdukte = verbaubareZubehoerProdukte;
    }

    public void checkTechnischesProdukt() {
        if (this.getKernProduktBnbs() == null) {
            this.mTooManyBauteile = false;
            return;
        }
        this.mTooManyBauteile = false;
        for (TechnischerBnb bnb : this.getKernProduktBnbs()) {
            if (bnb == null) continue;
            ArrayList verweisNr = (ArrayList)bnb.getAlleVerweisNr();
            for (int i = 0; i < verweisNr.size(); ++i) {
                Integer VerweisNr = (Integer)verweisNr.get(i);
                ArrayList bauteileNormal = (ArrayList)bnb.getBauteileNormal(VerweisNr);
                if (bauteileNormal.size() <= 1) continue;
                if (bauteileNormal.size() > 2) {
                    this.mTooManyBauteile = true;
                    return;
                }
                Bauteil Bauteil1 = (Bauteil)bauteileNormal.get(0);
                Bauteil Bauteil2 = (Bauteil)bauteileNormal.get(1);
                if (Bauteil1.getBuendelung() == null || Bauteil2.getBuendelung() == null) {
                    this.mTooManyBauteile = true;
                    return;
                }
                if (Bauteil1.getBuendelung().equals("RECHTS") && Bauteil2.getBuendelung().equals("LINKS") || Bauteil1.getBuendelung().equals("LINKS") && Bauteil2.getBuendelung().equals("RECHTS")) continue;
                this.mTooManyBauteile = true;
                return;
            }
        }
    }
}

