/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.verwaltung;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Fahrzeug;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Kunde
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Kunde.class);
    public static final int NULL = 0;
    public static final int NAME_FUEHREND = 1;
    public static final int NUMMER_FUEHREND = 2;
    private static final String seperator = ", ";
    protected int kundenId = 0;
    protected String mKundennummer;
    protected String mAnrede;
    protected String mName;
    protected String mVorname;
    protected String mStrasse;
    protected String mHausnr;
    protected String mLand;
    protected String mPlz;
    protected String mStadt;
    protected String mPostfachnr;
    protected String mTelefonnummer;
    protected String mMobilnummer;
    protected String mFaxnummer;
    protected String mEmail;
    protected String mBemerkung;
    protected Date mGeburtsDatum;
    protected List<Fahrzeug> mFahrzeuge = new ArrayList<Fahrzeug>();

    public Kunde() {
        this(null);
    }

    public Kunde(String name) {
        this.mName = name;
    }

    public Kunde(String kundennummer, String anrede, String name, String vorname, String strasse, String hausnr, String land, String plz, String stadt, String postfachnr, String telefonnummer, String mobilnummer, String faxnummer, String email, String bemerkung) {
        this.mKundennummer = kundennummer;
        this.mAnrede = anrede;
        this.mName = name;
        this.mVorname = vorname;
        this.mStrasse = strasse;
        this.mHausnr = hausnr;
        this.mLand = land;
        this.mPlz = plz;
        this.mStadt = stadt;
        this.mPostfachnr = postfachnr;
        this.mTelefonnummer = telefonnummer;
        this.mMobilnummer = mobilnummer;
        this.mFaxnummer = faxnummer;
        this.mEmail = email;
        this.mBemerkung = bemerkung;
    }

    public int getKundenId() {
        return this.kundenId;
    }

    public void setKundenId(int kundenId) {
        this.kundenId = kundenId;
    }

    public String getAnrede() {
        return this.mAnrede;
    }

    public void setAnrede(String anrede) {
        this.mAnrede = anrede;
    }

    public String getBemerkung() {
        return this.mBemerkung;
    }

    public void setBemerkung(String bemerkung) {
        this.mBemerkung = bemerkung;
    }

    public List<Fahrzeug> getFahrzeuge() {
        return this.mFahrzeuge;
    }

    public void setFahrzeuge(List<Fahrzeug> fahrzeuge) {
        this.mFahrzeuge = fahrzeuge;
    }

    public Date getGeburtsDatum() {
        return this.mGeburtsDatum;
    }

    public void setGeburtsDatum(Date geburtsDatum) {
        this.mGeburtsDatum = geburtsDatum;
    }

    public void setGeburtsDatum(String geburtsDatum) {
        try {
            this.mGeburtsDatum = new SimpleDateFormat("yyyyMMdd").parse(geburtsDatum);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getHausnr() {
        return this.mHausnr;
    }

    public void setHausnr(String hausnr) {
        this.mHausnr = hausnr;
    }

    public String getKundennummer() {
        return this.mKundennummer;
    }

    public void setKundennummer(String kundennummer) {
        if (kundennummer == null || kundennummer.length() == 0) {
            log.warn((Object)"Kundennummer is empty");
            return;
        }
        if (kundennummer.length() > 7) {
            log.error((Object)("Invalid Kundennummer " + kundennummer));
            this.mKundennummer = null;
        } else {
            try {
                Integer.parseInt(kundennummer);
                this.mKundennummer = kundennummer;
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid Kundennummer " + kundennummer), (Throwable)e);
                this.mKundennummer = null;
            }
        }
    }

    public String getLand() {
        return this.mLand;
    }

    public void setLand(String land) {
        this.mLand = land;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getPlz() {
        return this.mPlz;
    }

    public void setPlz(String plz) {
        this.mPlz = plz;
    }

    public String getPostfachnr() {
        return this.mPostfachnr;
    }

    public void setPostfachnr(String postfachnr) {
        this.mPostfachnr = postfachnr;
    }

    public String getStadt() {
        return this.mStadt;
    }

    public void setStadt(String stadt) {
        this.mStadt = stadt;
    }

    public String getStrasse() {
        return this.mStrasse;
    }

    public void setStrasse(String strasse) {
        this.mStrasse = strasse;
    }

    public String getVorname() {
        return this.mVorname;
    }

    public void setVorname(String vorname) {
        this.mVorname = vorname;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public void setEmail(String email) {
        this.mEmail = email;
    }

    public String getFaxnummer() {
        return this.mFaxnummer;
    }

    public void setFaxnummer(String faxnummer) {
        this.mFaxnummer = faxnummer;
    }

    public String getMobilnummer() {
        return this.mMobilnummer;
    }

    public void setMobilnummer(String mobilnummer) {
        this.mMobilnummer = mobilnummer;
    }

    public String getTelefonnummer() {
        return this.mTelefonnummer;
    }

    public void setTelefonnummer(String telefonnummer) {
        this.mTelefonnummer = telefonnummer;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.kundenId;
        result = 31 * result + (this.mKundennummer == null ? 0 : this.mKundennummer.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Kunde other = (Kunde)obj;
        if (this.kundenId != other.kundenId) {
            return false;
        }
        if (this.mKundennummer != other.mKundennummer) {
            return false;
        }
        return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int reihenfolge) {
        StringBuffer sb = new StringBuffer();
        if (reihenfolge == 1) {
            sb.append(this.mName);
            if (this.mVorname != null) {
                sb.append(seperator);
                sb.append(this.mVorname);
            }
            if (this.mKundennummer != null) {
                sb.append(seperator);
                sb.append(this.mKundennummer);
            }
        } else {
            if (this.mKundennummer != null) {
                sb.append(this.mKundennummer);
            }
            sb.append(seperator);
            sb.append(this.mName);
            if (this.mVorname != null) {
                sb.append(seperator);
                sb.append(this.mVorname);
            }
        }
        if (this.mStrasse != null) {
            sb.append(seperator);
            sb.append(this.mStrasse);
            if (this.mHausnr != null) {
                sb.append(" ");
                sb.append(this.mHausnr);
            }
        }
        if (this.mStadt != null) {
            sb.append(seperator);
            if (this.mPlz != null) {
                sb.append(this.mPlz);
                sb.append(" ");
            }
            sb.append(this.mStadt);
        }
        return sb.toString();
    }
}

