/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import webetk.app.Bedingungsmenge;
import webetk.app.ausstattung.Ausstattung;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.communication.JavaSucheInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JavaFzgSucheInfo
extends JavaSucheInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private long mlModellspalte = 0L;
    @XmlElement
    private String msFzgIdString = null;
    @XmlElement
    private String msLenkung = null;
    @XmlElement
    private String msGetriebe = null;
    @XmlElement
    private String msBaujahr = null;
    @XmlElement
    private String msZulassungsmonat = null;
    @XmlElement
    private String msProduktionsdatum = null;
    @XmlElement
    private boolean mbGraphicSearch = false;
    @XmlElement
    private String msFgstNr = null;
    @XmlElement
    private String msWerk = null;
    @XmlElements(value={@XmlElement(type=String.class)})
    private Collection<String> mcTypmenge;
    @XmlElement
    private Bedingungsmenge moBedingungswerte;
    @XmlElement
    private Bedingungsmenge moBedingungswerte_BTE;
    @XmlElement
    private Ausstattung mAusstattung = null;
    @XmlElement
    private boolean mbIGDOMFehler = false;
    @XmlElement
    private boolean mbVINSpecFehler = false;
    @XmlElement
    private boolean mbSOWUFehler = false;

    public JavaFzgSucheInfo() {
    }

    public JavaFzgSucheInfo(FzgSucheInfo oFzgSucheInfo) {
        super(oFzgSucheInfo);
        this.mlModellspalte = oFzgSucheInfo.getModellspalte();
        this.msFzgIdString = oFzgSucheInfo.getFzgIdString();
        this.msLenkung = oFzgSucheInfo.getLenkung();
        this.msGetriebe = oFzgSucheInfo.getGetriebe();
        this.msBaujahr = oFzgSucheInfo.getBaujahr();
        this.msZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
        this.msProduktionsdatum = oFzgSucheInfo.getProduktionsdatum();
        this.mbGraphicSearch = oFzgSucheInfo.getGraphicSearch();
        this.msFgstNr = oFzgSucheInfo.getFahrgestellnummer();
        this.msWerk = oFzgSucheInfo.getWerk();
        this.mcTypmenge = oFzgSucheInfo.getTypmenge();
        this.mAusstattung = oFzgSucheInfo.getAusstattung();
        this.moBedingungswerte = oFzgSucheInfo.getBedingungsMenge();
        this.moBedingungswerte_BTE = oFzgSucheInfo.getBedingungsMenge_BTE();
        this.mbIGDOMFehler = oFzgSucheInfo.getIGDOMFehler();
        this.mbVINSpecFehler = oFzgSucheInfo.getVINSpecFehler();
        this.mbSOWUFehler = oFzgSucheInfo.getSOWUFehler();
    }

    public boolean getGraphicSearch() {
        return this.mbGraphicSearch;
    }

    public long getModellspalte() {
        return this.mlModellspalte;
    }

    public String getFzgIdString() {
        return this.msFzgIdString;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public String getGetriebe() {
        return this.msGetriebe;
    }

    public String getBaujahr() {
        return this.msBaujahr;
    }

    public String getZulassungsmonat() {
        return this.msZulassungsmonat;
    }

    public String getProduktionsdatum() {
        return this.msProduktionsdatum;
    }

    public String getFahrgestellnummer() {
        return this.msFgstNr;
    }

    public String getWerk() {
        return this.msWerk;
    }

    public String getProduktionsdatumFuerFIString() {
        if (this.msProduktionsdatum != null) {
            return this.msProduktionsdatum.substring(5, 7) + "/" + this.msProduktionsdatum.substring(0, 4);
        }
        if (this.msBaujahr != null && this.msZulassungsmonat != null) {
            return this.msZulassungsmonat + "/" + this.msBaujahr;
        }
        return null;
    }

    public String getProduktionsdatum(boolean bTagesgenau) {
        if (this.msProduktionsdatum != null && bTagesgenau) {
            return this.msProduktionsdatum;
        }
        if (this.msProduktionsdatum != null && !bTagesgenau) {
            return this.msProduktionsdatum.substring(0, 4) + this.msProduktionsdatum.substring(5, 7) + "00";
        }
        if (this.msBaujahr != null && this.msZulassungsmonat != null) {
            return this.msBaujahr + this.msZulassungsmonat + "00";
        }
        return null;
    }

    public boolean isProduktionsdatumTagesgenau() {
        return this.msProduktionsdatum != null && this.msProduktionsdatum.length() == 8;
    }

    public Bedingungsmenge getBedingungsMenge() {
        return this.moBedingungswerte;
    }

    public Bedingungsmenge getBedingungsMenge_BTE() {
        return this.moBedingungswerte_BTE;
    }

    public Collection<String> getTypmenge() {
        return this.mcTypmenge;
    }

    public Ausstattung getAusstattung() {
        return this.mAusstattung;
    }

    public boolean getIGDOMFehler() {
        return this.mbIGDOMFehler;
    }

    public boolean getVINSpecFehler() {
        return this.mbVINSpecFehler;
    }

    public boolean getSOWUFehler() {
        return this.mbSOWUFehler;
    }

    public void uebernehmenBedingungen(JavaFzgSucheInfo oFzgSucheInfoSrc) {
        this.moBedingungswerte = oFzgSucheInfoSrc.getBedingungsMenge();
    }

    public void uebernehmenBedingungen_BTE(JavaFzgSucheInfo oFzgSucheInfoSrc) {
        this.moBedingungswerte_BTE = oFzgSucheInfoSrc.getBedingungsMenge_BTE();
    }

    public String printOut() {
        return "mAusstattung: " + this.mAusstattung + "mbGraphicSearch: " + this.mbGraphicSearch + "mbIGDOMFehler: " + this.mbIGDOMFehler + " mbSOWUFehler: " + this.mbSOWUFehler + " mbVINSpecFehler: " + this.mbVINSpecFehler + " mcTypmenge: " + this.mcTypmenge + " mlModellspalte: " + this.mlModellspalte + " moBedingungswerte: " + this.moBedingungswerte + " msBaujahr: " + this.msBaujahr + " msFgstNr: " + this.msFgstNr + " msFzgIdString: " + this.msFzgIdString + " msGetriebe: " + this.msGetriebe + " msLenkung: " + this.msLenkung + " msProduktionsdatum: " + this.msProduktionsdatum + " msWerk: " + this.msWerk + " msZulassungsmonat: " + this.msZulassungsmonat;
    }

    public long getMlModellspalte() {
        return this.mlModellspalte;
    }

    public String getMsFzgIdString() {
        return this.msFzgIdString;
    }

    public String getMsLenkung() {
        return this.msLenkung;
    }

    public String getMsGetriebe() {
        return this.msGetriebe;
    }

    public String getMsBaujahr() {
        return this.msBaujahr;
    }

    public String getMsZulassungsmonat() {
        return this.msZulassungsmonat;
    }

    public String getMsProduktionsdatum() {
        return this.msProduktionsdatum;
    }

    public boolean isMbGraphicSearch() {
        return this.mbGraphicSearch;
    }

    public String getMsFgstNr() {
        return this.msFgstNr;
    }

    public String getMsWerk() {
        return this.msWerk;
    }

    public Collection<String> getMcTypmenge() {
        return this.mcTypmenge;
    }

    public Bedingungsmenge getMoBedingungswerte() {
        return this.moBedingungswerte;
    }

    public Bedingungsmenge getMoBedingungswerte_BTE() {
        return this.moBedingungswerte_BTE;
    }

    public Ausstattung getmAusstattung() {
        return this.mAusstattung;
    }

    public boolean isMbIGDOMFehler() {
        return this.mbIGDOMFehler;
    }

    public boolean isMbVINSpecFehler() {
        return this.mbVINSpecFehler;
    }

    public boolean isMbSOWUFehler() {
        return this.mbSOWUFehler;
    }

    public void setMlModellspalte(long mlModellspalte) {
        this.mlModellspalte = mlModellspalte;
    }

    public void setMsFzgIdString(String msFzgIdString) {
        this.msFzgIdString = msFzgIdString;
    }

    public void setMsLenkung(String msLenkung) {
        this.msLenkung = msLenkung;
    }

    public void setMsGetriebe(String msGetriebe) {
        this.msGetriebe = msGetriebe;
    }

    public void setMsBaujahr(String msBaujahr) {
        this.msBaujahr = msBaujahr;
    }

    public void setMsZulassungsmonat(String msZulassungsmonat) {
        this.msZulassungsmonat = msZulassungsmonat;
    }

    public void setMsProduktionsdatum(String msProduktionsdatum) {
        this.msProduktionsdatum = msProduktionsdatum;
    }

    public void setMbGraphicSearch(boolean mbGraphicSearch) {
        this.mbGraphicSearch = mbGraphicSearch;
    }

    public void setMsFgstNr(String msFgstNr) {
        this.msFgstNr = msFgstNr;
    }

    public void setMsWerk(String msWerk) {
        this.msWerk = msWerk;
    }

    public void setMcTypmenge(Collection<String> mcTypmenge) {
        this.mcTypmenge = mcTypmenge;
    }

    public void setMoBedingungswerte(Bedingungsmenge moBedingungswerte) {
        this.moBedingungswerte = moBedingungswerte;
    }

    public void setMoBedingungswerte_BTE(Bedingungsmenge moBedingungswerte_BTE) {
        this.moBedingungswerte_BTE = moBedingungswerte_BTE;
    }

    public void setmAusstattung(Ausstattung mAusstattung) {
        this.mAusstattung = mAusstattung;
    }

    public void setMbIGDOMFehler(boolean mbIGDOMFehler) {
        this.mbIGDOMFehler = mbIGDOMFehler;
    }

    public void setMbVINSpecFehler(boolean mbVINSpecFehler) {
        this.mbVINSpecFehler = mbVINSpecFehler;
    }

    public void setMbSOWUFehler(boolean mbSOWUFehler) {
        this.mbSOWUFehler = mbSOWUFehler;
    }
}

