/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.utils;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class AllowAllTrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Logger log = Logger.getLogger(AllowAllTrustManager.class);

    public AllowAllTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        log.debug((Object)"Initialising the AllowAllTrustManager.");
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            log.fatal((Object)"The SunX509 trust manager is not supported!");
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        log.debug((Object)("We allow the client certificates: " + arg1));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        log.debug((Object)("We allow the server certificates: " + arg1));
    }
}

