/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import webetk.communication.utils.AllowAllTrustManager;

public class EasySSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger log = Logger.getLogger(EasySSLProtocolSocketFactory.class);

    private static SSLSocketFactory getEasySSLSocketFactory() {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new AllowAllTrustManager(null)}, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return context.getSocketFactory();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        log.debug((Object)("Creating Socket for host: " + host + " on port: " + Integer.toString(port)));
        return EasySSLProtocolSocketFactory.getEasySSLSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        if (log.isDebugEnabled()) {
            StringBuffer sMsg = new StringBuffer("Creating Socket for host: ");
            sMsg.append(host).append(", port: ").append(port).append(", client:").append(clientHost).append("/").append(clientPort);
            log.debug((Object)sMsg);
        }
        return EasySSLProtocolSocketFactory.getEasySSLSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        log.debug((Object)("Creating Socket for host: " + host + " on port: " + Integer.toString(port)));
        return EasySSLProtocolSocketFactory.getEasySSLSocketFactory().createSocket(host, port);
    }
}

