/*
 * Decompiled with CFR 0.152.
 */
package webetk.db;

import org.apache.log4j.Logger;
import webetk.db.ClassLoaderUtil;
import webetk.db.SQLStatements;
import webetk.db.zub.SQLStatements;

public class DbQueryConfigurator {
    private static final Logger log = Logger.getLogger(DbQueryConfigurator.class);

    public void configure() {
        this.configureQueryClasses();
        this.configureZubQueryClasses();
    }

    private void configureQueryClasses() {
        String dbEnv = "".equals(SQLStatements.getDbEnv()) ? "Transbase" : SQLStatements.getDbEnv();
        log.info((Object)("configuring DB queries for DB evnironment " + dbEnv));
        String packageAndCLassPrefix = SQLStatements.getPackageAndClassPrefix();
        ClassLoaderUtil classLoaderUtil = new ClassLoaderUtil(dbEnv, packageAndCLassPrefix);
        SQLStatements.Allgemein.instance = (SQLStatements.Allgemein)classLoaderUtil.createInstance(SQLStatements.Allgemein.class);
        SQLStatements.Wertebereiche.instance = (SQLStatements.Wertebereiche)classLoaderUtil.createInstance(SQLStatements.Wertebereiche.class);
        SQLStatements.Einstellungen.instance = (SQLStatements.Einstellungen)classLoaderUtil.createInstance(SQLStatements.Einstellungen.class);
        SQLStatements.FzgIdentifikation.instance = (SQLStatements.FzgIdentifikation)classLoaderUtil.createInstance(SQLStatements.FzgIdentifikation.class);
        SQLStatements.FzgUmfang.instance = (SQLStatements.FzgUmfang)classLoaderUtil.createInstance(SQLStatements.FzgUmfang.class);
        SQLStatements.TeilesucheSpezifischValueLineFzg.instance = (SQLStatements.TeilesucheSpezifischValueLineFzg)classLoaderUtil.createInstance(SQLStatements.TeilesucheSpezifischValueLineFzg.class);
        SQLStatements.TeilesucheFzg.instance = (SQLStatements.TeilesucheFzg)classLoaderUtil.createInstance(SQLStatements.TeilesucheFzg.class);
        SQLStatements.TeilesucheAllgemein.instance = (SQLStatements.TeilesucheAllgemein)classLoaderUtil.createInstance(SQLStatements.TeilesucheAllgemein.class);
        SQLStatements.TeilesucheAss.instance = (SQLStatements.TeilesucheAss)classLoaderUtil.createInstance(SQLStatements.TeilesucheAss.class);
        SQLStatements.Teileinfo.instance = (SQLStatements.Teileinfo)classLoaderUtil.createInstance(SQLStatements.Teileinfo.class);
        SQLStatements.TeileinfoHTML.instance = (SQLStatements.TeileinfoHTML)classLoaderUtil.createInstance(SQLStatements.TeileinfoHTML.class);
        SQLStatements.TeileinfoJAVA.instance = (SQLStatements.TeileinfoJAVA)classLoaderUtil.createInstance(SQLStatements.TeileinfoJAVA.class);
        SQLStatements.BedAuswertung.instance = (SQLStatements.BedAuswertung)classLoaderUtil.createInstance(SQLStatements.BedAuswertung.class);
        SQLStatements.BteAnzeige.instance = (SQLStatements.BteAnzeige)classLoaderUtil.createInstance(SQLStatements.BteAnzeige.class);
        SQLStatements.Teileliste.instance = (SQLStatements.Teileliste)classLoaderUtil.createInstance(SQLStatements.Teileliste.class);
        SQLStatements.TeilelisteHTML.instance = (SQLStatements.TeilelisteHTML)classLoaderUtil.createInstance(SQLStatements.TeilelisteHTML.class);
        SQLStatements.TeilelisteJAVA.instance = (SQLStatements.TeilelisteJAVA)classLoaderUtil.createInstance(SQLStatements.TeilelisteJAVA.class);
        SQLStatements.TeilelisteHTML_SAP.instance = (SQLStatements.TeilelisteHTML_SAP)classLoaderUtil.createInstance(SQLStatements.TeilelisteHTML_SAP.class);
        SQLStatements.TeilelisteJAVA_SAP.instance = (SQLStatements.TeilelisteJAVA_SAP)classLoaderUtil.createInstance(SQLStatements.TeilelisteJAVA_SAP.class);
        SQLStatements.BTEInfo.instance = (SQLStatements.BTEInfo)classLoaderUtil.createInstance(SQLStatements.BTEInfo.class);
        SQLStatements.Polstercode.instance = (SQLStatements.Polstercode)classLoaderUtil.createInstance(SQLStatements.Polstercode.class);
        SQLStatements.Interpretation.instance = (SQLStatements.Interpretation)classLoaderUtil.createInstance(SQLStatements.Interpretation.class);
        SQLStatements.SatzEinzelteile.instance = (SQLStatements.SatzEinzelteile)classLoaderUtil.createInstance(SQLStatements.SatzEinzelteile.class);
        SQLStatements.Aspg.instance = (SQLStatements.Aspg)classLoaderUtil.createInstance(SQLStatements.Aspg.class);
        SQLStatements.ValueLine.instance = (SQLStatements.ValueLine)classLoaderUtil.createInstance(SQLStatements.ValueLine.class);
        SQLStatements.Teileersetzung.instance = (SQLStatements.Teileersetzung)classLoaderUtil.createInstance(SQLStatements.Teileersetzung.class);
        SQLStatements.VisualisierungTeil.instance = (SQLStatements.VisualisierungTeil)classLoaderUtil.createInstance(SQLStatements.VisualisierungTeil.class);
        SQLStatements.TeileverwendungReduziert.instance = (SQLStatements.TeileverwendungReduziert)classLoaderUtil.createInstance(SQLStatements.TeileverwendungReduziert.class);
        SQLStatements.TeilevwdgFzg.instance = (SQLStatements.TeilevwdgFzg)classLoaderUtil.createInstance(SQLStatements.TeilevwdgFzg.class);
        SQLStatements.TechnischeLiteratur.instance = (SQLStatements.TechnischeLiteratur)classLoaderUtil.createInstance(SQLStatements.TechnischeLiteratur.class);
        SQLStatements.Erstbevorratung.instance = (SQLStatements.Erstbevorratung)classLoaderUtil.createInstance(SQLStatements.Erstbevorratung.class);
        SQLStatements.Lagerzeit.instance = (SQLStatements.Lagerzeit)classLoaderUtil.createInstance(SQLStatements.Lagerzeit.class);
        SQLStatements.Notizuebersicht.instance = (SQLStatements.Notizuebersicht)classLoaderUtil.createInstance(SQLStatements.Notizuebersicht.class);
        SQLStatements.NotizuebersichtHTML.instance = (SQLStatements.NotizuebersichtHTML)classLoaderUtil.createInstance(SQLStatements.NotizuebersichtHTML.class);
        SQLStatements.NotizuebersichtJAVA.instance = (SQLStatements.NotizuebersichtJAVA)classLoaderUtil.createInstance(SQLStatements.NotizuebersichtJAVA.class);
        SQLStatements.Normteile.instance = (SQLStatements.Normteile)classLoaderUtil.createInstance(SQLStatements.Normteile.class);
        SQLStatements.Fuellmengen.instance = (SQLStatements.Fuellmengen)classLoaderUtil.createInstance(SQLStatements.Fuellmengen.class);
        SQLStatements.Federtabelle.instance = (SQLStatements.Federtabelle)classLoaderUtil.createInstance(SQLStatements.Federtabelle.class);
        SQLStatements.TeilevwdgTeil.instance = (SQLStatements.TeilevwdgTeil)classLoaderUtil.createInstance(SQLStatements.TeilevwdgTeil.class);
        SQLStatements.TeilevwdgBen.instance = (SQLStatements.TeilevwdgBen)classLoaderUtil.createInstance(SQLStatements.TeilevwdgBen.class);
        SQLStatements.Hilfe.instance = (SQLStatements.Hilfe)classLoaderUtil.createInstance(SQLStatements.Hilfe.class);
        SQLStatements.Firmenkonfiguration.instance = (SQLStatements.Firmenkonfiguration)classLoaderUtil.createInstance(SQLStatements.Firmenkonfiguration.class);
        SQLStatements.News.instance = (SQLStatements.News)classLoaderUtil.createInstance(SQLStatements.News.class);
        SQLStatements.Infotool.instance = (SQLStatements.Infotool)classLoaderUtil.createInstance(SQLStatements.Infotool.class);
        SQLStatements.Admintool.instance = (SQLStatements.Admintool)classLoaderUtil.createInstance(SQLStatements.Admintool.class);
        SQLStatements.LoginInfo.instance = (SQLStatements.LoginInfo)classLoaderUtil.createInstance(SQLStatements.LoginInfo.class);
        SQLStatements.TabellenKonfiguration.instance = (SQLStatements.TabellenKonfiguration)classLoaderUtil.createInstance(SQLStatements.TabellenKonfiguration.class);
        SQLStatements.MailOptions.instance = (SQLStatements.MailOptions)classLoaderUtil.createInstance(SQLStatements.MailOptions.class);
        SQLStatements.PerformanceLog.instance = (SQLStatements.PerformanceLog)classLoaderUtil.createInstance(SQLStatements.PerformanceLog.class);
        SQLStatements.ETKTexte.instance = (SQLStatements.ETKTexte)classLoaderUtil.createInstance(SQLStatements.ETKTexte.class);
    }

    private void configureZubQueryClasses() {
        String dbEnvOrig = webetk.db.zub.SQLStatements.getDbEnv();
        String dbEnv = "".equals(dbEnvOrig) ? "Transbase" : dbEnvOrig;
        log.info((Object)("configuring IPAC DB queries for DB evnironment " + dbEnv));
        String packageAndCLassPrefix = webetk.db.zub.SQLStatements.getPackageAndClassPrefix();
        ClassLoaderUtil classLoaderUtil = new ClassLoaderUtil(dbEnv, packageAndCLassPrefix);
        SQLStatements.Listenfueller.instance = (SQLStatements.Listenfueller)classLoaderUtil.createInstance(SQLStatements.Listenfueller.class);
        SQLStatements.FahrzeugIdentifikation.instance = (SQLStatements.FahrzeugIdentifikation)classLoaderUtil.createInstance(SQLStatements.FahrzeugIdentifikation.class);
        SQLStatements.KundenIdentifikation.instance = (SQLStatements.KundenIdentifikation)classLoaderUtil.createInstance(SQLStatements.KundenIdentifikation.class);
        SQLStatements.ProduktSuche.instance = (SQLStatements.ProduktSuche)classLoaderUtil.createInstance(SQLStatements.ProduktSuche.class);
        SQLStatements.MarketingSicht.instance = (SQLStatements.MarketingSicht)classLoaderUtil.createInstance(SQLStatements.MarketingSicht.class);
        SQLStatements.TechnischeSicht.instance = (SQLStatements.TechnischeSicht)classLoaderUtil.createInstance(SQLStatements.TechnischeSicht.class);
        SQLStatements.AnfrageVorgangsHelper.instance = (SQLStatements.AnfrageVorgangsHelper)classLoaderUtil.createInstance(SQLStatements.AnfrageVorgangsHelper.class);
        SQLStatements.AngebotsHelper.instance = (SQLStatements.AngebotsHelper)classLoaderUtil.createInstance(SQLStatements.AngebotsHelper.class);
        SQLStatements.KonfigurationsHelper.instance = (SQLStatements.KonfigurationsHelper)classLoaderUtil.createInstance(SQLStatements.KonfigurationsHelper.class);
        SQLStatements.Preise.instance = (SQLStatements.Preise)classLoaderUtil.createInstance(SQLStatements.Preise.class);
        SQLStatements.Verwaltung.instance = (SQLStatements.Verwaltung)classLoaderUtil.createInstance(SQLStatements.Verwaltung.class);
        SQLStatements.Admin.instance = (SQLStatements.Admin)classLoaderUtil.createInstance(SQLStatements.Admin.class);
        SQLStatements.BestehendeAnfrage.instance = (SQLStatements.BestehendeAnfrage)classLoaderUtil.createInstance(SQLStatements.BestehendeAnfrage.class);
        SQLStatements.BestehendeAngebote.instance = (SQLStatements.BestehendeAngebote)classLoaderUtil.createInstance(SQLStatements.BestehendeAngebote.class);
        SQLStatements.Texte.instance = (SQLStatements.Texte)classLoaderUtil.createInstance(SQLStatements.Texte.class);
        SQLStatements.Nutzer.instance = (SQLStatements.Nutzer)classLoaderUtil.createInstance(SQLStatements.Nutzer.class);
    }
}

