/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.InvalidDataException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.Markt;
import webetk.app.settings.Einstellungen;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class SettingsDbAccess {
    private static Logger log = Logger.getLogger(SettingsDbAccess.class);
    public static final String[] vinSecurityExcludingUsers = new String[]{"bm111111", "io111111", "io222222", "io333333", "eu000000", "eu111111", "eu222222", "eu333333", "eu444444", "eu555555", "eu666666", "eu888888"};

    public static ResultSet loadSettings(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_EINSTELLUNGEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaID);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
            ps.setString(1, sNutzerID);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        if (sFirmaID != null) {
            sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_EINSTELLUNGEN_JAVA();
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaID);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadMarktId(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = null;
        if (sFirmaID == null) {
            return null;
        }
        sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_EINSTELLUNGEN_MARKTID_JAVA();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaID);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadIpacMarkt(Connection con, int id) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_IPAC_MARKT();
        String sId = Integer.toString(id);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void updateMarktId(Connection con, String firmaID, int marktId) throws SQLException, InvalidDataException {
        String sqlStatement = SQLStatements.Einstellungen.instance.UPDATE_MARKTID();
        PreparedStatement stat = con.prepareStatement(sqlStatement);
        stat.setInt(1, marktId);
        if (firmaID == null) {
            throw new InvalidDataException("The parameter firmaID cannot be null");
        }
        stat.setString(2, firmaID);
        stat.setNull(3, 12);
        stat.executeUpdate();
        stat.close();
    }

    public static void updateMarktId(Connection con, String firmaID, String userID, int marktId) throws SQLException, InvalidDataException {
        String sqlStatement = SQLStatements.Einstellungen.instance.UPDATE_MARKTID();
        PreparedStatement stat = con.prepareStatement(sqlStatement);
        stat.setInt(1, marktId);
        if (firmaID == null) {
            stat.setNull(2, 12);
        } else {
            stat.setString(3, firmaID);
        }
        if (userID == null) {
            throw new InvalidDataException("The parameter userID cannot be null");
        }
        stat.setString(3, userID);
        stat.executeUpdate();
        stat.close();
    }

    public static ResultSet loadMaerkteEtkLokaleProdukte(Connection con, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_MAERKTE_ETK_LOKALE_PRODUKTE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setInt(1, 0);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadEtkMarkt(Connection con, int id, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_ETK_MARKT();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sId = Integer.toString(id);
            ps.setString(1, sId);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        String sId = Integer.toString(id);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sId);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadUserWeitereMaerkte(Connection con, String firmaID, String userID, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_WEITERE_MAERKTE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(userID));
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(userID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(firmaID));
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadUserRegionen(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_EINSTELLUNGEN_REGIONEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sNutzerID);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        if (sFirmaID != null) {
            sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_EINSTELLUNGEN_REGIONEN_JAVA();
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaID);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void saveSettings(Connection con, String sNutzerId, Einstellungen cSettings) throws SQLException {
        try {
            int id;
            con.setAutoCommit(false);
            String sRegion2 = "";
            sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
            String sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_EINSTELLUNGEN_REGIONEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_EINSTELLUNGEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.Einstellungen.instance.INSERT_EINSTELLUNGEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
            String sWert = cSettings.getMarke();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sWert);
            sWert = cSettings.getProduktart();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sWert);
            sWert = cSettings.getLenkung();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sWert);
            sWert = cSettings.getKatalogumfang();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sWert);
            sWert = cSettings.getSprache();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sWert);
            sWert = cSettings.getSpracheRegion();
            if (sWert == null || sWert.equals("")) {
                sWert = "  ";
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sWert);
            sSQLStatement = cSettings.getDarstellungBN() ? StringUtils.substituteString(sSQLStatement, "EXPAND_BNB", "J") : StringUtils.substituteString(sSQLStatement, "EXPAND_BNB", "N");
            sSQLStatement = cSettings.getSuchwegVerkuerzen() ? StringUtils.substituteString(sSQLStatement, "SHORT_SEARCHPATH", "J") : StringUtils.substituteString(sSQLStatement, "SHORT_SEARCHPATH", "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "VERBAUMENGE", cSettings.getVerbaumenge() ? "J" : "N");
            sSQLStatement = cSettings.getNachruestungenRelevant() ? StringUtils.substituteString(sSQLStatement, "REQUEST_SAZ", "J") : StringUtils.substituteString(sSQLStatement, "REQUEST_SAZ", "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "VERBAUMENGE", cSettings.getVerbaumenge() ? "J" : "N");
            String vinBlockRequired = null;
            boolean isExcludingUsers = Arrays.asList(vinSecurityExcludingUsers).contains(sNutzerId);
            if (isExcludingUsers) {
                vinBlockRequired = "N";
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "VINBLOCKREQUIRED", vinBlockRequired);
            sSQLStatement = cSettings.getAlwaysDisplayProduktDate() != null ? (cSettings.getAlwaysDisplayProduktDate().booleanValue() ? StringUtils.substituteString(sSQLStatement, "SHOW_PRODDATE", "'J'") : StringUtils.substituteString(sSQLStatement, "SHOW_PRODDATE", "'N'")) : StringUtils.substituteString(sSQLStatement, "SHOW_PRODDATE", "NULL");
            sSQLStatement = cSettings.getEtkPrimaerMarkt() != null ? ((id = cSettings.getEtkPrimaerMarkt().getMarktId()) > 0 ? StringUtils.substituteString(sSQLStatement, "PRIMAER_MARKT_ID", Integer.toString(id)) : StringUtils.substituteString(sSQLStatement, "PRIMAER_MARKT_ID", "NULL")) : StringUtils.substituteString(sSQLStatement, "PRIMAER_MARKT_ID", "NULL");
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            for (String sRegion2 : cSettings.getRegionen()) {
                sSQLStatement = SQLStatements.Einstellungen.instance.INSERT_EINSTELLUNGEN_REGIONEN();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion2);
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_WEITERE_MAERKTE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (cSettings.getEtkSonstigeMaerkte() != null) {
                for (Markt markt : cSettings.getEtkSonstigeMaerkte()) {
                    sSQLStatement = SQLStatements.Einstellungen.instance.INSERT_WEITERE_MAERKTE();
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sNutzerId);
                    int id2 = markt.getMarktId();
                    if (id2 > 0) {
                        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKTID", Integer.toString(id2));
                    }
                    log.debug((Object)("Executing: " + sSQLStatement));
                    stmt = con.createStatement();
                    stmt.executeUpdate(sSQLStatement);
                    stmt.close();
                }
            }
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static void saveSettings(Connection con, String sFirmaId, String sNutzerId, Einstellungen cSettings) throws SQLException {
        try {
            int id;
            con.setAutoCommit(false);
            String sRegion2 = "";
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
            String sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_EINSTELLUNGEN_REGIONEN_JAVA();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_EINSTELLUNGEN_JAVA();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.Einstellungen.instance.INSERT_EINSTELLUNGEN_JAVA();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
            String sWert = cSettings.getMarke();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sWert);
            sWert = cSettings.getProduktart();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sWert);
            sWert = cSettings.getLenkung();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sWert);
            sWert = cSettings.getKatalogumfang();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sWert);
            sWert = cSettings.getSprache();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sWert);
            sWert = cSettings.getSpracheRegion();
            if (sWert == null) {
                sWert = "  ";
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sWert);
            sSQLStatement = cSettings.getDarstellungBN() ? StringUtils.substituteString(sSQLStatement, "EXPAND_BNB", "J") : StringUtils.substituteString(sSQLStatement, "EXPAND_BNB", "N");
            sSQLStatement = cSettings.getSuchwegVerkuerzen() ? StringUtils.substituteString(sSQLStatement, "SHORT_SEARCHPATH", "J") : StringUtils.substituteString(sSQLStatement, "SHORT_SEARCHPATH", "N");
            sSQLStatement = cSettings.getNachruestungenRelevant() ? StringUtils.substituteString(sSQLStatement, "REQUEST_SAZ", "J") : StringUtils.substituteString(sSQLStatement, "REQUEST_SAZ", "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TABLESTRETCH", cSettings.getTabellenanzeige());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FONTSIZE", cSettings.getSchriftgroesse());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHRAUM", cSettings.getSuchraum());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "VERBAUMENGE", cSettings.getVerbaumenge() ? "J" : "N");
            sSQLStatement = cSettings.getAlwaysDisplayProduktDate() != null ? (cSettings.getAlwaysDisplayProduktDate().booleanValue() ? StringUtils.substituteString(sSQLStatement, "SHOW_PRODDATE", "'J'") : StringUtils.substituteString(sSQLStatement, "SHOW_PRODDATE", "'N'")) : StringUtils.substituteString(sSQLStatement, "SHOW_PRODDATE", "NULL");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFBEWAHRUNG", "N");
            sSQLStatement = cSettings.getDisplayPreise() != null ? (cSettings.getDisplayPreise().booleanValue() ? StringUtils.substituteString(sSQLStatement, "SHOW_PREISE", "'J'") : StringUtils.substituteString(sSQLStatement, "SHOW_PREISE", "'N'")) : StringUtils.substituteString(sSQLStatement, "SHOW_PREISE", "NULL");
            boolean bDisplayTippsTricks = cSettings.displayTippsTricks();
            sSQLStatement = bDisplayTippsTricks ? StringUtils.substituteString(sSQLStatement, "SHOW_TIPPS", "'J'") : StringUtils.substituteString(sSQLStatement, "SHOW_TIPPS", "'N'");
            sSQLStatement = cSettings.getEtkPrimaerMarkt() != null ? ((id = cSettings.getEtkPrimaerMarkt().getMarktId()) > 0 ? StringUtils.substituteString(sSQLStatement, "PRIMAER_MARKT_ID", Integer.toString(id)) : StringUtils.substituteString(sSQLStatement, "PRIMAER_MARKT_ID", "NULL")) : StringUtils.substituteString(sSQLStatement, "PRIMAER_MARKT_ID", "NULL");
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            for (String sRegion2 : cSettings.getRegionen()) {
                sSQLStatement = SQLStatements.Einstellungen.instance.INSERT_EINSTELLUNGEN_REGIONEN_JAVA();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion2);
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_WEITERE_MAERKTE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (cSettings.getEtkSonstigeMaerkte() != null) {
                for (Markt markt : cSettings.getEtkSonstigeMaerkte()) {
                    sSQLStatement = SQLStatements.Einstellungen.instance.INSERT_WEITERE_MAERKTE();
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sNutzerId);
                    int id2 = markt.getMarktId();
                    if (id2 > 0) {
                        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKTID", Integer.toString(id2));
                    }
                    log.debug((Object)("Executing: " + sSQLStatement));
                    stmt = con.createStatement();
                    stmt.executeUpdate(sSQLStatement);
                    stmt.close();
                }
            }
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkModellspalte(Connection con, Einstellungen cSettings) throws SQLException {
        ResultSet res;
        String sWert;
        block17: {
            boolean bl;
            String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_COUNT_MODSPALTEN();
            if (HtmlUtils.isConnectionSourceOracle(con)) {
                int index = 0;
                String sWert2 = cSettings.getMarke();
                StringUtils.setPreparedStatementParams(++index, sWert2);
                sWert2 = cSettings.getProduktart();
                StringUtils.setPreparedStatementParams(++index, sWert2);
                sWert2 = cSettings.getLenkung();
                if (sWert2.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Einstellungen.instance.RETRIEVE_COUNT_MODSPALTEN_LENKUNG());
                    StringUtils.setPreparedStatementParams(++index, sWert2);
                }
                sWert2 = cSettings.getKatalogumfang();
                StringUtils.setPreparedStatementParams(++index, sWert2);
                Vector<String> cRegionen = cSettings.getRegionen();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cSettings.getRegionen().size()));
                for (String sRegionen : cRegionen) {
                    StringUtils.setPreparedStatementParams(++index, sRegionen);
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug((Object)("Executing: " + sSQLStatement));
                ResultSet res2 = null;
                try {
                    res2 = ps.executeQuery();
                    if (res2 == null || !res2.next()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    sWert2 = res2.getString(1);
                }
                finally {
                    WebetkUtils.closeQuery(res2);
                }
                return !sWert2.equals("0");
            }
            sWert = cSettings.getMarke();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sWert);
            sWert = cSettings.getProduktart();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sWert);
            sWert = cSettings.getLenkung();
            if (sWert.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Einstellungen.instance.RETRIEVE_COUNT_MODSPALTEN_LENKUNG());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sWert);
            }
            sWert = cSettings.getKatalogumfang();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sWert);
            String sRegionen = "";
            Iterator<String> iterator = cSettings.getRegionen().iterator();
            while (iterator.hasNext()) {
                if (sRegionen.length() > 0) {
                    sRegionen = sRegionen + ", ";
                }
                sRegionen = sRegionen + "'" + iterator.next() + "'";
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = null;
            res = null;
            try {
                stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (res != null && res.next()) break block17;
                bl = false;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return bl;
        }
        sWert = res.getString(1);
        WebetkUtils.closeQuery(res);
        return !sWert.equals("0");
    }

    public static ResultSet loadSprachen(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_SPRACHEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "S");
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadKatalogausfuehrungen(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_REGIONEN();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadUserRechte(Connection con, String sNutzerID, String sFirmaID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_RECHTE_JAVA();
        sFirmaID = StringUtils.maskiereHochkommaFuerDb(sFirmaID);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static List<String> loadSammelUserRestrictions(Connection con) throws SQLException {
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_SAMMEL_RESTR();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        ArrayList<String> resultList = new ArrayList<String>();
        while (res != null && res.next()) {
            resultList.add(res.getString("SAMMEL_RECHT_ID"));
        }
        WebetkUtils.closeQuery(res);
        return resultList;
    }

    public static ResultSet loadUserRechte(Connection con, String sNutzerID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_RECHTE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
            ps.setString(1, sNutzerID);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadUserBerechtigungen(Connection con, String sFirmaID, String sNutzerID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_BERECHTIGUNGEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaID = StringUtils.maskiereHochkommaFuerDb(sFirmaID);
            sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
            ps.setString(1, sFirmaID);
            ps.setString(2, sNutzerID);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sFirmaID = StringUtils.maskiereHochkommaFuerDb(sFirmaID);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void deleteTeilenotizen(Connection con, String sFirmaID, String sNutzerID) throws SQLException {
        String sSQLStatement = SQLStatements.Einstellungen.instance.DELETE_TEILENOTIZEN_ABGELAUFEN();
        sFirmaID = StringUtils.maskiereHochkommaFuerDb(sFirmaID);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        Date aktDate = Calendar.getInstance().getTime();
        GregorianCalendar objCalendar = new GregorianCalendar();
        objCalendar.setTime(aktDate);
        int nJahr = objCalendar.get(1);
        String sJahr = String.valueOf(nJahr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "JAHR", sJahr);
        int nMonat = objCalendar.get(2) + 1;
        String sMonat = String.valueOf(nMonat);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MONAT", sMonat);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
    }
}

