/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.NoDataFoundException;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TechnischeLiteraturDbAccess {
    private static Logger log = Logger.getLogger(TechnischeLiteraturDbAccess.class);

    public static ResultSet selectFGs(Connection con, String sLang, long lModellspalte, String sMarke, String sProduktart, String sKatalogumfang) throws SQLException, DatabaseBusyException {
        String sSQLStatement = SQLStatements.TechnischeLiteratur.instance.RETRIEVE_FGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(1, sModellspalte);
            ps.setString(2, "01");
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(5, "U");
            ps.setString(6, "01");
            ps.setString(7, sProduktart);
            ps.setString(8, "BE");
            ps.setString(9, sKatalogumfang);
            ps.setString(10, sMarke);
            ps.setString(11, "KONZERN");
            ps.setString(12, sISO);
            ps.setString(13, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogumfang);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectSprachen(Connection con, String sLang) throws SQLException, DatabaseBusyException {
        String sSQLStatement = SQLStatements.TechnischeLiteratur.instance.RETRIEVE_SPRACHEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "T");
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTechnischeLiteratur(Connection con, String sLang, long lModellspalte, String sMarke, String sProduktart, String sKatalogumfang, String sFG, String sLangTL) throws SQLException, DatabaseBusyException, NoDataFoundException {
        String sSQLStatement = SQLStatements.TechnischeLiteratur.instance.LOAD_TECHNISCHE_LITERATUR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, "01");
            StringUtils.setPreparedStatementParams(++index, sFG);
            StringUtils.setPreparedStatementParams(++index, "G");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogumfang);
            StringUtils.setPreparedStatementParams(++index, "--");
            if (sLangTL.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_GEB", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_GEB", SQLStatements.TechnischeLiteratur.instance.TL_SPRACHE_STMT_GEB());
                String sISO_TL = LanguageUtils.toLanguage(sLangTL);
                String sRegISO_TL = LanguageUtils.toRegion(sLangTL, true);
                StringUtils.setPreparedStatementParams(++index, sISO_TL);
                StringUtils.setPreparedStatementParams(++index, sRegISO_TL);
            }
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "01");
            StringUtils.setPreparedStatementParams(++index, sFG);
            StringUtils.setPreparedStatementParams(++index, "G");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogumfang);
            StringUtils.setPreparedStatementParams(++index, "--");
            if (sLangTL.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_UGB", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_UGB", SQLStatements.TechnischeLiteratur.instance.TL_SPRACHE_STMT_UGB());
                String sISO_TL = LanguageUtils.toLanguage(sLangTL);
                String sRegISO_TL = LanguageUtils.toRegion(sLangTL, true);
                StringUtils.setPreparedStatementParams(++index, sISO_TL);
                StringUtils.setPreparedStatementParams(++index, sRegISO_TL);
            }
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1008);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            if (res == null || !res.isBeforeFirst()) {
                throw new NoDataFoundException("No values found");
            }
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogumfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FG", sFG);
        if (sLangTL.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_GEB", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_UGB", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_GEB", SQLStatements.TechnischeLiteratur.instance.TL_SPRACHE_STMT_GEB());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TLSPRACHE_STMT_UGB", SQLStatements.TechnischeLiteratur.instance.TL_SPRACHE_STMT_UGB());
            String sISO_TL = LanguageUtils.toLanguage(sLangTL);
            String sRegISO_TL = LanguageUtils.toRegion(sLangTL, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO_TL", sISO_TL);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO_TL", sRegISO_TL);
        }
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement(1004, 1008);
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.isBeforeFirst()) {
            throw new NoDataFoundException("No values found");
        }
        return res;
    }
}

