/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.zub.dbaccess;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.zub.common.BaseMarketingProdukt;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktId;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.db.zub.SQLStatements;
import webetk.db.zub.dbaccess.SucheDbAccess;
import webetk.db.zub.dbaccess.TechnischDbAccess;
import webetk.utils.StringUtils;

public class MarketingDbAccess {
    static Logger logger = Logger.getLogger(MarketingDbAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MarketingProdukt ermittleMarketingProduktZuBte(String bteNr, String bildPosNr, String produktart, String marke, String katalogUmfang, String regionen, int markt, String iso, String regionIso, boolean isLifestyle) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        MarketingProdukt prod = new MarketingProdukt();
        prod.setBteNr(bteNr);
        if (bildPosNr != null) {
            prod.setBildPosNr(bildPosNr);
        }
        try {
            Zubehoergrafik grafik;
            con = globs.getDBConnection("zub.marketing.AdminToolDbAccess.ermittleMarketingProduktZuBTE");
            MarketingDbAccess.getMarketingInfos(con, prod, markt, iso, regionIso);
            MarketingDbAccess.ermittleBTEArt(con, prod, iso, regionIso);
            MarketingDbAccess.ermittleBnbsZuBte(con, prod, iso, regionIso);
            if (marke.equals("BMW") && produktart.equals("M")) {
                MarketingDbAccess.ermittleBnbMarketingInfos(con, prod, markt, iso, regionIso);
            }
            MarketingDbAccess.ermittleOptionaleProdukte(con, prod, katalogUmfang, regionen, markt, iso, regionIso);
            if (prod.isFahrzeugUngebunden()) {
                MarketingDbAccess.ermittleVarianten_ungebunden(con, prod, markt, iso, regionIso);
            } else {
                MarketingDbAccess.ermittleVarianten_gebunden(con, prod, markt, iso, regionIso);
            }
            MarketingDbAccess.ermittleVariantenBilder(con, prod, markt);
            MarketingDbAccess.ermittleVariantenBilder(con, prod, 0);
            if (!MarketingDbAccess.ermittleGrafikenZuProdukt(con, prod, markt)) {
                MarketingDbAccess.ermittleGrafikenZuProdukt(con, prod, 0);
            }
            if (prod.getImages() == null || prod.getImages().size() == 0) {
                grafik = null;
                grafik = isLifestyle ? (Zubehoergrafik)TechnischDbAccess.ermittleExplosionsGrafik(bteNr).get(0) : SucheDbAccess.ermittleLetztesFallbackBild(con, "N", prod, markt, isLifestyle);
                grafik.setProduktName("");
                grafik.setProduktName(prod.getProduktNamePlain());
                prod.setImages(new ArrayList());
                prod.getImages().add(grafik);
            }
            MarketingDbAccess.ermittleGrafikenZuBestandteilen(con, prod, markt);
            MarketingDbAccess.ermittleGrafikenZuAlternativen(con, prod, markt);
            MarketingDbAccess.ermittleGrafikenZuEinzelteilen(con, prod, markt);
            MarketingDbAccess.setzeVariantenGrafiken(prod);
            if (prod.getThumbnail() == null || prod.getThumbnail().getImageData() == null || prod.getThumbnail().getImageData().length == 0) {
                grafik = null;
                grafik = isLifestyle ? (Zubehoergrafik)TechnischDbAccess.ermittleExplosionsGrafik(bteNr).get(0) : SucheDbAccess.ermittleLetztesFallbackBild(con, "T", prod, markt, isLifestyle);
                grafik.setProduktName("");
                prod.setThumbnail(grafik);
            }
            MarketingDbAccess.ermittleFzgEinschraenkungen(con, prod);
            MarketingDbAccess.ermittleSZCode(con, prod);
            MarketingProdukt marketingProdukt = prod;
            return marketingProdukt;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "zub.marketing.AdminToolDbAccess.ermittleMarketingProduktZuBTE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleFzgEinschraenkungen(Connection con, MarketingProdukt prod) throws SQLException {
        block13: {
            PreparedStatement stat;
            block12: {
                stat = null;
                String bteNr = prod.getBteNr();
                String bildPos = prod.getBildPosNr();
                ResultSet rs = null;
                String statement = !prod.isFahrzeugUngebunden() ? SQLStatements.MarketingSicht.instance.ERMITTLE_NOETIGE_FZ_ATTRIBUTE_FZGEB_BASE() : SQLStatements.MarketingSicht.instance.ERMITTLE_NOETIGE_FZ_ATTRIBUTE_FZUGB_BASE();
                try {
                    stat = con.prepareStatement(statement);
                    stat.setString(1, bteNr);
                    if (prod.getBildPosNr() == null || prod.getBildPosNr().length() == 0) {
                        stat.setNull(2, 12);
                    } else {
                        stat.setString(2, bildPos);
                    }
                    rs = stat.executeQuery();
                    prod.setGetriebeNoetig(false);
                    prod.setLenkungNoetig(false);
                    prod.setDatumNoetig(false);
                    while (rs.next()) {
                        rs.getString("automatik");
                        if (!rs.wasNull()) {
                            prod.setGetriebeNoetig(true);
                        }
                        rs.getString("lenkung");
                        if (!rs.wasNull()) {
                            prod.setLenkungNoetig(true);
                        }
                        rs.getString("datEins");
                        if (!rs.wasNull()) {
                            prod.setDatumNoetig(true);
                        }
                        rs.getString("datAusl");
                        if (rs.wasNull()) continue;
                        prod.setDatumNoetig(true);
                    }
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block13;
            }
            if (stat != null) {
                stat.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ermittleFzgEinschraenkungenMospId(MarketingProdukt prod, Fahrzeug fahrzeug) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs;
        Connection con;
        block15: {
            PreparedStatement stat;
            block14: {
                stat = null;
                String bteNr = prod.getBteNr();
                String bildPos = prod.getBildPosNr();
                ResultSet rs = null;
                con = null;
                globs = ServerGlobalObjects.getInstance();
                String statement = SQLStatements.FahrzeugIdentifikation.instance.ERMITTLE_NOETIGE_FZ_ATTRIBUTE_MOSPID();
                try {
                    con = globs.getDBConnection("ermittleEinschraenkungenMospId");
                    stat = con.prepareStatement(statement);
                    stat.setString(1, bteNr);
                    if (prod.getBildPosNr() == null || prod.getBildPosNr().length() == 0) {
                        stat.setNull(2, 12);
                    } else {
                        stat.setString(2, bildPos);
                    }
                    stat.setLong(3, fahrzeug.getModellspalte());
                    rs = stat.executeQuery();
                    prod.setGetriebeNoetig(false);
                    prod.setLenkungNoetig(false);
                    prod.setDatumNoetig(false);
                    while (rs.next()) {
                        rs.getString("automatik");
                        if (!rs.wasNull()) {
                            prod.setGetriebeNoetig(true);
                        }
                        rs.getString("lenkung");
                        if (!rs.wasNull()) {
                            prod.setLenkungNoetig(true);
                        }
                        rs.getString("datEins");
                        if (!rs.wasNull()) {
                            prod.setDatumNoetig(true);
                        }
                        rs.getString("datAusl");
                        if (rs.wasNull()) continue;
                        prod.setDatumNoetig(true);
                    }
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "ermittleEinschraenkungenMospId");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block15;
            }
            if (stat != null) {
                stat.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "ermittleEinschraenkungenMospId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getMarketingInfos(Connection con, MarketingProdukt prod, int markt, String iso, String regionIso) throws SQLException {
        boolean bl;
        block14: {
            PreparedStatement stat;
            block13: {
                stat = null;
                String bildPosNr = prod.getBildPosNr();
                boolean hasData = false;
                String statement = bildPosNr == null || bildPosNr.length() == 0 ? SQLStatements.MarketingSicht.instance.ERMITTLE_MARKETINGINFOS_ZU_BTE() : SQLStatements.MarketingSicht.instance.ERMITTLE_MARKETINGINFOS_ZU_BNB();
                ResultSet rs = null;
                try {
                    stat = con.prepareStatement(statement);
                    stat.setString(1, prod.getBteNr());
                    stat.setInt(2, markt);
                    stat.setString(3, iso == null ? "" : iso);
                    stat.setString(4, regionIso == null ? "" : regionIso);
                    if (bildPosNr != null) {
                        stat.setString(5, bildPosNr);
                    }
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        hasData = true;
                        byte[] bdata = rs.getBytes("mprod_text");
                        int text_laenge = rs.getInt("text_laenge");
                        String text = null;
                        if (bdata == null) continue;
                        try {
                            text = new String(WebetkUtils.getBytes(bdata, text_laenge), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        String art = rs.getString(3);
                        if (text != null && text.length() > 0 && art.equalsIgnoreCase("PRODUKTNAME")) {
                            text = prod.getBteNr() + (bildPosNr != null && bildPosNr.length() > 0 ? " " + bildPosNr : "") + " - " + text;
                        }
                        MarketingDbAccess.setzeMarketingTexte(prod, text, art);
                    }
                    if (prod.getProduktName() == null || prod.getProduktName().length() == 0) {
                        MarketingDbAccess.ermittleProduktnameFallback(con, prod, markt, iso, regionIso);
                    }
                    if ((prod.getTeaser() == null || prod.getTeaser().length() == 0) && prod.getDetailText() != null && prod.getDetailText().length() > 0) {
                        prod.setTeaser(prod.getDetailText());
                    }
                    bl = hasData;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block14;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleBnbMarketingInfos(Connection con, MarketingProdukt prod, int markt, String iso, String regionIso) throws SQLException {
        Statement stat = null;
        ArrayList<Bnb> bnbs = new ArrayList<Bnb>();
        bnbs.addAll(prod.getAlternativen());
        bnbs.addAll(prod.getEinzelteile());
        boolean hasData = false;
        String statement = SQLStatements.MarketingSicht.instance.ERMITTLE_MARKETINGINFOS_ZU_BNB();
        ResultSet rs = null;
        try {
            for (int i = 0; i < bnbs.size(); ++i) {
                Bnb bnb = (Bnb)bnbs.get(i);
                stat = con.prepareStatement(statement);
                stat.setString(1, prod.getBteNr());
                stat.setInt(2, markt);
                stat.setString(3, iso == null ? "" : iso);
                stat.setString(4, regionIso == null ? "" : regionIso);
                stat.setString(5, bnb.getBildPos());
                rs = stat.executeQuery();
                while (rs.next()) {
                    hasData = true;
                    byte[] bdata = rs.getBytes("mprod_text");
                    int text_laenge = rs.getInt("text_laenge");
                    String text = null;
                    if (bdata == null) continue;
                    try {
                        text = new String(WebetkUtils.getBytes(bdata, text_laenge), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    String art = rs.getString(3);
                    MarketingDbAccess.setzeMarketingTexte(bnb, text, art);
                }
            }
            boolean bl = hasData;
            return bl;
        }
        finally {
            if (rs != null) {
                WebetkUtils.closeQuery(rs);
            } else if (stat != null) {
                stat.close();
            }
        }
    }

    public static void setzeMarketingTexte(BaseMarketingProdukt prod, String text, String art) {
        if (art.equalsIgnoreCase("DETAILTEXT") && (prod.getDetailText() == null || prod.getDetailText().length() == 0)) {
            prod.setDetailText(text);
        } else if (art.equalsIgnoreCase("TEASERTEXT") && (prod.getTeaser() == null || prod.getTeaser().length() == 0)) {
            prod.setTeaser(text);
        } else if (art.equalsIgnoreCase("NAVIGATIONSNAME") && (prod.getNavigationName() == null || prod.getNavigationName().length() == 0)) {
            prod.setNavigationName(text);
        } else if (art.equalsIgnoreCase("NUTZEN") && (prod.getNutzen() == null || prod.getNutzen().length() == 0)) {
            prod.setNutzen(text);
        } else if (art.equalsIgnoreCase("TIPPSTRICKS") && (prod.getTippsUndTricks() == null || prod.getTippsUndTricks().length() == 0)) {
            prod.setTippsUndTricks(text);
        } else if (art.equalsIgnoreCase("ZUSATZPRODUKTE") && (prod.getPiasZusatzProdukte() == null || prod.getPiasZusatzProdukte().length() == 0)) {
            prod.setPiasZusatzProdukte(text);
        } else if (art.equalsIgnoreCase("ZUSATZINFO") && (prod.getWeitergehendeInformationen() == null || prod.getWeitergehendeInformationen().length() == 0)) {
            prod.setWeitergehendeInformationen(text);
        } else if (art.equalsIgnoreCase("WETTBEWERB") && (prod.getWettbewerb() == null || prod.getWettbewerb().length() == 0)) {
            prod.setWettbewerb(text);
        } else if (art.equalsIgnoreCase("KUNDENINFO") && (prod.getKundeninformationen() == null || prod.getKundeninformationen().length() == 0)) {
            prod.setKundeninformationen(text);
        } else if (art.equalsIgnoreCase("SHOPANDERE") && (prod.getShopDisplaysUndAndere() == null || prod.getShopDisplaysUndAndere().length() == 0)) {
            prod.setShopDisplaysUndAndere(text);
        } else if (art.equalsIgnoreCase("WERBUNG") && (prod.getWerbungAktionen() == null || prod.getWerbungAktionen().length() == 0)) {
            prod.setWerbungAktionen(text);
        } else if (art.equalsIgnoreCase("RESTRIKTIONEN") && (prod.getRestriktionen() == null || prod.getRestriktionen().length() == 0)) {
            prod.setRestriktionen(text);
        } else if (art.equalsIgnoreCase("KOMMENTAR") && (prod.getPiasKommentar() == null || prod.getPiasKommentar().length() == 0)) {
            prod.setPiasKommentar(text);
        } else if (art.equalsIgnoreCase("ZUSATZNUTZEN") && (prod.getZusatzNutzen() == null || prod.getZusatzNutzen().length() == 0)) {
            prod.setZusatzNutzen(text);
        } else if (art.equalsIgnoreCase("VERKAUFSINFORMATION") && (prod.getVerkaufsinfo() == null || prod.getVerkaufsinfo().length() == 0)) {
            prod.setVerkaufsinfo(text);
        } else if (art.equalsIgnoreCase("HINWEISE") && (prod.getHinweise() == null || prod.getHinweise().length() == 0)) {
            prod.setHinweise(text);
        } else if (art.equalsIgnoreCase("CROSS-SELLING") && (prod.getCrossSelling() == null || prod.getCrossSelling().length() == 0)) {
            prod.setCrossSelling(text);
        } else if (art.equalsIgnoreCase("ERSATZTEILE") && (prod.getErsatzTeile() == null || prod.getErsatzTeile().length() == 0)) {
            prod.setErsatzTeile(text);
        } else if (art.equalsIgnoreCase("DETAILS") && (prod.getDetails() == null || prod.getDetails().length() == 0)) {
            prod.setDetails(text);
        } else if (art.equalsIgnoreCase("SONSTIGES") && (prod.getSonstiges() == null || prod.getSonstiges().length() == 0)) {
            prod.setSonstiges(text);
        }
    }

    public static void setzeBteBedingung(BaseMarketingProdukt prod, String text) {
        if (prod.getBteBedingung().equals("")) {
            String bedText = "F\u00fcr Fahrzeuge mit " + text;
            prod.setBteBedingung(bedText);
        } else {
            prod.setBteBedingung(prod.getBteBedingung() + " " + text);
        }
    }

    public static void ermittleProduktnameFallback(Connection con, BaseMarketingProdukt prod, int markt, String iso, String regionIso) throws SQLException {
        MarketingDbAccess.ermittleProduktnameFallback(con, prod, markt, iso, regionIso, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ermittleProduktnameFallback(Connection con, BaseMarketingProdukt prod, int markt, String iso, String regionIso, boolean isOptionalesProdukt) throws SQLException {
        block14: {
            PreparedStatement stat;
            block13: {
                stat = null;
                ResultSet rs = null;
                String bildPosNr = prod.getBildPosNr();
                String statement = isOptionalesProdukt ? SQLStatements.ProduktSuche.instance.ERMITTLE_PRODUKTNAME_BNB() : (bildPosNr != null && bildPosNr.length() > 0 ? SQLStatements.ProduktSuche.instance.ERMITTLE_PRODUKTNAME_BNB() : SQLStatements.ProduktSuche.instance.ERMITTLE_PRODUKTNAME());
                String produktName = null;
                try {
                    stat = con.prepareStatement(statement);
                    if (bildPosNr != null && bildPosNr.length() > 0) {
                        MarketingDbAccess.setzeProduktNameInParamsBnb(stat, prod, markt, iso, regionIso);
                    } else {
                        MarketingDbAccess.setzeProduktNameInParams(stat, prod, markt, iso, regionIso);
                    }
                    rs = stat.executeQuery();
                    int prio = -1;
                    int lastPrio = -1;
                    int komm_id = 0;
                    String szZusatz = "";
                    while (rs.next()) {
                        String produkt = rs.getString(1);
                        prio = rs.getInt(2);
                        if (bildPosNr == null) {
                            komm_id = rs.getInt(3);
                        }
                        if (produktName != null && lastPrio != -1 && prio >= lastPrio) continue;
                        produktName = produkt;
                        lastPrio = prio;
                    }
                    if (komm_id != 0) {
                        szZusatz = MarketingDbAccess.ermittleSzZusaetze(con, iso, regionIso, komm_id);
                    }
                    if (produktName != null && produktName.length() > 0) {
                        produktName = prod.getBteNr() + (bildPosNr != null && bildPosNr.length() > 0 ? " " + bildPosNr : "") + " - " + produktName;
                        prod.setProduktName(produktName + szZusatz);
                    } else {
                        prod.setProduktName(prod.getBteNr() + (bildPosNr != null && bildPosNr.length() > 0 ? " " + bildPosNr : ""));
                    }
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block14;
            }
            if (stat != null) {
                stat.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ermittleSzZusaetze(Connection con, String iso, String regionIso, int zusatzid) throws SQLException {
        String string;
        block8: {
            PreparedStatement stat;
            block7: {
                stat = null;
                ResultSet rs = null;
                String statement = SQLStatements.ProduktSuche.instance.ERMITTLE_SZ_ZUSAETZE();
                String szZusaetze = "";
                try {
                    stat = con.prepareStatement(statement);
                    stat.setInt(1, zusatzid);
                    stat.setString(2, iso == null ? "" : iso);
                    stat.setString(3, regionIso == null ? "" : regionIso);
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        szZusaetze = szZusaetze + " " + rs.getString(2);
                    }
                    string = szZusaetze;
                    if (rs == null) break block7;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block8;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return string;
    }

    private static void setzeProduktNameInParams(PreparedStatement stat, BaseMarketingProdukt prod, int markt, String iso, String regionIso) throws SQLException {
        stat.setString(1, iso == null ? "" : iso);
        stat.setString(2, regionIso == null ? "" : regionIso);
        stat.setString(3, prod.getBteNr());
    }

    private static void setzeProduktNameInParamsBnb(PreparedStatement stat, BaseMarketingProdukt prod, int markt, String iso, String regionIso) throws SQLException {
        stat.setString(1, prod.getBteNr());
        stat.setString(2, prod.getBildPosNr());
        stat.setString(3, iso == null ? "" : iso);
        stat.setString(4, regionIso == null ? "" : regionIso);
        stat.setString(5, prod.getBteNr());
        stat.setString(6, prod.getBildPosNr());
        stat.setString(7, iso == null ? "" : iso);
        stat.setString(8, regionIso == null ? "" : regionIso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleGrafikenZuProdukt(Connection con, MarketingProdukt prod, int marktId) throws SQLException, DatabaseBusyException {
        boolean bl;
        block15: {
            PreparedStatement thumbNailPs;
            block14: {
                thumbNailPs = null;
                ResultSet tnRset = null;
                String tStatement = null;
                boolean wasLoaded = false;
                tStatement = prod.getBildPosNr() != null ? SQLStatements.MarketingSicht.instance.ERMITTLE_GRAFIKEN_ZU_BNB() : SQLStatements.MarketingSicht.instance.ERMITTLE_GRAFIKEN_ZU_BTE();
                try {
                    byte[] bild;
                    thumbNailPs = con.prepareStatement(tStatement);
                    thumbNailPs.setString(1, prod.getBteNr());
                    thumbNailPs.setInt(2, marktId);
                    if (prod.getBildPosNr() != null) {
                        thumbNailPs.setString(3, prod.getBildPosNr());
                    }
                    tnRset = thumbNailPs.executeQuery();
                    while (tnRset.next()) {
                        String art = tnRset.getString(2);
                        byte[] blob = tnRset.getBytes(3);
                        Integer grafikId = new Integer(tnRset.getInt(4));
                        Zubehoergrafik icon = null;
                        if (blob != null) {
                            wasLoaded = true;
                            icon = new Zubehoergrafik(blob, grafikId);
                            icon.setProduktName(prod.getProduktNamePlain());
                        }
                        if (art.equalsIgnoreCase("T") && prod.getThumbnail() == null) {
                            prod.setThumbnail(icon);
                        }
                        if (!art.equalsIgnoreCase("N")) continue;
                        boolean isDrin = false;
                        for (int i = 0; i < prod.getImages().size(); ++i) {
                            Zubehoergrafik zubGr = prod.getImages().get(i);
                            if (zubGr.getGrafikId().intValue() != grafikId.intValue()) continue;
                            isDrin = true;
                            break;
                        }
                        if (isDrin) continue;
                        prod.getImages().add(icon);
                    }
                    if ((prod.getThumbnail() == null || prod.getThumbnail().getImageData() == null || prod.getThumbnail().getImageData().length == 0) && (bild = SucheDbAccess.ermittleErstesFallbackBild(con, "T", prod, marktId)) != null) {
                        wasLoaded = true;
                        Zubehoergrafik zubGr = new Zubehoergrafik(bild);
                        zubGr.setProduktName(prod.getProduktNamePlain());
                        prod.setThumbnail(zubGr);
                    }
                    if (prod.getImages() == null || prod.getImages().size() == 0) {
                        ArrayList<Zubehoergrafik> images = new ArrayList<Zubehoergrafik>();
                        byte[] bild2 = SucheDbAccess.ermittleErstesFallbackBild(con, "N", prod, marktId);
                        if (bild2 != null) {
                            wasLoaded = true;
                            Zubehoergrafik zubGr = new Zubehoergrafik(bild2);
                            zubGr.setProduktName(prod.getProduktNamePlain());
                            images.add(zubGr);
                        }
                        prod.setImages(images);
                    }
                    bl = wasLoaded;
                    if (tnRset == null) break block14;
                }
                catch (Throwable throwable) {
                    if (tnRset != null) {
                        WebetkUtils.closeQuery(tnRset);
                    } else if (thumbNailPs != null) {
                        thumbNailPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(tnRset);
                break block15;
            }
            if (thumbNailPs != null) {
                thumbNailPs.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleGrafikenZuBestandteilen(Connection con, MarketingProdukt prod, int marktId) throws SQLException, DatabaseBusyException {
        Statement thumbNailPs = null;
        ResultSet tnRset = null;
        String tStatement = null;
        boolean wasLoaded = false;
        if (prod.getBildPosNr() == null) {
            tStatement = SQLStatements.MarketingSicht.instance.ERMITTLE_GRAFIKEN_ZU_BNB();
            try {
                for (int k = 0; k < prod.getBestandTeile().size(); ++k) {
                    String bnb = prod.getBestandTeile().get(k).getBildPos();
                    String bnbName = prod.getBestandTeile().get(k).getBnbName();
                    thumbNailPs = con.prepareStatement(tStatement);
                    thumbNailPs.setString(1, prod.getBteNr());
                    thumbNailPs.setInt(2, marktId);
                    thumbNailPs.setString(3, bnb);
                    tnRset = thumbNailPs.executeQuery();
                    while (tnRset.next()) {
                        String art = tnRset.getString(2);
                        byte[] blob = tnRset.getBytes(3);
                        Integer grafikId = new Integer(tnRset.getInt(4));
                        Zubehoergrafik icon = null;
                        if (blob != null) {
                            wasLoaded = true;
                            icon = new Zubehoergrafik(blob, grafikId);
                            icon.setProduktName(bnbName);
                            icon.setElementart("HP_PAKET");
                        }
                        if (!art.equalsIgnoreCase("N")) continue;
                        boolean isDrin = false;
                        for (int i = 0; i < prod.getImages().size(); ++i) {
                            Zubehoergrafik zubGr = prod.getImages().get(i);
                            if (zubGr.getGrafikId() == null || zubGr.getGrafikId().intValue() != grafikId.intValue()) continue;
                            isDrin = true;
                            zubGr.setProduktName(bnbName);
                            zubGr.setElementart("HP_PAKET");
                            break;
                        }
                        if (isDrin) continue;
                        prod.getImages().add(icon);
                    }
                }
                boolean bl = wasLoaded;
                return bl;
            }
            finally {
                if (tnRset != null) {
                    WebetkUtils.closeQuery(tnRset);
                } else if (thumbNailPs != null) {
                    thumbNailPs.close();
                }
            }
        }
        return wasLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleGrafikenZuEinzelteilen(Connection con, MarketingProdukt prod, int marktId) throws SQLException, DatabaseBusyException {
        Statement thumbNailPs = null;
        ResultSet tnRset = null;
        String tStatement = null;
        boolean wasLoaded = false;
        if (prod.getBildPosNr() == null) {
            tStatement = SQLStatements.MarketingSicht.instance.ERMITTLE_GRAFIKEN_ZU_BNB();
            try {
                for (int k = 0; k < prod.getEinzelteile().size(); ++k) {
                    String bnb = prod.getEinzelteile().get(k).getBildPos();
                    String bnbName = prod.getEinzelteile().get(k).getBnbName();
                    thumbNailPs = con.prepareStatement(tStatement);
                    thumbNailPs.setString(1, prod.getBteNr());
                    thumbNailPs.setInt(2, marktId);
                    thumbNailPs.setString(3, bnb);
                    tnRset = thumbNailPs.executeQuery();
                    while (tnRset.next()) {
                        String art = tnRset.getString(2);
                        byte[] blob = tnRset.getBytes(3);
                        Integer grafikId = new Integer(tnRset.getInt(4));
                        Zubehoergrafik icon = null;
                        if (blob != null) {
                            wasLoaded = true;
                            icon = new Zubehoergrafik(blob, grafikId);
                            icon.setProduktName("Einzelteil: " + bnbName);
                            icon.setElementart("HP_EINZELTEIL");
                        }
                        if (!art.equalsIgnoreCase("N")) continue;
                        if (prod.getEinzelteile().get(k).getBnbGrafik() == null) {
                            prod.getEinzelteile().get(k).setBnbGrafik(icon);
                        }
                        boolean isDrin = false;
                        for (int i = 0; i < prod.getImages().size(); ++i) {
                            Zubehoergrafik zubGr = prod.getImages().get(i);
                            if (zubGr.getGrafikId() == null || zubGr.getGrafikId().intValue() != grafikId.intValue()) continue;
                            isDrin = true;
                            zubGr.setProduktName("Einzelteil: " + bnbName);
                            zubGr.setElementart("HP_EINZELTEIL");
                            break;
                        }
                        if (isDrin) continue;
                        prod.getImages().add(icon);
                    }
                }
                boolean bl = wasLoaded;
                return bl;
            }
            finally {
                if (tnRset != null) {
                    WebetkUtils.closeQuery(tnRset);
                } else if (thumbNailPs != null) {
                    thumbNailPs.close();
                }
            }
        }
        return wasLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleGrafikenZuAlternativen(Connection con, MarketingProdukt prod, int marktId) throws SQLException, DatabaseBusyException {
        Statement thumbNailPs = null;
        ResultSet tnRset = null;
        String tStatement = null;
        boolean wasLoaded = false;
        if (prod.getBildPosNr() == null) {
            tStatement = SQLStatements.MarketingSicht.instance.ERMITTLE_GRAFIKEN_ZU_BNB();
            try {
                for (int k = 0; k < prod.getAlternativen().size(); ++k) {
                    String bnb = prod.getAlternativen().get(k).getBildPos();
                    String bnbName = prod.getAlternativen().get(k).getBnbName();
                    thumbNailPs = con.prepareStatement(tStatement);
                    thumbNailPs.setString(1, prod.getBteNr());
                    thumbNailPs.setInt(2, marktId);
                    thumbNailPs.setString(3, bnb);
                    tnRset = thumbNailPs.executeQuery();
                    while (tnRset.next()) {
                        String art = tnRset.getString(2);
                        byte[] blob = tnRset.getBytes(3);
                        Integer grafikId = new Integer(tnRset.getInt(4));
                        Zubehoergrafik icon = null;
                        if (blob != null) {
                            wasLoaded = true;
                            icon = new Zubehoergrafik(blob, grafikId);
                            icon.setProduktName("Alternative: " + bnbName);
                            icon.setElementart("HP_ALTERNATIV");
                        }
                        if (!art.equalsIgnoreCase("N")) continue;
                        if (prod.getAlternativen().get(k).getBnbGrafik() == null) {
                            prod.getAlternativen().get(k).setBnbGrafik(icon);
                        }
                        boolean isDrin = false;
                        for (int i = 0; i < prod.getImages().size(); ++i) {
                            Zubehoergrafik zubGr = prod.getImages().get(i);
                            if (zubGr.getGrafikId() == null || zubGr.getGrafikId().intValue() != grafikId.intValue()) continue;
                            isDrin = true;
                            zubGr.setProduktName("Alternative: " + bnbName);
                            zubGr.setElementart("HP_ALTERNATIV");
                            break;
                        }
                        if (isDrin) continue;
                        prod.getImages().add(icon);
                    }
                }
                boolean bl = wasLoaded;
                return bl;
            }
            finally {
                if (tnRset != null) {
                    WebetkUtils.closeQuery(tnRset);
                } else if (thumbNailPs != null) {
                    thumbNailPs.close();
                }
            }
        }
        return wasLoaded;
    }

    private static void setzeVariantenGrafiken(MarketingProdukt prod) {
        for (int i = 0; i < prod.getAlleVarianten().size(); ++i) {
            Variante var = prod.getAlleVarianten().get(i);
            if (var.getGrafik() == null || var.getGrafik().getImageData() == null) continue;
            boolean isDrin = false;
            for (int k = 0; k < prod.getImages().size(); ++k) {
                Zubehoergrafik zubGr = prod.getImages().get(k);
                if (zubGr.getGrafikId().intValue() != var.getGrafik().getGrafikId().intValue()) continue;
                isDrin = true;
                zubGr.setProduktName(var.getGrafik().getProduktName());
                zubGr.setElementart("VARIANTE");
                break;
            }
            if (isDrin) continue;
            prod.getImages().add(var.getGrafik());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleVarianten_gebunden(Connection con, MarketingProdukt produkt, int marktId, String iso, String regIso) throws SQLException {
        block27: {
            PreparedStatement stat;
            block26: {
                String statement = null;
                statement = produkt.getBildPosNr() != null ? SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_GEBUNDEN() : SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BTE();
                stat = null;
                ResultSet rs = null;
                ArrayList<Variante> varianten = new ArrayList<Variante>();
                Hashtable<Integer, Variante> hilfsVarTable = new Hashtable<Integer, Variante>();
                try {
                    Integer varianteId;
                    ArrayList variants;
                    stat = con.prepareStatement(statement);
                    stat.setString(1, produkt.getBteNr());
                    stat.setString(2, iso == null ? "" : iso);
                    stat.setString(3, regIso == null ? "" : regIso);
                    if (produkt.getBildPosNr() != null && produkt.getBildPosNr().length() > 0) {
                        stat.setString(4, produkt.getBildPosNr());
                        stat.setInt(5, marktId);
                    } else {
                        stat.setInt(4, marktId);
                    }
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        Integer varianteId2 = new Integer(rs.getInt(2));
                        String name = rs.getString(3);
                        Variante var = new Variante(produkt.getBteNr(), varianteId2, name);
                        if (!varianten.contains(var)) {
                            varianten.add(var);
                        }
                        if (hilfsVarTable.containsKey(varianteId2)) continue;
                        hilfsVarTable.put(varianteId2, var);
                    }
                    produkt.setVarianten(varianten);
                    if (produkt.getAlternativen() != null && produkt.getAlternativen().size() > 0) {
                        HashMap varZuAlter = new HashMap();
                        for (int i = 0; i < produkt.getAlternativen().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_GEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, produkt.getAlternativen().get(i).getBildPos());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                varianteId = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId)) continue;
                                variants.add(hilfsVarTable.get(varianteId));
                            }
                            varZuAlter.put(produkt.getAlternativen().get(i).getBildPos(), variants);
                        }
                        produkt.setVariantenZuAlternativen(varZuAlter);
                    }
                    if (produkt.getEinzelteile() != null && produkt.getEinzelteile().size() > 0) {
                        HashMap varZuEinzel = new HashMap();
                        for (int i = 0; i < produkt.getEinzelteile().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_GEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, produkt.getEinzelteile().get(i).getBildPos());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                varianteId = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId)) continue;
                                variants.add(hilfsVarTable.get(varianteId));
                            }
                            varZuEinzel.put(produkt.getEinzelteile().get(i).getBildPos(), variants);
                        }
                        produkt.setVariantenZuEinzelteile(varZuEinzel);
                    }
                    if (produkt.getBestandTeile() != null && produkt.getBestandTeile().size() > 0) {
                        HashMap varZuBestandteile = new HashMap();
                        for (int i = 0; i < produkt.getBestandTeile().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_GEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, produkt.getBestandTeile().get(i).getBildPos());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                varianteId = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId)) continue;
                                variants.add(hilfsVarTable.get(varianteId));
                            }
                            varZuBestandteile.put(produkt.getBestandTeile().get(i).getBildPos(), variants);
                        }
                        produkt.setVariantenZuBestandteile(varZuBestandteile);
                    }
                    if (produkt.getZusatzProdukte() != null && produkt.getZusatzProdukte().size() > 0) {
                        ArrayList<ProduktListenElement> zusatzProdNeu = new ArrayList<ProduktListenElement>();
                        for (int i = 0; i < produkt.getZusatzProdukte().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_GEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, ((ProduktListenElement)produkt.getZusatzProdukte().get(i)).getBildPosNr());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                Integer varianteId3 = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId3)) continue;
                                variants.add(hilfsVarTable.get(varianteId3));
                            }
                            try {
                                if (variants.size() == 0) {
                                    ProduktListenElement prodListEl = (ProduktListenElement)((ProduktListenElement)produkt.getZusatzProdukte().get(i)).clone();
                                    zusatzProdNeu.add(prodListEl);
                                    continue;
                                }
                                for (int k = 0; k < variants.size(); ++k) {
                                    ProduktListenElement prodListEl = (ProduktListenElement)((ProduktListenElement)produkt.getZusatzProdukte().get(i)).clone();
                                    prodListEl.setVariante((Variante)variants.get(k));
                                    zusatzProdNeu.add(prodListEl);
                                }
                                continue;
                            }
                            catch (CloneNotSupportedException e) {
                                logger.error((Object)"CloneNotSupportedException: ", (Throwable)e);
                            }
                        }
                        produkt.setZusatzProdukte(zusatzProdNeu);
                    }
                    if (rs == null) break block26;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block27;
            }
            if (stat != null) {
                stat.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleVarianten_ungebunden(Connection con, MarketingProdukt produkt, int marktId, String iso, String regIso) throws SQLException {
        block27: {
            PreparedStatement stat;
            block26: {
                String statement = null;
                statement = produkt.getBildPosNr() != null ? SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_UNGEBUNDEN() : SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BTE();
                stat = null;
                ResultSet rs = null;
                ArrayList<Variante> varianten = new ArrayList<Variante>();
                Hashtable<Integer, Variante> hilfsVarTable = new Hashtable<Integer, Variante>();
                try {
                    Integer varianteId;
                    ArrayList variants;
                    stat = con.prepareStatement(statement);
                    stat.setString(1, produkt.getBteNr());
                    stat.setString(2, iso == null ? "" : iso);
                    stat.setString(3, regIso == null ? "" : regIso);
                    if (produkt.getBildPosNr() != null && produkt.getBildPosNr().length() > 0) {
                        stat.setString(4, produkt.getBildPosNr());
                        stat.setInt(5, marktId);
                    } else {
                        stat.setInt(4, marktId);
                    }
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        Integer varianteId2 = new Integer(rs.getInt(2));
                        String name = rs.getString(3);
                        Variante var = new Variante(produkt.getBteNr(), varianteId2, name);
                        if (!varianten.contains(var)) {
                            varianten.add(var);
                        }
                        if (hilfsVarTable.containsKey(varianteId2)) continue;
                        hilfsVarTable.put(varianteId2, var);
                    }
                    produkt.setVarianten(varianten);
                    if (produkt.getAlternativen() != null && produkt.getAlternativen().size() > 0) {
                        HashMap varZuAlter = new HashMap();
                        for (int i = 0; i < produkt.getAlternativen().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_UNGEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, produkt.getAlternativen().get(i).getBildPos());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                varianteId = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId)) continue;
                                variants.add(hilfsVarTable.get(varianteId));
                            }
                            varZuAlter.put(produkt.getAlternativen().get(i).getBildPos(), variants);
                        }
                        produkt.setVariantenZuAlternativen(varZuAlter);
                    }
                    if (produkt.getEinzelteile() != null && produkt.getEinzelteile().size() > 0) {
                        HashMap varZuEinzel = new HashMap();
                        for (int i = 0; i < produkt.getEinzelteile().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_UNGEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, produkt.getEinzelteile().get(i).getBildPos());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                varianteId = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId)) continue;
                                variants.add(hilfsVarTable.get(varianteId));
                            }
                            varZuEinzel.put(produkt.getEinzelteile().get(i).getBildPos(), variants);
                        }
                        produkt.setVariantenZuEinzelteile(varZuEinzel);
                    }
                    if (produkt.getBestandTeile() != null && produkt.getBestandTeile().size() > 0) {
                        HashMap varZuBestandteile = new HashMap();
                        for (int i = 0; i < produkt.getBestandTeile().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_UNGEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, produkt.getBestandTeile().get(i).getBildPos());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                varianteId = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId)) continue;
                                variants.add(hilfsVarTable.get(varianteId));
                            }
                            varZuBestandteile.put(produkt.getBestandTeile().get(i).getBildPos(), variants);
                        }
                        produkt.setVariantenZuBestandteile(varZuBestandteile);
                    }
                    if (produkt.getZusatzProdukte() != null && produkt.getZusatzProdukte().size() > 0) {
                        ArrayList<ProduktListenElement> zusatzProdNeu = new ArrayList<ProduktListenElement>();
                        for (int i = 0; i < produkt.getZusatzProdukte().size(); ++i) {
                            variants = new ArrayList();
                            statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTEN_ZU_BNB_UNGEBUNDEN();
                            stat = null;
                            rs = null;
                            stat = con.prepareStatement(statement);
                            stat.setString(1, produkt.getBteNr());
                            stat.setString(2, iso == null ? "" : iso);
                            stat.setString(3, regIso == null ? "" : regIso);
                            stat.setString(4, ((ProduktListenElement)produkt.getZusatzProdukte().get(i)).getBildPosNr());
                            stat.setInt(5, marktId);
                            rs = stat.executeQuery();
                            while (rs.next()) {
                                Integer varianteId3 = new Integer(rs.getInt(2));
                                if (!hilfsVarTable.containsKey(varianteId3)) continue;
                                variants.add(hilfsVarTable.get(varianteId3));
                            }
                            try {
                                if (variants.size() == 0) {
                                    ProduktListenElement prodListEl = (ProduktListenElement)((ProduktListenElement)produkt.getZusatzProdukte().get(i)).clone();
                                    zusatzProdNeu.add(prodListEl);
                                    continue;
                                }
                                for (int k = 0; k < variants.size(); ++k) {
                                    ProduktListenElement prodListEl = (ProduktListenElement)((ProduktListenElement)produkt.getZusatzProdukte().get(i)).clone();
                                    prodListEl.setVariante((Variante)variants.get(k));
                                    zusatzProdNeu.add(prodListEl);
                                }
                                continue;
                            }
                            catch (CloneNotSupportedException e) {
                                logger.error((Object)"CloneNotSupportedException: ", (Throwable)e);
                            }
                        }
                        produkt.setZusatzProdukte(zusatzProdNeu);
                    }
                    if (rs == null) break block26;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block27;
            }
            if (stat != null) {
                stat.close();
            }
        }
    }

    private static void ermittleVariantenBilder(Connection con, MarketingProdukt produkt, int marktId) throws SQLException {
        String statement = SQLStatements.MarketingSicht.instance.ERMITTLE_VARIANTE_BILDER();
        PreparedStatement stat = con.prepareStatement(statement);
        stat.setInt(1, marktId);
        stat.setString(2, produkt.getBteNr());
        for (Variante var : produkt.getAlleVarianten()) {
            stat.setInt(3, var.getVarianteId());
            stat.setInt(4, marktId);
            ResultSet rs = stat.executeQuery();
            boolean bGrafikVorhanden = false;
            if (var.getGrafik() != null && var.getGrafik().getImageData() != null) {
                bGrafikVorhanden = true;
            }
            if (rs.next() && !bGrafikVorhanden) {
                var.setImageData(rs.getBytes("image"), new Integer(rs.getInt("grafikid")));
            }
            rs.close();
        }
        stat.close();
    }

    private static void ermittleOptionaleProdukte(Connection con, MarketingProdukt produkt, String katalogumfang, String regionen, int marktId, String iso, String regIso) throws SQLException {
        Map map = MarketingDbAccess.ermittleOptionaleProduktIds(con, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTE_FZABH_ZU_BTE(), produkt, regionen, marktId, iso, regIso);
        MarketingDbAccess.ermittleOptionaleMarketingInfos(con, map, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTINFOS_FZABH_ZU_BTE(), marktId, iso, regIso);
        MarketingDbAccess.ermittleOptionaleMarketingBilder(con, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTBILDER_FZABH_ZU_BTE(), map, produkt, marktId);
        MarketingDbAccess.ermittleOptionaleMarketingBilder(con, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTBILDER_FZABH_ZU_BTE(), map, produkt, 0);
        Map fzuabMap = MarketingDbAccess.ermittleOptionaleProduktIds(con, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTE_FZUABH_ZU_BTE(), produkt, regionen, marktId, iso, regIso);
        MarketingDbAccess.ermittleOptionaleMarketingInfos(con, fzuabMap, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTINFOS_FZUABH_ZU_BTE(), marktId, iso, regIso);
        MarketingDbAccess.ermittleOptionaleMarketingBilder(con, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTBILDER_FZUABH_ZU_BTE(), fzuabMap, produkt, marktId);
        MarketingDbAccess.ermittleOptionaleMarketingBilder(con, SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_PRODUKTBILDER_FZUABH_ZU_BTE(), fzuabMap, produkt, 0);
        String baureihenStatement = SQLStatements.MarketingSicht.instance.ERMITTLE_OPTIONALE_BAUREIHEN();
        baureihenStatement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(baureihenStatement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(baureihenStatement, "REGIONEN", regionen);
        MarketingDbAccess.ermittleOptionaleBaureihen(con, baureihenStatement, map, produkt, katalogumfang, regionen, marktId, iso, regIso);
        Collection coll = map.values();
        if (!coll.isEmpty()) {
            coll.addAll(fzuabMap.values());
        } else {
            coll = fzuabMap.values();
        }
        ArrayList produktListe = new ArrayList(coll);
        Collections.sort(produktListe);
        produkt.setZusatzProdukte(produktListe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleSZCode(Connection con, MarketingProdukt produkt) throws SQLException {
        PreparedStatement ps = null;
        String statement = SQLStatements.MarketingSicht.instance.ERMITTLE_SZCODE_ZU_BTE();
        String bteNr = produkt.getBteNr();
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(statement);
            ps.setString(1, bteNr);
            rs = ps.executeQuery();
            while (rs.next()) {
                produkt.setSzCode(rs.getString("szcode"));
                produkt.setSalaid(rs.getLong("salaid"));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleOptionaleBaureihen(Connection con, String statement, Map map, MarketingProdukt produkt, String katalogUmfang, String regionen, int marktId, String iso, String regIso) throws SQLException {
        block11: {
            PreparedStatement ps;
            block10: {
                ps = null;
                ResultSet rs = null;
                try {
                    ps = con.prepareStatement(statement);
                    ps.setString(1, produkt.getBteNr());
                    if (produkt.getBildPosNr() != null) {
                        ps.setString(2, produkt.getBildPosNr());
                    } else {
                        ps.setNull(2, 12);
                    }
                    ps.setString(3, katalogUmfang);
                    ps.setString(4, katalogUmfang);
                    ps.setString(5, "OPTIONAL");
                    ps.setString(6, iso == null ? "" : iso);
                    ps.setString(7, regIso == null ? "" : regIso);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String baureihenText = rs.getString(1);
                        String baureihenId = rs.getString(2);
                        String bildPosNr = rs.getString(3);
                        ProduktId elem = new ProduktId(produkt.getBteNr(), bildPosNr);
                        if (!map.containsKey(elem)) {
                            map.put(elem, new ProduktListenElement());
                        }
                        Baureihe baureihe = new Baureihe(baureihenId);
                        baureihe.setBezeichnung(baureihenText);
                        ProduktListenElement optionalesProdukt = (ProduktListenElement)map.get(elem);
                        optionalesProdukt.getBaureihen().add(baureihe);
                    }
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (ps != null) {
                        ps.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block11;
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleOptionaleMarketingBilder(Connection con, String statement, Map map, MarketingProdukt produkt, int marktId) throws SQLException {
        block11: {
            PreparedStatement ps;
            block10: {
                ps = null;
                ResultSet rs = null;
                try {
                    ps = con.prepareStatement(statement);
                    if (produkt.getBildPosNr() != null) {
                        ps.setString(1, produkt.getBildPosNr());
                    } else {
                        ps.setNull(1, 12);
                    }
                    ps.setString(2, produkt.getBteNr());
                    ps.setString(3, "OPTIONAL");
                    ps.setInt(4, marktId);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ProduktListenElement listenElement;
                        String bildpos;
                        byte[] blob = rs.getBytes(1);
                        String bteNr = rs.getString(2);
                        ProduktId elem = new ProduktId(bteNr, bildpos = rs.getString(3));
                        if (!map.containsKey(elem)) {
                            map.put(elem, new ProduktListenElement());
                            ((ProduktListenElement)map.get(elem)).setBteNr(bteNr);
                            ((ProduktListenElement)map.get(elem)).setBildPosNr(bildpos);
                        }
                        if ((listenElement = (ProduktListenElement)map.get(elem)).getThumbNail() != null && (listenElement.getThumbNail() == null || listenElement.getThumbNail().getImageData() != null || blob == null)) continue;
                        listenElement.setImageData(blob);
                    }
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (ps != null) {
                        ps.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block11;
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map ermittleOptionaleProduktIds(Connection con, String statement, MarketingProdukt produkt, String regionen, int marktId, String iso, String regIso) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<ProduktId, ProduktListenElement> bnbMap = new HashMap<ProduktId, ProduktListenElement>();
        try {
            ps = con.prepareStatement(statement);
            ps.setString(1, produkt.getBteNr());
            if (produkt.getBildPosNr() != null) {
                ps.setString(2, produkt.getBildPosNr());
            } else {
                ps.setNull(2, 12);
            }
            ps.setString(3, "OPTIONAL");
            rs = ps.executeQuery();
            while (rs.next()) {
                String bildpos;
                String bteNr = rs.getString(1);
                ProduktId elem = new ProduktId(bteNr, bildpos = rs.getString(2));
                if (bnbMap.containsKey(elem)) continue;
                bnbMap.put(elem, new ProduktListenElement());
                ((ProduktListenElement)bnbMap.get(elem)).setBteNr(elem.getBteNr());
                ((ProduktListenElement)bnbMap.get(elem)).setBildPosNr(elem.getBildPosNr());
            }
            for (ProduktId id : bnbMap.keySet()) {
                ProduktListenElement el = (ProduktListenElement)bnbMap.get(id);
                if (el.getProduktName() != null && el.getProduktName().length() != 0) continue;
                MarketingDbAccess.ermittleProduktnameFallback(con, el, marktId, iso, regIso, true);
            }
            HashMap<ProduktId, ProduktListenElement> hashMap = bnbMap;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleOptionaleMarketingInfos(Connection con, Map optionaleProdukte, String statement, int marktId, String iso, String regIso) throws SQLException {
        ResultSet rs = null;
        try (PreparedStatement ps = null;){
            ps = con.prepareStatement(statement);
            ps.setInt(1, marktId);
            ps.setInt(2, marktId);
            ps.setString(3, iso == null ? "" : iso);
            ps.setString(4, regIso == null ? "" : regIso);
            ps.setString(7, "OPTIONAL");
            for (ProduktId id : optionaleProdukte.keySet()) {
                ps.setString(5, id.getBteNr());
                ps.setString(6, id.getBildPosNr());
                rs = ps.executeQuery();
                ProduktListenElement elem = (ProduktListenElement)optionaleProdukte.get(id);
                while (rs.next()) {
                    String art;
                    byte[] bdata = rs.getBytes("mprod_text");
                    String text = null;
                    if (bdata == null) continue;
                    try {
                        text = new String(WebetkUtils.removeZeroBytes(bdata), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    if ((art = rs.getString(2)) == null) continue;
                    MarketingDbAccess.setzeMarketingTexte(elem, text, art);
                }
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleBTEArt(Connection con, MarketingProdukt prod, String iso, String regIso) throws SQLException {
        block11: {
            PreparedStatement bteArtPs;
            block10: {
                bteArtPs = null;
                ResultSet bteArtRs = null;
                String statement = SQLStatements.MarketingSicht.instance.ERMITTLE_BTEART();
                try {
                    bteArtPs = con.prepareStatement(statement);
                    bteArtPs.setString(1, prod.getBteNr());
                    bteArtRs = bteArtPs.executeQuery();
                    while (bteArtRs.next()) {
                        String bteArt = bteArtRs.getString(1);
                        prod.setFahrzeugUngebunden(!bteArt.equals("G"));
                    }
                    if (bteArtRs == null) break block10;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    break block11;
                }
                finally {
                    if (bteArtRs != null) {
                        WebetkUtils.closeQuery(bteArtRs);
                    } else if (bteArtPs != null) {
                        bteArtPs.close();
                    }
                }
                WebetkUtils.closeQuery(bteArtRs);
                break block11;
            }
            if (bteArtPs != null) {
                bteArtPs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleBnbsZuBte(Connection con, MarketingProdukt prod, String iso, String regIso) throws SQLException {
        ResultSet bteFZUAbhZubRs;
        PreparedStatement bteFZUAbhZubPs;
        ArrayList<Bnb> fehlendeBenennungen;
        block61: {
            block60: {
                String btfzuabStatement;
                String bildPosNr;
                block63: {
                    ResultSet bteFZAbhZubRs;
                    PreparedStatement bteFZAbhZubPs;
                    block59: {
                        block58: {
                            bteFZAbhZubPs = null;
                            bteFZAbhZubRs = null;
                            bildPosNr = prod.getBildPosNr();
                            String btfzabStatement = SQLStatements.MarketingSicht.instance.ERMITTLE_FZABH_BESTANDTEILE_ZU_BTE();
                            btfzuabStatement = SQLStatements.MarketingSicht.instance.ERMITTLE_FZUABH_BESTANDTEILE_ZU_BTE();
                            fehlendeBenennungen = new ArrayList<Bnb>();
                            if (prod.isFahrzeugUngebunden()) break block63;
                            try {
                                bteFZAbhZubPs = con.prepareStatement(btfzabStatement);
                                bteFZAbhZubPs.setString(1, iso == null ? "" : iso);
                                bteFZAbhZubPs.setString(2, regIso == null ? "" : regIso);
                                bteFZAbhZubPs.setString(3, prod.getBteNr());
                                if (bildPosNr == null) {
                                    bteFZAbhZubPs.setNull(4, 12);
                                } else {
                                    bteFZAbhZubPs.setString(4, bildPosNr);
                                }
                                bteFZAbhZubRs = bteFZAbhZubPs.executeQuery();
                                while (bteFZAbhZubRs.next()) {
                                    String bteNr = bteFZAbhZubRs.getString(1);
                                    String bildPos = bteFZAbhZubRs.getString(2);
                                    String elementArt = bteFZAbhZubRs.getString(3);
                                    String text = bteFZAbhZubRs.getString(4);
                                    if (text == null || text.length() == 0) {
                                        fehlendeBenennungen.add(new Bnb(bteNr, bildPos, elementArt));
                                    }
                                    if (elementArt.equalsIgnoreCase("HP_PAKET") || elementArt.equalsIgnoreCase("HP_OBLIGAT")) {
                                        prod.getBestandTeile().add(new Bnb(bteNr, bildPos, text, elementArt));
                                        continue;
                                    }
                                    if (elementArt.equalsIgnoreCase("HP_ALTERNATIV")) {
                                        prod.getAlternativen().add(new Bnb(bteNr, bildPos, text, elementArt));
                                        continue;
                                    }
                                    if (elementArt.equalsIgnoreCase("HP_EINZELTEIL")) {
                                        prod.getEinzelteile().add(new Bnb(bteNr, bildPos, text, elementArt));
                                        continue;
                                    }
                                    if (!elementArt.equalsIgnoreCase("HILFSSTOFFE")) continue;
                                    prod.getHilfsBetriebsStoffe().add(new Bnb(bteNr, bildPos, text, elementArt));
                                }
                                if (bteFZAbhZubRs == null) break block58;
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                break block59;
                            }
                            finally {
                                if (bteFZAbhZubRs != null) {
                                    WebetkUtils.closeQuery(bteFZAbhZubRs);
                                } else if (bteFZAbhZubPs != null) {
                                    bteFZAbhZubPs.close();
                                }
                            }
                            WebetkUtils.closeQuery(bteFZAbhZubRs);
                            break block59;
                        }
                        if (bteFZAbhZubPs != null) {
                            bteFZAbhZubPs.close();
                        }
                    }
                    try {
                        bteFZAbhZubPs = con.prepareStatement(SQLStatements.MarketingSicht.instance.ERMITTLE_FZGABH_ALTERNATIVNAMEN_BNB());
                        for (Bnb bnb : fehlendeBenennungen) {
                            bteFZAbhZubPs.setString(1, bnb.getBteNr());
                            bteFZAbhZubPs.setString(2, bnb.getBildPos());
                            bteFZAbhZubPs.setString(3, iso);
                            bteFZAbhZubPs.setString(4, regIso == null ? "  " : regIso);
                            bteFZAbhZubRs = bteFZAbhZubPs.executeQuery();
                            String bnbName = "";
                            if (bteFZAbhZubRs.next()) {
                                bnbName = bteFZAbhZubRs.getString(1);
                            }
                            bteFZAbhZubRs.close();
                            if (bnb.getElementArt().equalsIgnoreCase("HP_ALTERNATIV")) {
                                prod.getAlternativen().get(prod.getAlternativen().indexOf(bnb)).setBnbName(bnbName);
                            }
                            if (bnb.getElementArt().equalsIgnoreCase("HP_EINZELTEIL")) {
                                prod.getEinzelteile().get(prod.getEinzelteile().indexOf(bnb)).setBnbName(bnbName);
                                continue;
                            }
                            if (bnb.getElementArt().equalsIgnoreCase("HILFSSTOFFE")) {
                                ((Bnb)prod.getHilfsBetriebsStoffe().get(prod.getHilfsBetriebsStoffe().indexOf(bnb))).setBnbName(bnbName);
                                continue;
                            }
                            if (!bnb.getElementArt().equalsIgnoreCase("HP_OBLIGAT") && !bnb.getElementArt().equalsIgnoreCase("HP_PAKET")) continue;
                            prod.getBestandTeile().get(prod.getBestandTeile().indexOf(bnb)).setBnbName(bnbName);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (bteFZAbhZubRs != null) {
                            WebetkUtils.closeQuery(bteFZAbhZubRs);
                        } else if (bteFZAbhZubPs != null) {
                            bteFZAbhZubPs.close();
                        }
                    }
                }
                bteFZUAbhZubPs = null;
                bteFZUAbhZubRs = null;
                fehlendeBenennungen = new ArrayList();
                try {
                    bteFZUAbhZubPs = con.prepareStatement(btfzuabStatement);
                    bteFZUAbhZubPs.setString(1, iso == null ? "" : iso);
                    bteFZUAbhZubPs.setString(2, regIso == null ? "" : regIso);
                    bteFZUAbhZubPs.setString(3, prod.getBteNr());
                    if (bildPosNr == null) {
                        bteFZUAbhZubPs.setNull(4, 12);
                    } else {
                        bteFZUAbhZubPs.setString(4, bildPosNr);
                    }
                    bteFZUAbhZubRs = bteFZUAbhZubPs.executeQuery();
                    while (bteFZUAbhZubRs.next()) {
                        String bteNr = bteFZUAbhZubRs.getString(1);
                        String bildPos = bteFZUAbhZubRs.getString(2);
                        String elementArt = bteFZUAbhZubRs.getString(3);
                        String text = bteFZUAbhZubRs.getString(4);
                        if (text == null || text.length() == 0) {
                            fehlendeBenennungen.add(new Bnb(bteNr, bildPos, elementArt));
                        }
                        if (elementArt.equalsIgnoreCase("HP_PAKET") || elementArt.equalsIgnoreCase("HP_OBLIGAT")) {
                            prod.getBestandTeile().add(new Bnb(bteNr, bildPos, text, elementArt));
                            continue;
                        }
                        if (elementArt.equalsIgnoreCase("HP_ALTERNATIV")) {
                            prod.getAlternativen().add(new Bnb(bteNr, bildPos, text, elementArt));
                            continue;
                        }
                        if (elementArt.equalsIgnoreCase("HP_EINZELTEIL")) {
                            prod.getEinzelteile().add(new Bnb(bteNr, bildPos, text, elementArt));
                            continue;
                        }
                        if (!elementArt.equalsIgnoreCase("HILFSSTOFFE")) continue;
                        prod.getHilfsBetriebsStoffe().add(new Bnb(bteNr, bildPos, text, elementArt));
                    }
                    if (bteFZUAbhZubRs == null) break block60;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    break block61;
                }
                finally {
                    if (bteFZUAbhZubRs != null) {
                        WebetkUtils.closeQuery(bteFZUAbhZubRs);
                    } else if (bteFZUAbhZubPs != null) {
                        bteFZUAbhZubPs.close();
                    }
                }
                WebetkUtils.closeQuery(bteFZUAbhZubRs);
                break block61;
            }
            if (bteFZUAbhZubPs != null) {
                bteFZUAbhZubPs.close();
            }
        }
        try {
            bteFZUAbhZubPs = con.prepareStatement(SQLStatements.MarketingSicht.instance.ERMITTLE_FZGUABH_ALTERNATIVNAMEN_BNB());
            for (Bnb bnb : fehlendeBenennungen) {
                bteFZUAbhZubPs.setString(1, bnb.getBteNr());
                bteFZUAbhZubPs.setString(2, bnb.getBildPos());
                bteFZUAbhZubPs.setString(3, iso);
                bteFZUAbhZubPs.setString(4, regIso == null ? "  " : regIso);
                bteFZUAbhZubRs = bteFZUAbhZubPs.executeQuery();
                String bnbName = "";
                if (bteFZUAbhZubRs.next()) {
                    bnbName = bteFZUAbhZubRs.getString(1);
                }
                bteFZUAbhZubRs.close();
                if (bnb.getElementArt().equalsIgnoreCase("HP_ALTERNATIV")) {
                    prod.getAlternativen().get(prod.getAlternativen().indexOf(bnb)).setBnbName(bnbName);
                }
                if (bnb.getElementArt().equalsIgnoreCase("HP_EINZELTEIL")) {
                    prod.getEinzelteile().get(prod.getEinzelteile().indexOf(bnb)).setBnbName(bnbName);
                    continue;
                }
                if (bnb.getElementArt().equalsIgnoreCase("HILFSSTOFFE")) {
                    ((Bnb)prod.getHilfsBetriebsStoffe().get(prod.getHilfsBetriebsStoffe().indexOf(bnb))).setBnbName(bnbName);
                    continue;
                }
                if (!bnb.getElementArt().equalsIgnoreCase("HP_PAKET") && !bnb.getElementArt().equalsIgnoreCase("HP_OBLIGAT")) continue;
                prod.getBestandTeile().get(prod.getBestandTeile().indexOf(bnb)).setBnbName(bnbName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (bteFZUAbhZubRs != null) {
                WebetkUtils.closeQuery(bteFZUAbhZubRs);
            } else if (bteFZUAbhZubPs != null) {
                bteFZUAbhZubPs.close();
            }
        }
    }

    public static ResultSet loadBTEKommentarZub(Connection con, String sBTENr, String sBildPos, String sSprache, String typ) throws SQLException {
        if (sBildPos == null || sBildPos.length() == 0) {
            String sSQLStatement = SQLStatements.MarketingSicht.instance.RETRIEVE_BTEKOMMENTAR();
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            PreparedStatement stmt = con.prepareStatement(sSQLStatement);
            stmt.setString(1, sBTENr);
            stmt.setString(2, typ);
            stmt.setString(3, sISO);
            stmt.setString(4, sRegISO);
            stmt.setString(5, sBTENr);
            stmt.setString(6, typ);
            stmt.setString(7, sISO);
            stmt.setString(8, sRegISO);
            stmt.setString(9, sBTENr);
            stmt.setString(10, typ);
            stmt.setString(11, sISO);
            stmt.setString(12, sRegISO);
            ResultSet res = stmt.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.MarketingSicht.instance.RETRIEVE_BTEKOMMENTAR_BNB();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        PreparedStatement stmt = con.prepareStatement(sSQLStatement);
        stmt.setString(1, sBTENr);
        stmt.setString(2, typ);
        stmt.setString(3, sBildPos);
        stmt.setString(4, sISO);
        stmt.setString(5, sRegISO);
        stmt.setNull(6, 4);
        ResultSet res = stmt.executeQuery();
        return res;
    }
}

