/*
 * Decompiled with CFR 0.152.
 */
package webetk.mrkprd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import webetk.mrkprd.Marke;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkt;
import webetk.mrkprd.Produkte;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MarkenProdukteBerechtigungen {
    private Hashtable<String, Boolean> mMarkenBerechtigungen = new Hashtable();
    private Hashtable<String, Boolean> mProdukteBerechtigungen = new Hashtable();

    protected MarkenProdukteBerechtigungen() {
        this.initMarkenListe();
        this.initProdukteListe();
    }

    protected MarkenProdukteBerechtigungen(Hashtable<String, Boolean> pmlMarkenBerechtigungen, Hashtable<String, Boolean> pmlProdukteBerechtigungen) {
        this.mMarkenBerechtigungen = new Hashtable();
        for (String sMarke : pmlMarkenBerechtigungen.keySet()) {
            this.mMarkenBerechtigungen.put(sMarke, pmlMarkenBerechtigungen.get(sMarke));
        }
        this.mProdukteBerechtigungen = new Hashtable();
        for (String sProdukt : pmlProdukteBerechtigungen.keySet()) {
            this.mProdukteBerechtigungen.put(sProdukt, pmlProdukteBerechtigungen.get(sProdukt));
        }
    }

    private void initMarkenListe() {
        ArrayList<String> lMarken = Marken.getInstance().getEigenschaften("marke.berechtigung");
        for (String sMarke : lMarken) {
            this.mMarkenBerechtigungen.put(sMarke, Boolean.FALSE);
        }
    }

    private void initProdukteListe() {
        ArrayList<String> lProdukte = Produkte.getInstance().getEigenschaften("produkt.berechtigung");
        for (String sProdukt : lProdukte) {
            this.mProdukteBerechtigungen.put(sProdukt, Boolean.FALSE);
        }
    }

    public Hashtable<String, Boolean> getMarkenBerechtigungen() {
        return this.mMarkenBerechtigungen;
    }

    public Vector<String> getBerechtigteMarken() {
        Vector<String> lMarken = new Vector<String>();
        for (String sMarken : this.mMarkenBerechtigungen.keySet()) {
            if (!this.mMarkenBerechtigungen.get(sMarken).booleanValue()) continue;
            lMarken.add(sMarken);
        }
        return lMarken;
    }

    public Vector<Marke> getBerechtigteMarkenObjekte() {
        Vector<Marke> lMarken = new Vector<Marke>();
        for (String sMarken : this.mMarkenBerechtigungen.keySet()) {
            if (!this.mMarkenBerechtigungen.get(sMarken).booleanValue()) continue;
            lMarken.add(Marken.getInstance().getMarkeZurMarkeBerechtigung(sMarken));
        }
        return lMarken;
    }

    public void setMarkenBerechtigungen(Hashtable<String, Boolean> markenBerechtigungen) {
        this.mMarkenBerechtigungen = markenBerechtigungen;
    }

    public void resetMarkenBerechtigungen() {
        for (String sMarke : this.mMarkenBerechtigungen.keySet()) {
            this.mMarkenBerechtigungen.put(sMarke, Boolean.FALSE);
        }
    }

    public Boolean getMarkeBerechtigung(String sMarke) {
        Boolean bBerechtigung = this.mMarkenBerechtigungen.get(sMarke);
        return bBerechtigung == null ? Boolean.FALSE : bBerechtigung;
    }

    public void setMarkeBerechtigung(String sMarke, Boolean bBerechtigt) {
        this.mMarkenBerechtigungen.put(sMarke, bBerechtigt);
    }

    public Hashtable<String, Boolean> getProdukteBerechtigungen() {
        return this.mProdukteBerechtigungen;
    }

    public Vector<String> getBerechtigteProdukte() {
        Vector<String> lProdukte = new Vector<String>();
        for (String sProdukt : this.mProdukteBerechtigungen.keySet()) {
            if (!this.mProdukteBerechtigungen.get(sProdukt).booleanValue()) continue;
            lProdukte.add(sProdukt);
        }
        return lProdukte;
    }

    public Vector<Produkt> getBerechtigteProdukteObjekte() {
        Vector<Produkt> lProdukte = new Vector<Produkt>();
        for (String sProdukt : this.mProdukteBerechtigungen.keySet()) {
            if (!this.mProdukteBerechtigungen.get(sProdukt).booleanValue()) continue;
            lProdukte.add(Produkte.getInstance().getProduktZurProduktBerechtigung(sProdukt));
        }
        return lProdukte;
    }

    public void resetProduktBerechtigungen() {
        for (String sProdukt : this.mProdukteBerechtigungen.keySet()) {
            this.mProdukteBerechtigungen.put(sProdukt, Boolean.FALSE);
        }
    }

    public Boolean getProduktBerechtigung(String sProdukt) {
        Boolean bBerechtigung = this.mProdukteBerechtigungen.get(sProdukt);
        return bBerechtigung == null ? Boolean.FALSE : bBerechtigung;
    }

    public void setProduktBerechtigung(String sProdukt, Boolean bBerechtigt) {
        this.mProdukteBerechtigungen.put(sProdukt, bBerechtigt);
    }

    public void setProdukteBerechtigungen(Hashtable<String, Boolean> produkteBerechtigungen) {
        this.mProdukteBerechtigungen = produkteBerechtigungen;
    }

    protected void setzenBerechtigungenMarkenProdukte(String sArt, String sWert) {
        if (sArt.equalsIgnoreCase("Marke")) {
            this.mMarkenBerechtigungen.put(sWert, this.mMarkenBerechtigungen.containsKey(sWert));
        } else if (sArt.equalsIgnoreCase("Produktart")) {
            this.mProdukteBerechtigungen.put(sWert, this.mProdukteBerechtigungen.containsKey(sWert));
        }
    }

    protected void uebernehmenBerechtigungenMarkenProdukte(Vector<String[]> cBerechtigungen) {
        for (String sKeyMarkenBerechtigung : this.mMarkenBerechtigungen.keySet()) {
            if (!this.mMarkenBerechtigungen.get(sKeyMarkenBerechtigung).booleanValue()) continue;
            cBerechtigungen.add(new String[]{"Marke", sKeyMarkenBerechtigung});
        }
        for (String sKeyProduktBerechtigung : this.mProdukteBerechtigungen.keySet()) {
            if (!this.mProdukteBerechtigungen.get(sKeyProduktBerechtigung).booleanValue()) continue;
            cBerechtigungen.add(new String[]{"Produktart", sKeyProduktBerechtigung});
        }
    }

    protected boolean hasChangedMarkenBerechtigungen(Hashtable<String, Boolean> pmlMarkenBerechtigungen) {
        for (String sKeyMarke : this.mMarkenBerechtigungen.keySet()) {
            if (this.mMarkenBerechtigungen.get(sKeyMarke) == pmlMarkenBerechtigungen.get(sKeyMarke)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasChangedProduktBerechtigungen(Hashtable<String, Boolean> pmlProdukteBerechtigungen) {
        for (String sKeyMarke : this.mProdukteBerechtigungen.keySet()) {
            if (this.mProdukteBerechtigungen.get(sKeyMarke) == pmlProdukteBerechtigungen.get(sKeyMarke)) continue;
            return true;
        }
        return false;
    }

    public void getValuesBerechtigungenMarkenProdukte(HashMap<Object, Object> trfMap) {
        for (String sKeyMarkenBerechtigung : this.mMarkenBerechtigungen.keySet()) {
            this.mMarkenBerechtigungen.put(sKeyMarkenBerechtigung, (Boolean)trfMap.get(Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sKeyMarkenBerechtigung, "marke.transferableKey")));
        }
        for (String sKeyProduktBerechtigung : this.mProdukteBerechtigungen.keySet()) {
            this.mProdukteBerechtigungen.put(sKeyProduktBerechtigung, (Boolean)trfMap.get(Produkte.getInstance().getProduktEigenschaft("produkt.berechtigung", sKeyProduktBerechtigung, "produkt.transferableKey")));
        }
    }

    public void setValuesBerechtigungenMarkenProdukte(HashMap<Object, Object> trfMap) {
        for (String sKeyMarkenBerechtigung : this.mMarkenBerechtigungen.keySet()) {
            trfMap.put(Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sKeyMarkenBerechtigung, "marke.transferableKey"), this.mMarkenBerechtigungen.get(sKeyMarkenBerechtigung));
        }
        for (String sKeyProduktBerechtigung : this.mProdukteBerechtigungen.keySet()) {
            trfMap.put(Produkte.getInstance().getProduktEigenschaft("produkt.berechtigung", sKeyProduktBerechtigung, "produkt.transferableKey"), this.mProdukteBerechtigungen.get(sKeyProduktBerechtigung));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mMarkenBerechtigungen == null ? 0 : this.mMarkenBerechtigungen.hashCode());
        result = 31 * result + (this.mProdukteBerechtigungen == null ? 0 : this.mProdukteBerechtigungen.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkenProdukteBerechtigungen other = (MarkenProdukteBerechtigungen)obj;
        if (this.mMarkenBerechtigungen == null ? other.mMarkenBerechtigungen != null : !this.mMarkenBerechtigungen.equals(other.mMarkenBerechtigungen)) {
            return false;
        }
        return !(this.mProdukteBerechtigungen == null ? other.mProdukteBerechtigungen != null : !this.mProdukteBerechtigungen.equals(other.mProdukteBerechtigungen));
    }
}

