/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.kr.gki.keyreader;

import com.bmw.kr.gki.exception.KeyReaderAccessDLLException;
import com.bmw.kr.gki.exception.KeyReaderCommunicationException;
import com.bmw.kr.gki.exception.KeyReaderException;
import com.bmw.kr.gki.exception.KeyReaderProtocolException;
import com.bmw.kr.gki.exception.NoKeyException;
import com.bmw.kr.gki.exception.TimeoutException;
import com.bmw.sis.kernel.KeyReaderRequest;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyReaderAccess {
    private static Log log = LogFactory.getLog(KeyReaderAccess.class);
    private int bytesRead;

    public int getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(int bytesRead) {
        this.bytesRead = bytesRead;
    }

    private KeyReaderException exceptionFactory(int code) {
        KeyReaderException e = null;
        log.debug((Object)"+KeyReaderAccess.exceptionFactory");
        log.debug((Object)("errorCode:" + code));
        if (code == 0) {
            e = new NoKeyException();
        } else if (-6 <= code && code <= -1) {
            e = new KeyReaderCommunicationException(code);
        } else if (-13 <= code && code <= -7) {
            e = new KeyReaderProtocolException(code);
        } else if (90 <= code && code <= 99) {
            e = new KeyReaderAccessDLLException(code);
        }
        if (e != null) {
            log.debug((Object)("-KeyreaderAccess.exceptionFactory: " + e.getClass().getName()));
        } else {
            log.debug((Object)"-KeyreaderAccess.exceptionFactory: no Exception was found");
        }
        return e;
    }

    public void retrieveKeydata(byte[] keydata, Date readin, int timeout, String keyReaderPipeDLL, boolean isSkipKeyReader, String skipKeyReaderBinFile) throws KeyReaderException, TimeoutException {
        log.debug((Object)"+KeyReaderAccess.retrieveKeydata");
        KeyReaderRequest keyRequest = new KeyReaderRequest(keydata, readin, (byte)timeout, keyReaderPipeDLL, isSkipKeyReader, skipKeyReaderBinFile);
        keyRequest.run();
        log.debug((Object)("ErrorCode: " + keyRequest.getError()));
        KeyReaderException ex = this.exceptionFactory(keyRequest.getError());
        this.bytesRead = keyRequest.getBytesRead();
        if (ex != null) {
            throw ex;
        }
        if (keyRequest.getError() == 99) {
            throw new TimeoutException();
        }
        log.debug((Object)"-KeyReaderAccess.retrieveKeydata");
    }
}

