/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.sis.kernel;

import com.bmw.kr.gki.keyreader.ReadKeyBin;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyReaderRequest {
    private static Log log = LogFactory.getLog(KeyReaderRequest.class);
    private static boolean running = false;
    private byte[] keydata;
    private Date readin;
    private int error;
    private String dateString;
    private byte timeout;
    private int bytesRead;
    private String keyKeaderpipedllPath;
    private boolean isSkipKeyReader;
    private String skipKeyReaderBinFilePath;

    public KeyReaderRequest(byte[] keydata, Date readin, byte i, String keyReaderPipeDLL, boolean skipKeyReader, String skipKeyReaderBinFilePath) {
        this.keydata = keydata;
        this.readin = readin;
        this.timeout = i;
        this.isSkipKeyReader = skipKeyReader;
        this.skipKeyReaderBinFilePath = skipKeyReaderBinFilePath;
        this.keyKeaderpipedllPath = keyReaderPipeDLL;
        KeyReaderRequest.setRunning(true);
    }

    public void run() {
        log.debug((Object)"+KeyReaderRequest.run");
        if (this.isSkipKeyReader) {
            this.readDataFromFile();
        } else {
            this.loadLibrary("KeyreaderAccess");
            try {
                log.debug((Object)("call native function keyreaderPipeDllPath = " + this.keyKeaderpipedllPath));
                this.error = this.expGetData(this.keydata, this.timeout);
                log.debug((Object)("native function returns errorcode: " + this.error));
            }
            catch (Throwable e) {
                log.error((Object)"Error in KeyReaderRequest.run", e);
                this.error = 95;
            }
        }
        log.debug((Object)("dateString: " + this.dateString));
        log.debug((Object)("bytesRead: " + this.bytesRead));
        KeyReaderRequest.setRunning(false);
        this.convertDate();
        log.debug((Object)"-KeyReaderRequest.run");
    }

    private void loadLibrary(String name) {
        block3: {
            log.debug((Object)"+KeyReaderRequest.loadLibrary");
            log.debug((Object)("lib: " + name));
            try {
                System.loadLibrary(name);
                log.debug((Object)(name + ".dll loaded"));
            }
            catch (UnsatisfiedLinkError e) {
                File library = null;
                if (this.keyKeaderpipedllPath != null) {
                    library = new File(this.keyKeaderpipedllPath, name + ".dll");
                }
                if (library == null || !library.exists()) break block3;
                System.load(library.getAbsolutePath());
                log.debug((Object)(name + ".dll loaded"));
            }
        }
        log.debug((Object)"-KeyReaderRequest.loadLibrary");
    }

    private void convertDate() {
        log.debug((Object)"+KeyReaderRequest.convertDate");
        log.debug((Object)("readin: " + this.readin));
        if (this.dateString != null) {
            try {
                if (this.dateString.equals("")) {
                    throw new IllegalStateException("KeyReader returns empty datestring");
                }
                String[] dateArray = this.dateString.split(",");
                if (dateArray.length != 6) {
                    throw new IllegalArgumentException("date from keyreader is no YYYY,MM,DD,hh,mm,ss, is " + this.dateString);
                }
                if (this.readin == null) {
                    throw new IllegalStateException("readin - date is not initialisied");
                }
                int[] intDate = new int[6];
                for (int i = 0; i < 6; ++i) {
                    intDate[i] = Integer.parseInt(dateArray[i]);
                }
                Calendar cal = Calendar.getInstance();
                cal.set(1, intDate[0]);
                cal.set(2, intDate[1] - 1);
                cal.set(5, intDate[2]);
                cal.set(10, intDate[3]);
                cal.set(12, intDate[4]);
                cal.set(13, intDate[5]);
                this.readin.setTime(cal.getTimeInMillis());
            }
            catch (IllegalStateException e) {
                log.debug((Object)("Error converting date: " + e.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)"Error converting date", (Throwable)e);
            }
        }
        log.debug((Object)"-KeyReaderRequest.convertDate");
    }

    private void readDataFromFile() {
        log.debug((Object)"+KeyReaderRequest.readDataFromFile");
        ReadKeyBin read = new ReadKeyBin();
        try {
            read.readData(this.keydata, this.skipKeyReaderBinFilePath);
            this.bytesRead = read.getBytesRead();
        }
        catch (Exception e) {
            log.error((Object)"Error reading data from file", (Throwable)e);
        }
        this.dateString = null;
        this.error = 1;
        log.debug((Object)"-KeyReaderRequest.readDataFromFile");
    }

    public native int expGetData(byte[] var1, byte var2);

    public static boolean isRunning() {
        return running;
    }

    public byte[] getKeydata() {
        return this.keydata;
    }

    public Date getReadin() {
        return this.readin;
    }

    public int getError() {
        return this.error;
    }

    public static void setRunning(boolean running) {
        KeyReaderRequest.running = running;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(int bytesRead) {
        this.bytesRead = bytesRead;
    }
}

