/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.install.resources.Resource;
import webetk.install.server.HeaderPanel;
import webetk.install.server.InstallServer;
import webetk.install.utils.ImageCache;
import webetk.install.utils.LimitedTextField;

public class AskProperties
extends JPanel {
    private static final int BLOCKSIZE = 64000;
    private static Logger log = Logger.getLogger(AskProperties.class);
    private InstallServer mParent;
    private HeaderPanel mHeaderPanel;
    private JButton mButtonUebernehmen;
    private JButton mButtonAbbrechen;
    private JButton mButtonZurueck;
    private JLabel mZeile1;
    private JLabel mNameUrlServer;
    private JLabel mCommentUrlServer;
    private JTextField mtfUrlServer;
    private JLabel mNameUrlDmsServer;
    private JLabel mCommentUrlDmsServer;
    private JTextField mtfUrlDmsServer;
    private String mszTargetDir = "";
    private String mszPropertyFile;
    private String mszBmwetkFile;
    private String mszClientPropertyFile;
    private String mszAdminToolPropertyFile;
    private String mszMigrationPropertyFile;
    private String mszLog4jFile;
    private String mszJarFile;
    private String mszVersionFile;
    private String mszServerName;
    private String msWorkDir;
    private String msSamba = null;
    private boolean mbShowBackButton;

    public AskProperties(InstallServer parent, String szTargetDir, String szJavaserverDir, String szClientPropertyFile, String szAdminToolPropertyFile, String szMigrationPropertyFile, String szServerName, String sWorkDir, String sSamba, boolean bShowBackButton) {
        this.mParent = parent;
        this.mszTargetDir = szTargetDir;
        this.mszPropertyFile = szJavaserverDir + File.separator + "WEB-INF" + File.separator + "javaclient.properties";
        this.mszBmwetkFile = szJavaserverDir + File.separator + "WEB-INF" + File.separator + "bmwetk.properties";
        this.mszVersionFile = szJavaserverDir + File.separator + "WEB-INF" + File.separator + "version.txt";
        this.mszLog4jFile = szJavaserverDir + File.separator + "WEB-INF" + File.separator + "log4j.properties";
        this.mszJarFile = szJavaserverDir + File.separator + "javaserver.war";
        this.mszClientPropertyFile = szClientPropertyFile;
        this.mszAdminToolPropertyFile = szAdminToolPropertyFile;
        this.mszMigrationPropertyFile = szMigrationPropertyFile;
        this.mszServerName = szServerName;
        this.msWorkDir = sWorkDir;
        this.msSamba = sSamba;
        this.mbShowBackButton = bShowBackButton;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getEigenschaften(), null);
        this.initComponents();
    }

    private void initComponents() {
        this.mParent.setTitle(Resource.getInstance().getEigenschaften());
        this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButton(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mButtonZurueck = new JButton(Resource.getInstance().getZurueck());
        this.mZeile1 = new JLabel(Resource.getInstance().getWerteFuerEigenschaftenAngeben());
        this.mNameUrlServer = new JLabel("server.URL");
        this.mCommentUrlServer = new JLabel(Resource.getInstance().getCommentServerURL());
        this.mtfUrlServer = new LimitedTextField(256, 60);
        this.mNameUrlDmsServer = new JLabel("xmldms.serverurl");
        this.mCommentUrlDmsServer = new JLabel(Resource.getInstance().getDmsServerUrl());
        this.mtfUrlDmsServer = new LimitedTextField(256, 60);
        this.loadProperties();
        this.layoutAll();
    }

    private void layoutAll() {
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(l);
        this.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 5, 0, 10, 0, 5, 0, 10, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.mZeile1, c.rcwh(2, 2, 3, 1, "tlbr"));
        panel.add((Component)this.mCommentUrlServer, c.rcwh(4, 2, 3, 1, "tlbr"));
        panel.add((Component)this.mNameUrlServer, c.rc(6, 2, "l"));
        panel.add((Component)this.mtfUrlServer, c.rc(6, 4, "l"));
        panel.add((Component)this.mCommentUrlDmsServer, c.rcwh(8, 2, 3, 1, "tlbr"));
        panel.add((Component)this.mNameUrlDmsServer, c.rc(10, 2, "l"));
        panel.add((Component)this.mtfUrlDmsServer, c.rc(10, 4, "l"));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, 0, -4, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        if (this.mbShowBackButton) {
            panel.add((Component)this.mButtonZurueck, c.rc(1, 6, "lrtb"));
        }
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskProperties.this.saveProperties();
                AskProperties.this.mParent.executeNextStep();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskProperties.this.mParent.stopInstall();
            }
        });
        this.mButtonZurueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskProperties.this.mParent.back();
            }
        });
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Properties oProperties;
        log.info("Property-File des Servers lesen: " + this.mszPropertyFile);
        FileInputStream in = null;
        try {
            oProperties = new Properties();
            in = new FileInputStream(this.mszPropertyFile);
            oProperties.load(in);
            this.mtfUrlDmsServer.setText(oProperties.getProperty("xmldms.serverurl"));
        }
        catch (IOException e) {
            log.error("Konnte Property-File des Servers nicht lesen: ", e);
            return;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        log.info("Property-File des Clients lesen: " + this.mszClientPropertyFile);
        try {
            oProperties = new Properties();
            in = new FileInputStream(this.mszClientPropertyFile);
            oProperties.load(in);
            String szServerUrl = oProperties.getProperty("server.URL");
            if (this.mszServerName != null && this.mszServerName.length() > 0) {
                szServerUrl = AskProperties.substituteString(szServerUrl, "localhost", this.mszServerName);
            }
            this.mtfUrlServer.setText(szServerUrl);
        }
        catch (IOException e) {
            log.error("Konnte Property-File des Clients nicht lesen: ", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties() {
        String szLine;
        Iterator iter;
        BufferedWriter out;
        BufferedReader in;
        Vector<String> aszZeilen;
        System.out.println("saveProperties");
        this.setCursor(Cursor.getPredefinedCursor(3));
        log.info("Version aus version.txt lesen: " + this.mszVersionFile);
        String szVersion = "";
        try {
            BufferedReader in2 = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszVersionFile)));
            String szLine2 = in2.readLine();
            while (szLine2 != null) {
                if (szLine2.indexOf("Version.Programme=") == 0) {
                    szVersion = szLine2.substring(18);
                }
                szLine2 = in2.readLine();
            }
            in2.close();
        }
        catch (IOException e) {
            log.error("Konnte Version nicht lesen: ", e);
            return;
        }
        if (szVersion != null) {
            log.info("Version: " + szVersion);
        }
        log.info("Property-File des Servers speichern: " + this.mszPropertyFile);
        try {
            aszZeilen = new Vector<String>();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszPropertyFile)));
            boolean bFoundTimeouts = false;
            boolean bFoundTicker = false;
            boolean bFoundSowu = false;
            String szLine3 = in.readLine();
            while (szLine3 != null) {
                if (szLine3.indexOf("xmldms.serverurl") == 0) {
                    szLine3 = "xmldms.serverurl=" + this.mtfUrlDmsServer.getText();
                    log.info("Neue Zeile: " + szLine3);
                } else if (szLine3.indexOf("# Timeouts (in seconds)") == 0) {
                    bFoundTimeouts = true;
                } else if (szLine3.indexOf("ticker.dir =") == 0) {
                    bFoundTicker = true;
                } else if (szLine3.indexOf("sowu.connection =") == 0) {
                    bFoundSowu = true;
                    if (szLine3.indexOf("sowu.connection = 0") == 0) {
                        szLine3 = "sowu.connection = 1";
                    }
                }
                if (szLine3.indexOf("#TARGETDIR#") >= 0) {
                    szLine3 = AskProperties.substituteString(szLine3, "#TARGETDIR#", this.mszTargetDir);
                }
                szLine3 = AskProperties.maskBackSlash(szLine3);
                aszZeilen.add(szLine3);
                szLine3 = in.readLine();
            }
            in.close();
            if (!bFoundTimeouts) {
                szLine3 = "# Timeouts (in seconds)";
                aszZeilen.add(szLine3);
                szLine3 = "# waiting for connection";
                aszZeilen.add(szLine3);
                szLine3 = "timeout.connection = 60";
                aszZeilen.add(szLine3);
                szLine3 = "# waiting for Data";
                aszZeilen.add(szLine3);
                szLine3 = "timeout.socket = 600";
                aszZeilen.add(szLine3);
            }
            if (!bFoundTicker) {
                szLine3 = "# Directory for Ticker texts";
                aszZeilen.add(szLine3);
                szLine3 = "ticker.dir = #TARGETDIR#\\ticker";
                szLine3 = AskProperties.substituteString(szLine3, "#TARGETDIR#", this.mszTargetDir);
                szLine3 = AskProperties.maskBackSlash(szLine3);
                aszZeilen.add(szLine3);
            }
            if (!bFoundSowu) {
                szLine3 = "# connection to SOWU (0 AUTO or 1)";
                aszZeilen.add(szLine3);
                szLine3 = "sowu.connection = 1";
                aszZeilen.add(szLine3);
            }
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszPropertyFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("Property-File fuer das Logging: " + this.mszLog4jFile);
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszLog4jFile)));
            szLine3 = in.readLine();
            while (szLine3 != null) {
                String szLogPath = AskProperties.substituteString(this.mszTargetDir, "\\", "/") + "/tomcat/webapps/javaserver/";
                if (szLine3.indexOf("log4j.appender.file.File") == 0) {
                    szLine3 = "log4j.appender.file.File=" + szLogPath + "etk_java_server.log";
                    log.info("Neue Zeile: " + szLine3);
                } else if (szLine3.indexOf("log4j.appender.lf5Roll.File") == 0) {
                    szLine3 = "log4j.appender.lf5Roll.File=" + szLogPath + "etk_lf5.log";
                    log.info("Neue Zeile: " + szLine3);
                }
                aszZeilen.add(szLine3);
                szLine3 = in.readLine();
            }
            in.close();
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszLog4jFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("bmwetk.Property-File: " + this.mszBmwetkFile);
            boolean bBTMailFound = false;
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszBmwetkFile)));
            szLine3 = in.readLine();
            while (szLine3 != null) {
                if (szLine3.indexOf("application.version") == 0) {
                    szLine3 = "application.version = " + szVersion;
                    log.info("Neue Zeile: " + szLine3);
                } else if (this.mszServerName != null && this.mszServerName.length() > 0 && szLine3.indexOf("localhost") > -1) {
                    szLine3 = AskProperties.substituteString(szLine3, "localhost", this.mszServerName);
                    log.info("Neue Zeile: " + szLine3);
                } else if (szLine3.indexOf("mail.AttachmentName.Diagram") == 0) {
                    bBTMailFound = true;
                }
                aszZeilen.add(szLine3);
                szLine3 = in.readLine();
            }
            in.close();
            if (!bBTMailFound) {
                szLine3 = "# The name for the attachment to the mail that contains the Diagram";
                aszZeilen.add(szLine3);
                szLine3 = "mail.AttachmentName.Diagram = Diagram";
                aszZeilen.add(szLine3);
            }
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszBmwetkFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("Jar-File aktualisieren");
            this.updateJarFile();
        }
        catch (IOException e) {
            log.error("Konnte Property-File des Servers nicht speichern: ", e);
            return;
        }
        log.info("Property-File des Clients speichern: " + this.mszClientPropertyFile);
        try {
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszClientPropertyFile)));
            szLine = in.readLine();
            boolean bFoundPortPool = false;
            boolean bFoundTimeouts = false;
            boolean bFoundRrSap = false;
            while (szLine != null) {
                if (szLine.indexOf("server.URL") == 0) {
                    szLine = "server.URL=" + this.mtfUrlServer.getText();
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("language") == 0) {
                    szLine = "language=" + Resource.getInstance().getLanguage();
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("# Bereich aus denen der Client und das ASAP-Applet die Ports fuer ihre Kommunikation suchen") == 0) {
                    bFoundPortPool = true;
                } else if (szLine.indexOf("# Timeouts (in seconds)") == 0) {
                    bFoundTimeouts = true;
                } else if (szLine.indexOf("# SAP Communication for RR") == 0) {
                    bFoundRrSap = true;
                }
                szLine = AskProperties.maskBackSlash(szLine);
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            if (!bFoundPortPool) {
                szLine = "# Bereich aus denen der Client und das ASAP-Applet die Ports fuer ihre Kommunikation suchen";
                aszZeilen.add(szLine);
                szLine = "# asap.port.from=4101";
                aszZeilen.add(szLine);
                szLine = "# asap.port.to=4199";
                aszZeilen.add(szLine);
            }
            if (!bFoundTimeouts) {
                szLine = "# Timeouts (in seconds)";
                aszZeilen.add(szLine);
                szLine = "# waiting for connection";
                aszZeilen.add(szLine);
                szLine = "timeout.connection = 60";
                aszZeilen.add(szLine);
                szLine = "# waiting for Data";
                aszZeilen.add(szLine);
                szLine = "timeout.socket = 600";
                aszZeilen.add(szLine);
            }
            if (!bFoundRrSap) {
                szLine = "# SAP Communication for RR";
                aszZeilen.add(szLine);
                szLine = "# maximum number of parts in a list for which a SAP communication is allowed";
                aszZeilen.add(szLine);
                szLine = "rrsap.maxparts = 250";
                aszZeilen.add(szLine);
                szLine = "# Number of times the wait dialog asks the server for a reply";
                aszZeilen.add(szLine);
                szLine = "rrsap.wait.steps = 20";
                aszZeilen.add(szLine);
                szLine = "# time in ms the wait dialog waits before asking again for a reply";
                aszZeilen.add(szLine);
                szLine = "rrsap.wait.time = 2000";
                aszZeilen.add(szLine);
            }
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszClientPropertyFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            log.error("Konnte Property-File des Clients nicht speichern: ", e);
            return;
        }
        log.info("Property-File des AdminTool speichern: " + this.mszAdminToolPropertyFile);
        try {
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszAdminToolPropertyFile)));
            szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("standalone") == 0) {
                    szLine = "standalone=0";
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("language") == 0) {
                    szLine = "language=" + Resource.getInstance().getLanguage();
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("htmlserver") == 0) {
                    szLine = this.mParent.getInstallThinClient() ? "htmlserver=1" : "htmlserver=0";
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("device") == 0) {
                    szLine = "device=" + this.msWorkDir;
                    if ((szLine = AskProperties.maskBackSlash(szLine)).endsWith("\\\\")) {
                        szLine = szLine.substring(0, szLine.length() - 2);
                    }
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("samba") == 0 && !InstallServer.isMSWindows()) {
                    szLine = "samba = " + this.msSamba;
                    log.info("Neue Zeile: " + szLine);
                } else if (this.mszServerName != null && this.mszServerName.length() > 0 && szLine.indexOf("localhost") > -1) {
                    szLine = AskProperties.substituteString(szLine, "localhost", this.mszServerName);
                    log.info("Neue Zeile: " + szLine);
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszAdminToolPropertyFile)));
            Iterator iter2 = aszZeilen.iterator();
            while (iter2.hasNext()) {
                out2.write((String)iter2.next() + System.getProperty("line.separator"));
            }
            out2.close();
        }
        catch (IOException e) {
            log.error("Konnte Property-File des Admintools nicht speichern: ", e);
        }
        log.info("Property-File der Migration speichern: " + this.mszMigrationPropertyFile);
        try {
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszMigrationPropertyFile)));
            szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("standalone") == 0) {
                    szLine = "standalone=0";
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("language") == 0) {
                    szLine = "language=" + Resource.getInstance().getLanguage();
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("device") == 0) {
                    szLine = "device=" + this.msWorkDir;
                    szLine = AskProperties.maskBackSlash(szLine);
                    log.info("Neue Zeile: " + szLine);
                } else if (szLine.indexOf("xmldms.serverurl") == 0) {
                    szLine = "xmldms.serverurl=" + this.mtfUrlDmsServer.getText();
                    szLine = AskProperties.maskBackSlash(szLine);
                    log.info("Neue Zeile: " + szLine);
                } else if (this.mszServerName != null && this.mszServerName.length() > 0 && szLine.indexOf("localhost") > -1) {
                    szLine = AskProperties.substituteString(szLine, "localhost", this.mszServerName);
                    log.info("Neue Zeile: " + szLine);
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out3 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszMigrationPropertyFile)));
            Iterator iter3 = aszZeilen.iterator();
            while (iter3.hasNext()) {
                out3.write((String)iter3.next() + System.getProperty("line.separator"));
            }
            out3.close();
        }
        catch (IOException e) {
            log.error("Konnte Property-File der Migration nicht speichern: ", e);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void updateJarFile() {
        try {
            log.info("Jar-File aktualisieren: " + this.mszJarFile);
            JarFile jarFile = new JarFile(this.mszJarFile);
            JarOutputStream output = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.mszJarFile + "_out.war")));
            log.info("--> new from 2.0.39 allways new jarentry to avoid zipexception");
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = new JarEntry(jarEntries.nextElement().getName());
                InputStream input = null;
                boolean change = false;
                if (entry.getName().equals("WEB-INF/javaclient.properties")) {
                    input = new FileInputStream(this.mszPropertyFile);
                    change = true;
                } else if (entry.getName().equals("WEB-INF/bmwetk.properties")) {
                    input = new FileInputStream(this.mszBmwetkFile);
                    change = true;
                } else if (entry.getName().equals("WEB-INF/log4j.properties")) {
                    input = new FileInputStream(this.mszLog4jFile);
                    change = true;
                } else if (entry.getName().equals("WEB-INF/version.txt")) {
                    input = new FileInputStream(this.mszVersionFile);
                    change = true;
                } else {
                    input = jarFile.getInputStream(entry);
                }
                this.updateJarEntry(entry, output, new BufferedInputStream(input), change);
            }
            output.close();
            jarFile.close();
            File jarold = new File(this.mszJarFile);
            File jarnew = new File(this.mszJarFile + "_out.war");
            boolean ret = jarold.delete();
            if (!ret) {
                log.error("Konnte altes Jar-File nicht loeschen.");
            }
            if (!(ret = jarnew.renameTo(jarold))) {
                log.error("Konnte neues Jar-File nicht umbenennen.");
            }
        }
        catch (IOException e) {
            log.error("Konnte Jar-Files des Servers nicht updaten: ", e);
        }
    }

    private void updateJarEntry(JarEntry jarentry, JarOutputStream jarout, BufferedInputStream input, boolean change) {
        try {
            if (change) {
                jarentry.setMethod(0);
            }
            byte[] buffer = new byte[64000];
            int nread = 0;
            input.mark(999999999);
            int size = 0;
            while ((nread = input.read(buffer, 0, buffer.length)) != -1) {
                size += nread;
            }
            jarentry.setSize(size);
            if (change) {
                jarentry.setCompressedSize(size);
            }
            input.reset();
            buffer = size == 0 ? new byte[1] : new byte[size];
            nread = 0;
            while ((nread = input.read(buffer, 0, buffer.length)) != -1) {
                if (change && size > 0) {
                    CRC32 crc = new CRC32();
                    crc.update(buffer);
                    jarentry.setCrc(crc.getValue());
                }
                jarout.putNextEntry(jarentry);
                if (size <= 0) continue;
                jarout.write(buffer, 0, nread);
            }
            jarout.closeEntry();
            input.close();
        }
        catch (Exception e) {
            log.error("Konnte Eintrags im Jar-File nicht updaten: " + jarentry.getName() + " ", e);
        }
    }

    private static String maskBackSlash(String sSource) {
        if (sSource == null) {
            return sSource;
        }
        int nIndex = sSource.indexOf("\\");
        while (nIndex != -1) {
            String sNewString;
            if (nIndex < sSource.length() - 2 && sSource.charAt(nIndex + 1) == '\\') {
                nIndex = sSource.indexOf("\\", nIndex + 2);
                continue;
            }
            sSource = sNewString = sSource.substring(0, nIndex) + "\\\\" + sSource.substring(nIndex + 1, sSource.length());
            nIndex = sSource.indexOf("\\", nIndex + 2);
        }
        return sSource;
    }

    private static String substituteString(String sSource, String sParam, String sSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (sSubst == null) {
            sSubst = "";
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }
}

